/*
 * Decompiled with CFR 0.152.
 */
package com.sas;

import com.sas.ComponentException;
import com.sas.ComponentInterface;
import com.sas.GlobalInfoTable;
import com.sas.ModelInterface;
import com.sas.RB;
import com.sas.beans.Introspector;
import com.sas.beans.PropertyChangeEvent;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.Vector;

public class ViewInterfaceSupport
implements Serializable {
    static final long serialVersionUID = -2738764574726136681L;
    public static final String RB_KEY = "ViewInterfaceSupport.";

    public static Vector getRequiredInterfaces(ComponentInterface componentInstance) {
        return new Vector(1);
    }

    public static void setRequiredInterfaces(ComponentInterface componentInstance, Vector interfaces) {
    }

    public static void attachModel(ComponentInterface componentInstance, ModelInterface model) {
        if (model == componentInstance) {
            String message = RB.getStringResource((String)RB_KEY, (String)"attachSelf.ex.txt");
            throw new ComponentException(Message.format((String)message, (Object)componentInstance.getClass().getName()));
        }
        if (componentInstance.supportsRequiredInterfaces(model)) {
            if (!model.attachView()) {
                String message = RB.getStringResource((String)RB_KEY, (String)"attachDenied.ex.txt");
                throw new ComponentException(Message.format((String)message, (Object)componentInstance.getClass().getName()));
            }
        } else {
            String message = RB.getStringResource((String)RB_KEY, (String)"unsupportedInterface.ex.txt");
            throw new ComponentException(Message.format((String)message, (Object)componentInstance.getClass().getName()));
        }
        componentInstance.getViewInterfaceSupportInfo().modelInterface = model;
        componentInstance.refresh(model);
    }

    public static void detachModel(ComponentInterface componentInstance, ModelInterface model) {
        model.detachView();
        componentInstance.getViewInterfaceSupportInfo().modelInterface = null;
        componentInstance.refresh(null);
    }

    public static void refresh(ComponentInterface componentInstance, ModelInterface model) {
    }

    public static boolean supportsRequiredInterfaces(ComponentInterface componentInstance, ModelInterface model) {
        boolean retval = true;
        Vector requiredInterfaces = componentInstance.getRequiredInterfaces();
        if (requiredInterfaces != null && requiredInterfaces.size() > 0 && ((String[])requiredInterfaces.elementAt(0)).length > 0) {
            int i;
            Class<?> model_class = model.getClass();
            Class[] supported_interfaces = Introspector.getInterfaces(model_class);
            block2: for (i = 0; i < supported_interfaces.length; ++i) {
                int n = requiredInterfaces.size();
                for (int j = 0; j < n; ++j) {
                    String required_interface = ((String[])requiredInterfaces.elementAt(j))[0];
                    Class requiredInterfaceClass = null;
                    try {
                        requiredInterfaceClass = GlobalInfoTable.loadClass((String)required_interface);
                    }
                    catch (Exception e) {
                        String message = RB.getStringResource((String)RB_KEY, (String)"exceptionLoadingClass.ex.txt");
                        throw new ComponentException(Message.format((String)message, (Object)componentInstance.getClass().getName(), (Object)e.getMessage()));
                    }
                    if (requiredInterfaceClass != null && requiredInterfaceClass.isInstance(model)) break block2;
                }
            }
            if (i >= supported_interfaces.length) {
                retval = false;
            }
        }
        return retval;
    }

    public static ModelInterface getModelInterface(ComponentInterface componentInstance) {
        if (componentInstance.getViewInterfaceSupportInfo() == null) {
            return null;
        }
        return componentInstance.getViewInterfaceSupportInfo().modelInterface;
    }

    public static void setModelInterface(ComponentInterface componentInstance, ModelInterface model) {
        ModelInterface previous_model = componentInstance.getModelInterface();
        if (previous_model != model) {
            if (previous_model != null) {
                componentInstance.detachModel(previous_model);
            }
            if (model != null) {
                componentInstance.attachModel(model);
            }
            componentInstance.firePropertyChange((java.beans.PropertyChangeEvent)new PropertyChangeEvent((Object)componentInstance, "modelInterface", (Object)previous_model, (Object)model));
        }
    }
}

