/*
 * Decompiled with CFR 0.152.
 */
package com.sas;

import com.sas.ComponentException;
import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupportInfo;
import com.sas.GlobalInfoTable;
import com.sas.LinkListenerInvocationHandler;
import com.sas.PropertyChangeInfo;
import com.sas.PropertyValueQueryInterface;
import com.sas.RB;
import com.sas.beans.Introspector;
import com.sas.beans.PropertyChangeEvent;
import com.sas.beans.PropertyDescriptor;
import com.sas.security.BaseSecuritySupport;
import com.sas.text.Message;
import com.sas.util.ParameterBag;
import com.sas.util.SystemLog;
import com.sas.util.Util;
import com.sas.util.linkhandlers.LinkHandlerInterface;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.transforms.Transforms;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class PropertyLinkAdaptor
implements PropertyChangeListener {
    public static final String RB_KEY = "PropertyLinkAdaptor.";
    protected Object sourceObject;
    protected Object targetObject;
    protected String sourceProperty;
    protected String targetProperty;
    protected TransformInterface transform;
    protected Method sourceGetMethod;
    protected Method targetSetMethod;
    protected Class sourceClass;
    protected Class targetClass;
    protected boolean transformSpecified;
    protected PropertyValueQueryInterface propertyValueSource;
    protected PropertyValueQueryInterface propertyValueTarget;
    protected boolean enabled = true;
    private List linkHandlerList;
    protected Set interfaceSet;
    protected EventListener eventListenerProxy;
    protected boolean linkConnected;
    protected static Map sourceMap = new HashMap();
    protected static Map proxyMap;
    public static Map userProxyMap;

    public static PropertyLinkAdaptor addLink(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty) {
        return PropertyLinkAdaptor.addLink(sourceObject, sourceProperty, targetObject, targetProperty, null);
    }

    public static PropertyLinkAdaptor addLink(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty, TransformInterface specifiedTransform) {
        PropertyValueQueryInterface propertyValueSource = null;
        PropertyValueQueryInterface propertyValueTarget = null;
        if (sourceObject instanceof PropertyValueQueryInterface) {
            propertyValueSource = (PropertyValueQueryInterface)sourceObject;
        }
        if (targetObject instanceof PropertyValueQueryInterface) {
            propertyValueTarget = (PropertyValueQueryInterface)targetObject;
        }
        return PropertyLinkAdaptor.addLink(sourceObject, sourceProperty, targetObject, targetProperty, specifiedTransform, propertyValueSource, propertyValueTarget);
    }

    public static PropertyLinkAdaptor addLink(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty, TransformInterface specifiedTransform, PropertyValueQueryInterface propertyValueSource, PropertyValueQueryInterface propertyValueTarget) {
        PropertyLinkAdaptor adaptor = new PropertyLinkAdaptor(sourceObject, targetObject, sourceProperty, targetProperty, specifiedTransform, propertyValueSource, propertyValueTarget);
        adaptor.addLink();
        return adaptor;
    }

    public static boolean isLinkable(Object source, String property) {
        Class<?> sourceClass = source.getClass();
        java.beans.PropertyDescriptor propDesc = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(sourceClass);
            propDesc = Introspector.getPropertyDescriptor((String)property, (BeanInfo)beanInfo);
        }
        catch (IntrospectionException e) {
            System.out.println(" Introspection exception " + e);
            return false;
        }
        if (propDesc == null) {
            return source instanceof ParameterBag;
        }
        if (propDesc instanceof PropertyDescriptor) {
            return ((PropertyDescriptor)propDesc).isLinkable();
        }
        if (propDesc.isBound()) {
            return true;
        }
        return PropertyLinkAdaptor.containsProxy(sourceClass, property, PropertyLinkAdaptor.getProxyMap());
    }

    public boolean isConnected() {
        return this.linkConnected;
    }

    public Object getSource() {
        return this.sourceObject;
    }

    public Object getTarget() {
        return this.targetObject;
    }

    public String getSourceProperty() {
        return this.sourceProperty;
    }

    public String getTargetProperty() {
        return this.targetProperty;
    }

    protected Object createLinkListenerProxy(Set methodSet, Set interfaceSet, PropertyLinkAdaptor target) {
        LinkListenerInvocationHandler handler = new LinkListenerInvocationHandler(methodSet, target);
        ClassLoader classLoader = target.getClass().getClassLoader();
        Class[] classArray = new Class[interfaceSet.size()];
        System.arraycopy(interfaceSet.toArray(), 0, classArray, 0, classArray.length);
        return Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)handler);
    }

    protected void processInterfaceMethods(List listenerMethodList, Set interfaceSet, Set methodSet) {
        for (int i = 0; i < listenerMethodList.size(); ++i) {
            String listenerMethodName = (String)listenerMethodList.get(i);
            int methodIndex = listenerMethodName.lastIndexOf(46);
            if (methodIndex == -1 || methodIndex == listenerMethodName.length() - 1) continue;
            try {
                String interfaceName = listenerMethodName.substring(0, methodIndex);
                if (listenerMethodName.endsWith(".class")) {
                    Class linkHandlerClass = GlobalInfoTable.loadClass((String)interfaceName);
                    if (linkHandlerClass == null || !LinkHandlerInterface.class.isAssignableFrom(linkHandlerClass)) continue;
                    LinkHandlerInterface linkHandler = (LinkHandlerInterface)linkHandlerClass.newInstance();
                    if (this.linkHandlerList == null) {
                        this.linkHandlerList = new ArrayList();
                    }
                    this.linkHandlerList.add(linkHandler);
                    continue;
                }
                String methodName = listenerMethodName.substring(methodIndex + 1);
                Class listenerInterface = GlobalInfoTable.loadClass((String)interfaceName);
                Method[] methods = listenerInterface.getMethods();
                Method listenerMethod = null;
                for (int j = 0; j < methods.length && listenerMethod == null; ++j) {
                    if (!methodName.equals(methods[j].getName())) continue;
                    listenerMethod = methods[j];
                }
                if (listenerMethod == null) continue;
                interfaceSet.add(listenerInterface);
                methodSet.add(listenerMethod);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println(" Exception " + cnfe);
                continue;
            }
            catch (InstantiationException e1) {
                System.out.println(" Exception " + e1);
                continue;
            }
            catch (IllegalAccessException e2) {
                System.out.println(" Exception " + e2);
                continue;
            }
            catch (SecurityException e3) {
                System.out.println(" Exception " + e3);
                continue;
            }
            catch (ExceptionInInitializerError e4) {
                System.out.println(" Exception " + e4);
            }
        }
    }

    protected static void loadProxyMap() {
        proxyMap = new Properties();
        try {
            InputStream inputStream = BaseSecuritySupport.securitySupport.getResourceAsStream(PropertyLinkAdaptor.class, "LinkProxyMap.properties");
            ((Properties)proxyMap).load(inputStream);
        }
        catch (IOException e) {
            System.out.println(" IOException " + e);
        }
    }

    protected static Map getProxyMap() {
        if (proxyMap == null) {
            PropertyLinkAdaptor.loadProxyMap();
        }
        HashMap map = new HashMap();
        if (proxyMap != null) {
            map.putAll(proxyMap);
        }
        if (userProxyMap != null) {
            map.putAll(userProxyMap);
        }
        return map;
    }

    protected List processListenerMethodList(String listenerList) {
        StringTokenizer tokenizer = new StringTokenizer(listenerList, ",");
        ArrayList<String> methodList = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreElements()) {
            String methodName = tokenizer.nextToken().trim();
            methodList.add(methodName);
        }
        return methodList;
    }

    protected static boolean containsProxy(Class sourceClass, String sourceProperty, Map listenerProxyMap) {
        String propertyName = null;
        for (Class currentClass = sourceClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            propertyName = currentClass.getName() + "." + sourceProperty;
            if (!listenerProxyMap.containsKey(propertyName)) continue;
            return true;
        }
        return false;
    }

    protected List findListenerMethodList(Class sourceClass, String sourceProperty) {
        Map listenerProxyMap = PropertyLinkAdaptor.getProxyMap();
        String propertyName = null;
        for (Class currentClass = sourceClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            propertyName = currentClass.getName() + "." + sourceProperty;
            if (!listenerProxyMap.containsKey(propertyName)) continue;
            return this.processListenerMethodList((String)listenerProxyMap.get(propertyName));
        }
        return null;
    }

    protected void processEventListener(String listenerOperation, Set listenerInterfaceSet, Object eventSource, EventListener eventListener) {
        Class<?> sourceClass = eventSource.getClass();
        for (Class interfaceClass : listenerInterfaceSet) {
            String className = interfaceClass.getName();
            int index = className.lastIndexOf(".");
            if (index != -1 && index + 1 < className.length()) {
                className = className.substring(index + 1);
            }
            Class[] paramTypes = new Class[]{interfaceClass};
            String listenerOperationName = listenerOperation + className;
            try {
                Object[] args = new Object[]{eventListener};
                Method listenerMethod = sourceClass.getMethod(listenerOperationName, paramTypes);
                if (listenerMethod == null) continue;
                listenerMethod.invoke(eventSource, args);
            }
            catch (NoSuchMethodException e) {
                System.out.println(" caught exception " + e);
            }
            catch (IllegalAccessException e) {
                System.out.println(" caught exception " + e);
            }
            catch (IllegalArgumentException e) {
                System.out.println(" caught exception " + e);
            }
            catch (InvocationTargetException e) {
                System.out.println(" caught exception " + e);
            }
        }
    }

    public void addLink() {
        if (this.linkConnected) {
            return;
        }
        Class<?> sourceClass = this.sourceObject.getClass();
        this.eventListenerProxy = null;
        List methodList = this.findListenerMethodList(sourceClass, this.sourceProperty);
        if (methodList != null) {
            this.interfaceSet = new HashSet();
            HashSet methodSet = new HashSet();
            this.processInterfaceMethods(methodList, this.interfaceSet, methodSet);
            if (this.linkHandlerList != null && !this.linkHandlerList.isEmpty()) {
                for (LinkHandlerInterface linkHandler : this.linkHandlerList) {
                    linkHandler.setLink(this);
                }
                this.linkConnected = true;
            }
            if (!this.interfaceSet.isEmpty()) {
                this.eventListenerProxy = (EventListener)this.createLinkListenerProxy(methodSet, this.interfaceSet, this);
                this.processEventListener("add", this.interfaceSet, this.sourceObject, this.eventListenerProxy);
                this.linkConnected = true;
            }
            if (this.linkConnected) {
                this.addToSourceAdaptors();
            }
        } else {
            java.beans.PropertyDescriptor propDesc = null;
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(sourceClass);
                propDesc = Introspector.getPropertyDescriptor((String)this.sourceProperty, (BeanInfo)beanInfo);
            }
            catch (IntrospectionException e) {
                System.out.println(" Introspection exception " + e);
                return;
            }
            if (propDesc.isBound()) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.sourceObject, (PropertyChangeListener)this);
                this.linkConnected = true;
            } else {
                this.linkConnected = false;
            }
        }
        this.synchronizeValues();
    }

    protected void addToSourceAdaptors() {
        Map sourceLinks = null;
        if (sourceMap.containsKey(this.sourceObject)) {
            sourceLinks = (Map)sourceMap.get(this.sourceObject);
        } else {
            sourceLinks = new HashMap();
            sourceMap.put(this.sourceObject, sourceLinks);
        }
        List<PropertyLinkAdaptor> sourceAdaptors = null;
        if (sourceLinks.containsKey(this.sourceProperty)) {
            sourceAdaptors = (List)sourceLinks.get(this.sourceProperty);
        } else {
            sourceAdaptors = new ArrayList();
            sourceLinks.put(this.sourceProperty, sourceAdaptors);
        }
        sourceAdaptors.add(this);
    }

    protected boolean removeFromSourceAdaptors() {
        Map sourceLinks = null;
        if (!sourceMap.containsKey(this.sourceObject)) {
            return false;
        }
        sourceLinks = (Map)sourceMap.get(this.sourceObject);
        List sourceAdaptors = null;
        if (sourceLinks == null || !sourceLinks.containsKey(this.sourceProperty)) {
            return false;
        }
        sourceAdaptors = (List)sourceLinks.get(this.sourceProperty);
        boolean removed = sourceAdaptors.remove(this);
        if (sourceAdaptors.size() == 0) {
            sourceLinks.remove(this.sourceProperty);
            if (sourceLinks.size() == 0) {
                sourceMap.remove(this.sourceObject);
            }
        }
        return removed;
    }

    protected List getAdaptors(Object source, String propertyName) {
        Map sourceLinks = null;
        if (!sourceMap.containsKey(source)) {
            return null;
        }
        sourceLinks = (Map)sourceMap.get(source);
        List sourceAdaptors = null;
        if (sourceLinks != null && sourceLinks.containsKey(propertyName)) {
            sourceAdaptors = (List)sourceLinks.get(propertyName);
        }
        return sourceAdaptors;
    }

    public void synchronizeValues() {
        Object targetValue;
        Object value = this.getPropertyValue();
        if (this.transform != null && value != null) {
            try {
                value = this.transform.transform(value);
            }
            catch (Exception e) {
                String message = RB.getStringResource((String)RB_KEY, (String)"errorTransformingValue.ex.txt");
                throw new ComponentException(Message.format((String)message, (Object)e), (Throwable)e);
            }
        }
        if (Util.equal((Object)value, (Object)(targetValue = com.sas.beans.Util.getPropertyValue((Object)this.targetObject, (String)this.targetProperty)))) {
            return;
        }
        java.beans.PropertyChangeEvent event = new java.beans.PropertyChangeEvent(this.sourceObject, this.sourceProperty, null, null);
        this.propertyChange(event);
    }

    public static void removeLink(PropertyLinkAdaptor adaptor) {
        adaptor.removeLink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLink() {
        if (!this.linkConnected) {
            return;
        }
        try {
            com.sas.beans.Util.removePropertyChangeListener((Object)this.sourceObject, (PropertyChangeListener)this);
            boolean removedFromSourceAdaptors = false;
            if (this.eventListenerProxy != null) {
                this.processEventListener("remove", this.interfaceSet, this.sourceObject, this.eventListenerProxy);
                this.eventListenerProxy = null;
                removedFromSourceAdaptors = this.removeFromSourceAdaptors();
            }
            if (this.linkHandlerList != null && !this.linkHandlerList.isEmpty()) {
                for (LinkHandlerInterface linkHandler : this.linkHandlerList) {
                    linkHandler.setLink(null);
                }
                if (!removedFromSourceAdaptors) {
                    this.removeFromSourceAdaptors();
                }
            }
        }
        finally {
            this.linkConnected = false;
        }
    }

    public PropertyLinkAdaptor(Object sourceObject, Object targetObject, String sourceProperty, String targetProperty) {
        this(sourceObject, targetObject, sourceProperty, targetProperty, null);
    }

    public PropertyLinkAdaptor(Object sourceObject, Object targetObject, String sourceProperty, String targetProperty, TransformInterface specifiedTransform) {
        this(sourceObject, targetObject, sourceProperty, targetProperty, specifiedTransform, null, null);
    }

    public PropertyLinkAdaptor(Object sourceObject, Object targetObject, String sourceProperty, String targetProperty, TransformInterface specifiedTransform, PropertyValueQueryInterface propertyValueSource, PropertyValueQueryInterface propertyValueTarget) {
        java.beans.PropertyDescriptor propDesc;
        BeanInfo beanInfo;
        this.sourceObject = sourceObject;
        this.targetObject = targetObject;
        this.sourceProperty = sourceProperty;
        this.targetProperty = targetProperty;
        this.transform = specifiedTransform;
        this.propertyValueSource = propertyValueSource;
        this.propertyValueTarget = propertyValueTarget;
        if (this.transform != null) {
            this.transformSpecified = true;
        }
        if (propertyValueTarget == null) {
            try {
                Method targetGetMethod = null;
                beanInfo = Introspector.getBeanInfo(targetObject.getClass());
                propDesc = Introspector.getPropertyDescriptor((String)targetProperty, (BeanInfo)beanInfo);
                if (propDesc == null) {
                    String message = RB.getStringResource((String)RB_KEY, (String)"invalidProperty.ex.txt");
                    if (targetProperty == null) {
                        targetProperty = "null";
                    }
                    throw new ComponentException(Message.format((String)message, (Object)targetObject.getClass().getName(), (Object)targetProperty));
                }
                this.targetSetMethod = propDesc.getWriteMethod();
                targetGetMethod = propDesc.getReadMethod();
                this.targetClass = BaseSecuritySupport.securitySupport.getMethodReturnType(targetGetMethod);
            }
            catch (ComponentException ce) {
                throw ce;
            }
            catch (Throwable e) {
                e = Util.getTargetException((Throwable)e);
                String message = RB.getStringResource((String)RB_KEY, (String)"constructionFailed.ex.txt");
                String exceptionMessage = e.getMessage();
                if (exceptionMessage == null) {
                    exceptionMessage = e.getClass().getName();
                }
                throw new ComponentException(Message.format((String)message, (Object)exceptionMessage), e);
            }
        } else {
            this.targetClass = propertyValueTarget.getPropertyType(targetObject, targetProperty);
        }
        if (!this.transformSpecified) {
            Object sourceValue = this.getPropertyValue();
            if (sourceValue != null) {
                this.sourceClass = sourceValue.getClass();
            } else {
                try {
                    beanInfo = Introspector.getBeanInfo(sourceObject.getClass());
                    propDesc = Introspector.getPropertyDescriptor((String)sourceProperty, (BeanInfo)beanInfo);
                    if (propDesc == null) {
                        String message = RB.getStringResource((String)RB_KEY, (String)"invalidProperty.ex.txt");
                        if (sourceProperty == null) {
                            sourceProperty = "null";
                        }
                        throw new ComponentException(Message.format((String)message, (Object)targetObject.getClass().getName(), (Object)targetProperty));
                    }
                    this.sourceClass = propDesc.getPropertyType();
                }
                catch (ComponentException ce) {
                    throw ce;
                }
                catch (Throwable e) {
                    e = Util.getTargetException((Throwable)e);
                    String message = RB.getStringResource((String)RB_KEY, (String)"constructionFailed.ex.txt");
                    String exceptionMessage = e.getMessage();
                    if (exceptionMessage == null) {
                        exceptionMessage = e.getClass().getName();
                    }
                    throw new ComponentException(Message.format((String)message, (Object)exceptionMessage), e);
                }
            }
            this.transform = Transforms.lookupTransform(this.sourceClass, this.targetClass);
        }
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        int i;
        if (!this.isEnabled()) {
            return;
        }
        if (evt.getSource() != this.sourceObject || evt.getPropertyName() == null || !evt.getPropertyName().equals(this.sourceProperty)) {
            return;
        }
        boolean looping = false;
        if (this.targetObject instanceof ComponentInterface && evt instanceof PropertyChangeEvent) {
            ComponentInterface componentInstance = (ComponentInterface)this.targetObject;
            ComponentInterfaceSupportInfo info = componentInstance.getComponentSupportInfo(true);
            ++info.m_PropertyChangeDepth;
            info.m_ChangeHistory = ((PropertyChangeEvent)evt).m_ChangeHistory != null ? (Vector)((PropertyChangeEvent)evt).m_ChangeHistory.clone() : null;
            if (info.m_ChangeHistory != null) {
                int n = info.m_ChangeHistory.size();
                for (i = 0; i < n; ++i) {
                    PropertyChangeInfo changeInfo = (PropertyChangeInfo)info.m_ChangeHistory.elementAt(i);
                    if (changeInfo.component != componentInstance || !changeInfo.property.equals(this.targetProperty)) continue;
                    looping = true;
                }
            }
        }
        if (!looping) {
            Object newValue = evt.getNewValue();
            if (newValue == null) {
                newValue = this.getPropertyValue();
            }
            if (!this.transformSpecified && newValue != null && this.sourceClass != newValue.getClass()) {
                this.sourceClass = newValue.getClass();
                this.transform = Transforms.lookupTransform(this.sourceClass, this.targetClass);
            }
            if (this.transform != null) {
                try {
                    newValue = this.transform.transform(newValue);
                }
                catch (Exception e) {
                    this.cleanUpLoopingHistory(evt);
                    String message = RB.getStringResource((String)RB_KEY, (String)"errorTransformingValue.ex.txt");
                    throw new ComponentException(Message.format((String)message, (Object)e), (Throwable)e);
                }
            }
            this.setPropertyValue(newValue);
            List adaptorList = this.getAdaptors(this.targetObject, this.targetProperty);
            if (adaptorList != null) {
                for (i = 0; i < adaptorList.size(); ++i) {
                    PropertyLinkAdaptor adaptor = (PropertyLinkAdaptor)adaptorList.get(i);
                    if (adaptor == this || !Util.unequal((Object)this.getSourceProperty(), (Object)adaptor.getTargetProperty()) && this.getSource() == adaptor.getTarget()) continue;
                    adaptor.synchronizeValues();
                }
            }
        }
        this.cleanUpLoopingHistory(evt);
    }

    protected void cleanUpLoopingHistory(java.beans.PropertyChangeEvent evt) {
        if (this.targetObject instanceof ComponentInterface && evt instanceof PropertyChangeEvent) {
            ComponentInterface componentInstance = (ComponentInterface)this.targetObject;
            --componentInstance.getComponentSupportInfo((boolean)true).m_PropertyChangeDepth;
            if (componentInstance.getComponentSupportInfo((boolean)true).m_PropertyChangeDepth == 0) {
                componentInstance.getComponentSupportInfo((boolean)true).m_ChangeHistory = null;
            }
        }
    }

    protected Object getPropertyValue() {
        if (this.propertyValueSource == null) {
            if (this.sourceGetMethod == null) {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(this.sourceObject.getClass());
                    java.beans.PropertyDescriptor propDesc = Introspector.getPropertyDescriptor((String)this.sourceProperty, (BeanInfo)beanInfo);
                    this.sourceGetMethod = propDesc.getReadMethod();
                }
                catch (Exception e) {
                    String message = RB.getStringResource((String)RB_KEY, (String)"errorGettingSourceReadMethod.ex.txt");
                    String param = e.getMessage();
                    if (param == null) {
                        param = "null";
                    }
                    throw new ComponentException(Message.format((String)message, (Object)param), (Throwable)e);
                }
            }
            try {
                return BaseSecuritySupport.securitySupport.invokeMethod(this.sourceGetMethod, this.sourceObject, null);
            }
            catch (Throwable e) {
                e = Util.getTargetException((Throwable)e);
                String message = RB.getStringResource((String)RB_KEY, (String)"errorGettingSourceValue.ex.txt");
                throw new ComponentException(Message.format((String)message, (Object)e.getMessage()), e);
            }
        }
        return this.propertyValueSource.getPropertyValue(this.sourceObject, this.sourceProperty);
    }

    protected void setPropertyValue(Object newValue) {
        if (this.propertyValueTarget == null) {
            try {
                Object[] args = new Object[]{newValue};
                BaseSecuritySupport.securitySupport.invokeMethod(this.targetSetMethod, this.targetObject, args);
            }
            catch (Throwable e) {
                e = Util.getTargetException((Throwable)e);
                String message = RB.getStringResource((String)RB_KEY, (String)"errorSettingTargetValue.ex.txt");
                if (newValue == null) {
                    newValue = "null";
                }
                SystemLog.logException(Message.format((String)message, (Object)newValue), e);
            }
        } else {
            this.propertyValueTarget.setPropertyValue(this.targetObject, this.sourceProperty, newValue);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    static {
        userProxyMap = new HashMap();
    }
}

