/*
 * Decompiled with CFR 0.152.
 */
package com.sas;

import com.sas.ComponentException;
import com.sas.ComponentInterface;
import com.sas.RB;
import com.sas.beans.PropertyChangeEvent;
import com.sas.security.BaseSecuritySupport;
import com.sas.text.Message;
import com.sas.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class PropertyChangeListenerSupport {
    public static final String RB_KEY = "PropertyChangeListenerSupport.";

    public static void propertyChange(ComponentInterface componentInstance, PropertyChangeEvent e) {
        Vector requiredInterfaces;
        if (componentInstance.getViewInterfaceSupportInfo().modelInterface != null && (requiredInterfaces = componentInstance.getRequiredInterfaces()).size() > 0) {
            String[] requiredInterfaceEvents = (String[])requiredInterfaces.elementAt(0);
            int n = requiredInterfaceEvents.length;
            for (int j = 2; j <= n; j += 2) {
                String property_name = requiredInterfaceEvents[j - 1];
                if (!e.getPropertyName().equals(property_name) || e.getSource() != componentInstance.getViewInterfaceSupportInfo().modelInterface) continue;
                Class[] params = new Class[]{};
                Object[] args = new Object[]{};
                Class<?> thisClass = componentInstance.getClass();
                try {
                    Method invokeMethod = BaseSecuritySupport.securitySupport.getMethod(thisClass, requiredInterfaceEvents[j], params);
                    BaseSecuritySupport.securitySupport.invokeMethod(invokeMethod, (Object)componentInstance, args);
                    continue;
                }
                catch (NoSuchMethodException nsme) {
                    nsme.printStackTrace();
                    throw new ComponentException(PropertyChangeListenerSupport.getExceptionMessage(componentInstance, requiredInterfaceEvents[j]));
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                    throw new ComponentException(PropertyChangeListenerSupport.getExceptionMessage(componentInstance, requiredInterfaceEvents[j]));
                }
                catch (IllegalArgumentException iare) {
                    iare.printStackTrace();
                    throw new ComponentException(PropertyChangeListenerSupport.getExceptionMessage(componentInstance, requiredInterfaceEvents[j]));
                }
                catch (InvocationTargetException ite) {
                    Throwable realException = Util.getTargetException((Throwable)ite);
                    realException.printStackTrace();
                    throw new ComponentException(PropertyChangeListenerSupport.getExceptionMessage(componentInstance, requiredInterfaceEvents[j]));
                }
            }
        }
    }

    protected static String getExceptionMessage(ComponentInterface componentInstance, String method) {
        String message = RB.getStringResource((String)RB_KEY, (String)"methodCannotBeInvoked.ex.txt");
        return Message.format((String)message, (Object)componentInstance, (Object)method);
    }
}

