/*
 * Decompiled with CFR 0.152.
 */
package com.sas;

import com.sas.ObjectLoaderInterface;
import com.sas.security.BaseSecuritySupport;
import java.io.ObjectInputStream;
import java.util.Hashtable;

public class ObjectLoaderThread
implements Runnable {
    protected Object m_container;
    protected ObjectInputStream m_in;
    protected Hashtable m_objects;
    protected Thread m_thread;
    protected boolean m_failed = false;

    public ObjectLoaderThread(Object container, ObjectInputStream in) {
        this.m_container = container;
        this.m_in = in;
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
    }

    @Override
    public void run() {
        try {
            this.m_objects = this.m_container != null && this.m_container instanceof ObjectLoaderInterface ? ((ObjectLoaderInterface)this.m_container).readObjects(this.m_in) : (Hashtable)this.m_in.readObject();
        }
        catch (Exception ex) {
            this.m_failed = true;
            ex.printStackTrace();
        }
    }

    public boolean isAlive() {
        boolean rc = false;
        if (this.m_thread != null) {
            rc = this.m_thread.isAlive();
        }
        return rc;
    }

    public boolean didFail() {
        boolean rc = false;
        if (!this.isAlive()) {
            rc = this.m_failed;
        }
        return rc;
    }

    public Hashtable getObjects() {
        return this.m_objects;
    }
}

