/*
 * Decompiled with CFR 0.152.
 */
package com.sas;

import com.sas.ObjectLoaderThread;
import com.sas.RB;
import com.sas.text.Message;
import java.applet.Applet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Vector;

public class ObjectLoader {
    public static final String RB_KEY = "ObjectLoader.";
    protected Object m_container = null;

    public ObjectLoader(Object container) {
        this.m_container = container;
    }

    public Hashtable loadObjects(InputStream in, Vector names) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = this.convert(in);
        return this.loadObjects(ois, names);
    }

    public Object loadObject(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = this.convert(in);
        return ois.readObject();
    }

    private ObjectInputStream convert(InputStream in) throws IOException {
        byte[] b;
        int n;
        Vector<byte[]> data = new Vector<byte[]>();
        Vector<Integer> len = new Vector<Integer>();
        int total = 0;
        while ((n = in.read(b = new byte[1024])) >= 0) {
            data.addElement(b);
            len.addElement(new Integer(n));
            total += n;
        }
        byte[] buf = new byte[total];
        int pos = 0;
        for (int i = 0; i < data.size(); ++i) {
            int l = (Integer)len.elementAt(i);
            System.arraycopy((byte[])data.elementAt(i), 0, buf, pos, l);
            pos += l;
        }
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buf));
        return ois;
    }

    public Hashtable loadObjects(ObjectInputStream in, Vector names) throws IOException, ClassNotFoundException {
        if (in == null) {
            return null;
        }
        String modelNames = "";
        if (names != null) {
            for (int i = 0; i < names.size(); ++i) {
                if (i > 0) {
                    modelNames = modelNames + ", ";
                }
                modelNames = modelNames + (String)names.elementAt(i);
            }
        }
        ObjectLoaderThread t = new ObjectLoaderThread(this.m_container, in);
        t.start();
        int sleepTime = 50;
        long nextStatus = System.currentTimeMillis();
        int elapsed = 0;
        while (t.isAlive()) {
            long curTime = System.currentTimeMillis();
            if (curTime >= nextStatus) {
                String message = RB.getStringResource((String)RB_KEY, (String)"loadObjectsStatus.txt");
                this.showStatus(Message.format((String)message, (Object)this.formatTime(elapsed), (Object)modelNames));
                nextStatus += 1000L;
                ++elapsed;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception exception) {}
        }
        if (t.didFail()) {
            throw new IOException(RB.getStringResource((String)RB_KEY, (String)"loadObjectsException.ex.txt"));
        }
        return t.getObjects();
    }

    protected void showStatus(String s) {
        if (this.m_container != null && this.m_container instanceof Applet) {
            ((Applet)this.m_container).showStatus(s);
        }
    }

    protected String formatTime(int seconds) {
        int min = seconds / 60;
        if (min > 0) {
            seconds -= min * 60;
        }
        return "" + min + ":" + seconds / 10 + seconds % 10;
    }
}

