/*
 * Decompiled with CFR 0.152.
 */
package com.sas;

import com.sas.ComponentException;
import com.sas.ComponentInterface;
import com.sas.LinkInfo;
import com.sas.PropertyLinkAdaptor;
import com.sas.PropertyLinkInfo;
import com.sas.RB;
import com.sas.beans.Introspector;
import com.sas.beans.PropertyDescriptor;
import com.sas.text.Message;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.util.Vector;

public class LinkPropertiesInterfaceSupport {
    public static void addLink(ComponentInterface componentInstance, String property, ComponentInterface sourceComponent, String sourceProperty) {
        Vector m_LinkInfoList = componentInstance.getLinkInfo().m_LinkInfoList;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(componentInstance.getClass());
            java.beans.PropertyDescriptor propertyDescriptor = Introspector.getPropertyDescriptor((String)property, (BeanInfo)beanInfo);
            BeanInfo sourceBeanInfo = Introspector.getBeanInfo(sourceComponent.getClass());
            java.beans.PropertyDescriptor sourcePropertyDescriptor = Introspector.getPropertyDescriptor((String)sourceProperty, (BeanInfo)sourceBeanInfo);
            if (propertyDescriptor instanceof PropertyDescriptor && !((PropertyDescriptor)propertyDescriptor).isLinkable()) {
                String errorMessage = RB.getStringResource((String)"LinkPropertiesInterfaceSupport.addLink.destinationNotLinkable.ex.txt");
                throw new ComponentException(Message.format((String)errorMessage, (Object)propertyDescriptor.getName()));
            }
            if (sourcePropertyDescriptor instanceof PropertyDescriptor && !((PropertyDescriptor)sourcePropertyDescriptor).isLinkable()) {
                String errorMessage = RB.getStringResource((String)"LinkPropertiesInterfaceSupport.addLink.sourceNotLinkable.ex.txt");
                throw new ComponentException(Message.format((String)errorMessage, (Object)propertyDescriptor.getName()));
            }
        }
        catch (IntrospectionException e) {
            throw new ComponentException(RB.getStringResource((String)"LinkPropertiesInterfaceSupport.addLink.ex.txt"));
        }
        int n = m_LinkInfoList.size();
        for (int i = 0; i < n; ++i) {
            LinkInfo linkInfo = (LinkInfo)m_LinkInfoList.elementAt(i);
            if (!linkInfo.m_Property.equals(property) || !linkInfo.m_LinkedProperty.equals(sourceProperty) || !linkInfo.m_LinkedComponent.equals(sourceComponent)) continue;
            System.err.println(RB.getStringResource((String)"LinkPropertiesInterfaceSupport.addLink.duplicate.ex.txt"));
            System.err.println("componentInstance = " + componentInstance);
            System.err.println("property = " + property);
            System.err.println("sourceComponent = " + sourceComponent);
            System.err.println("sourceProperty = " + sourceProperty);
            Thread.dumpStack();
            return;
        }
        LinkInfo linkInfo = new LinkInfo();
        linkInfo.m_Property = property;
        linkInfo.m_LinkedProperty = sourceProperty;
        linkInfo.m_LinkedComponent = sourceComponent;
        linkInfo.linkAdaptor = PropertyLinkAdaptor.addLink(sourceComponent, sourceProperty, componentInstance, property);
        m_LinkInfoList.addElement(linkInfo);
    }

    public static void removeLink(ComponentInterface componentInstance, String property, ComponentInterface sourceComponent, String sourceProperty) {
        Vector m_LinkInfoList = componentInstance.getLinkInfo().m_LinkInfoList;
        boolean found = false;
        for (int i = 0; i < m_LinkInfoList.size(); ++i) {
            LinkInfo linkInfo = (LinkInfo)m_LinkInfoList.elementAt(i);
            if (!linkInfo.m_Property.equals(property) || !linkInfo.m_LinkedProperty.equals(sourceProperty) || !linkInfo.m_LinkedComponent.equals(sourceComponent)) continue;
            m_LinkInfoList.removeElementAt(i);
            sourceComponent.removePropertyChangeListener(linkInfo.linkAdaptor);
            found = true;
            break;
        }
    }

    public static void removeAllLinks(ComponentInterface componentInstance) {
        PropertyLinkInfo[] link_list = componentInstance.queryLinks();
        for (int i = 0; i < link_list.length; ++i) {
            componentInstance.removeLink(link_list[i].property, link_list[i].sourceComponent, link_list[i].sourceProperty);
        }
    }

    public static PropertyLinkInfo[] queryLinks(ComponentInterface componentInstance, String property) {
        Vector linkInfoList = componentInstance.getLinkInfo().m_LinkInfoList;
        int link_count = 0;
        int n = linkInfoList.size();
        for (int i = 0; i < n; ++i) {
            LinkInfo linkInfo = (LinkInfo)linkInfoList.elementAt(i);
            if (!linkInfo.m_Property.equals(property)) continue;
            ++link_count;
        }
        PropertyLinkInfo[] link_list = new PropertyLinkInfo[link_count];
        int index = 0;
        int n2 = linkInfoList.size();
        for (int i = 0; i < n2; ++i) {
            LinkInfo linkInfo = (LinkInfo)linkInfoList.elementAt(i);
            if (!linkInfo.m_Property.equals(property)) continue;
            link_list[index++] = new PropertyLinkInfo(componentInstance, property, linkInfo.m_LinkedComponent, linkInfo.m_LinkedProperty);
        }
        return link_list;
    }

    public static PropertyLinkInfo[] queryLinks(ComponentInterface componentInstance) {
        Vector linkInfoList = componentInstance.getLinkInfo().m_LinkInfoList;
        PropertyLinkInfo[] link_list = new PropertyLinkInfo[linkInfoList.size()];
        int n = linkInfoList.size();
        for (int i = 0; i < n; ++i) {
            LinkInfo linkInfo = (LinkInfo)linkInfoList.elementAt(i);
            link_list[i] = new PropertyLinkInfo(componentInstance, linkInfo.m_Property, linkInfo.m_LinkedComponent, linkInfo.m_LinkedProperty);
        }
        return link_list;
    }

    public static boolean isLinked(ComponentInterface componentInstance, String property, ComponentInterface sourceComponent, String sourceProperty) {
        Vector linkInfoList = componentInstance.getLinkInfo().m_LinkInfoList;
        int n = linkInfoList.size();
        for (int i = 0; i < n; ++i) {
            LinkInfo linkInfo = (LinkInfo)linkInfoList.elementAt(i);
            if (!linkInfo.m_Property.equals(property) || !linkInfo.m_LinkedProperty.equals(sourceProperty) || !linkInfo.m_LinkedComponent.equals(sourceComponent)) continue;
            return true;
        }
        return false;
    }
}

