/*
 * Decompiled with CFR 0.152.
 */
package com.sas;

import com.sas.Component;
import com.sas.ComponentException;
import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupportInfo;
import com.sas.LinkPropertiesInfo;
import com.sas.ModelInterface;
import com.sas.PropertyChangeInfo;
import com.sas.RB;
import com.sas.ViewInterfaceSupportInfo;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Introspector;
import com.sas.beans.PropertyChangeEvent;
import com.sas.beans.PropertyChangeListenerList;
import com.sas.collection.OrderedCollection;
import com.sas.text.Message;
import com.sas.util.StringComparator;
import com.sas.util.SystemLog;
import com.sas.util.Util;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public final class ComponentInterfaceSupport {
    public static final String[][][] propertyMetadata = new String[][][]{{{"Name", "modelInterface"}, {"Property editor class", "com.sas.beans.editors._ModelInterfaceEditor"}, {"Description", RB.getStringResource((String)"ComponentInterface.modelInterface.pd.txt")}}, {{"Name", "componentDescription"}, {"Description", RB.getStringResource((String)"ComponentInterface.componentDescription.pd.txt")}}, {{"Name", "requiredInterfaces"}, {"Description", RB.getStringResource((String)"ComponentInterface.requiredInterfaces.pd.txt")}, {"Property editor class", "com.sas.beans.editors._RequiredInterfacesEditor"}}, {{"Name", "designTime"}, {"Expert", "true"}, {"Description", RB.getStringResource((String)"ComponentInterface.designTime.pd.txt")}}, {{"Name", "componentSupportInfo"}, {"Hidden", "true"}}, {{"Name", "viewInterfaceSupportInfo"}, {"Hidden", "true"}}, {{"Name", "extendedBeanInfo"}, {"Hidden", "true"}}, {{"Name", "linkInfo"}, {"Hidden", "true"}}};

    private ComponentInterfaceSupport() {
    }

    public static String getComponentDescription(ComponentInterface componentInstance) {
        ComponentInterfaceSupportInfo info = componentInstance.getComponentSupportInfo(true);
        if (info.m_Description == null) {
            info.m_Description = "";
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(componentInstance.getClass());
                BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                info.m_Description = beanDescriptor.getShortDescription();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return info.m_Description;
    }

    public static void setComponentDescription(ComponentInterface componentInstance, String description) {
        String prev_description = componentInstance.getComponentDescription();
        if (description == null) {
            description = "";
        }
        ComponentInterfaceSupportInfo info = componentInstance.getComponentSupportInfo(true);
        if (!prev_description.equals(description)) {
            info.m_Description = description;
            componentInstance.firePropertyChange("componentDescription", prev_description, description);
        }
    }

    public static boolean isDesignTime(ComponentInterface componentInstance) {
        return componentInstance.getComponentSupportInfo((boolean)true).m_DesignTime;
    }

    public static void dumpComponent(ComponentInterface componentInstance) {
        String startMessage = RB.getStringResource((String)"ComponentInterface.dumpStarting.txt");
        System.out.println(Message.format((String)startMessage, (Object)componentInstance.getClass().getName()));
        System.out.println("    this = " + componentInstance);
        System.out.println("    class = " + componentInstance.getClass());
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(componentInstance.getClass());
            PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
            OrderedCollection sortedProperties = new OrderedCollection();
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i].getReadMethod() == null || properties[i].isHidden()) continue;
                Object value = properties[i].getReadMethod().invoke((Object)componentInstance, null);
                String valueString = "    " + properties[i].getName() + " = " + value;
                sortedProperties.add(valueString);
            }
            sortedProperties.sort(new StringComparator());
            Enumeration e = sortedProperties.getItems();
            while (e.hasMoreElements()) {
                String string = (String)e.nextElement();
                System.out.println(string);
            }
        }
        catch (Exception e) {
            String message = RB.getStringResource((String)"ComponentInterfaceSupport.dumpPropertiesException.ex.txt");
            System.out.println(Message.format((String)message, (Object)componentInstance.getClass().getName(), (Object)e.getMessage()));
        }
        String message = RB.getStringResource((String)"ComponentInterface.dumpRequiredInterface.txt");
        Vector requiredInterfaces = componentInstance.getRequiredInterfaces();
        int n = requiredInterfaces.size();
        for (int i = 0; i < n; ++i) {
            System.out.print(message);
            String[] interfaceInfo = (String[])requiredInterfaces.elementAt(i);
            for (int j = 0; j < interfaceInfo.length; ++j) {
                System.out.print(interfaceInfo[j] + ", ");
            }
            System.out.println();
        }
        String doneMessage = RB.getStringResource((String)"ComponentInterface.dumpDone.txt");
        System.out.println(Message.format((String)doneMessage, (Object)componentInstance.getClass().getName()));
    }

    public static void addPropertyChangeListener(ComponentInterface componentInstance, PropertyChangeListener listener) {
        ComponentInterfaceSupportInfo info = componentInstance.getComponentSupportInfo(true);
        if (info.propertyListeners == null) {
            info.propertyListeners = new PropertyChangeListenerList();
        }
        info.propertyListeners.add(listener);
    }

    public static void removePropertyChangeListener(ComponentInterface componentInstance, PropertyChangeListener listener) {
        ComponentInterfaceSupportInfo info = componentInstance.getComponentSupportInfo(true);
        if (info.propertyListeners == null) {
            return;
        }
        info.propertyListeners.remove(listener);
    }

    public static void firePropertyChange(ComponentInterface componentInstance, String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && Util.equal((Object)oldValue, (Object)newValue) || !ComponentInterfaceSupport.anyPropertyChangeListeners(componentInstance)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)componentInstance, propertyName, oldValue, newValue);
        componentInstance.firePropertyChange((java.beans.PropertyChangeEvent)propertyChangeEvent);
    }

    public static boolean anyPropertyChangeListeners(ComponentInterface componentInstance) {
        ComponentInterfaceSupportInfo info = componentInstance.getComponentSupportInfo(false);
        if (info == null) {
            return false;
        }
        PropertyChangeListenerList propertyListeners = info.propertyListeners;
        return propertyListeners != null && propertyListeners.count() > 0;
    }

    public static void firePropertyChange(ComponentInterface componentInstance, java.beans.PropertyChangeEvent propertyChangeEvent) {
        ComponentInterfaceSupportInfo info = componentInstance.getComponentSupportInfo(true);
        PropertyChangeListenerList propertyListeners = info.propertyListeners;
        if (propertyListeners == null || propertyListeners.count() == 0) {
            return;
        }
        PropertyChangeListener[] listeners = propertyListeners.getListeners();
        if (listeners.length == 0) {
            return;
        }
        Object oldValue = propertyChangeEvent.getOldValue();
        Object newValue = propertyChangeEvent.getNewValue();
        String propertyName = propertyChangeEvent.getPropertyName();
        if (oldValue != newValue || oldValue == null && newValue == null) {
            Vector changeHistory = null;
            if (info.m_ChangeHistory != null) {
                changeHistory = (Vector)info.m_ChangeHistory.clone();
                int n = info.m_ChangeHistory.size();
                for (int i = 0; i < n; ++i) {
                    PropertyChangeInfo changeInfo = (PropertyChangeInfo)info.m_ChangeHistory.elementAt(i);
                    if (changeInfo.component != componentInstance || !changeInfo.property.equals(propertyName)) continue;
                    return;
                }
            } else {
                changeHistory = new Vector();
            }
            PropertyChangeInfo changeInfo = new PropertyChangeInfo();
            changeInfo.component = componentInstance;
            changeInfo.property = propertyName;
            changeHistory.addElement(changeInfo);
            if (propertyChangeEvent instanceof PropertyChangeEvent) {
                ((PropertyChangeEvent)propertyChangeEvent).m_ChangeHistory = changeHistory;
            }
            int length = listeners.length;
            for (int j = 0; j < length; ++j) {
                try {
                    PropertyChangeListener listener = listeners[j];
                    listener.propertyChange(propertyChangeEvent);
                    continue;
                }
                catch (ComponentException exc) {
                    Throwable targetException = exc.getTargetException();
                    if (targetException != null) {
                        System.out.println(" Exception = " + targetException);
                        targetException.printStackTrace();
                        continue;
                    }
                    System.out.println(" ComponentException = " + (Object)((Object)exc));
                    exc.printStackTrace();
                }
            }
        }
    }

    public static boolean anyVetoableChangeListeners(ComponentInterface componentInstance) {
        ComponentInterfaceSupportInfo info = componentInstance.getComponentSupportInfo(true);
        return info.vetos != null;
    }

    public static void addVetoableChangeListener(ComponentInterface componentInstance, VetoableChangeListener listener) {
        ComponentInterfaceSupportInfo info = componentInstance.getComponentSupportInfo(true);
        if (info.vetos == null) {
            info.vetos = new VetoableChangeSupport(componentInstance);
        }
        info.vetos.addVetoableChangeListener(listener);
    }

    public static void removeVetoableChangeListener(ComponentInterface componentInstance, VetoableChangeListener listener) {
        ComponentInterfaceSupportInfo info = componentInstance.getComponentSupportInfo(true);
        if (info.vetos == null) {
            return;
        }
        info.vetos.removeVetoableChangeListener(listener);
    }

    public static void fireVetoableChange(ComponentInterface componentInstance, String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        ComponentInterfaceSupportInfo info = componentInstance.getComponentSupportInfo(true);
        if (info.vetos == null) {
            return;
        }
        info.vetos.fireVetoableChange(propertyName, oldValue, newValue);
    }

    public static void initialize(ComponentInterface componentInstance) {
    }

    public static void initializeComponent(ComponentInterface componentInstance) {
        componentInstance.setDefaultValues();
        if (Component.beansIsDesignTime()) {
            componentInstance.getComponentSupportInfo((boolean)true).m_DesignTime = true;
        }
    }

    public static void readObject(ComponentInterface componentInstance, ObjectInputStream stream) throws NotActiveException, InvalidObjectException, ClassNotFoundException, IOException {
        stream.defaultReadObject();
        try {
            stream.registerValidation(componentInstance, 1);
        }
        catch (Error e) {
            SystemLog.logNote("Note: registerValidation failed.  This is normal when deserializing in CORBA, but some classes may not deserialize correctly");
        }
        componentInstance.getComponentSupportInfo((boolean)true).m_DesignTime = Component.beansIsDesignTime();
        componentInstance.getComponentSupportInfo((boolean)true).m_RequiredInterfaces = null;
    }

    public static void validateObject(ComponentInterface componentInstance) {
        ViewInterfaceSupportInfo info = componentInstance.getViewInterfaceSupportInfo();
        if (info.modelInterface != null) {
            ModelInterface model = info.modelInterface;
            info.modelInterface = null;
            model.detachView();
            componentInstance.setModelInterface(model);
        }
        componentInstance.initialize();
    }

    public static void clone(ComponentInterface sourceComponent, ComponentInterface destComponent) throws CloneNotSupportedException {
        ModelInterface model;
        if (sourceComponent.getComponentSupportInfo(true) != null) {
            destComponent.setComponentSupportInfo((ComponentInterfaceSupportInfo)sourceComponent.getComponentSupportInfo(true).clone());
        }
        if (sourceComponent.getLinkInfo() != null) {
            destComponent.setLinkInfo((LinkPropertiesInfo)sourceComponent.getLinkInfo().clone());
        }
        if (sourceComponent.getViewInterfaceSupportInfo() != null) {
            destComponent.setViewInterfaceSupportInfo((ViewInterfaceSupportInfo)sourceComponent.getViewInterfaceSupportInfo().clone());
        }
        if ((model = sourceComponent.getModelInterface()) != null) {
            if (!model.attachView()) {
                throw new CloneNotSupportedException(RB.getStringResource((String)"ComponentInterface.cloneFailedOnAttachView.ex.txt"));
            }
            model.detachView();
            destComponent.getViewInterfaceSupportInfo().modelInterface = null;
            destComponent.setModelInterface(model);
        }
    }

    public static void firePropertyChange(ComponentInterface source, String propertyName, int oldValue, int newValue) {
        if (oldValue == newValue || !source.anyPropertyChangeListeners()) {
            return;
        }
        ComponentInterfaceSupport.firePropertyChangeQuickly(source, propertyName, new Integer(oldValue), new Integer(newValue));
    }

    public static void firePropertyChange(ComponentInterface source, String propertyName, float oldValue, float newValue) {
        boolean oldIsNaN = Float.isNaN(oldValue);
        boolean newIsNaN = Float.isNaN(newValue);
        if (oldIsNaN && newIsNaN || !oldIsNaN && !newIsNaN && oldValue == newValue || !source.anyPropertyChangeListeners()) {
            return;
        }
        ComponentInterfaceSupport.firePropertyChangeQuickly(source, propertyName, new Float(oldValue), new Float(newValue));
    }

    public static void firePropertyChange(ComponentInterface source, String propertyName, double oldValue, double newValue) {
        boolean oldIsNaN = Double.isNaN(oldValue);
        boolean newIsNaN = Double.isNaN(newValue);
        if (oldIsNaN && newIsNaN || !oldIsNaN && !newIsNaN && oldValue == newValue || !source.anyPropertyChangeListeners()) {
            return;
        }
        ComponentInterfaceSupport.firePropertyChangeQuickly(source, propertyName, new Double(oldValue), new Double(newValue));
    }

    public static void firePropertyChange(ComponentInterface source, String propertyName, char oldValue, char newValue) {
        if (oldValue == newValue || !source.anyPropertyChangeListeners()) {
            return;
        }
        ComponentInterfaceSupport.firePropertyChangeQuickly(source, propertyName, new Character(oldValue), new Character(newValue));
    }

    public static void firePropertyChange(ComponentInterface source, String propertyName, byte oldValue, byte newValue) {
        if (oldValue == newValue || !source.anyPropertyChangeListeners()) {
            return;
        }
        ComponentInterfaceSupport.firePropertyChangeQuickly(source, propertyName, new Byte(oldValue), new Byte(newValue));
    }

    public static void firePropertyChange(ComponentInterface source, String propertyName, short oldValue, short newValue) {
        if (oldValue == newValue || !source.anyPropertyChangeListeners()) {
            return;
        }
        ComponentInterfaceSupport.firePropertyChangeQuickly(source, propertyName, new Short(oldValue), new Short(newValue));
    }

    public static void firePropertyChange(ComponentInterface source, String propertyName, long oldValue, long newValue) {
        if (oldValue == newValue || !source.anyPropertyChangeListeners()) {
            return;
        }
        ComponentInterfaceSupport.firePropertyChangeQuickly(source, propertyName, new Long(oldValue), new Long(newValue));
    }

    public static void firePropertyChange(ComponentInterface source, String propertyName, boolean newValue) {
        if (!source.anyPropertyChangeListeners()) {
            return;
        }
        ComponentInterfaceSupport.firePropertyChangeQuickly(source, propertyName, newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void firePropertyChangeQuickly(ComponentInterface source, String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)source, propertyName, oldValue, newValue);
        source.firePropertyChange((java.beans.PropertyChangeEvent)propertyChangeEvent);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }
}

