/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.viewregistry;

import com.sas.deploymntreg.DeployAPI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class Report {
    public static final String[] productNamesWantingAllVersions = new String[]{"eguide", "msofficeint"};
    public static final String serializationHotfixFile = "serialization_hotfix.properties";
    public static final String securityHotfixFile = "security_hotfix.properties";
    private static final String instqualtoolName = "instqualtool";
    String code;
    String hostName;
    String displayName;
    String versionNumber;
    String maintenanceVersion;
    Vector<String> hotFixVersion;

    Report(String c, String h, String d, String v, String m, Vector<String> hf) {
        this.code = c;
        this.hostName = h;
        this.displayName = d;
        this.versionNumber = v;
        this.maintenanceVersion = m;
        this.hotFixVersion = hf;
    }

    Report(String c, String h, String d, String v, String m) {
        this.code = c;
        this.hostName = h;
        this.displayName = d;
        this.versionNumber = v;
        this.maintenanceVersion = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        String textFile = "";
        String htmlFile = "";
        boolean hotfixOnly = false;
        boolean redirectOutput = false;
        boolean allVersions = false;
        String sep = System.getProperty("file.separator");
        String maint_level = "";
        if (Report.validateOptions(argv)) {
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equalsIgnoreCase("-hotfix")) {
                    hotfixOnly = true;
                }
                if (argv[i].equalsIgnoreCase("-out")) {
                    redirectOutput = true;
                    htmlFile = argv[i + 1] + sep + "DeploymentRegistry.html";
                    textFile = argv[i + 1] + sep + "DeploymentRegistry.txt";
                }
                if (!argv[i].equalsIgnoreCase("-all")) continue;
                allVersions = true;
            }
            if (!redirectOutput) {
                htmlFile = "." + sep + "DeploymentRegistry.html";
                textFile = "." + sep + "DeploymentRegistry.txt";
            }
            try {
                DeployAPI.open();
                String sasHome = DeployAPI.getSASHome();
                maint_level = Report.getPlatformMaintenanceLevel(sasHome);
                Collection<Report> registryData = Report.collectRegistryData();
                if (!allVersions) {
                    registryData = Report.getLatestProductVersions(registryData);
                }
                Report.writeReport(Report.formatWebReport(registryData, hotfixOnly, sasHome, maint_level), htmlFile);
                Report.writeReport(Report.formatTextReport(registryData, hotfixOnly, sasHome, maint_level), textFile);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            finally {
                DeployAPI.close();
            }
        }
    }

    public static Vector<Report> collectRegistryData() {
        Vector<Report> _registryEntries = new Vector<Report>();
        String[] hosts = DeployAPI.getInstallHosts();
        for (int i = 0; i < hosts.length; ++i) {
            String host = hosts[i];
            String[] products = DeployAPI.getInstallCodes(host);
            for (int j = 0; j < products.length; ++j) {
                String product = products[j];
                String[] versions = DeployAPI.getInstallVersions(product, host);
                for (int k = 0; k < versions.length; ++k) {
                    String version = versions[k];
                    Report regEntry = new Report(product, host, DeployAPI.getInstallDisplayName(product, version, host), version, "");
                    String[] maintVersions = DeployAPI.getMaintVersions(product, version, host);
                    String maintLevel = DeployAPI.getMaintLevel(product, version, host);
                    boolean maintLevelFound = false;
                    Vector<String> hFixes = new Vector<String>();
                    for (int l = 0; l < maintVersions.length; ++l) {
                        String maintenance = maintVersions[l];
                        if (maintLevelFound) {
                            hFixes.add(DeployAPI.getMaintDisplayName(product, version, host, maintenance));
                            continue;
                        }
                        if (!maintenance.equals(maintLevel)) continue;
                        maintLevelFound = true;
                        regEntry.maintenanceVersion = DeployAPI.getMaintDisplayName(product, version, host, maintenance);
                    }
                    regEntry.hotFixVersion = hFixes;
                    _registryEntries.add(regEntry);
                }
            }
        }
        Report.addSerializationHotfixData(_registryEntries);
        Report.addSecurityHotfixData(_registryEntries);
        return _registryEntries;
    }

    public static boolean validateOptions(String[] opts) {
        boolean validOptions = true;
        for (int i = 0; i < opts.length; ++i) {
            if (opts[i].startsWith("-") && !opts[i].equalsIgnoreCase("-hotfix") && !opts[i].equalsIgnoreCase("-out") && !opts[i].equalsIgnoreCase("-all")) {
                validOptions = false;
                System.out.println(opts[i] + " is not a valid option.");
                System.out.println("Valid options are: \n\"-out\" followed by a path for redirecting output \n\"-hotfix\" for displaying only product data containing hot fixes.");
                continue;
            }
            if (!opts[i].equalsIgnoreCase("-out")) continue;
            if (i == opts.length - 1) {
                validOptions = false;
                System.out.println("-out must be followed by a path. Please run again using -out with a valid path.");
                continue;
            }
            File path = new File(opts[i + 1]);
            if (!path.isDirectory()) {
                validOptions = false;
                System.out.println("The path \"" + opts[i + 1] + "\" is not valid.  Please run again using -out with a valid path.");
                continue;
            }
            if (path.canWrite()) continue;
        }
        return validOptions;
    }

    public static String formatWebReport(Collection<Report> r, boolean hFix, String sasHomeValue, String maint_level) {
        StringBuffer htmlBuffer = new StringBuffer();
        String HTMLSTART = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><html><head><title>SAS Deployment Registry Report</title><style>body { font-family: Arial, Helvetica, sans-serif; font-size: 10pt;}</style></head><body>";
        String HTMLEND = "</body></html>";
        String HEADER_DIV = "<div style=\"width:100%; background-color:#003399\"></div>";
        String DATA_DIV = "<div style=\"width:100%; padding:10px; border:1px solid #dddddd; margin:0px;\">";
        String DOCHEADING = "SAS Installed Software And Components";
        htmlBuffer.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><html><head><title>SAS Deployment Registry Report</title><style>body { font-family: Arial, Helvetica, sans-serif; font-size: 10pt;}</style></head><body>").append("<div style=\"width:100%; background-color:#003399\"></div>").append("<h1>").append("SAS Installed Software And Components").append("</h1>").append("<div style=\"width:100%; background-color:#003399\"></div>").append("<br/>");
        htmlBuffer.append("<div style=\"width:100%; padding:10px; border:1px solid #dddddd; margin:0px;\">").append("<table>").append("<tr><td>SASHOME:</td><td>").append(sasHomeValue).append("</td></tr>").append("<tr><td>MAINTENANCE:</td><td>").append(maint_level).append("</td></tr>").append("</table></div>");
        for (Report regData : r) {
            if (hFix && regData.hotFixVersion.isEmpty()) continue;
            htmlBuffer.append("<div style=\"width:100%; padding:10px; border:1px solid #dddddd; margin:0px;\">").append("<table>");
            htmlBuffer.append("<tr><td align=\"right\"><b>Host:</b></td><td>").append(regData.hostName).append("</td></tr>");
            htmlBuffer.append("<tr><td align=\"right\"><b>Product Code:</b></td><td>").append(regData.code).append("</td></tr>");
            htmlBuffer.append("<tr><td align=\"right\"><b>Version:</b></td><td>").append(regData.versionNumber).append("</td></tr>");
            htmlBuffer.append("<tr><td align=\"right\"><b>Display Name:<b/></td><td>").append(regData.displayName).append("</td></tr>");
            if (!regData.hotFixVersion.isEmpty()) {
                for (String hfData : regData.hotFixVersion) {
                    htmlBuffer.append("<tr><td align=\"right\"><b>Hot Fix Entry:</b></td><td>").append(hfData).append("</td></tr>");
                }
            }
            htmlBuffer.append("<tr><td align=\"right\"><b>Display Version:</b></td><td>").append(regData.maintenanceVersion).append("</td></tr>");
            htmlBuffer.append("</table></div>");
        }
        htmlBuffer.append("</body></html>");
        return htmlBuffer.toString();
    }

    public static String formatTextReport(Collection<Report> r, boolean hFix, String sasHomeValue, String maint_level) {
        StringBuffer textBuffer = new StringBuffer();
        String docHeading = "SAS Installed Software And Components";
        String separator = System.getProperty("line.separator");
        String bar = "-------------------------------------------------------------------------------";
        textBuffer.append(docHeading).append(separator).append(separator).append("SASHOME: ").append(sasHomeValue).append(separator).append("MAINTENANCE: ").append(maint_level).append(separator).append(separator);
        for (Report regData : r) {
            if (hFix && regData.hotFixVersion.isEmpty()) continue;
            textBuffer.append("           Host: ").append(regData.hostName).append(separator);
            textBuffer.append("        Product: ").append(regData.code).append(separator);
            textBuffer.append("        Version: ").append(regData.versionNumber).append(separator);
            textBuffer.append("   Display Name: ").append(regData.displayName).append(separator);
            if (!regData.hotFixVersion.isEmpty()) {
                for (String hfData : regData.hotFixVersion) {
                    textBuffer.append("  Hot Fix Entry: ").append(hfData).append(separator);
                }
            }
            textBuffer.append("Display Version: ").append(regData.maintenanceVersion).append(separator);
            textBuffer.append(bar).append(separator).append(separator);
        }
        return textBuffer.toString();
    }

    public static void writeReport(String str, String fle) {
        try {
            FileWriter fout = new FileWriter(fle);
            fout.write(str);
            fout.close();
        }
        catch (IOException e) {
            System.out.println("Error writing file:  " + fle + "\n" + e);
        }
    }

    private static Collection<Report> getLatestProductVersions(Collection<Report> registryData) {
        HashMap<String, Report> registryHash = new HashMap<String, Report>();
        ArrayList<Report> productsWithAllVersions = new ArrayList<Report>();
        for (Report report : registryData) {
            String reportKey = report.code + report.hostName;
            if (Report.isProductExcludedFromVersionTrim(report.code)) {
                productsWithAllVersions.add(report);
                continue;
            }
            if (registryHash.containsKey(reportKey) && !Report.hashHasEarlierVersion(registryHash, report, reportKey)) continue;
            registryHash.put(reportKey, report);
        }
        ArrayList<Report> shortList = new ArrayList<Report>(registryHash.values());
        shortList.addAll(productsWithAllVersions);
        return shortList;
    }

    private static boolean hashHasEarlierVersion(Map<String, Report> registryHash, Report product, String productKey) {
        Report hashReport = registryHash.get(productKey);
        String hashDate = DeployAPI.getInstallLastPortDate(hashReport.code, hashReport.versionNumber, hashReport.hostName);
        String newDate = DeployAPI.getInstallLastPortDate(product.code, product.versionNumber, product.hostName);
        String hashVersion = hashReport.versionNumber;
        String newVersion = product.versionNumber;
        if (hashDate != null && newDate != null && Report.compareDates(hashDate, newDate) == 1) {
            return true;
        }
        return hashVersion != null && newVersion != null && Report.compareVersions(hashVersion, newVersion) == newVersion;
    }

    private static boolean isProductExcludedFromVersionTrim(String productCode) {
        ArrayList<String> excludedProducts = new ArrayList<String>(Arrays.asList(productNamesWantingAllVersions));
        return excludedProducts.contains(productCode);
    }

    public static int compareDates(String date1, String date2) {
        if (date1 == null && date2 == null) {
            return 0;
        }
        if (date1.length() != 9 || date2.length() != 9) {
            throw new NumberFormatException("Supplied last port date is not in ddMMMyyyy format");
        }
        if (date1 == null || date1.length() != 9) {
            return 1;
        }
        long time1 = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(date1, new ParsePosition(0)).getTime();
        if (date2 == null || date2.length() != 9) {
            return -1;
        }
        long time2 = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(date2, new ParsePosition(0)).getTime();
        if (time1 == time2) {
            return 0;
        }
        if (time1 > time2) {
            return -1;
        }
        if (time2 > time1) {
            return 1;
        }
        return 0;
    }

    private static String compareVersions(String version1, String version2) {
        int result = version1.compareTo(version2);
        if (result == 0) {
            return version1;
        }
        String[] version1Members = version1.split("\\.");
        String[] version2Members = version2.split("\\.");
        for (int i = 0; i < version1Members.length; ++i) {
            int version1LastIndex = version1Members.length - 1;
            if (i < version2Members.length) {
                int value2;
                int value1 = Integer.parseInt(version1Members[i]);
                if (value1 > (value2 = Integer.parseInt(version2Members[i]))) {
                    return version1;
                }
                if (value1 < value2) {
                    return version2;
                }
                if (i == version1LastIndex && version2Members.length > version1Members.length) {
                    return version2;
                }
            }
            if (i != version2Members.length) continue;
            return version1;
        }
        return "";
    }

    private static void addSerializationHotfixData(Collection<Report> registryEntries) throws IllegalArgumentException {
        Report instqualtoolReport = Report.getReportByProduct(registryEntries, instqualtoolName);
        if (instqualtoolReport == null) {
            System.out.println("The product code instqualtool which is used for the management of quarterly security updates could not be found in the SAS deployment registry.");
            return;
        }
        String hotfixVersion = Report.getSerializationHotfixVersion(instqualtoolReport.versionNumber);
        if (hotfixVersion.isEmpty()) {
            hotfixVersion = Report.getStandaloneSerializationHotfixVersion();
        }
        if (instqualtoolReport != null && !hotfixVersion.isEmpty()) {
            Report.addHotfixReport(registryEntries, "secupdate", instqualtoolReport.hostName, "SAS Security Update", hotfixVersion);
        }
    }

    private static void addSecurityHotfixData(Collection<Report> registryEntries) {
        Report instqualtoolReport = Report.getReportByProduct(registryEntries, instqualtoolName);
        if (instqualtoolReport == null) {
            return;
        }
        String hotfixVersion = Report.getSecurityHotfixVersion(instqualtoolReport.versionNumber);
        if (hotfixVersion.isEmpty()) {
            hotfixVersion = Report.getStandaloneSecurityHotfixVersion();
        }
        if (instqualtoolReport != null && !hotfixVersion.isEmpty()) {
            Report.addHotfixReport(registryEntries, "secupdate2", instqualtoolReport.hostName, "SAS Security Update 2", hotfixVersion);
        }
    }

    private static void addHotfixReport(Collection<Report> registryEntries, String code, String hostName, String displayName, String hotfixVersion) {
        String versionNumber = hotfixVersion;
        String maintenanceVersion = hotfixVersion;
        Report hotfixReport = new Report(code, hostName, displayName, versionNumber, maintenanceVersion, new Vector<String>());
        registryEntries.add(hotfixReport);
    }

    private static Report getReportByProduct(Collection<Report> registryEntries, String product) {
        for (Report report : registryEntries) {
            if (!report.code.equals(product)) continue;
            return report;
        }
        return null;
    }

    private static String getStandaloneSerializationHotfixVersion() {
        return Report.getStandaloneHotfixVersion(serializationHotfixFile);
    }

    private static String getStandaloneSecurityHotfixVersion() {
        return Report.getStandaloneHotfixVersion(securityHotfixFile);
    }

    private static String getStandaloneHotfixVersion(String hotfixFile) {
        String sasHome = DeployAPI.getSASHome();
        String separator = System.getProperty("file.separator");
        String versionFilePath = sasHome + separator + instqualtoolName + separator + hotfixFile;
        File versionFile = new File(versionFilePath);
        return Report.getHotfixVersionFromFile(versionFile);
    }

    private static String getSerializationHotfixVersion(String version) {
        return Report.getHotfixVersion(version, serializationHotfixFile);
    }

    private static String getSecurityHotfixVersion(String version) {
        return Report.getHotfixVersion(version, securityHotfixFile);
    }

    private static String getHotfixVersion(String version, String hotfixFile) {
        String instqualtoolLoc = DeployAPI.getInstallLoc(instqualtoolName, version);
        File versionFile = new File(instqualtoolLoc, hotfixFile);
        return Report.getHotfixVersionFromFile(versionFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHotfixVersionFromFile(File versionFile) {
        String hotfixVersion = "";
        FileInputStream input = null;
        try {
            input = new FileInputStream(versionFile.toString());
            Properties props = new Properties();
            props.load(input);
            hotfixVersion = props.getProperty("version", "");
        }
        catch (FileNotFoundException e) {
            String string = hotfixVersion;
            return string;
        }
        catch (IOException e) {
            String string = hotfixVersion;
            return string;
        }
        finally {
            try {
                if (input != null) {
                    ((InputStream)input).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return hotfixVersion;
    }

    private static String getPlatformMaintenanceLevel(String sasHome) {
        String maint_level = "";
        String order = DeployAPI.getLastOrder();
        String separator = System.getProperty("file.separator");
        String versionFilePath = sasHome + separator + "SASDeploymentManager" + separator + "9.4" + separator + "order_data" + separator + order + separator + "order.xml";
        File versionFile = new File(versionFilePath);
        if (versionFile.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(versionFile);
                XPath xPath = XPathFactory.newInstance().newXPath();
                String expression = "/order/@maint_level";
                String maintLevel = (String)xPath.evaluate(expression, document, XPathConstants.STRING);
                if (maintLevel.matches("TS1M\\d+")) {
                    String numberPart = maintLevel.substring(4);
                    maint_level = "94M" + numberPart;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("File does not exist at: " + versionFilePath);
        }
        return maint_level;
    }
}

