/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.legal;

import com.sas.framework.legal.i18n.LegalRB;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public final class SASLegalNotices {
    public static final String MYSQL = "SASLegalNotices.Acknowledgement.MySQL.txt";
    public static final String APACHE = "SASLegalNotices.Acknowledgement.Apache.txt";
    private static final Pattern COPYRIGHT = Pattern.compile("\\(c\\)");
    private static final Pattern NEWLINE = Pattern.compile("\n");
    private static final String RESOURCE_ALLRIGHTSRESERVED = "SASLegalNotices.AllRightsReserved.txt";

    private SASLegalNotices() {
    }

    public static String getLegalStatement(String copyrightYear, String thirdPartyInfo) {
        return SASLegalNotices.getLegalStatement(copyrightYear, null, thirdPartyInfo, false, Locale.getDefault());
    }

    public static String getLegalStatement(String copyrightYear, String thirdPartyInfo, Locale locale) {
        return SASLegalNotices.getLegalStatement(copyrightYear, null, thirdPartyInfo, false, locale);
    }

    public static String getLegalStatement(String copyrightYear, String copyrightLastYear, String thirdPartyInfo) {
        return SASLegalNotices.getLegalStatement(copyrightYear, copyrightLastYear, thirdPartyInfo, false, Locale.getDefault());
    }

    public static String getLegalStatement(String copyrightYear, String copyrightLastYear, String thirdPartyInfo, Locale locale) {
        return SASLegalNotices.getLegalStatement(copyrightYear, copyrightLastYear, thirdPartyInfo, false, locale);
    }

    public static String getLegalStatement(String copyrightFirstYear, String copyrightLastYear, String thirdPartyInfo, boolean formatForHTML) {
        return SASLegalNotices.getLegalStatement(copyrightFirstYear, copyrightLastYear, thirdPartyInfo, formatForHTML, Locale.getDefault());
    }

    public static String getLegalStatement(String copyrightFirstYear, String copyrightLastYear, String thirdPartyInfo, boolean formatForHTML, Locale locale) {
        String msg;
        String copyright;
        Object[] args;
        String msg2;
        if (null == copyrightLastYear || StringUtils.equals((CharSequence)copyrightFirstYear, (CharSequence)copyrightLastYear)) {
            msg2 = LegalRB.getString("SASLegalNotices.Copyright.MultiLine.SingleYear.fmt.txt", locale);
            args = new Object[]{copyrightFirstYear, LegalRB.getString(RESOURCE_ALLRIGHTSRESERVED, locale)};
            copyright = new MessageFormat(msg2).format(args, new StringBuffer(), (FieldPosition)null).toString();
        } else {
            msg2 = LegalRB.getString("SASLegalNotices.Copyright.MultiLine.RangeOfYears.fmt.txt", locale);
            args = new Object[]{copyrightFirstYear, copyrightLastYear, LegalRB.getString(RESOURCE_ALLRIGHTSRESERVED, locale)};
            copyright = new MessageFormat(msg2).format(args, new StringBuffer(), (FieldPosition)null).toString();
        }
        String statement = null;
        if (null == thirdPartyInfo) {
            msg = LegalRB.getString("SASLegalNotices.LegalStatement.NoThirdParty.fmt.txt", locale);
            Object[] args2 = new Object[]{copyright, LegalRB.getString("SASLegalNotices.GeneralProtection.txt", locale), LegalRB.getString("SASLegalNotices.GovtRestrictedRights.Title.txt", locale), LegalRB.getString("SASLegalNotices.GovtRestrictedRights.Desc.txt", locale)};
            statement = new MessageFormat(msg).format(args2, new StringBuffer(), (FieldPosition)null).toString();
        } else {
            msg = LegalRB.getString("SASLegalNotices.LegalStatement.ThirdParty.fmt.txt", locale);
            Object[] args3 = new Object[]{copyright, LegalRB.getString("SASLegalNotices.GeneralProtection.txt", locale), LegalRB.getString("SASLegalNotices.GovtRestrictedRights.Title.txt", locale), LegalRB.getString("SASLegalNotices.GovtRestrictedRights.Desc.txt", locale), thirdPartyInfo};
            statement = new MessageFormat(msg).format(args3, new StringBuffer(), (FieldPosition)null).toString();
        }
        if (formatForHTML) {
            return SASLegalNotices.formatForHTML(statement);
        }
        return statement;
    }

    public static String getSingleLineCopyright(String copyrightFirstYear, String copyrightLastYear) {
        return SASLegalNotices.getSingleLineCopyright(copyrightFirstYear, copyrightLastYear, false, Locale.getDefault());
    }

    public static String getSingleLineCopyright(String copyrightFirstYear, String copyrightLastYear, Locale locale) {
        return SASLegalNotices.getSingleLineCopyright(copyrightFirstYear, copyrightLastYear, false, locale);
    }

    public static String getSingleLineCopyright(String copyrightFirstYear, String copyrightLastYear, boolean formatForHTML) {
        return SASLegalNotices.getSingleLineCopyright(copyrightFirstYear, copyrightLastYear, formatForHTML, Locale.getDefault());
    }

    public static String getSingleLineCopyright(String copyrightFirstYear, String copyrightLastYear, boolean formatForHTML, Locale locale) {
        String copyright;
        if (null == copyrightLastYear || StringUtils.equals((CharSequence)copyrightFirstYear, (CharSequence)copyrightLastYear)) {
            Object[] args = new Object[]{copyrightFirstYear, LegalRB.getString(RESOURCE_ALLRIGHTSRESERVED, locale)};
            copyright = LegalRB.formatString("SASLegalNotices.Copyright.SingleLine.SingleYear.fmt.txt", locale, args);
        } else {
            Object[] args = new Object[]{copyrightFirstYear, copyrightLastYear, LegalRB.getString(RESOURCE_ALLRIGHTSRESERVED, locale)};
            copyright = LegalRB.formatString("SASLegalNotices.Copyright.SingleLine.RangeOfYears.fmt.txt", locale, args);
        }
        if (formatForHTML) {
            return SASLegalNotices.formatForHTML(copyright);
        }
        return copyright;
    }

    public static String getAcknowledgement(String ackKey) {
        return SASLegalNotices.getAcknowledgement(ackKey, null, false);
    }

    public static String getAcknowledgement(String ackKey, boolean formatForHTML) {
        return SASLegalNotices.getAcknowledgement(ackKey, null, formatForHTML);
    }

    public static String getAcknowledgement(String ackKey, Locale locale) {
        return SASLegalNotices.getAcknowledgement(ackKey, locale, false);
    }

    public static String getAcknowledgement(String ackKey, Locale locale, boolean formatForHTML) {
        String notice = null;
        try {
            notice = null == locale ? LegalRB.getString(ackKey) : LegalRB.getString(ackKey, locale);
        }
        catch (MissingResourceException mre) {
            System.err.println(mre);
        }
        if (formatForHTML) {
            return SASLegalNotices.formatForHTML(notice);
        }
        return notice;
    }

    private static String formatForHTML(String legalstring) {
        String legalstr = StringEscapeUtils.escapeHtml4((String)legalstring);
        legalstr = COPYRIGHT.matcher(legalstr).replaceAll("&copy;");
        legalstr = NEWLINE.matcher(legalstr).replaceAll("<br/>");
        return legalstr;
    }
}

