/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.setinit;

import com.sas.util.setinit.SetinitVerifierInterface;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class Setinit
extends ClassLoader {
    static Class<?> verifierClass;
    private byte[] database;
    private static final int DATA_SIZE = 8;
    private static final int DATA_ARRAY_SIZE = 16;

    public static SetinitVerifierInterface getSetinitValidator(URL location) throws ClassNotFoundException, IOException, Exception {
        try {
            Setinit.loadSetinitVerifierClass();
            Constructor<?> c = verifierClass.getConstructor(URL.class);
            SetinitVerifierInterface si = (SetinitVerifierInterface)c.newInstance(location);
            return si;
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private static synchronized void loadSetinitVerifierClass() throws PrivilegedActionException, ClassNotFoundException {
        if (null == verifierClass) {
            ClassLoader sClass = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException, IOException {
                    try {
                        URL url = Setinit.class.getResource("res/setinit");
                        byte[] b = Setinit.getBytes(url);
                        if (b == null) {
                            throw new ClassNotFoundException("Setinit");
                        }
                        Setinit s = new Setinit(Setinit.class.getClassLoader(), b);
                        return s;
                    }
                    catch (DataFormatException e) {
                        throw new ClassNotFoundException("Setinit");
                    }
                }
            });
            verifierClass = sClass.loadClass("com.sas.util.setinit.SetinitFileVerifier");
        }
    }

    public static SetinitVerifierInterface getSetinitValidator(String setinitString) throws ClassNotFoundException, IOException, Exception {
        try {
            Setinit.loadSetinitVerifierClass();
            Constructor<?> c = verifierClass.getConstructor(String.class);
            SetinitVerifierInterface si = (SetinitVerifierInterface)c.newInstance(setinitString);
            return si;
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(URL url) throws IOException {
        byte[] b;
        if (url == null) {
            return null;
        }
        InputStream in = null;
        try {
            URLConnection uc = url.openConnection();
            in = uc.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
        try {
            int len;
            if (len != -1) {
                int n;
                b = new byte[len];
                for (len = uc.getContentLength(); len > 0; len -= n) {
                    n = in.read(b, b.length - len, len);
                    if (n != -1) continue;
                    throw new IOException("unexpected EOF");
                }
            } else {
                byte[] tmp;
                b = new byte[1024];
                int total = 0;
                while ((len = in.read(b, total, b.length - total)) != -1) {
                    if ((total += len) < b.length) continue;
                    tmp = new byte[total * 2];
                    System.arraycopy(b, 0, tmp, 0, total);
                    b = tmp;
                }
                if (total != b.length) {
                    tmp = new byte[total];
                    System.arraycopy(b, 0, tmp, 0, total);
                    b = tmp;
                }
            }
        }
        finally {
            in.close();
        }
        return b;
    }

    protected Setinit(ClassLoader parent, byte[] b) throws DataFormatException, IOException {
        super(parent);
        Inflater d = new Inflater();
        d.setInput(b);
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        do {
            int len;
            if ((len = d.inflate(data)) == 0) continue;
            ba.write(data, 0, len);
        } while (!d.finished());
        this.database = ba.toByteArray();
        ba.close();
    }

    private int getValue(int i) {
        return ((((((((this.database[i] & 0xFF) << 8) + (this.database[i + 1] & 0xFF) << 8) + (this.database[i + 2] & 0xFF) << 8) + (this.database[i + 3] & 0xFF) << 8) + (this.database[i + 4] & 0xFF) << 8) + (this.database[i + 5] & 0xFF) << 8) + (this.database[i + 6] & 0xFF) << 8) + (this.database[i + 7] & 0xFF);
    }

    protected Class findClass(String className) {
        int numClasses = this.database[0];
        for (int i = 0; i < numClasses; ++i) {
            int len;
            int offset = i * 16 + 1;
            int classNameOffset = this.getValue(offset);
            int classDataOffset = this.getValue(offset + 8);
            for (len = 0; len < this.database.length - classNameOffset && this.database[len + classNameOffset] != 0; ++len) {
            }
            if (len > this.database.length - classNameOffset) {
                throw new ClassFormatError();
            }
            String name = new String(this.database, classNameOffset, len);
            if (!name.equals(className)) continue;
            int dataLen = this.getValue(classDataOffset);
            Class<?> c = this.defineClass(name, this.database, classDataOffset + 8, dataLen, this.getClass().getProtectionDomain());
            this.resolveClass(c);
            return c;
        }
        return null;
    }
}

