/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.vgf;

import com.sas.graphics.util.FontManager;
import com.sas.util.BASE64;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class VGFGraphics2D
extends Graphics2D {
    private boolean debugMode = false;
    private boolean isDisposed = false;
    protected static final int BUFSIZE = 1024;
    protected static final int indentSpacing = 4;
    protected static final double deg2rad = Math.PI / 180;
    protected static final double rad2deg = 57.29577951308232;
    protected boolean closeWriter;
    protected boolean linkOpen;
    protected int groupNesting;
    protected int currentIndent;
    protected boolean clipGroup;
    protected int width;
    protected int height;
    protected static long sequenceNumber = 0L;
    protected PrintStream printStream;
    protected Color currentColor;
    protected Color currentBackgroundColor;
    protected Paint currentPaint;
    protected Stroke currentStroke;
    protected Composite currentComposite;
    protected String currentColorString;
    protected String currentPaintDefinition;
    protected String currentFontDefinition;
    protected String currentFontTransformDefinition;
    protected String currentClipPathNumber;
    protected Font currentFont;
    protected Shape currentClip;
    protected Hashtable<Shape, String> clipDictionary;
    protected AffineTransform currentTransform;
    protected AffineTransform previousTransform;
    protected AffineTransform tempTransform;
    protected double[] transformationMatrixValues;
    protected double[] currentTextTranslationPoint;
    protected Graphics g;
    protected BufferedImage bufferedImage;
    protected boolean contextIsRotated = false;
    private boolean applyClip = false;
    private boolean textClip = true;
    private static final int MAX_COMPLEXITY_COUNT = 100000;
    private static int complexityCount = 0;
    public static boolean SVG_destination = false;
    public static boolean selectionMode = false;
    boolean flag = false;

    public VGFGraphics2D() {
        this((Component)null, (String)null);
    }

    public VGFGraphics2D(Component comp, String outputFile) {
        this(comp, outputFile == null ? null : new File(outputFile));
    }

    public VGFGraphics2D(Component comp, File outputFile) {
        this.init(comp, outputFile);
        this.closeWriter = true;
    }

    protected VGFGraphics2D(VGFGraphics2D g) {
        this.bufferedImage = null;
        this.closeWriter = false;
        this.currentBackgroundColor = g.currentBackgroundColor;
        this.currentClip = g.currentClip;
        this.currentClipPathNumber = g.currentClipPathNumber;
        this.currentColor = g.currentColor;
        this.currentColorString = g.currentColorString;
        this.currentComposite = g.currentComposite;
        this.currentFont = g.currentFont;
        this.currentFontDefinition = g.currentFontDefinition;
        this.currentFontTransformDefinition = g.currentFontTransformDefinition;
        this.currentIndent = g.currentIndent;
        this.currentPaint = g.currentPaint;
        this.currentPaintDefinition = g.currentPaintDefinition;
        this.clipDictionary = g.clipDictionary;
        this.currentStroke = g.currentStroke;
        this.currentTransform = g.currentTransform == null ? null : new AffineTransform(g.currentTransform);
        this.previousTransform = g.previousTransform == null ? null : new AffineTransform(g.previousTransform);
        this.g = g.g.create();
        this.groupNesting = 0;
        this.clipGroup = false;
        this.height = g.height;
        this.linkOpen = g.linkOpen;
        this.transformationMatrixValues = new double[6];
        this.currentTextTranslationPoint = new double[2];
        this.width = g.width;
        this.printStream = g.printStream;
    }

    public static boolean addComponentToOutput(VGFGraphics2D g, Component comp) {
        if (g == null || comp == null) {
            return false;
        }
        comp.paint(g);
        return true;
    }

    protected static boolean doRender(VGFGraphics2D g, Component comp, boolean optimizeForSpeed, boolean includeHeader) {
        boolean out = false;
        g.begin(optimizeForSpeed, includeHeader);
        out = VGFGraphics2D.addComponentToOutput(g, comp);
        g.end();
        return out;
    }

    public static boolean renderToSVG(Component comp, File file, boolean optimizeForSpeed, boolean includeHeader) {
        if (comp == null || file == null) {
            return false;
        }
        return VGFGraphics2D.doRender(new VGFGraphics2D(comp, file), comp, optimizeForSpeed, includeHeader);
    }

    protected void init(Component comp, File outputFile) {
        this.transformationMatrixValues = new double[6];
        this.currentTextTranslationPoint = new double[2];
        this.linkOpen = false;
        sequenceNumber = 0L;
        this.groupNesting = 0;
        this.clipGroup = false;
        this.closeWriter = false;
        this.currentIndent = 0;
        if (comp != null) {
            if (comp.getWidth() <= 0 || comp.getHeight() <= 0) {
                comp.setBounds(0, 0, 640, 480);
                comp.layout();
                comp.setVisible(true);
            }
            this.setSize(comp.getWidth(), comp.getHeight());
            this.g = comp.getGraphics();
            if (this.g == null && (this.bufferedImage = new BufferedImage(this.width, this.height, 1)) != null) {
                this.g = this.bufferedImage.getGraphics();
            }
        } else {
            this.setSize(640, 480);
            this.bufferedImage = new BufferedImage(this.width, this.height, 1);
            if (this.bufferedImage != null) {
                this.g = this.bufferedImage.getGraphics();
            }
        }
        this.currentColor = this.g != null ? this.g.getColor() : Color.black;
        this.currentColorString = this.colorToString(this.currentColor);
        this.currentBackgroundColor = Color.gray;
        this.currentPaint = null;
        this.currentPaintDefinition = null;
        this.currentFontDefinition = null;
        this.currentFontTransformDefinition = null;
        this.currentStroke = null;
        this.currentComposite = null;
        this.currentClipPathNumber = null;
        this.clipDictionary = new Hashtable();
        this.currentFont = FontManager.getFont((String)"Dialog", (int)0, (int)12);
        this.currentTransform = new AffineTransform();
        this.previousTransform = new AffineTransform(this.currentTransform);
        if (outputFile == null) {
            this.printStream = null;
        } else {
            try {
                this.printStream = new PrintStream((OutputStream)new FileOutputStream(outputFile), false, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected String colorToString(Color c) {
        String bs;
        String gs;
        String rs;
        if (c == null) {
            return null;
        }
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        try {
            rs = Integer.toHexString(r);
            if (rs == null) {
                return null;
            }
            gs = Integer.toHexString(g);
            if (gs == null) {
                return null;
            }
            bs = Integer.toHexString(b);
            if (bs == null) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (rs.length() < 2) {
            rs = "0" + rs;
        }
        if (gs.length() < 2) {
            gs = "0" + gs;
        }
        if (bs.length() < 2) {
            bs = "0" + bs;
        }
        return "#" + rs + gs + bs;
    }

    protected String getCurrentFill() {
        String s;
        int ia = 255;
        float a2 = 1.0f;
        float a1 = 1.0f;
        if (this.currentPaint != null && this.currentPaintDefinition != null) {
            s = " fill=\"url(#" + this.currentPaintDefinition + ")\"";
        } else if (this.currentColorString != null) {
            s = " fill=\"" + this.currentColorString + "\"";
            if (this.currentColor != null && (ia = this.currentColor.getAlpha()) < 255) {
                a1 = (float)ia / 255.0f;
            }
        } else {
            s = " fill=\"#000\"";
        }
        if (this.currentComposite != null) {
            a2 = ((AlphaComposite)this.currentComposite).getAlpha();
        }
        if (!selectionMode && (a1 < 1.0f || a2 < 1.0f)) {
            s = s + " opacity=\"" + a1 * a2 + "\"";
        }
        return s;
    }

    protected String getCurrentStroke() {
        float[] dashes;
        String s;
        int ia = 255;
        float a2 = 1.0f;
        float a1 = 1.0f;
        if (this.currentPaint != null && this.currentPaintDefinition != null) {
            s = " stroke=\"url(#" + this.currentPaintDefinition + ")\"";
        } else if (this.currentColorString != null) {
            s = " stroke=\"" + this.currentColorString + "\"";
            if (this.currentColor != null && (ia = this.currentColor.getAlpha()) < 255) {
                a1 = (float)ia / 255.0f;
            }
        } else {
            s = " stroke=\"#000\"";
        }
        if (this.currentComposite != null) {
            a2 = ((AlphaComposite)this.currentComposite).getAlpha();
        }
        if (a1 < 1.0f || a2 < 1.0f) {
            s = s + " stroke-opacity=\"" + a1 * a2 + "\"";
        }
        if (this.currentStroke == null) {
            return s;
        }
        BasicStroke bs = (BasicStroke)this.currentStroke;
        if (bs.getLineWidth() != 1.0f) {
            s = s + " stroke-width=\"" + bs.getLineWidth() + "\"";
        }
        switch (bs.getEndCap()) {
            default: {
                s = s + " stroke-linecap=\"butt\"";
                break;
            }
            case 1: {
                s = s + " stroke-linecap=\"round\"";
                break;
            }
            case 2: {
                s = s + " stroke-linecap=\"square\"";
            }
        }
        switch (bs.getLineJoin()) {
            case 2: {
                s = s + " stroke-linejoin=\"bevel\"";
                break;
            }
            default: {
                s = s + " stroke-linejoin=\"miter\"";
                break;
            }
            case 1: {
                s = s + " stroke-linejoin=\"round\"";
            }
        }
        if (bs.getMiterLimit() != 10.0f) {
            s = s + " stroke-miterlimit=\"" + bs.getMiterLimit() + "\"";
        }
        if (bs.getDashPhase() != 0.0f) {
            s = s + " stroke-dashoffset=\"" + bs.getDashPhase() + "\"";
        }
        if (bs.getDashArray() != null && (dashes = bs.getDashArray()).length != 0) {
            s = s + " stroke-dasharray=\"" + dashes[0];
            for (int i = 1; i < dashes.length; ++i) {
                s = s + "," + dashes[i];
            }
            s = s + "\"";
        }
        return s;
    }

    protected String getCurrentClipPath() {
        return "";
    }

    protected boolean writeString(String s) {
        String out = "";
        if (this.printStream == null) {
            return false;
        }
        for (int i = 0; i < this.currentIndent; ++i) {
            out = out + " ";
        }
        out = out + s;
        if (!this.isDisposed) {
            this.printStream.print(out + "\r\n");
        }
        if (this.debugMode) {
            this.writeDebugString(out);
        }
        ++complexityCount;
        return true;
    }

    protected void writeDebugString(String s) {
        System.out.println((this.isDisposed ? "<DISPOSED id=" + this.hashCode() + "> " : "") + s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleRect(Shape shape, boolean fill, String extra, boolean bare) {
        double h;
        double w;
        double y;
        double x;
        double aw = 0.0;
        double ah = 0.0;
        if (shape == null) {
            return;
        }
        if (shape instanceof Rectangle2D) {
            if (shape instanceof Rectangle2D.Double) {
                Rectangle2D.Double r2d = (Rectangle2D.Double)shape;
                x = r2d.x;
                y = r2d.y;
                w = r2d.width;
                h = r2d.height;
            } else if (shape instanceof Rectangle2D.Float) {
                Rectangle2D.Float r2f = (Rectangle2D.Float)shape;
                x = r2f.x;
                y = r2f.y;
                w = r2f.width;
                h = r2f.height;
            } else {
                Rectangle rect = shape.getBounds();
                if (rect == null) return;
                x = rect.x;
                y = rect.y;
                w = rect.width;
                h = rect.height;
            }
        } else {
            if (!(shape instanceof RoundRectangle2D)) return;
            if (shape instanceof RoundRectangle2D.Double) {
                RoundRectangle2D.Double rr2d = (RoundRectangle2D.Double)shape;
                x = rr2d.x;
                y = rr2d.y;
                w = rr2d.width;
                h = rr2d.height;
                aw = rr2d.getArcWidth();
                ah = rr2d.getArcHeight();
            } else if (shape instanceof RoundRectangle2D.Float) {
                RoundRectangle2D.Float rr2f = (RoundRectangle2D.Float)shape;
                x = rr2f.x;
                y = rr2f.y;
                w = rr2f.width;
                h = rr2f.height;
                aw = rr2f.getArcWidth();
                ah = rr2f.getArcHeight();
            } else {
                Rectangle rect = shape.getBounds();
                if (rect == null) return;
                x = rect.x;
                y = rect.y;
                w = rect.width;
                h = rect.height;
            }
        }
        this.handleRect(x, y, w, h, aw, ah, fill, extra, bare);
    }

    protected void handleRect(double x, double y, double w, double h, double arcWidth, double arcHeight, boolean fill, String extra, boolean bare) {
        String s = "<rect";
        if (arcWidth > 0.0 && arcHeight > 0.0) {
            s = s + " rx = \"" + arcWidth / 2.0 + "\" ry = \"" + arcHeight / 2.0 + "\"";
        }
        if (extra != null) {
            s = s + " " + extra;
        }
        if (!bare) {
            if (fill) {
                w -= 1.0;
                h -= 1.0;
                s = s + this.getCurrentFill() + (this.applyClip ? this.getCurrentClipPath() : "");
            } else {
                s = s + " fill=\"none\"" + this.getCurrentStroke() + (this.applyClip ? this.getCurrentClipPath() : "");
            }
        }
        if (w >= 0.0 && w < 1.0) {
            w = 1.0;
        }
        if (h >= 0.0 && h < 1.0) {
            h = 1.0;
        }
        s = s + String.format(Locale.US, " x=\"%.6f\" y=\"%.6f\" width=\"%.6f\" height=\"%.6f\" />", x, y, w, h);
        this.writeString(s);
    }

    protected void handleOval(Shape shape, boolean fill, boolean bare) {
        double h;
        double w;
        double y;
        double x;
        if (shape == null) {
            return;
        }
        if (shape instanceof Ellipse2D.Double) {
            Ellipse2D.Double e2d = (Ellipse2D.Double)shape;
            x = e2d.x;
            y = e2d.y;
            w = e2d.width;
            h = e2d.height;
        } else if (shape instanceof Ellipse2D.Float) {
            Ellipse2D.Float e2f = (Ellipse2D.Float)shape;
            x = e2f.x;
            y = e2f.y;
            w = e2f.width;
            h = e2f.height;
        } else {
            Rectangle rect = shape.getBounds();
            if (rect != null) {
                x = rect.x;
                y = rect.y;
                w = rect.width;
                h = rect.height;
            } else {
                return;
            }
        }
        this.handleOval(x, y, w, h, fill, bare);
    }

    protected void handleOval(double x, double y, double w, double h, boolean fill, boolean bare) {
        String clip = bare ? "" : this.getCurrentClipPath();
        String s = "<ellipse" + clip + String.format(Locale.US, " cx=\"%.6f\" cy=\"%.6f\" rx=\"%.6f\" ry=\"%.6f\"", x + w / 2.0, y + h / 2.0, w / 2.0, h / 2.0);
        s = bare ? s + " />" : (!fill ? s + " fill=\"none\" " + this.getCurrentStroke() + " />" : s + this.getCurrentFill() + " />");
        this.writeString(s);
    }

    protected void handlePolygons(int[] xPoints, int[] yPoints, int n, boolean close, boolean fill, boolean bare) {
        if (xPoints == null || yPoints == null || n <= 0) {
            return;
        }
        String clip = bare ? "" : this.getCurrentClipPath();
        String s = close ? "<polygon " : "<polyline ";
        s = bare ? s + " points=\"" : (!fill ? s + clip + " fill=\"none\" " + this.getCurrentStroke() + " points=\"" : s + clip + this.getCurrentFill() + " points=\"");
        this.writeString(s);
        this.currentIndent += 33;
        for (int i = 0; i < n; ++i) {
            this.writeString(xPoints[i] + "," + yPoints[i]);
        }
        this.currentIndent = Math.max(this.currentIndent - 33, 0);
        this.writeString("\" />");
    }

    protected void handleClipShape(Shape shape) {
        if (shape == null) {
            return;
        }
        if (shape instanceof Rectangle2D || shape instanceof RoundRectangle2D) {
            RectangularShape rect = (RectangularShape)shape;
            double x = rect.getX() - (SVG_destination ? 1.0 : 0.0);
            double y = rect.getY() - (SVG_destination ? 1.0 : 0.0);
            double width = rect.getWidth() + (SVG_destination ? 1.0 : -1.0);
            double height = rect.getHeight() + (SVG_destination ? 1.0 : -1.0);
            if (shape instanceof RoundRectangle2D) {
                this.handleRect(x, y, width, height, ((RoundRectangle2D)shape).getArcWidth() / 2.0, ((RoundRectangle2D)shape).getArcHeight() / 2.0, false, null, true);
            } else {
                this.handleRect(x, y, width, height, 0.0, 0.0, false, null, true);
            }
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellip = (Ellipse2D)shape;
            this.handleOval(ellip.getX(), ellip.getY(), ellip.getWidth(), ellip.getHeight(), false, true);
        } else if (shape instanceof Polygon) {
            Polygon poly = (Polygon)shape;
            this.handlePolygons(poly.xpoints, poly.ypoints, poly.npoints, true, false, true);
        } else if (shape instanceof GeneralPath || shape instanceof Area) {
            this.handlePath(shape, false, true);
        }
    }

    protected void handleCurve(Shape curve, boolean fill, boolean bare) {
        String clip;
        String fillString = bare ? "" : (fill ? this.getCurrentFill() : " fill=\"none\" " + this.getCurrentStroke());
        clip = bare || (clip = this.getCurrentClipPath()) == null ? "" : clip + " ";
        if (curve == null) {
            return;
        }
        if (curve instanceof CubicCurve2D) {
            CubicCurve2D cubic = (CubicCurve2D)curve;
            this.writeString("<path " + clip + fillString + " d=\"M" + cubic.getX1() + "," + cubic.getY1() + " C" + cubic.getCtrlX1() + "," + cubic.getCtrlY1() + " " + cubic.getCtrlX2() + "," + cubic.getCtrlY2() + " " + cubic.getX2() + "," + cubic.getY2() + "\" />");
        } else if (curve instanceof QuadCurve2D) {
            QuadCurve2D quad = (QuadCurve2D)curve;
            this.writeString("<path " + clip + fillString + " d=\"M" + quad.getX1() + "," + quad.getY1() + " Q" + quad.getCtrlX() + "," + quad.getCtrlY() + " " + quad.getX2() + "," + quad.getY2() + "\" />");
        }
    }

    protected void handlePath(Shape path, boolean fill, boolean bare) {
        String clip;
        boolean isArea = false;
        double lastx = Double.NaN;
        double lasty = Double.NaN;
        String s = null;
        if (path == null) {
            return;
        }
        isArea = path instanceof Area;
        PathIterator pi = path.getPathIterator(null);
        if (pi == null) {
            return;
        }
        double[] d = new double[6];
        if (d == null) {
            return;
        }
        String fillString = bare ? "" : (fill ? this.getCurrentFill() : " fill=\"none\" " + this.getCurrentStroke());
        clip = bare || (clip = this.getCurrentClipPath()) == null ? "" : clip + " ";
        while (!pi.isDone()) {
            if (s == null) {
                s = "<path " + clip + fillString + " d=\"";
                this.writeString(s);
            }
            int type = pi.currentSegment(d);
            pi.next();
            switch (type) {
                case 4: {
                    s = "Z ";
                    this.writeString(s);
                    break;
                }
                case 0: {
                    s = String.format(Locale.US, "M%.6f,%.6f ", d[0], d[1]);
                    this.writeString(s);
                    lastx = d[0];
                    lasty = d[0];
                    break;
                }
                case 1: {
                    s = String.format(Locale.US, "L%.6f,%.6f ", d[0], d[1]);
                    this.writeString(s);
                    lastx = d[0];
                    lasty = d[0];
                    break;
                }
                case 3: {
                    s = String.format(Locale.US, "C%.6f,%.6f, %.6f,%.6f %.6f,%.6f ", d[0], d[1], d[2], d[3], d[4], d[5]);
                    this.writeString(s);
                    lastx = d[4];
                    lasty = d[5];
                    break;
                }
                case 2: {
                    s = String.format(Locale.US, "Q%.6f,%.6f, %.6f,%.6f ", d[0], d[1], d[2], d[3]);
                    this.writeString(s);
                    lastx = d[2];
                    lasty = d[3];
                }
            }
        }
        if (s != null) {
            s = "\" />";
            this.writeString(s);
        }
    }

    public void handleLine(double x1, double y1, double x2, double y2) {
        String out = String.format(Locale.US, "<line x1=\"%.6f\" y1=\"%.6f\" x2=\"%.6f\" y2=\"%.6f\"", x1, y1, x2, y2);
        out = out + this.getCurrentStroke() + this.getCurrentClipPath() + " />";
        this.writeString(out);
    }

    protected void handleFont(Font f) {
        String style = f.isItalic() ? "italic" : "normal";
        String fontFamily = f.getFamily(Locale.US);
        if (fontFamily.equalsIgnoreCase("Monospaced")) {
            fontFamily = "monospace";
        }
        if (fontFamily.equalsIgnoreCase("Dialog") || fontFamily.equalsIgnoreCase("sansserif")) {
            fontFamily = "sans-serif";
        }
        if (fontFamily.equalsIgnoreCase("DialogInput")) {
            fontFamily = "monospace";
        }
        if (fontFamily.equalsIgnoreCase("monospace") || fontFamily.equalsIgnoreCase("sans-serif") || fontFamily.equalsIgnoreCase("serif")) {
            fontFamily = "&lt;" + fontFamily + "&gt;";
        }
        this.currentFontDefinition = "font-family=\"" + fontFamily + "\" font-style=\"" + style + "\" font-size=\"" + f.getSize() + "\"";
        if (f.isBold()) {
            this.currentFontDefinition = this.currentFontDefinition + " font-weight=\"bold\"";
        }
        if (f.isTransformed()) {
            AffineTransform af = f.getTransform();
            af.getMatrix(this.transformationMatrixValues);
            this.currentFontTransformDefinition = "matrix(" + this.transformationMatrixValues[0] + "," + this.transformationMatrixValues[1] + "," + this.transformationMatrixValues[2] + "," + this.transformationMatrixValues[3] + "," + this.transformationMatrixValues[4] + "," + this.transformationMatrixValues[5] + ")";
        } else {
            this.currentFontTransformDefinition = null;
        }
    }

    protected void handleArc(int x, int y, int w, int h, int startAngle, int arcAngle, boolean fill, int type, boolean bare) {
        String s;
        String clip;
        if (arcAngle == 360) {
            this.handleOval(x, y, w, h, fill, bare);
            return;
        }
        int largeArc = 0;
        int sweepFlag = 0;
        int rx = w / 2;
        int ry = h / 2;
        int cx = x + rx;
        int cy = y + ry;
        double xStart = (double)x + (double)rx * Math.cos((double)startAngle * (Math.PI / 180)) + (double)rx;
        double yStart = (double)y - (double)ry * Math.sin((double)startAngle * (Math.PI / 180)) + (double)ry;
        double xEnd = (double)x + (double)rx * Math.cos((double)(startAngle + arcAngle) * (Math.PI / 180)) + (double)rx;
        double yEnd = (double)y - (double)ry * Math.sin((double)(startAngle + arcAngle) * (Math.PI / 180)) + (double)ry;
        if (Math.abs(arcAngle) > 180) {
            largeArc = 1;
        }
        if (arcAngle < 0) {
            sweepFlag = 1;
        }
        String fillString = bare ? "" : (fill ? this.getCurrentFill() : " fill=\"none\" " + this.getCurrentStroke());
        clip = bare || (clip = this.getCurrentClipPath()) == null ? "" : clip + " ";
        switch (type) {
            case 2: {
                s = "<path " + clip + "d=\"M" + cx + "," + cy + " L";
                break;
            }
            default: {
                s = "<path " + clip + "d=\"M";
            }
        }
        s = s + xStart + "," + yStart + " A" + rx + "," + ry + " 0 " + largeArc + "," + sweepFlag + " " + xEnd + "," + yEnd;
        s = fill || type == 2 || type == 1 ? s + " z\" " + fillString + " />" : s + "\" " + fillString + " />";
        this.writeString(s);
    }

    protected void handleArc(double x, double y, double w, double h, double startAngle, double arcAngle, boolean fill, int type, boolean bare) {
        String s;
        String clip;
        if (arcAngle == 360.0) {
            this.handleOval(x, y, w, h, fill, bare);
            return;
        }
        int largeArc = 0;
        int sweepFlag = 0;
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + rx;
        double cy = y + ry;
        double xStart = x + rx * Math.cos(startAngle * (Math.PI / 180)) + rx;
        double yStart = y - ry * Math.sin(startAngle * (Math.PI / 180)) + ry;
        double xEnd = x + rx * Math.cos((startAngle + arcAngle) * (Math.PI / 180)) + rx;
        double yEnd = y - ry * Math.sin((startAngle + arcAngle) * (Math.PI / 180)) + ry;
        if (Math.abs(arcAngle) > 180.0) {
            largeArc = 1;
        }
        if (arcAngle < 0.0) {
            sweepFlag = 1;
        }
        String fillString = bare ? "" : (fill ? this.getCurrentFill() : " fill=\"none\" " + this.getCurrentStroke());
        clip = bare || (clip = this.getCurrentClipPath()) == null ? "" : clip + " ";
        switch (type) {
            case 2: {
                s = "<path " + clip + "d=\"M" + cx + "," + cy + " L";
                break;
            }
            default: {
                s = "<path " + clip + "d=\"M";
            }
        }
        s = s + xStart + "," + yStart + " A" + rx + "," + ry + " 0 " + largeArc + "," + sweepFlag + " " + xEnd + "," + yEnd;
        s = fill || type == 2 || type == 1 ? s + " z\" " + fillString + " />" : s + "\" " + fillString + " />";
        this.writeString(s);
    }

    protected void handleText(String s, float x, float y) {
        if (s.trim().length() == 0) {
            return;
        }
        if (s == null || s.length() == 0) {
            return;
        }
        FontRenderContext frc = ((Graphics2D)this.g).getFontRenderContext();
        String trimmedStr = s.replaceAll("^\\s+", "");
        Rectangle2D bounds_s = this.g.getFont().getStringBounds(s, frc);
        Rectangle2D bounds_trimmedStr = this.g.getFont().getStringBounds(trimmedStr, frc);
        trimmedStr = VGFGraphics2D.replaceXMLControlCharacters(trimmedStr);
        x += (float)(bounds_s.getWidth() - bounds_trimmedStr.getWidth());
        String out = "<text ";
        if (this.currentFontDefinition != null) {
            out = out + this.currentFontDefinition + " ";
        }
        if (this.currentFontTransformDefinition != null) {
            out = out + " transform=\"translate( " + x + ", " + y + " ) " + this.currentFontTransformDefinition + " translate( " + -x + ", " + -y + " )\" ";
        }
        out = out + "textLength=\"" + bounds_trimmedStr.getWidth() + "\" lengthAdjust=\"spacingAndGlyphs\"";
        out = out + this.getCurrentFill() + " x=\"" + x + "\" y=\"" + y + "\" >" + trimmedStr + "</text>";
        this.writeString(out);
    }

    public static String restoreXMLControlCharacters(String string) {
        if (string == null) {
            return null;
        }
        String rc = "";
        rc = string.replaceAll("&#60;", "<");
        rc = rc.replaceAll("&#62;", ">");
        rc = rc.replaceAll("&#38;", "&");
        rc = rc.replaceAll("&#39;", "'");
        rc = rc.replaceAll("&apos;", "'");
        rc = rc.replaceAll("&#34;", "\"");
        return rc;
    }

    public static String replaceXMLControlCharacters(String string) {
        if (string == null) {
            return null;
        }
        String rc = "";
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            rc = ch == '<' ? rc + "&#60;" : (ch == '>' ? rc + "&#62;" : (ch == '&' ? rc + "&#38;" : (ch == '\'' ? rc + "&#39;" : (ch == '\"' ? rc + "&#34;" : rc + ch))));
        }
        return rc;
    }

    protected void handleImage(Image image, double translateX, double translateY, double scaleX, double scaleY, Color bgcolor, ImageObserver observer) {
        BufferedImage scaledImage = null;
        scaledImage = scaleX == 1.0 && scaleY == 1.0 ? this.toBufferedImage(image) : this.getScaledInstance(this.toBufferedImage(image), scaleX, scaleY, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
        int scaledWidth = scaledImage.getWidth(observer);
        int scaledHeight = scaledImage.getHeight(observer);
        if (this.debugMode && (scaledImage.getWidth(observer) <= 0 || scaledImage.getHeight(observer) <= 0)) {
            System.out.println("imageWidth = " + image.getWidth(observer) + "\nscaleX = " + scaleX + "\nscaledImageWidth = " + scaledWidth + "\nimageHeight = " + image.getHeight(observer) + "\nscaleY = " + scaleY + "scaledImageHeight = " + scaledHeight);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)scaledImage, "png", baos);
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String base64EncodingString = BASE64.encode((byte[])baos.toByteArray());
        String out = "<image ";
        out = out + "x=\"" + translateX + "\" ";
        out = out + "y=\"" + translateY + "\" ";
        out = out + "width=\"" + scaledWidth + "\" ";
        out = out + "height=\"" + scaledHeight + "\" ";
        out = out + this.getCurrentClipPath();
        float opacity = 1.0f;
        if (this.currentComposite != null) {
            opacity = ((AlphaComposite)this.currentComposite).getAlpha();
        }
        if (opacity < 1.0f) {
            out = out + " opacity=\"" + opacity + "\"";
        }
        out = out + " xlink:href=\"data:image/PNG;base64," + base64EncodingString + "\"";
        out = out + " />";
        this.writeString(out);
    }

    protected BufferedImage getScaledInstance(BufferedImage img, double scaleX, double scaleY, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        int targetWidth = (int)Math.floor(scaleX * (double)img.getWidth());
        int targetHeight = (int)Math.floor(scaleY * (double)img.getHeight());
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (scaleX < 1.0 && w > targetWidth) {
                if ((w /= 2) < targetWidth) {
                    w = targetWidth;
                }
            } else if (scaleX > 1.0 && w < targetWidth) {
                w = targetWidth;
            }
            if (scaleY < 1.0 && h > targetHeight) {
                if ((h /= 2) < targetHeight) {
                    h = targetHeight;
                }
            } else if (scaleY > 1.0 && h < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    protected BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = VGFGraphics2D.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pg.getColorModel().hasAlpha();
    }

    protected void closeThisGroup() {
        if (this.groupNesting == 0) {
            return;
        }
        this.currentIndent = Math.max(this.currentIndent - 4, 0);
        this.writeString("</g>");
        this.groupNesting = Math.max(0, this.groupNesting - 1);
        this.contextIsRotated = false;
    }

    protected void closeAllGroups() {
        if (this.groupNesting == 0) {
            return;
        }
        for (int i = 0; i < this.groupNesting; ++i) {
            this.currentIndent = Math.max(this.currentIndent - 4, 0);
            this.writeString("</g>");
        }
        this.groupNesting = 0;
        this.contextIsRotated = false;
    }

    protected void handleTransformMatrix(double[] m) {
        if (m == null || m.length < 6) {
            return;
        }
        if (m[0] == 1.0 && m[1] == 0.0 && m[2] == 0.0 && m[3] == 1.0) {
            this.currentTextTranslationPoint[0] = m[4];
            this.currentTextTranslationPoint[1] = m[5];
            this.contextIsRotated = true;
            if (this.writeString("<g transform=\"translate(" + m[4] + "," + m[5] + ")\">")) {
                ++this.groupNesting;
                this.currentIndent += 4;
            }
            return;
        }
        if (m[0] == 0.0 && m[1] == -1.0 && m[2] == 1.0 && m[3] == 0.0) {
            this.currentTextTranslationPoint[0] = 0.0;
            this.currentTextTranslationPoint[1] = m[4];
            this.contextIsRotated = true;
        } else {
            this.currentTextTranslationPoint[0] = 0.0;
            this.currentTextTranslationPoint[1] = 0.0;
            this.contextIsRotated = true;
        }
        if (this.writeString("<g transform=\"matrix(" + m[0] + "," + m[1] + "," + m[2] + "," + m[3] + "," + m[4] + "," + m[5] + ")\">")) {
            ++this.groupNesting;
            this.currentIndent += 4;
        }
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
        this.currentClip = new Rectangle(0, 0, this.width, this.height);
    }

    public void begin(boolean optimizeForSpeed, boolean includeHeader) {
        complexityCount = 0;
        if (includeHeader) {
            this.writeString("<?xml version=\"1.0\" standalone=\"no\" ?>");
        }
        String s = "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:ev=\"http://www.w3.org/2001/xml-events\" width=\"" + this.width + "\" height=\"" + this.height + "\"";
        if (optimizeForSpeed) {
            s = s + " shape-rendering=\"optimizeSpeed\"";
        }
        s = s + " >";
        this.writeString(s);
        this.currentIndent += 4;
        s = "<desc>Copyright SAS Institute, Inc. 2009</desc>";
        this.writeString(s);
        this.handleFont(this.getFont());
    }

    public void end() {
        if (this.printStream != null) {
            this.closeAllGroups();
            if (this.clipGroup) {
                this.writeString("</g>");
                this.clipGroup = false;
            }
            this.currentIndent = 0;
            this.writeString("</svg>");
            if (this.closeWriter) {
                this.printStream.flush();
                this.printStream.close();
            }
            if (complexityCount > 100000) {
                String msg = "This graph has too many graphical elements. You may not be able to get any vector graphics output and in that case, you can set your output format to an image type.";
                System.out.println("%2z" + msg);
                complexityCount = 0;
            }
        }
        this.printStream = null;
        if (this.g != null) {
            this.g.dispose();
        }
        this.bufferedImage = null;
        this.g = null;
    }

    public boolean openHyperlink(URL link) {
        if (link == null) {
            return false;
        }
        return this.openHyperlink(link.toExternalForm());
    }

    public boolean openHyperlink(String link) {
        if (this.linkOpen) {
            this.closeHyperlink();
            if (this.linkOpen) {
                return false;
            }
        }
        if (link == null) {
            this.linkOpen = this.writeString("<a>");
        } else {
            link = link.trim();
            this.linkOpen = this.writeString("<a href=\"" + link + "\" >");
        }
        this.currentIndent += 4;
        return true;
    }

    public void closeHyperlink() {
        if (!this.linkOpen) {
            return;
        }
        this.currentIndent -= 4;
        this.linkOpen = !this.writeString("</a>");
    }

    protected void handleTitle(String s) {
        if (s == null) {
            return;
        }
        s = VGFGraphics2D.replaceXMLControlCharacters(s);
        this.writeString("<title>" + s + "</title>");
    }

    @Override
    public void drawRect(int x, int y, int w, int h) {
        this.handleRect(x, y, w, h, 0.0, 0.0, false, null, false);
    }

    @Override
    public void draw(Shape shape) {
        if (shape == null) {
            return;
        }
        if (shape instanceof Line2D) {
            this.handleLine(((Line2D)shape).getX1(), ((Line2D)shape).getY1(), ((Line2D)shape).getX2(), ((Line2D)shape).getY2());
        } else if (shape instanceof Ellipse2D) {
            this.handleOval(shape, false, false);
        } else if (shape instanceof Rectangle2D || shape instanceof RoundRectangle2D) {
            this.handleRect(shape, false, null, false);
        } else if (shape instanceof Polygon) {
            this.drawPolygon(((Polygon)shape).xpoints, ((Polygon)shape).ypoints, ((Polygon)shape).npoints);
        } else if (shape instanceof CubicCurve2D || shape instanceof QuadCurve2D) {
            this.handleCurve(shape, false, false);
        } else if (shape instanceof Arc2D) {
            double start = ((Arc2D)shape).getAngleStart();
            double extent = ((Arc2D)shape).getAngleExtent();
            double arc = start + extent;
            double startDouble = ((Arc2D)shape).getAngleStart();
            double extentDouble = arc - startDouble;
            this.handleArc(((Arc2D)shape).getX(), ((Arc2D)shape).getY(), ((Arc2D)shape).getWidth(), ((Arc2D)shape).getHeight(), startDouble, extentDouble, false, ((Arc2D)shape).getArcType(), false);
        } else {
            this.handlePath(shape, false, false);
        }
    }

    @Override
    public void drawRenderableImage(RenderableImage image, AffineTransform transform) {
        AffineTransform reverseTransform;
        if (this.debugMode) {
            this.writeDebugString("drawRenderableImage(" + image + "," + transform + ")");
        }
        if (image == null) {
            return;
        }
        AffineTransform pipeTransform = this.currentTransform;
        AffineTransform concatTransform = new AffineTransform(transform);
        concatTransform.concatenate(pipeTransform);
        RenderContext rc = new RenderContext(concatTransform);
        try {
            reverseTransform = pipeTransform.createInverse();
        }
        catch (NoninvertibleTransformException nte) {
            rc = new RenderContext(pipeTransform);
            reverseTransform = new AffineTransform();
        }
        RenderedImage rendering = image.createRendering(rc);
        this.drawRenderedImage(rendering, reverseTransform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    @Override
    public void drawString(String s, int x, int y) {
        if (x == -2147483647 && y == -2147483647) {
            this.closeHyperlink();
        } else if (x == -2147483647) {
            this.openHyperlink(s);
        } else if (y == -2147483647) {
            this.handleTitle(s);
        } else {
            this.handleText(s, x, y);
        }
    }

    @Override
    public void drawString(String s, float x, float y) {
        this.handleText(s, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (iterator == null) {
            return;
        }
        char c = iterator.first();
        do {
            Font currentFont;
            if ((currentFont = (Font)iterator.getAttribute(TextAttribute.FONT)) != null) {
                this.setFont(currentFont);
            }
            this.handleText(Character.toString(c), x, y);
            x += (float)this.g.getFontMetrics().charWidth(c);
        } while ((c = iterator.next()) != '\uffff');
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        if (g == null) {
            return;
        }
        Shape s = g.getOutline(x, y);
        this.fill(s);
    }

    @Override
    public void fill(Shape shape) {
        if (shape == null) {
            return;
        }
        if (shape instanceof Ellipse2D) {
            this.handleOval(shape, true, false);
        } else if (shape instanceof Rectangle2D || shape instanceof RoundRectangle2D) {
            this.handleRect(shape, true, null, false);
        } else if (shape instanceof Polygon) {
            this.fillPolygon(((Polygon)shape).xpoints, ((Polygon)shape).ypoints, ((Polygon)shape).npoints);
        } else if (shape instanceof CubicCurve2D || shape instanceof QuadCurve2D) {
            this.handleCurve(shape, true, false);
        } else if (shape instanceof Arc2D) {
            double start = ((Arc2D)shape).getAngleStart();
            double extent = ((Arc2D)shape).getAngleExtent();
            double arc = start + extent;
            double startDouble = ((Arc2D)shape).getAngleStart();
            double extentDouble = arc - startDouble;
            this.handleArc(((Arc2D)shape).getX(), ((Arc2D)shape).getY(), ((Arc2D)shape).getWidth(), ((Arc2D)shape).getHeight(), startDouble, extentDouble, true, ((Arc2D)shape).getArcType(), false);
        } else {
            this.handlePath(shape, true, false);
        }
    }

    @Override
    public boolean hit(Rectangle arg0, Shape arg1, boolean arg2) {
        if (this.debugMode) {
            this.writeDebugString("hit");
        }
        return false;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        if (this.g == null || !(this.g instanceof Graphics2D)) {
            return null;
        }
        return ((Graphics2D)this.g).getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite c) {
        float alpha = 1.0f;
        if (c == null || !(c instanceof AlphaComposite)) {
            return;
        }
        AlphaComposite cIn = (AlphaComposite)c;
        alpha = cIn.getAlpha();
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setComposite(c);
        }
        this.currentComposite = (double)alpha < 1.0 ? c : null;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setPaint(paint);
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint);
            return;
        }
        this.currentPaint = paint;
        if (!(paint instanceof GradientPaint)) {
            return;
        }
        GradientPaint gp = (GradientPaint)paint;
        Color c1 = gp.getColor1();
        Color c2 = gp.getColor2();
        Point2D p1 = gp.getPoint1();
        Point2D p2 = gp.getPoint2();
        String s1 = this.colorToString(c1);
        String s2 = this.colorToString(c2);
        if (s1 == null || s2 == null) {
            return;
        }
        String op1 = c1.getAlpha() < 255 ? " stop-opacity=\"" + (float)c1.getAlpha() / 255.0f + "\" " : "";
        String op2 = c2.getAlpha() < 255 ? " stop-opacity=\"" + (float)c2.getAlpha() / 255.0f + "\" " : "";
        this.currentPaintDefinition = "Gradient" + Long.toString(sequenceNumber);
        ++sequenceNumber;
        String tab1 = "";
        for (int i = 0; i < 4; ++i) {
            tab1 = tab1 + " ";
        }
        this.writeString("<defs>");
        this.writeString(tab1 + "<linearGradient id=\"" + this.currentPaintDefinition + "\" gradientUnits=\"userSpaceOnUse\" x1=\"" + p1.getX() + "\" y1=\"" + p1.getY() + "\" x2=\"" + p2.getX() + "\" y2=\"" + p2.getY() + "\" >");
        this.writeString(tab1 + tab1 + "<stop offset=\"0%\" stop-color=\"" + s1 + "\"" + op1 + " />");
        this.writeString(tab1 + tab1 + "<stop offset=\"100%\" stop-color=\"" + s2 + "\"" + op2 + " />");
        this.writeString(tab1 + "</linearGradient>");
        this.writeString("</defs>");
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (stroke == null || stroke instanceof BasicStroke && ((BasicStroke)stroke).equals(this.currentStroke)) {
            return;
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setStroke(stroke);
        }
        this.currentStroke = stroke;
    }

    @Override
    public Stroke getStroke() {
        if (this.g != null && this.g instanceof Graphics2D) {
            return ((Graphics2D)this.g).getStroke();
        }
        if (this.currentStroke != null) {
            return this.currentStroke;
        }
        return new BasicStroke();
    }

    @Override
    public void setRenderingHint(RenderingHints.Key arg0, Object arg1) {
        if (this.debugMode) {
            this.writeDebugString("setRenderingHint(" + arg1.toString() + ")");
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setRenderingHint(arg0, arg1);
        }
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        if (this.g != null && this.g instanceof Graphics2D) {
            return ((Graphics2D)this.g).getRenderingHint(hintKey);
        }
        return null;
    }

    public void setRenderingHints(Map arg0) {
        if (this.debugMode) {
            this.writeDebugString("setRenderingHints");
        }
    }

    public void addRenderingHints(Map arg0) {
        if (this.debugMode) {
            this.writeDebugString("addRenderingHints");
        }
    }

    @Override
    public RenderingHints getRenderingHints() {
        if (this.g != null && this.g instanceof Graphics2D) {
            return ((Graphics2D)this.g).getRenderingHints();
        }
        return null;
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void translate(double x, double y) {
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).translate(x, y);
            this.tempTransform = ((Graphics2D)this.g).getTransform();
            if (this.currentTransform.equals(this.tempTransform)) {
                return;
            }
            if (!this.contextIsRotated && this.previousTransform.equals(this.tempTransform)) {
                this.closeThisGroup();
            } else {
                this.previousTransform.setTransform(this.currentTransform);
                if (this.writeString("<g transform=\"translate(" + x + "," + y + ")\" " + this.getCurrentClipPath() + ">")) {
                    ++this.groupNesting;
                    this.currentIndent += 4;
                }
            }
            this.currentTransform.setTransform(this.tempTransform);
        }
    }

    @Override
    public void rotate(double angle) {
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).rotate(angle);
        }
        this.contextIsRotated = true;
        if (this.writeString("<g transform=\"rotate(" + angle * 57.29577951308232 + ")\">")) {
            ++this.groupNesting;
            this.currentIndent += 4;
        }
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.contextIsRotated = true;
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    @Override
    public void scale(double sx, double sy) {
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).scale(sx, sy);
        }
        if (this.writeString("<g transform=\"scale(" + sx + "," + sy + ")\">")) {
            ++this.groupNesting;
            this.currentIndent += 4;
        }
    }

    @Override
    public void shear(double shx, double shy) {
        if (this.transformationMatrixValues == null) {
            return;
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).shear(shx, shy);
        }
        this.transformationMatrixValues[0] = 1.0;
        this.transformationMatrixValues[1] = shy;
        this.transformationMatrixValues[2] = shx;
        this.transformationMatrixValues[3] = 1.0;
        this.transformationMatrixValues[4] = 0.0;
        this.transformationMatrixValues[5] = 0.0;
        this.handleTransformMatrix(this.transformationMatrixValues);
    }

    @Override
    public void transform(AffineTransform tx) {
        if (tx == null || this.transformationMatrixValues == null) {
            return;
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).transform(tx);
        }
        tx.getMatrix(this.transformationMatrixValues);
        this.handleTransformMatrix(this.transformationMatrixValues);
    }

    @Override
    public void setTransform(AffineTransform transform) {
        if (transform == null || this.transformationMatrixValues == null || this.currentTransform.equals(transform)) {
            return;
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setTransform(transform);
        }
        if (transform.getType() == 0) {
            this.closeAllGroups();
            this.currentTransform.setTransform(transform);
        } else if (transform.equals(this.previousTransform)) {
            this.closeThisGroup();
            this.currentTransform.setTransform(transform);
        } else {
            this.previousTransform.setTransform(this.currentTransform);
            this.closeThisGroup();
            this.currentTransform.setTransform(transform);
            this.currentTransform.getMatrix(this.transformationMatrixValues);
            this.handleTransformMatrix(this.transformationMatrixValues);
        }
    }

    @Override
    public AffineTransform getTransform() {
        AffineTransform t = AffineTransform.getTranslateInstance(-this.currentTransform.getTranslateX(), -this.currentTransform.getTranslateY());
        if (this.g == null || !(this.g instanceof Graphics2D)) {
            t.concatenate(this.currentTransform);
        } else {
            t.concatenate(((Graphics2D)this.g).getTransform());
        }
        return t;
    }

    @Override
    public Paint getPaint() {
        if (this.g != null && this.g instanceof Graphics2D) {
            return ((Graphics2D)this.g).getPaint();
        }
        if (this.currentPaint != null) {
            return this.currentPaint;
        }
        return this.currentColor;
    }

    @Override
    public Composite getComposite() {
        if (this.g != null && this.g instanceof Graphics2D) {
            return ((Graphics2D)this.g).getComposite();
        }
        if (this.currentComposite != null) {
            return this.currentComposite;
        }
        return AlphaComposite.getInstance(3, 1.0f);
    }

    @Override
    public void setBackground(Color c) {
        if (this.debugMode) {
            this.writeDebugString("setBackground(" + c.toString() + ")");
        }
        if (c == null) {
            return;
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setBackground(c);
        }
        this.currentBackgroundColor = c;
    }

    @Override
    public Color getBackground() {
        return this.currentBackgroundColor;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        if (this.g == null || !(this.g instanceof Graphics2D)) {
            return new FontRenderContext(this.currentTransform, false, true);
        }
        return ((Graphics2D)this.g).getFontRenderContext();
    }

    @Override
    public Graphics create() {
        VGFGraphics2D newChild = new VGFGraphics2D(this);
        if (this.debugMode) {
            this.writeDebugString("create (" + newChild.hashCode() + ")");
        }
        return newChild;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        Graphics out = this.create();
        out.translate(x, y);
        out.clipRect(0, 0, width, height);
        return out;
    }

    @Override
    public Color getColor() {
        if (this.g != null) {
            return this.g.getColor();
        }
        return this.currentColor;
    }

    @Override
    public void setColor(Color c) {
        if (this.debugMode) {
            this.writeDebugString("setColor(" + c.toString() + ")");
        }
        String s = null;
        if (c == null) {
            return;
        }
        if (this.g != null) {
            this.g.setColor(c);
        }
        this.currentColor = c;
        this.currentPaint = null;
        s = this.colorToString(c);
        if (s == null) {
            return;
        }
        this.currentColorString = s;
    }

    @Override
    public void setPaintMode() {
        if (this.debugMode) {
            this.writeDebugString("setPaintMode()");
        }
    }

    @Override
    public void setXORMode(Color arg0) {
        if (this.debugMode) {
            this.writeDebugString("setXORMode(" + arg0.toString() + ")");
        }
    }

    @Override
    public Font getFont() {
        if (this.g != null) {
            return this.g.getFont();
        }
        return this.currentFont;
    }

    @Override
    public void setFont(Font f) {
        if (this.debugMode) {
            this.writeDebugString("setFont(" + f.toString() + ")");
        }
        if (f == null) {
            return;
        }
        if (this.g != null) {
            this.g.setFont(f);
        }
        this.currentFont = f;
        this.handleFont(f);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        if (this.g != null) {
            return this.g.getFontMetrics(f);
        }
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.currentClip == null) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        return this.currentClip.getBounds();
    }

    @Override
    public void clipRect(int arg0, int arg1, int arg2, int arg3) {
        if (this.debugMode) {
            this.writeDebugString("clipRect(" + arg0 + "," + arg1 + "," + arg2 + "," + arg3 + ")");
        }
        if (this.g != null) {
            this.g.clipRect(arg0, arg1, arg2, arg3);
        } else {
            Rectangle2D.Double.intersect((Rectangle)this.currentClip, new Rectangle2D.Double(arg0, arg1, arg2, arg3), (Rectangle)this.currentClip);
        }
        this.clip(new Rectangle2D.Double(arg0, arg1, arg2, arg3));
    }

    @Override
    public void clip(Shape newShape) {
        Shape oldShape = this.getClip();
        String oldClipPath = this.currentClipPathNumber;
        if (newShape == null) {
            return;
        }
        if (oldShape == null || oldClipPath == null) {
            this.setClip(newShape);
            return;
        }
        this.setClip(this.g.getClip());
    }

    @Override
    public void setClip(int x, int y, int w, int h) {
        this.setClip(new Rectangle(x, y, w, h));
    }

    @Override
    public void setClip(Shape shape) {
        if (this.g != null) {
            this.g.setClip(shape);
        }
        this.currentClip = shape;
        if (this.clipGroup) {
            this.currentIndent -= 4;
            this.writeString("</g>");
            this.clipGroup = false;
        }
        if (shape == null) {
            this.currentClipPathNumber = null;
            return;
        }
        this.clipGroup = true;
        this.currentClipPathNumber = "ClipPath" + sequenceNumber++;
        this.writeString("<clipPath id=\"" + this.currentClipPathNumber + "\">");
        this.currentIndent += 4;
        this.handleClipShape(shape);
        this.currentIndent -= 4;
        this.writeString("</clipPath>");
        this.writeString("<g  clip-path=\"url(#" + this.currentClipPathNumber + ")\">");
        this.currentIndent += 4;
    }

    @Override
    public Shape getClip() {
        return this.currentClip;
    }

    @Override
    public void copyArea(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        if (this.debugMode) {
            this.writeDebugString("copyArea");
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.writeString("<line x1=\"" + x1 + "\" y1=\"" + y1 + "\" x2=\"" + x2 + "\" y2=\"" + y2 + "\"" + this.getCurrentStroke() + this.getCurrentClipPath() + " />");
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        this.handleRect(x, y, w, h, 0.0, 0.0, true, null, false);
    }

    @Override
    public void clearRect(int x, int y, int w, int h) {
        String s = this.colorToString(this.currentBackgroundColor);
        if (s == null) {
            return;
        }
        this.handleRect(x, y, w, h, 0.0, 0.0, true, "fill=\"" + s + "\"", false);
    }

    @Override
    public void drawRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight) {
        this.handleRect(x, y, w, h, arcWidth, arcHeight, false, null, false);
    }

    @Override
    public void fillRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight) {
        this.handleRect(x, y, w, h, arcWidth, arcHeight, true, null, false);
    }

    @Override
    public void drawOval(int x, int y, int w, int h) {
        this.handleOval(x, y, w, h, false, false);
    }

    @Override
    public void fillOval(int x, int y, int w, int h) {
        this.handleOval(x, y, w, h, true, false);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.handleArc(x, y, width, height, startAngle, arcAngle, false, 0, false);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.handleArc(x, y, width, height, startAngle, arcAngle, true, 2, false);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int n) {
        this.handlePolygons(xPoints, yPoints, n, false, false, false);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int n) {
        this.handlePolygons(xPoints, yPoints, n, true, false, false);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int n) {
        this.handlePolygons(xPoints, yPoints, n, true, true, false);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform transform, ImageObserver observer) {
        if (this.debugMode) {
            this.writeDebugString("drawImage(" + image + "," + transform + "," + observer + ")");
        }
        this.handleImage(image, transform.getTranslateX(), transform.getTranslateY(), transform.getScaleX(), transform.getScaleY(), null, observer);
        return true;
    }

    @Override
    public void drawImage(BufferedImage image, BufferedImageOp imageOp, int x, int y) {
        if (this.debugMode) {
            this.writeDebugString("drawImage(" + image + "," + imageOp + "," + x + "," + y + ")");
        }
        BufferedImage filteredImage = imageOp.filter(image, null);
        this.handleImage(filteredImage, x, y, 1.0, 1.0, null, null);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        return this.drawImage(image, x, y, null, observer);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, Color bgcolor, ImageObserver observer) {
        if (this.debugMode) {
            this.writeDebugString("drawImage(" + image + ") 5arguments");
        }
        this.handleImage(image, x, y, 1.0, 1.0, bgcolor, observer);
        return true;
    }

    @Override
    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(image, x, y, width, height, null, observer);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (this.debugMode) {
            this.writeDebugString("drawImage(" + image + ") 7arguments");
        }
        double scaleX = (double)width / (double)image.getWidth(observer);
        double scaleY = (double)height / (double)image.getHeight(observer);
        this.handleImage(image, x, y, scaleX, scaleY, bgcolor, observer);
        return true;
    }

    @Override
    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    @Override
    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (this.debugMode) {
            this.writeDebugString("drawImage(" + image + ") 11arguments");
        }
        if (dx1 == dx2 || dy1 == dy2 || sx1 == sx2 || sy1 == sy2) {
            return true;
        }
        int translateX = dx1 - sx1;
        int translateY = dy1 - sy1;
        double scaleX = (dx2 - dx1) / (sx2 - sx1);
        double scaleY = (dy2 - dy1) / (sy2 - sy1);
        this.handleImage(image, translateX, translateY, scaleX, scaleY, bgcolor, observer);
        return true;
    }

    @Override
    public void dispose() {
        if (this.debugMode) {
            this.writeDebugString("dispose(" + this.hashCode() + ")");
        }
        this.closeAllGroups();
        if (this.clipGroup) {
            this.currentIndent -= 4;
            this.writeString("</g>");
            this.clipGroup = false;
        }
        this.isDisposed = true;
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        if (this.debugMode) {
            this.writeDebugString("draw3DRect");
        }
        super.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        if (this.debugMode) {
            this.writeDebugString("fill3DRect");
        }
        super.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        if (this.debugMode) {
            this.writeDebugString("drawBytes");
        }
        super.drawBytes(data, offset, length, x, y);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        super.drawChars(data, offset, length, x, y);
    }

    @Override
    public void drawPolygon(Polygon p) {
        if (this.debugMode) {
            this.writeDebugString("drawPolygon");
        }
        super.drawPolygon(p);
    }

    @Override
    public void fillPolygon(Polygon p) {
        if (this.debugMode) {
            this.writeDebugString("fillPolygon");
        }
        super.fillPolygon(p);
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        if (this.debugMode) {
            this.writeDebugString("getClipBounds");
        }
        return super.getClipBounds(r);
    }

    @Override
    public Rectangle getClipRect() {
        if (this.debugMode) {
            this.writeDebugString("getClipRect");
        }
        return super.getClipRect();
    }

    @Override
    public FontMetrics getFontMetrics() {
        if (this.debugMode) {
            this.writeDebugString("getFontMetrics");
        }
        return super.getFontMetrics();
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        if (this.debugMode) {
            this.writeDebugString("hitClip(" + x + "," + y + "," + width + "," + height + ")");
        }
        if (this.g == null) {
            return this.currentClip.intersects(x, y, width, height);
        }
        return this.g.hitClip(x, y, width, height);
    }

    public void applyRectClip(boolean clip) {
        this.applyClip = clip;
    }

    public void textClip(boolean clip) {
        this.textClip = clip;
    }

    public void setSelectionMode(boolean mode) {
        if (mode) {
            this.writeString("<g opacity=\"0.0\" >");
            this.currentIndent += 4;
        } else {
            this.currentIndent -= 4;
            this.writeString("</g>");
        }
    }
}

