/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery;

public enum TxState {
    MARKED_ABORT(false, false, new TxState[0]),
    LOCALLY_DONE(false, false, new TxState[0]),
    COMMITTED(false, false, new TxState[0]),
    ABORTED(false, false, new TxState[0]),
    ABANDONED(false, false, new TxState[0]),
    TERMINATED(true, true, ABANDONED),
    HEUR_HAZARD(false, false, TERMINATED, ABANDONED),
    HEUR_COMMITTED(false, false, TERMINATED, ABANDONED),
    HEUR_ABORTED(false, false, TERMINATED, ABANDONED),
    HEUR_MIXED(false, false, TERMINATED, ABANDONED),
    COMMITTING(true, false, HEUR_ABORTED, HEUR_COMMITTED, HEUR_HAZARD, HEUR_MIXED, TERMINATED, ABANDONED),
    ABORTING(false, false, HEUR_ABORTED, HEUR_COMMITTED, HEUR_HAZARD, HEUR_MIXED, TERMINATED, ABANDONED),
    IN_DOUBT(true, false, ABORTING, COMMITTING, ABANDONED, TERMINATED),
    PREPARING(false, false, IN_DOUBT, ABORTING, TERMINATED, ABANDONED),
    ACTIVE(false, false, ABORTING, COMMITTING, PREPARING);

    private boolean recoverableState;
    private boolean finalState;
    private TxState[] legalNextStates;

    private TxState(boolean recoverableState, boolean finalState, TxState ... legalNextStates) {
        this.finalState = finalState;
        this.recoverableState = recoverableState;
        this.legalNextStates = legalNextStates;
    }

    public boolean isFinalState() {
        return this.finalState;
    }

    public boolean isFinalStateForOltp() {
        return this.isFinalState() || this == ABANDONED;
    }

    public boolean isRecoverableState() {
        return this.recoverableState;
    }

    public boolean transitionAllowedTo(TxState nextState) {
        if (nextState == this) {
            return true;
        }
        for (TxState txState : this.legalNextStates) {
            if (txState != nextState) continue;
            return true;
        }
        return false;
    }

    public boolean isOneOf(TxState ... state) {
        for (int i = 0; i < state.length; ++i) {
            if (this != state[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isHeuristic() {
        return this.isOneOf(HEUR_ABORTED, HEUR_COMMITTED, HEUR_HAZARD, HEUR_MIXED);
    }
}

