/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.encoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.decoder.compression.BitBuffer;
import java.io.IOException;
import java.io.OutputStream;

@SASScope(value="ALL")
public class WbmpEncoder {
    static final int TYPE_1BIT = 0;
    static final int FIX_HEADER = 0;
    static final int SIGN_MASK = 128;
    static final int SIGN_ERASE = 127;
    static final int BW_THRESHOLD = 126;
    protected OutputStream oStrm;
    protected int height;
    protected int width;
    protected int[] imageData;

    public WbmpEncoder(int iWidth, int iHeight, int[] inImageData, OutputStream iOutStrm) {
        this.width = iWidth;
        this.height = iHeight;
        this.imageData = inImageData;
        this.oStrm = iOutStrm;
    }

    public void encode() throws IOException {
        this.writeHeader();
        this.writeImageData();
    }

    protected void writeHeader() throws IOException {
        this.oStrm.write(0);
        this.oStrm.write(0);
        this.writeMultiByteInt(this.width);
        this.writeMultiByteInt(this.height);
        if (Debug.debug) {
            Debug.println("WBMP Width=" + this.width + " Height=" + this.height);
        }
    }

    protected void writeImageData() throws IOException {
        boolean needsPad = (this.width & 7) != 0;
        int padBits = (short)((this.width & 7) == 0 ? 0 : (short)(8 - (this.width & 7)));
        int totalBits = this.height * (this.width + padBits) << 3;
        int idx = 0;
        BitBuffer outBitBuffer = new BitBuffer(totalBits, false);
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                if (this.imageData[idx++] == 0) {
                    outBitBuffer.fillZeros(1);
                    continue;
                }
                outBitBuffer.fillOnes(1);
            }
            if (padBits == 0) continue;
            int currentBitOffset = outBitBuffer.getOffset();
            outBitBuffer.seek(padBits + currentBitOffset);
        }
        byte[] outBytes = outBitBuffer.getByteBuffer();
        this.oStrm.write(outBytes);
    }

    protected void writeMultiByteInt(int val) throws IOException {
        if (Debug.debug && val < 0) {
            Debug.println("WbmpEncoder.writeMultiByte: val=" + val + " is -VE");
        }
        boolean more = true;
        byte[] multiBytes = new byte[4];
        int byteIndex = 0;
        while (more & byteIndex < 4) {
            multiBytes[byteIndex] = (byte)(val & 0xFF);
            if ((val >>>= 7) == 0) {
                more = false;
            }
            ++byteIndex;
        }
        if (more) {
            if (Debug.debug) {
                Debug.println("WbmpEncoder.writeMultiByte: Error! not enough array bytes!");
            }
            return;
        }
        for (int i = --byteIndex; i > 0; --i) {
            int n = i;
            multiBytes[n] = (byte)(multiBytes[n] | 0x80);
            this.oStrm.write(multiBytes[i]);
        }
        multiBytes[0] = (byte)(multiBytes[0] & 0x7F);
        this.oStrm.write(multiBytes[0]);
    }
}

