/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.encoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.encoder.ImageAdaptor;
import com.sas.visuals.image.encoder.LEDataOutputStream;
import com.sas.visuals.image.encoder.compression.LZWCScheme;
import java.io.IOException;
import java.io.OutputStream;

@SASScope(value="ALL")
public class GifEncoder {
    static final int SIGNATURE_LENGTH = 18;
    static final String GIF_SIGNATURE = "GIF89a";
    static final byte GIF_IMAGE_SEPARATOR = 44;
    static final byte GIF_TRAILER = 59;
    static final byte GIF_EXTENSION_INTRO = 33;
    static final byte GIF_GRAPHIC_CONTROL_EXTENSION = -7;
    static final byte GIF_GCE_BLOCK_SIZE = 4;
    static final byte GIF_BLOCK_TERMINATOR = 0;
    static final int GIF_MAX_CODE_SIZE = 12;
    static final int GIF_MAX_SUB_BLOCK_SIZE = 255;
    protected ImageAdaptor imgAdp;
    protected OutputStream oStrm;
    protected LEDataOutputStream gifStrm;
    protected short height;
    protected short width;
    protected byte pixelBitSize;

    public GifEncoder(ImageAdaptor iAd, OutputStream gStrm) {
        this.imgAdp = iAd;
        this.gifStrm = new LEDataOutputStream(gStrm);
        this.oStrm = gStrm;
    }

    public void encode() throws IOException {
        this.writeSignature();
        this.writeLogicalScreenDescriptor();
        this.writeGlobalColorTable();
        if (this.imgAdp.isTransparent()) {
            this.writeGCE();
        }
        this.writeImageDescriptor();
        this.writeImageData();
        this.writeTrailer();
    }

    protected void writeSignature() throws IOException {
        this.gifStrm.write(GIF_SIGNATURE.getBytes());
    }

    protected void writeLogicalScreenDescriptor() throws IOException {
        byte globalColorTableSize;
        this.width = (short)(0xFFFF & this.imgAdp.getWidth());
        this.height = (short)(0xFFFF & this.imgAdp.getHeight());
        this.gifStrm.writeShort(this.width);
        this.gifStrm.writeShort(this.height);
        int hasGlobalColorTable = -128;
        int sortFlag = 0;
        this.pixelBitSize = (byte)this.imgAdp.getPixelBitSize();
        byte colorResolution = globalColorTableSize = (byte)(this.pixelBitSize - 1);
        byte packedField = (byte)(hasGlobalColorTable | colorResolution << 4 | sortFlag | globalColorTableSize);
        this.gifStrm.write(packedField);
        int backgroundIndex = 0;
        this.gifStrm.write(backgroundIndex);
        int pixelAspectRatio = 0;
        this.gifStrm.write(pixelAspectRatio);
        if (Debug.debug) {
            Debug.println("GifEncoder.writeLSDesc(): W=" + this.width + " H=" + this.height + " ColRes=" + colorResolution);
        }
    }

    protected void writeGlobalColorTable() throws IOException {
        this.imgAdp.writeColorTable(this.gifStrm);
    }

    protected void writeImageDescriptor() throws IOException {
        this.gifStrm.writeByte(44);
        this.gifStrm.writeShort(0);
        this.gifStrm.writeShort(0);
        this.gifStrm.writeShort(this.width);
        this.gifStrm.writeShort(this.height);
        int packedField = 0;
        this.gifStrm.write(packedField);
    }

    protected void writeImageData() throws IOException {
        if (this.pixelBitSize == 1) {
            this.pixelBitSize = (byte)2;
        }
        this.gifStrm.write(this.pixelBitSize);
        byte[] imageBytes = this.imgAdp.getImageBytes();
        LZWCScheme lzwComp = new LZWCScheme(imageBytes, this.oStrm, this.pixelBitSize, 12, 255);
        lzwComp.compress();
    }

    protected void writeGCE() throws IOException {
        this.gifStrm.write(33);
        this.gifStrm.write(-7);
        this.gifStrm.write(4);
        int packedFields = 1;
        this.gifStrm.write(packedFields);
        this.gifStrm.write(0);
        this.gifStrm.write(0);
        this.gifStrm.write(this.imgAdp.getTransparentIndex());
        this.gifStrm.write(0);
    }

    protected void writeTrailer() throws IOException {
        this.gifStrm.write(59);
    }
}

