/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder.compression;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.decoder.compression.CompressionScheme;
import com.sas.visuals.image.decoder.compression.ImageCompressionException;

@SASScope(value="ALL")
public class PackBitsCScheme
extends CompressionScheme {
    public PackBitsCScheme(byte[] inputBytes, int iXSize, int iUnCompSize, int iYSize) throws ImageCompressionException {
        super(inputBytes, iXSize, iUnCompSize, iYSize);
    }

    @Override
    public byte[] uncompress() throws ImageCompressionException {
        byte[] outBytes = new byte[this.uncompressedSize];
        int inIndx = 0;
        int outIndx = 0;
        int runLength = 0;
        while (outIndx < this.uncompressedSize) {
            runLength = this.inBytes[inIndx];
            ++inIndx;
            if (runLength >= 0 && runLength <= 127) {
                System.arraycopy(this.inBytes, inIndx, outBytes, outIndx, ++runLength);
                inIndx += runLength;
                outIndx += runLength;
                continue;
            }
            if (runLength <= -1 && runLength >= -127) {
                runLength = -runLength + 1;
                while (runLength > 0) {
                    outBytes[outIndx] = this.inBytes[inIndx];
                    --runLength;
                    ++outIndx;
                }
                ++inIndx;
                continue;
            }
            if (runLength == -128) {
                ++inIndx;
                continue;
            }
            throw new ImageCompressionException("Invalid runLength=" + runLength);
        }
        return outBytes;
    }

    @Override
    public byte[] compress() throws ImageCompressionException {
        throw new ImageCompressionException("Unsupported method");
    }
}

