/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder.compression;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.decoder.compression.BitBuffer;
import com.sas.visuals.image.decoder.compression.CcittG3CScheme;
import com.sas.visuals.image.decoder.compression.CcittModeTree;
import com.sas.visuals.image.decoder.compression.ImageCompressionException;

@SASScope(value="ALL")
public class CcittG4CScheme
extends CcittG3CScheme {
    int cScanLine;
    int stripIndex;
    public long[] stripCummCounts;
    public long rowsPerStrip;

    public CcittG4CScheme(byte[] inputBytes, int iXSize, int iUnCompSize, int iYSize) throws ImageCompressionException {
        super(inputBytes, iXSize, iUnCompSize, iYSize);
        this.refLine.fill(this.xSize, true);
    }

    @Override
    public byte[] uncompress() throws ImageCompressionException {
        boolean fillOrder = false;
        this.inBitBuff = new BitBuffer(this.inBytes, fillOrder);
        BitBuffer outBitBuff = new BitBuffer(this.uncompressedSize * 8, fillOrder);
        BitBuffer tmpOutBuff = new BitBuffer(this.xSize, false);
        this.stripIndex = 0;
        this.cScanLine = 0;
        while (this.cScanLine < this.ySize) {
            Debug.println("Scan = " + this.cScanLine);
            tmpOutBuff.reset();
            this.refLine.seek(0);
            this.uncompressScanLine(tmpOutBuff);
            this.refLine.copy(tmpOutBuff);
            outBitBuff.append(tmpOutBuff);
            outBitBuff.nextByteBoundary();
            this.processEndOfLine();
            ++this.cScanLine;
        }
        return outBitBuff.getByteBuffer();
    }

    @Override
    protected void uncompressScanLine(BitBuffer oBuff) throws ImageCompressionException {
        int count;
        short mode;
        this.markA0 = 0;
        this.markB2 = 0;
        this.markB1 = 0;
        this.curPixelIsWhite = true;
        for (count = 0; count < this.xSize; count += this.processMode(mode, oBuff)) {
            mode = CcittModeTree.getMode(this.inBitBuff);
            Debug.print("Mode=" + mode);
        }
        if (count > this.xSize) {
            throw new ImageCompressionException("Uncompressed width =" + count + " exceeds image XSize=" + this.xSize);
        }
    }

    @Override
    protected void processEndOfLine() throws ImageCompressionException {
        if ((long)(this.cScanLine + 1) % this.rowsPerStrip == 0L) {
            int nextStripOffset = (int)(this.stripCummCounts[this.stripIndex] * 8L);
            this.inBitBuff.seek(nextStripOffset);
            ++this.stripIndex;
        }
    }
}

