/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.ImageException;
import com.sas.visuals.image.ImageProperties;
import com.sas.visuals.image.decoder.ImageDecoder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

@SASScope(value="ALL")
public class WbmpDecoder
extends ImageDecoder {
    private static final int WBMP_SIGNATURE = 0;
    private static final int SIGN_MASK = 128;
    private static final int SIGN_ERASE = 127;
    protected int width;
    protected int height;
    protected int colorModelType;
    protected int colorMapLength;
    protected DataInput iStream;

    public WbmpDecoder(InputStream iStrm) throws IOException {
        super(iStrm);
        this.iStream = new DataInputStream(iStrm);
        this.iStream.skipBytes(1);
    }

    public void finalizer() throws IOException {
    }

    public static boolean matchFormat(byte[] iSign) {
        return iSign[0] == 0;
    }

    @Override
    public byte[] getColorMap() throws IOException {
        return null;
    }

    @Override
    public byte[] getRawImageData(ImageProperties iProps) throws IOException {
        int scanLineSize = iProps.getScanLineSize();
        int rawDataSize = scanLineSize * this.height;
        byte[] rawData = new byte[rawDataSize];
        this.iStream.readFully(rawData, 0, rawDataSize);
        return rawData;
    }

    @Override
    public ImageProperties getImageProperties() throws IOException, ImageException {
        ImageProperties iProps = new ImageProperties("WBMP");
        this.iStream.skipBytes(1);
        this.width = this.readMultiByteInt();
        iProps.setXSize(this.width);
        this.height = this.readMultiByteInt();
        iProps.setYSize(this.height);
        iProps.setPixelSizeInSamples(1);
        iProps.setSampleSizeInBits(1);
        this.colorMapLength = 2;
        iProps.setColorModelType(1);
        iProps.setPadSizeInBits(8);
        iProps.calcScanLineSizes();
        return iProps;
    }

    protected int readMultiByteInt() throws IOException {
        boolean more = true;
        int accumulator = 0;
        int i = 0;
        while (more & i < 4) {
            byte val = this.iStream.readByte();
            if ((val & 0x80) != 0) {
                accumulator |= val & 0x7F;
                accumulator <<= 7;
            } else {
                accumulator |= val;
                more = false;
            }
            ++i;
        }
        if (Debug.debug && accumulator < 0) {
            Debug.println("WbmpEncoder.readMultiByte: Error! got a -VE int!");
        }
        return accumulator;
    }
}

