/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.decoder.RAStream;
import java.io.IOException;

@SASScope
class TiffField {
    static final short FIELD_SIZE = 12;
    static final short IMAGE_WIDTH_TAG = 256;
    static final short IMAGE_LENGTH_TAG = 257;
    static final short BITS_PER_SAMPLE_TAG = 258;
    static final short COMPRESSION_TAG = 259;
    static final short C_RAW = 1;
    static final short C_CCITT1D = 2;
    static final short C_CCITTG3 = 3;
    static final short C_CCITTG4 = 4;
    static final int C_PACKBITS = 32773;
    static final short T4_OPTIONS_TAG = 292;
    static final short T6_OPTIONS_TAG = 293;
    static final short FILL_ORDER_TAG = 266;
    static final short PHOTOMETRIC_INTERPRETATION_TAG = 262;
    static final short PI_WHITE_IS_ZERO = 0;
    static final short PI_BLACK_IS_ZERO = 1;
    static final short PI_RGB = 2;
    static final short PI_RGB_PALETTE = 3;
    static final short PI_TRANSPARENCY_MASK = 4;
    static final short PI_CMYK = 5;
    static final short PI_YCBCR = 6;
    static final short PI_CIELAB = 7;
    static final short SAMPLES_PER_PIXEL_TAG = 277;
    static final short ROWS_PER_STRIP_TAG = 278;
    static final short STRIP_OFFSETS_TAG = 273;
    static final short STRIP_BYTE_COUNTS_TAG = 279;
    static final short COLOR_MAP_TAG = 320;
    static final short PLANAR_CONFIGURATION_TAG = 284;
    static final short BYTE_TYPE = 1;
    static final short ASCII_TYPE = 2;
    static final short SHORT_TYPE = 3;
    static final short LONG_TYPE = 4;
    static final short RATIONAL_TYPE = 5;
    static final short SBYTE_TYPE = 6;
    static final short UNDEFINED_TYPE = 7;
    static final short SSHORT_TYPE = 8;
    static final short SLONG_TYPE = 9;
    static final short SRATIONAL_TYPE = 10;
    static final short FLOAT_TYPE = 11;
    static final short DOUBLE_TYPE = 12;
    private static final int[] typeSize = new int[]{1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    RAStream iStream;
    int tag;
    int type;
    int count;
    boolean isValue;
    Object values;
    long valueOffset;

    public TiffField(RAStream iStrm) throws IOException {
        this.iStream = iStrm;
        long nextFieldOffset = this.iStream.getFilePointer() + 12L;
        this.tag = this.iStream.readUnsignedShort();
        this.type = this.iStream.readUnsignedShort();
        this.count = (int)this.iStream.readUnsignedInt();
        boolean bl = this.isValue = typeSize[this.type - 1] * this.count <= 4;
        if (!this.isValue) {
            this.valueOffset = this.iStream.readUnsignedInt();
            this.iStream.seek(this.valueOffset);
        }
        this.interpretValues();
        this.iStream.seek(nextFieldOffset);
    }

    protected void interpretValues() throws IOException {
        switch (this.type) {
            case 1: {
                this.values = new byte[this.count];
                this.iStream.read((byte[])this.values, 0, this.count);
                break;
            }
            case 2: {
                this.values = new char[this.count];
                for (int i = 0; i < this.count; ++i) {
                    ((char[])this.values)[i] = (char)this.iStream.readByte();
                }
                break;
            }
            case 3: {
                this.values = new long[this.count];
                for (int i = 0; i < this.count; ++i) {
                    ((long[])this.values)[i] = this.iStream.readUnsignedShort();
                }
                break;
            }
            case 4: {
                this.values = new long[this.count];
                for (int i = 0; i < this.count; ++i) {
                    ((long[])this.values)[i] = this.iStream.readUnsignedInt();
                }
                break;
            }
            case 5: {
                this.values = new double[this.count];
                for (int i = 0; i < this.count; ++i) {
                    ((double[])this.values)[i] = (double)this.iStream.readUnsignedInt() / (double)this.iStream.readUnsignedInt();
                }
                break;
            }
            default: {
                throw new IOException("Unknown type:" + this.type);
            }
        }
    }

    public int getTag() {
        return this.tag;
    }

    public String asString() throws IOException {
        return "tag=" + this.tag + " type=" + this.type + " count=" + this.count + " isValue=" + this.isValue + " values=( " + this.getValueAsString() + " )";
    }

    public String getValueAsString() throws IOException {
        StringBuffer tmpStr = new StringBuffer(this.count * typeSize[this.type]);
        switch (this.type) {
            case 1: {
                for (int i = 0; i < this.count; ++i) {
                    tmpStr.append(((byte[])this.values)[i] + " ");
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.count; ++i) {
                    tmpStr.append(((char[])this.values)[i] + " ");
                }
                break;
            }
            case 3: 
            case 4: {
                for (int i = 0; i < this.count; ++i) {
                    tmpStr.append(((long[])this.values)[i] + " ");
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.count; ++i) {
                    tmpStr.append(((double[])this.values)[i] + " ");
                }
                break;
            }
            default: {
                throw new IOException("Unknown type:" + this.type);
            }
        }
        return tmpStr.toString();
    }

    public Object getValue() {
        return this.values;
    }
}

