/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.ImageException;
import com.sas.visuals.image.ImageFormatException;
import com.sas.visuals.image.ImageProperties;
import com.sas.visuals.image.decoder.ImageDecoder;
import com.sas.visuals.image.decoder.LEDataInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

@SASScope(value="ALL")
public class BmpDecoder
extends ImageDecoder {
    public static final String BMP_SIGNATURE = "BM";
    private static final int BI_RGB = 0;
    protected int fileSize;
    protected int bitmapOffset;
    protected int bitmapHeaderSize;
    protected boolean oldStyleHeader;
    protected boolean topDown;
    protected int height;
    protected int compressionType;
    protected int imageSize;
    protected int colorModelType;
    protected int colorMapLength;
    protected int sampleSizeInBits;
    protected DataInput iStream;
    protected int curPos;

    BmpDecoder(InputStream iStrm) throws IOException {
        super(iStrm);
        this.iStream = new LEDataInputStream(iStrm);
        this.iStream.skipBytes(BMP_SIGNATURE.length());
        this.fileSize = this.iStream.readInt();
        this.iStream.skipBytes(4);
        this.bitmapOffset = this.iStream.readInt();
        this.curPos = BMP_SIGNATURE.length() + 12;
    }

    public void finalizer() throws IOException {
    }

    public static boolean matchFormat(byte[] iSign) {
        String testSign = new String(iSign, 0, BMP_SIGNATURE.length());
        return testSign.compareTo(BMP_SIGNATURE) == 0;
    }

    @Override
    public byte[] getColorMap() throws IOException {
        byte[] tmpBGRA;
        byte[] cMap = new byte[this.colorMapLength * 3];
        byte[] byArray = tmpBGRA = this.oldStyleHeader ? new byte[3] : new byte[4];
        if (Debug.debug) {
            Debug.print("Colormap:");
        }
        for (int i = 0; i < cMap.length; i += 3) {
            this.iStream.readFully(tmpBGRA);
            cMap[i] = tmpBGRA[2];
            cMap[i + 1] = tmpBGRA[1];
            cMap[i + 2] = tmpBGRA[0];
            if (i >= 30 || !Debug.debug) continue;
            if (i % 9 == 0) {
                Debug.print("\n\t");
            }
            Debug.print(Integer.toHexString(0xFF & cMap[i]) + " " + Integer.toHexString(0xFF & cMap[i + 1]) + " " + Integer.toHexString(0xFF & cMap[i + 2]) + " | ");
        }
        if (Debug.debug) {
            Debug.println("\n");
        }
        this.curPos += 4 * this.colorMapLength;
        return cMap;
    }

    @Override
    public byte[] getRawImageData(ImageProperties iProps) throws IOException {
        int offsetDelta;
        int byteOffset;
        int scanLineSize = iProps.getScanLineSize();
        int padBytes = 0;
        if (this.curPos != this.bitmapOffset) {
            this.iStream.skipBytes(this.bitmapOffset - this.curPos);
        }
        if (this.colorModelType == 2) {
            padBytes = scanLineSize - iProps.getPixelSizeInSamples() * iProps.getXSize();
            scanLineSize -= padBytes;
        }
        int rawDataSize = scanLineSize * this.height;
        byte[] rawData = new byte[rawDataSize];
        if (this.topDown) {
            byteOffset = 0;
            offsetDelta = scanLineSize;
        } else {
            byteOffset = rawDataSize - scanLineSize;
            offsetDelta = -scanLineSize;
        }
        int i = 0;
        while (i < this.height) {
            try {
                this.iStream.readFully(rawData, byteOffset, scanLineSize);
                this.iStream.skipBytes(padBytes);
            }
            catch (EOFException e) {
                if (i == this.height - 1) {
                    Debug.println("BmpDecoder.getRawImageData(): Incomplete last scanline");
                }
                throw e;
            }
            ++i;
            byteOffset += offsetDelta;
        }
        if (this.colorModelType == 2) {
            int i2 = 0;
            for (int j = 2; j < rawDataSize; j += 3) {
                byte tmpColor = rawData[i2];
                rawData[i2] = rawData[j];
                rawData[j] = tmpColor;
                i2 += 3;
            }
        }
        return rawData;
    }

    @Override
    public ImageProperties getImageProperties() throws IOException, ImageException {
        int width;
        int xResolution = 0;
        int yResolution = 0;
        int numColorsUsed = 0;
        int numColorsImportant = 0;
        ImageProperties iProps = new ImageProperties("BMP");
        this.bitmapHeaderSize = this.iStream.readInt();
        if (this.bitmapHeaderSize == 12) {
            if (Debug.debug) {
                Debug.println("Old-style bitmap header size=" + this.bitmapHeaderSize);
            }
            this.oldStyleHeader = true;
            width = this.iStream.readShort();
            this.height = this.iStream.readShort();
        } else if (this.bitmapHeaderSize == 40) {
            this.oldStyleHeader = false;
            width = this.iStream.readInt();
            this.height = this.iStream.readInt();
        } else {
            throw new ImageFormatException("Unknown bitmap header size=" + this.bitmapHeaderSize);
        }
        iProps.setXSize(width);
        if (this.height < 0) {
            this.topDown = true;
            this.height = -this.height;
        } else {
            this.topDown = false;
        }
        iProps.setYSize(this.height);
        iProps.setPixelSizeInSamples(this.iStream.readShort());
        this.sampleSizeInBits = this.iStream.readShort();
        iProps.setSampleSizeInBits(this.sampleSizeInBits);
        this.colorMapLength = 0;
        if (this.bitmapHeaderSize == 40) {
            this.compressionType = this.iStream.readInt();
            this.imageSize = this.iStream.readInt();
            xResolution = this.iStream.readInt();
            yResolution = this.iStream.readInt();
            this.colorMapLength = numColorsUsed = this.iStream.readInt();
            numColorsImportant = this.iStream.readInt();
        }
        if (this.colorMapLength == 0 && this.sampleSizeInBits < 24) {
            this.colorMapLength = 1 << this.sampleSizeInBits * iProps.getPixelSizeInSamples();
        }
        if (this.sampleSizeInBits == 24) {
            iProps.setSampleSizeInBits(8);
            iProps.setPixelSizeInSamples(3);
            this.colorModelType = 2;
        } else {
            this.colorModelType = this.sampleSizeInBits == 1 ? 1 : 3;
        }
        iProps.setColorModelType(this.colorModelType);
        iProps.setPadSizeInBits(32);
        iProps.calcScanLineSizes();
        if (Debug.debug) {
            Debug.println("BMP-specific Image Properties: Bitmap offset=" + this.bitmapOffset + " BitmapHeaderSize=" + this.bitmapHeaderSize + "\n\tXResolution=" + xResolution + " YResolution=" + yResolution + " topDown=" + this.topDown + "\n\tnumColorsUsed=" + numColorsUsed + " colorMapLength=" + this.colorMapLength + " numColorsImportant=" + numColorsImportant + "\n\tBmp sampleSizeinBits=" + this.sampleSizeInBits);
        }
        this.curPos += this.bitmapHeaderSize;
        if (this.compressionType != 0) {
            throw new ImageFormatException("Unsupported Bitmap compressionType=" + this.compressionType);
        }
        return iProps;
    }
}

