/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import java.awt.Dimension;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.io.Serializable;
import java.util.Hashtable;

@SASScope(value="ALL")
public class TileImageFilter
extends ImageFilter
implements Serializable {
    static final long serialVersionUID = -8665927349231663881L;
    private static ColorModel defaultRGB = ColorModel.getRGBdefault();
    private transient int[] outpix;
    protected int srcWidth;
    protected int srcHeight;
    protected int destWidth;
    protected int destHeight;

    public TileImageFilter(int width, int height) {
        this.destWidth = width;
        this.destHeight = height;
    }

    public TileImageFilter() {
    }

    @Override
    public void setColorModel(ColorModel model) {
        this.consumer.setColorModel(defaultRGB);
    }

    public void setProperties(Hashtable props) {
        props = (Hashtable)props.clone();
        String key = "tile";
        String val = this.destWidth + "x" + this.destHeight;
        Object o = props.get(key);
        if (o != null && o instanceof String) {
            val = (String)o + ", " + val;
        }
        props.put(key, val);
        super.setProperties(props);
    }

    public Dimension getDestinationSize() {
        return new Dimension(this.destWidth, this.destHeight);
    }

    public void setDestinationSize(Dimension destSize) {
        this.destWidth = destSize.width;
        this.destHeight = destSize.height;
    }

    @Override
    public void setDimensions(int w, int h) {
        this.srcWidth = w;
        this.srcHeight = h;
        if (this.destWidth < 0) {
            if (this.destHeight < 0) {
                this.destWidth = this.srcWidth;
                this.destHeight = this.srcHeight;
            } else {
                this.destWidth = this.srcWidth * this.destHeight / this.srcHeight;
            }
        } else if (this.destHeight < 0) {
            this.destHeight = this.srcHeight * this.destWidth / this.srcWidth;
        }
        this.outpix = new int[this.srcWidth * this.srcHeight];
        this.consumer.setDimensions(this.destWidth, this.destHeight);
    }

    @Override
    public void imageComplete(int status) {
        int dy;
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int[][] pixels = new int[this.srcHeight][this.destWidth];
        for (dy = 0; dy < this.srcHeight; ++dy) {
            for (int dx = 0; dx < this.destWidth; dx += this.srcWidth) {
                for (int srcdx = dx; srcdx < dx + this.srcWidth && srcdx < this.destWidth; ++srcdx) {
                    pixels[dy][srcdx] = this.outpix[dy * this.srcWidth + srcdx - dx];
                }
            }
        }
        for (dy = 0; dy < this.destHeight; dy += this.srcHeight) {
            for (int srcdy = dy; srcdy < this.srcHeight + dy && srcdy < this.destHeight; ++srcdy) {
                this.consumer.setPixels(0, srcdy, this.destWidth, 1, defaultRGB, pixels[srcdy - dy], 0, this.destWidth);
            }
        }
        this.consumer.imageComplete(status);
    }

    @Override
    public void setHints(int hintflags) {
        this.consumer.setHints(0xE | hintflags & 0x10);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int srcoff = off;
        int dstoff = y * this.srcWidth + x;
        for (int yc = 0; yc < h; ++yc) {
            for (int xc = 0; xc < w; ++xc) {
                this.outpix[dstoff++] = model.getRGB(pixels[srcoff++] & 0xFF);
            }
            srcoff += scansize - w;
            dstoff += this.srcWidth - w;
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int srcoff = off;
        int dstoff = y * this.srcWidth + x;
        if (model == defaultRGB) {
            for (int yc = 0; yc < h; ++yc) {
                System.arraycopy(pixels, srcoff, this.outpix, dstoff, w);
                srcoff += scansize;
                dstoff += this.srcWidth;
            }
        } else {
            for (int yc = 0; yc < h; ++yc) {
                for (int xc = 0; xc < w; ++xc) {
                    this.outpix[dstoff++] = model.getRGB(pixels[srcoff++]);
                }
                srcoff += scansize - w;
                dstoff += this.srcWidth - w;
            }
        }
    }
}

