/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.BufferedFilter;

@SASScope(value="ALL")
public class RotateAnyFilter
extends BufferedFilter {
    static final long serialVersionUID = 6156102326953660155L;
    protected double rotateAngle;
    protected double cosFactor;
    protected double sinFactor;
    static double degreesPerRadian = 57.29578;

    public RotateAnyFilter() {
        this(0);
    }

    public RotateAnyFilter(double angleRadians, int backgroundColor) {
        super(backgroundColor);
        this.propKey = "rotate";
        this.setRotateAngle(angleRadians);
    }

    public RotateAnyFilter(double angleRadians) {
        this(angleRadians, 0);
    }

    public RotateAnyFilter(int angleDegrees, int backgroundColor) {
        this((double)angleDegrees / degreesPerRadian, backgroundColor);
    }

    public RotateAnyFilter(int angleDegrees) {
        this(angleDegrees, 0);
    }

    public void setRotateAngle(double angleRadians) {
        this.rotateAngle = angleRadians;
        this.cosFactor = Math.cos(this.rotateAngle);
        this.sinFactor = Math.sin(this.rotateAngle);
        this.propVal = "" + this.rotateAngle;
    }

    public double getRotateAngle() {
        return this.rotateAngle;
    }

    public void setRotateAngleInDegrees(int angleDegrees) {
        this.setRotateAngle((double)angleDegrees / degreesPerRadian);
    }

    @Override
    public final void transform(int[] src, double[] dest) {
        dest[0] = (double)src[0] * this.cosFactor - (double)src[1] * this.sinFactor;
        dest[1] = (double)src[0] * this.sinFactor + (double)src[1] * this.cosFactor;
    }

    @Override
    public final void invTransform(double[] src, double[] dest) {
        dest[0] = src[0] * this.cosFactor + src[1] * this.sinFactor;
        dest[1] = src[1] * this.cosFactor - src[0] * this.sinFactor;
    }
}

