/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import java.util.Hashtable;

@SASScope(value="ALL")
public class QuantizeCoarseFilter
extends RGBImageFilter
implements Serializable {
    protected int redLevels;
    protected int greenLevels;
    protected int blueLevels;
    static final long serialVersionUID = -8731742151156926814L;

    public QuantizeCoarseFilter() {
        this(3, 3, 2);
    }

    public QuantizeCoarseFilter(int rBits, int gBits, int bBits) {
        if (rBits < 0 || gBits < 0 || bBits < 0) {
            throw new IllegalArgumentException("Negative channel bits not supported: (R=" + rBits + ", G=" + gBits + ", B=" + bBits + ")");
        }
        if (rBits > 8 || gBits > 8 || bBits > 8) {
            throw new IllegalArgumentException("Channel bits exceeds 8 (R=" + rBits + ", G=" + gBits + ", B=" + bBits + ")");
        }
        this.redLevels = 255 / ((1 << rBits) - 1);
        this.greenLevels = 255 / ((1 << gBits) - 1);
        this.blueLevels = 255 / ((1 << bBits) - 1);
        this.canFilterIndexColorModel = true;
    }

    public void setProperties(Hashtable props) {
        String key = "Quantize Coarse: Levels ";
        String val = "R=" + this.redLevels + " G=" + this.greenLevels + " B=" + this.blueLevels;
        Object o = (props = (Hashtable)props.clone()).get(key);
        if (o != null && o instanceof String) {
            val = (String)o + ", " + val;
        }
        props.put(key, val);
        super.setProperties(props);
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int transparencyInfo = rgb & 0xFF000000;
        int redVal = (rgb & 0xFF0000) >> 16;
        int greenVal = (rgb & 0xFF00) >> 8;
        int blueVal = rgb & 0xFF;
        redVal = redVal / this.redLevels * this.redLevels;
        greenVal = greenVal / this.greenLevels * this.greenLevels;
        blueVal = blueVal / this.blueLevels * this.blueLevels;
        return transparencyInfo | (redVal <<= 16) | (greenVal <<= 8) | blueVal;
    }
}

