/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import java.awt.Image;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;

@SASScope(value="ALL")
public class ImageCache {
    public static final String NORMAL = "normal";
    public static final String DISABLED_SINK = "disabled sink";
    public static final String DISABLED_GREY = "disabled grey";
    public static final String DISABLED_GRAY = "disabled grey";
    public static final String MIXED = "mixed";
    public static final String TRANSPARENT = "transparent";
    protected static Hashtable _table = new Hashtable();
    protected static Integer _max = new Integer(10);
    protected static Integer _min = new Integer(5);
    protected static Vector _frequent = new Vector();
    protected static Boolean _enabled = new Boolean(true);
    protected static ImageCache _cache = new ImageCache();

    protected ImageCache() {
    }

    public static ImageCache instance() {
        return _cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addImage(Image key, Image image, String type) {
        if (ImageCache.isEnabled()) {
            Object object = null;
            ImageGroup images = null;
            Hashtable hashtable = _table;
            synchronized (hashtable) {
                object = _table.get(key);
            }
            if (object == null) {
                ImageCache imageCache = ImageCache.instance();
                Objects.requireNonNull(imageCache);
                images = imageCache.new ImageGroup(key);
                images.setImage(image, type);
                hashtable = _table;
                synchronized (hashtable) {
                    _table.put(key, images);
                }
            } else {
                images = object;
                images.setImage(image, type);
            }
            if (_frequent.indexOf(key) != 0) {
                _frequent.removeElement(key);
            }
            _frequent.addElement(key);
            ImageCache.pareImageCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(Image key, String type) {
        Image image = null;
        if (ImageCache.isEnabled()) {
            Object object = null;
            ImageGroup images = null;
            Hashtable hashtable = _table;
            synchronized (hashtable) {
                object = _table.get(key);
            }
            if (object != null) {
                images = object;
                image = images.getImage(type);
                if (_frequent.indexOf(key) != 0) {
                    _frequent.removeElement(key);
                }
                _frequent.addElement(key);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void pareImageCache() {
        int min = ImageCache.getMinImages();
        int max = ImageCache.getMaxImages();
        int size = ImageCache.getCacheSize();
        if (size > max) {
            Hashtable hashtable = _table;
            synchronized (hashtable) {
                Hashtable table = new Hashtable();
                Vector vector = _frequent;
                synchronized (vector) {
                    int count = _frequent.size();
                    int start = count - min;
                    for (int i = start = Math.max(start, 0); i < count; ++i) {
                        Object key = _frequent.elementAt(i);
                        Object object = _table.get(key);
                        table.put(key, object);
                    }
                    _frequent = new Vector();
                    _table = table;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled() {
        boolean enabled = false;
        Boolean bl = _enabled;
        synchronized (bl) {
            enabled = _enabled;
        }
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnabled(boolean enabled) {
        Boolean bl = _enabled;
        synchronized (bl) {
            if (_enabled != enabled) {
                _enabled = new Boolean(enabled);
                if (!enabled) {
                    Cloneable cloneable = _table;
                    synchronized (cloneable) {
                        _table = new Hashtable();
                    }
                    cloneable = _frequent;
                    synchronized (cloneable) {
                        _frequent = new Vector();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMinImages() {
        int min = -1;
        Integer n = _min;
        synchronized (n) {
            min = _min;
        }
        return min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxImages() {
        int max = -1;
        Integer n = _max;
        synchronized (n) {
            max = _max;
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMinImages(int min) {
        Integer n = _min;
        synchronized (n) {
            _min = new Integer(min);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxImages(int max) {
        Integer n = _max;
        synchronized (n) {
            _max = new Integer(max);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCacheSize() {
        int size = -1;
        Hashtable hashtable = _table;
        synchronized (hashtable) {
            size = _table.size();
        }
        return size;
    }

    @SASScope
    class ImageGroup {
        protected Image _disabledSink;
        protected Image _disabledGrey;
        protected Image _mixed;
        protected Image _transparent;
        protected Image _normal;

        public ImageGroup(Image normal) {
            this._normal = normal;
            this._disabledGrey = null;
            this._disabledSink = null;
            this._mixed = null;
            this._transparent = null;
        }

        public Image getImage(String type) {
            Image image = null;
            if (ImageCache.NORMAL.equalsIgnoreCase(type)) {
                image = this._normal;
            } else if (ImageCache.DISABLED_SINK.equalsIgnoreCase(type)) {
                image = this._disabledSink;
            } else if ("disabled grey".equalsIgnoreCase(type)) {
                image = this._disabledGrey;
            } else if (ImageCache.MIXED.equalsIgnoreCase(type)) {
                image = this._mixed;
            }
            if (ImageCache.TRANSPARENT.equalsIgnoreCase(type)) {
                image = this._transparent;
            }
            return image;
        }

        public void setImage(Image image, String type) {
            if (ImageCache.NORMAL.equalsIgnoreCase(type)) {
                this._normal = image;
            }
            if (ImageCache.DISABLED_SINK.equalsIgnoreCase(type)) {
                this._disabledSink = image;
            } else if ("disabled grey".equalsIgnoreCase(type)) {
                this._disabledGrey = image;
            } else if (ImageCache.MIXED.equalsIgnoreCase(type)) {
                this._mixed = image;
            }
            if (ImageCache.TRANSPARENT.equalsIgnoreCase(type)) {
                this._transparent = image;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof ImageGroup) {
                ImageGroup images = (ImageGroup)object;
                Image normal = images.getImage(ImageCache.NORMAL);
                if (normal != null) {
                    return normal.equals(this._normal);
                }
                return super.equals(object);
            }
            return super.equals(object);
        }
    }
}

