/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.adapters;

import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.io.Serializable;

public class MinMaxSpacePartitioner
implements SpacePartitionerInterface,
Serializable {
    static final long serialVersionUID = 5236031106504715542L;
    protected int[] minimums;
    protected int[] maximums;
    protected boolean giveMoreSpaceThanSpecified;

    public MinMaxSpacePartitioner() {
        this(true);
    }

    public MinMaxSpacePartitioner(boolean giveMoreSpaceThanSpecified) {
        this(null, null, giveMoreSpaceThanSpecified);
    }

    public MinMaxSpacePartitioner(int[] minimums, int[] maximums) {
        this(minimums, maximums, true);
    }

    public MinMaxSpacePartitioner(int[] minimums, int[] maximums, boolean giveMoreSpaceThanSpecified) {
        this.minimums = minimums;
        this.maximums = maximums;
        this.giveMoreSpaceThanSpecified = giveMoreSpaceThanSpecified;
    }

    protected int getConstrainedSize(int i, int size, int totalSize, int sizeUsed) {
        if (this.minimums != null && this.minimums[i] >= 0 && size < this.minimums[i]) {
            size = this.minimums[i];
        }
        if (this.maximums != null && this.maximums[i] >= 0 && size > this.maximums[i]) {
            size = this.maximums[i];
        }
        if (!this.giveMoreSpaceThanSpecified) {
            int sizeLeft = totalSize - sizeUsed;
            if (sizeLeft < 0) {
                size = 0;
            } else if (sizeLeft < size) {
                size = sizeLeft;
            }
        }
        return size;
    }

    @Override
    public int getPartitionedSpace(int[] sizes, int totalSize, int[] preferredSizes) {
        int sizeUsed = 0;
        for (int i = 0; i < sizes.length; ++i) {
            int size;
            sizes[i] = size = this.getConstrainedSize(i, preferredSizes[i], totalSize, sizeUsed);
            sizeUsed += size;
        }
        return totalSize - sizeUsed;
    }
}

