/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.adapters;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.io.Serializable;

@SASScope(value="ALL")
public class EqualSpacePartitioner
implements SpacePartitionerInterface,
Serializable {
    static final long serialVersionUID = 5236031106504715542L;
    protected boolean divideTotalSpace = false;
    protected int minimumSize;
    protected int maximumSize;
    protected boolean[] partitionsToDivide;

    public EqualSpacePartitioner() {
        this(false);
    }

    public EqualSpacePartitioner(boolean divideTotalSpace) {
        this.divideTotalSpace = divideTotalSpace;
    }

    protected int constrainSize(int size) {
        if (this.minimumSize != 0 && size < this.minimumSize) {
            size = this.minimumSize;
        }
        if (this.maximumSize != 0 && size > this.maximumSize) {
            size = this.maximumSize;
        }
        return size;
    }

    @Override
    public int getPartitionedSpace(int[] sizes, int totalSize, int[] preferredSizes) {
        if (sizes.length == 0) {
            return totalSize;
        }
        if (!this.divideTotalSpace) {
            if (this.partitionsToDivide == null) {
                int i;
                int maxPreferredSize = 0;
                for (i = 0; i < preferredSizes.length; ++i) {
                    if (preferredSizes[i] <= maxPreferredSize) continue;
                    maxPreferredSize = preferredSizes[i];
                }
                if (maxPreferredSize * sizes.length < totalSize) {
                    maxPreferredSize = totalSize / sizes.length;
                }
                maxPreferredSize = this.constrainSize(maxPreferredSize);
                for (i = 0; i < sizes.length; ++i) {
                    sizes[i] = maxPreferredSize;
                }
                return totalSize - maxPreferredSize * sizes.length;
            }
            int maxPreferredSize = 0;
            int numSplittingSize = 0;
            int otherSizes = 0;
            for (int i = 0; i < preferredSizes.length; ++i) {
                if (this.partitionsToDivide[i]) {
                    ++numSplittingSize;
                    if (preferredSizes[i] <= maxPreferredSize) continue;
                    maxPreferredSize = preferredSizes[i];
                    continue;
                }
                otherSizes += preferredSizes[i];
            }
            if (maxPreferredSize * numSplittingSize < totalSize - otherSizes) {
                maxPreferredSize = (totalSize - otherSizes) / numSplittingSize;
            }
            maxPreferredSize = this.constrainSize(maxPreferredSize);
            if (totalSize > 0) {
                maxPreferredSize = (totalSize - otherSizes) / numSplittingSize;
            }
            int sizeUsed = 0;
            for (int i = 0; i < sizes.length; ++i) {
                sizes[i] = this.partitionsToDivide[i] ? maxPreferredSize : preferredSizes[i];
                sizeUsed += sizes[i];
            }
            return totalSize - sizeUsed;
        }
        if (this.partitionsToDivide == null) {
            if (totalSize < 0) {
                for (int i = 0; i < sizes.length; ++i) {
                    sizes[i] = 0;
                }
                return 0;
            }
            int size = totalSize / sizes.length;
            size = this.constrainSize(size);
            for (int i = 0; i < sizes.length; ++i) {
                sizes[i] = size;
            }
            return totalSize - size * sizes.length;
        }
        if (totalSize < 0) {
            for (int i = 0; i < sizes.length; ++i) {
                sizes[i] = 0;
            }
            return 0;
        }
        int numSplittingSize = 0;
        int otherSizes = 0;
        for (int i = 0; i < preferredSizes.length; ++i) {
            if (this.partitionsToDivide[i]) {
                ++numSplittingSize;
                continue;
            }
            otherSizes += preferredSizes[i];
        }
        int size = (totalSize - otherSizes) / numSplittingSize;
        size = this.constrainSize(size);
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = this.partitionsToDivide[i] ? size : preferredSizes[i];
        }
        return totalSize - otherSizes - size * numSplittingSize;
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(int minimumSize) {
        this.minimumSize = minimumSize;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public boolean isDivideTotalSpace() {
        return this.divideTotalSpace;
    }

    public void setDivideTotalSpace(boolean divideTotalSpace) {
        this.divideTotalSpace = divideTotalSpace;
    }

    @SASScope
    public boolean[] getPartitionsToDivide() {
        return this.partitionsToDivide;
    }

    @SASScope
    public void setPartitionsToDivide(boolean[] partitionsToDivide) {
        this.partitionsToDivide = partitionsToDivide;
    }
}

