/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.Serializable;

public class RowColumnLayout
implements LayoutManager,
Serializable {
    static final long serialVersionUID = -8871844715171542514L;
    int hgap;
    int vgap;
    int rows;
    int cols;
    int fill;
    boolean autoSpacing;

    public RowColumnLayout() {
        this(0, 0, 0, 0, 0, false);
    }

    public RowColumnLayout(int rows, int cols, int fill) {
        this(rows, cols, fill, 0, 0, false);
    }

    public RowColumnLayout(int rows, int cols, int fill, int hgap, int vgap) {
        this(rows, cols, fill, hgap, vgap, false);
    }

    public RowColumnLayout(int rows, int cols, int fill, int hgap, int vgap, boolean spacing) {
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
        this.fill = fill;
        this.autoSpacing = spacing;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RowColumnLayout) {
            RowColumnLayout tempLayout = (RowColumnLayout)obj;
            int tRows = tempLayout.getRows();
            int tCols = tempLayout.getColumns();
            int tHGap = tempLayout.getHgap();
            int tVGap = tempLayout.getVgap();
            int tFill = tempLayout.getFill();
            boolean tAutoSpacing = tempLayout.isAutoSpacing();
            return tRows == this.rows && tCols == this.cols && this.hgap == tHGap && this.vgap == tVGap && this.fill == tFill && this.autoSpacing == tAutoSpacing;
        }
        return false;
    }

    public boolean isAutoSpacing() {
        return this.autoSpacing;
    }

    public void setAutoSpacing(boolean s) {
        this.autoSpacing = s;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int cols) {
        this.cols = cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public int getFill() {
        return this.fill;
    }

    public void setFill(int fillFirst) {
        if (fillFirst == 0 || fillFirst == 1) {
            this.fill = fillFirst;
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (nrows == 0 && ncols == 0) {
                nrows = ncomponents;
                ncols = 1;
            } else if (nrows == 0) {
                nrows = (ncomponents + ncols - 1) / ncols;
            } else if (ncols == 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            }
            int maxW = 0;
            int maxH = 0;
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = parent.getComponent(i);
                Dimension d = comp.getPreferredSize();
                if (maxW < d.width) {
                    maxW = d.width;
                }
                if (maxH >= d.height) continue;
                maxH = d.height;
            }
            return new Dimension(insets.left + insets.right + ncols * maxW + (ncols - 1) * this.hgap, insets.top + insets.bottom + nrows * maxH + (nrows - 1) * this.vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (nrows == 0) {
                nrows = 1;
            }
            if (ncols == 0) {
                ncols = 1;
            }
            int maxW = 0;
            int maxH = 0;
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = parent.getComponent(i);
                Dimension d = comp.getPreferredSize();
                if (maxW < d.width) {
                    maxW = d.width;
                }
                if (maxH >= d.height) continue;
                maxH = d.height;
            }
            return new Dimension(insets.left + insets.right + ncols * maxW + (ncols - 1) * this.hgap, insets.top + insets.bottom + nrows * maxH + (nrows - 1) * this.vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (ncomponents == 0) {
                return;
            }
            int availWidth = parent.getSize().width - insets.left - insets.right;
            int availHeight = parent.getSize().height - insets.top - insets.bottom;
            Point pos = new Point(insets.left, insets.top);
            int maxW = 0;
            int maxH = 0;
            int tmpNComponents = ncomponents;
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = parent.getComponent(i);
                Dimension d = comp.getPreferredSize();
                if (maxW < d.width) {
                    maxW = d.width;
                }
                if (maxH >= d.height) continue;
                maxH = d.height;
            }
            ncomponents = tmpNComponents;
            if (maxW == 0 || maxH == 0) {
                return;
            }
            int numCols = availWidth / (maxW + this.hgap);
            int numRows = availHeight / (maxH + this.vgap);
            if (availWidth % (maxW + this.hgap) >= maxW) {
                ++numCols;
            }
            if (availHeight % (maxH + this.vgap) >= maxH) {
                ++numRows;
            }
            if (nrows < numRows && nrows > 0) {
                numRows = nrows;
            }
            if (ncols < numCols && ncols > 0) {
                numCols = ncols;
            }
            if (numRows == 0) {
                numRows = 1;
            }
            if (numCols == 0) {
                numCols = 1;
            }
            if (this.fill == 0) {
                int bufferVert = 0;
                int bufferHorz = 0;
                if (this.autoSpacing) {
                    int ncolsNeeded = (ncomponents + numRows - 1) / numRows;
                    if (ncolsNeeded < numCols) {
                        numCols = ncolsNeeded;
                    }
                    if (ncomponents < numRows) {
                        numRows = ncomponents;
                    }
                    bufferVert = (availHeight - (maxH * numRows + this.vgap * (numRows - 1))) / numRows;
                    bufferHorz = (availWidth - (maxW * numCols + this.hgap * (numCols - 1))) / numCols;
                }
                pos.x += bufferHorz / 2;
                pos.y += bufferVert / 2;
                int topPos = pos.y;
                int i = 0;
                for (int k = 0; k < numCols; ++k) {
                    for (int j = 0; j < numRows; ++j) {
                        if (i >= ncomponents) continue;
                        Component comp = parent.getComponent(i);
                        comp.setVisible(true);
                        ++i;
                        comp.setBounds(pos.x, pos.y, maxW, maxH);
                        pos.y = pos.y + maxH + bufferVert + this.vgap;
                    }
                    pos.y = topPos;
                    pos.x = pos.x + maxW + bufferHorz + this.hgap;
                }
                for (int x = i; x < ncomponents; ++x) {
                    parent.getComponent(x).setVisible(false);
                }
            } else {
                int bufferVert = 0;
                int bufferHorz = 0;
                if (this.autoSpacing) {
                    int nrowsNeeded = (ncomponents + numCols - 1) / numCols;
                    if (nrowsNeeded < numRows) {
                        numRows = nrowsNeeded;
                    }
                    if (ncomponents < numCols) {
                        numCols = ncomponents;
                    }
                    bufferVert = (availHeight - (maxH * numRows + this.vgap * (numRows - 1))) / numRows;
                    bufferHorz = (availWidth - (maxW * numCols + this.hgap * (numCols - 1))) / numCols;
                }
                pos.x += bufferHorz / 2;
                pos.y += bufferVert / 2;
                int leftPos = pos.x;
                int i = 0;
                for (int k = 0; k < numRows; ++k) {
                    for (int j = 0; j < numCols; ++j) {
                        if (i >= ncomponents) continue;
                        Component comp = parent.getComponent(i);
                        comp.setVisible(true);
                        ++i;
                        comp.setBounds(pos.x, pos.y, maxW, maxH);
                        pos.x = pos.x + maxW + bufferHorz + this.hgap;
                    }
                    pos.x = leftPos;
                    pos.y = pos.y + maxH + bufferVert + this.vgap;
                }
                for (int x = i; x < ncomponents; ++x) {
                    parent.getComponent(x).setVisible(false);
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + "]";
    }
}

