/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.validators;

import com.sas.text.Message;
import com.sas.util.validators.RB;
import com.sas.util.validators.Validator;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateStringValidator
extends Validator {
    public static final String RB_KEY = "DateStringValidator.";
    static final long serialVersionUID = -7241441754623891156L;
    protected static int INVALID_FORMAT = 0;
    protected static int ONLY_STRING = 1;
    public static final String invalidFormat = "DateStringValidator.InvalidFormat.txt";
    public static final String onlyString = "DateStringValidator.OnlyString.txt";
    protected DateFormat format;

    public DateStringValidator() {
    }

    public DateStringValidator(String formatString) {
        this(new SimpleDateFormat(formatString));
    }

    public DateStringValidator(DateFormat format) {
        this.format = format;
    }

    public void setFormat(DateFormat newFormat) {
        this.format = newFormat;
    }

    public DateFormat getFormat() {
        return this.format;
    }

    @Override
    public boolean validateValue(Object component, Object value) {
        if (value instanceof String) {
            try {
                if (this.format != null) {
                    this.format.parse((String)value);
                } else {
                    new Date((String)value);
                }
                return true;
            }
            catch (IllegalArgumentException e) {
                this.setValidationMessage((Message)this.messages.get(INVALID_FORMAT));
                this.setValidationMessageCode(invalidFormat);
            }
            catch (ParseException e) {
                this.setValidationMessage((Message)this.messages.get(INVALID_FORMAT));
                this.setValidationMessageCode(invalidFormat);
            }
        } else {
            this.setValidationMessage((Message)this.messages.get(ONLY_STRING));
            this.setValidationMessageCode(onlyString);
        }
        return false;
    }

    @Override
    public void createValidationMessages() {
        this.messages.add(this.newValidationMessage(RB.getStringResource(RB_KEY, "InvalidFormat.txt")));
        this.messages.add(this.newValidationMessage(RB.getStringResource(RB_KEY, "OnlyString.txt")));
    }
}

