/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeModel;

public class PreorderTreeModelIterator
implements Iterator {
    private Object next;
    private List parentStack;
    private TreeModel model;

    public PreorderTreeModelIterator(TreeModel model) {
        this.model = model;
        this.next = model.getRoot();
        this.parentStack = new ArrayList();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        Object nextObject = this.next;
        this.next = this.getNext(this.next);
        return nextObject;
    }

    public Object[] getParentStack() {
        return this.parentStack.toArray();
    }

    private Object getNext(Object object) {
        Object next;
        if (!this.model.isLeaf(object) && this.model.getChildCount(object) > 0) {
            Object parent = object;
            next = this.model.getChild(parent, 0);
            this.parentStack.add(parent);
        } else {
            next = this.getSibling(object);
        }
        return next;
    }

    private Object getSibling(Object object) {
        int parentCnt = this.parentStack.size();
        if (parentCnt <= 0) {
            return null;
        }
        Object parent = this.parentStack.get(parentCnt - 1);
        int childCount = this.model.getChildCount(parent);
        int index = this.model.getIndexOfChild(parent, object);
        if (index + 1 < childCount) {
            return this.model.getChild(parent, index + 1);
        }
        this.parentStack.remove(parent);
        return this.getSibling(parent);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

