/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.GlobalInfoTable;
import com.sas.security.BaseSecuritySupport;
import com.sas.text.Message;
import com.sas.util.RB;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;

public class ContentServer2
implements Runnable {
    public static final String RB_KEY = "ContentServer.";
    protected byte[] _content;
    protected String _mimeType;
    protected ServerSocket _server;
    protected int _localPort = -1;
    protected int _minPort = 0;
    protected int _maxPort = 0;
    protected static int serverTimeOut = 30000;
    protected String _fileName;
    protected String _extension;
    protected String _browser;
    protected String _application;
    protected static boolean _isInApplet;
    protected static boolean _useSockets;
    protected static boolean _useEcho;
    protected static String _echoURL;
    protected static String[] _echoURLs;
    protected static boolean _checked;
    protected static boolean _canWriteToDisk;
    protected static int _counter;
    protected static final String BROWSER = "WebBrowser";
    protected static boolean _verbose;
    protected StringBuffer _printBuf;
    protected TextArea _printText;
    protected Dialog _printDialog;
    public static final int SUCCESS = 0;
    public static final int CANT_OPEN_SERVERSOCKET = 1;
    public static final int CANT_ACCEPT = 2;
    public static final int CANT_GET_OUTPUT_STREAM = 3;
    public static final int TIMED_OUT = 4;
    public static final int ERROR_SENDING_HEADER = 5;
    public static final int ERROR_SENDING_CONTENT = 6;
    public static final int ERROR_CREATING_URL = 7;
    public static final int ERROR_WRITING_FILE = 8;
    public static final int ERROR_INVOKING_APP = 9;
    public static final int CANT_GET_REQUEST = 10;
    public static final int EXPORT_NOT_ALLOWED = 11;
    public static final int FAILED_TO_EXPORT = 12;
    public static final String[] errorMsgs;
    private String baseTempFileName;
    private URLConnection conn;
    private File applicationFile;

    public ContentServer2() {
        this.baseTempFileName = "temp";
    }

    public ContentServer2(String contentType, byte[] content, String fileName) {
        this.setMIMEType(contentType);
        this.setContent(content);
        this.setFileName(fileName);
    }

    public ContentServer2(String contentType, StringBuffer content, String fileName) {
        this.setMIMEType(contentType);
        this.setContent(content);
        this.setFileName(fileName);
    }

    public ContentServer2(String contentType, String content, String fileName) {
        this.setMIMEType(contentType);
        this.setContent(content);
        this.setFileName(fileName);
    }

    public static void resetCheck() {
        _checked = false;
    }

    public String getBaseTempFileName() {
        if (this.baseTempFileName != null) {
            return this.baseTempFileName;
        }
        return "temp";
    }

    public void setBaseTempFileName(String prefix) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (prefix.length() >= 3) {
            this.baseTempFileName = prefix;
        }
    }

    public static boolean isExportUsingSocketsAllowed() {
        boolean rc = ContentServer2.isExportAllowed();
        return rc && _useSockets;
    }

    public static boolean isExportUsingEchoCGIAllowed() {
        boolean rc = ContentServer2.isExportAllowed();
        return rc && _useEcho;
    }

    public static boolean isExportToDiskAllowed() {
        boolean rc = ContentServer2.isExportAllowed();
        return rc && _canWriteToDisk;
    }

    public static boolean isExportAllowed() {
        if (!_checked) {
            Applet applet = (Applet)GlobalInfoTable.getObject();
            if (applet != null) {
                Container c;
                for (c = applet.getParent(); c != null && !(c instanceof Frame); c = c.getParent()) {
                }
                if (c != null && c.getClass().getName().equals("sun.applet.AppletViewer")) {
                    applet = null;
                }
                if (_verbose) {
                    System.err.println("In AppletViewer? " + (applet == null));
                }
            }
            if (applet != null) {
                block24: {
                    _isInApplet = true;
                    try {
                        if (System.getSecurityManager() != null) {
                            System.getSecurityManager().checkAccept("localhost", 3030);
                        }
                        _useSockets = true;
                    }
                    catch (SecurityException e) {
                        if (!_verbose) break block24;
                        System.err.println("SecurityManager.checkAccept failed");
                    }
                }
                if (!_useSockets) {
                    URL docBase = applet.getDocumentBase();
                    String server = null;
                    server = docBase.getHost();
                    if (_verbose) {
                        System.err.println("URL.getHost() returned " + server);
                    }
                    server = server != null && server.length() > 0 ? "http://" + server : "http://localhost";
                    if (_verbose) {
                        System.err.println("Using base server URL " + server);
                    }
                    String[] possible = ContentServer2.getPossibleEchoURLs();
                    for (int i = 0; i < possible.length; ++i) {
                        String testURL = server + possible[i];
                        try {
                            if (_verbose) {
                                System.err.println("Trying " + testURL);
                            }
                            URL url = new URL(testURL);
                            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                            String response = reader.readLine();
                            boolean no404 = true;
                            do {
                                if (response.indexOf(" 404 ") == -1) continue;
                                no404 = false;
                                break;
                            } while ((response = reader.readLine()) != null);
                            reader.close();
                            if (!no404) continue;
                            _useEcho = true;
                            _echoURL = testURL;
                            if (_verbose) {
                                System.err.println("Found echo at " + _echoURL);
                            }
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            } else {
                block26: {
                    try {
                        String temp = "zz29xqq.foo";
                        if (_verbose) {
                            System.err.println("Testing write access to " + temp);
                        }
                        if (System.getSecurityManager() != null) {
                            System.getSecurityManager().checkWrite(temp);
                        }
                        _canWriteToDisk = true;
                    }
                    catch (Exception e) {
                        _canWriteToDisk = false;
                        if (!_verbose) break block26;
                        System.err.println("SecurityManager.checkWrite failed");
                    }
                }
                if (_verbose) {
                    System.err.println("Can write to disk? " + _canWriteToDisk);
                }
            }
            _checked = true;
        }
        return _isInApplet && (_useSockets || _useEcho) || _canWriteToDisk;
    }

    public static int export(String content, String contentType, String app, String args, String fileExt) {
        return ContentServer2.export(content.getBytes(), contentType, app, args, null, fileExt, ContentServer2.getTimeOut(), 0, 0);
    }

    public static int export(byte[] content, String contentType, String app, String args, String fileExt) {
        return ContentServer2.export(content, contentType, app, args, null, fileExt, ContentServer2.getTimeOut(), 0, 0);
    }

    public static int export(byte[] content, String contentType, String app, String args, String browser, String fileExt, int timeOut, int minPort, int maxPort) {
        if (content == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"contentNull.ex.txt"));
        }
        if (!ContentServer2.isExportAllowed()) {
            return 11;
        }
        ContentServer2 server = new ContentServer2();
        server.setMinPort(minPort);
        server.setMaxPort(maxPort);
        server.setFileExtension(fileExt);
        ContentServer2.setTimeOut(timeOut);
        if (_isInApplet || app == null && browser != null) {
            server.setFileName(server.getBaseTempFileName() + _counter++ + "." + server.getFileExtension());
        }
        server.setContent(content);
        server.setMIMEType(contentType);
        if (_isInApplet) {
            return server.sendToBrowser();
        }
        if (app != null) {
            server.setApplication(app, args);
            return server.sendToApplication(true);
        }
        if (browser != null) {
            server.setBrowser(browser);
            return server.sendToBrowserApp();
        }
        return 12;
    }

    public OutputStream getExportOutputStream(String app, String args, String browser) {
        try {
            if (!ContentServer2.isExportAllowed()) {
                return null;
            }
            if (_isInApplet || app == null && browser != null) {
                this.setFileName(this.getBaseTempFileName() + _counter++ + "." + this.getFileExtension());
            }
            if (_isInApplet) {
                return this.getOutputStreamForBrowser();
            }
            if (app != null) {
                this.setApplication(app, args);
                return this.getOutputStreamForApplication();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private OutputStream getOutputStreamForBrowser() {
        if (_useSockets) {
            return null;
        }
        if (_useEcho) {
            return this.getOutputStreamForBrowserEcho();
        }
        return null;
    }

    private OutputStream getOutputStreamForApplication() throws IOException {
        String extension = this._extension;
        if (extension != null && !extension.startsWith(".")) {
            extension = "." + this._extension;
        }
        this.applicationFile = File.createTempFile(this.getBaseTempFileName(), extension);
        this.setFileName(this.applicationFile.getName());
        return new FileOutputStream(this.applicationFile);
    }

    private OutputStream getOutputStreamForBrowserEcho() {
        try {
            return this.getOutputStreamForCreateCmd();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private OutputStream getOutputStreamForCreateCmd() throws Exception {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ContentServer2.getEchoURL());
        sb.append("?create+");
        sb.append(".");
        sb.append(this.getFileExtension());
        URL url = new URL(sb.toString());
        this.println("URL: " + url);
        this.conn = url.openConnection();
        this.println(RB.getStringResource((String)RB_KEY, (String)"openedConnection.txt"));
        this.conn.setDoOutput(true);
        this.conn.setDoInput(true);
        this.conn.setUseCaches(false);
        this.conn.setRequestProperty("content-type", "application/octet-stream");
        this.println(RB.getStringResource((String)RB_KEY, (String)"gettingOutputStream.txt"));
        DataOutputStream os = new DataOutputStream(this.conn.getOutputStream());
        this.println(RB.getStringResource((String)RB_KEY, (String)"gotOutputStream.txt"));
        return os;
    }

    public int exportContentsOfOutputStream(OutputStream out, String app, String args, String browser) {
        if (out != null) {
            if (!ContentServer2.isExportAllowed()) {
                return 11;
            }
            if (_isInApplet && !_useSockets && _useEcho) {
                return this.exportToBrowserEcho(out);
            }
            if (app != null) {
                this.setApplication(app, args);
                return this.executeCommand(true);
            }
        }
        return 12;
    }

    private int exportToBrowserEcho(OutputStream os) {
        try {
            this.println(RB.getStringResource((String)RB_KEY, (String)"sentData.txt"));
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
            String resultsFile = reader.readLine();
            reader.close();
            os.close();
            resultsFile = resultsFile.trim();
            this.println(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"receivedFilename.txt"), (Object)resultsFile));
            this.sendShowCmd(resultsFile);
            this.sendDeleteCmd(resultsFile);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            return 6;
        }
        return 0;
    }

    public static void setTimeOut(int newTimeOut) {
        serverTimeOut = newTimeOut;
    }

    public static int getTimeOut() {
        return serverTimeOut;
    }

    public static void setPossibleEchoURLs(String[] echoURLs) {
        _echoURLs = echoURLs;
    }

    public static String[] getPossibleEchoURLs() {
        if (_echoURLs == null) {
            _echoURLs = new String[]{"/sasweb/cgi-bin/echocgi.exe", "/sasweb/cgi-bin/echocgi"};
        }
        return _echoURLs;
    }

    public static String getEchoURL() {
        return _echoURL;
    }

    public boolean setApplication(String application, String args) {
        if (_verbose) {
            System.err.println("Checking application...");
        }
        this._application = application;
        boolean exists = this.pathExists(this._application);
        if (args != null) {
            this._application = this._application + " " + args;
        }
        return exists;
    }

    public boolean setBrowser(String browser) {
        if (browser == null) {
            browser = System.getProperty(BROWSER);
        }
        if (_verbose) {
            System.err.println("Checking browser...");
        }
        boolean exists = this.pathExists(browser);
        this._browser = browser;
        return exists;
    }

    public static void setVerbose(boolean verbose) {
        if (_verbose == verbose) {
            return;
        }
        _verbose = verbose;
        if (_verbose) {
            System.err.println("ContentServer2 -- verbose mode on");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendToApplication(boolean deleteFile) {
        OutputStream fos = null;
        try {
            fos = this.getOutputStreamForApplication();
            fos.write(this._content);
            fos.flush();
        }
        catch (IOException e) {
            int n = 8;
            return n;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.executeCommand(deleteFile);
    }

    private int executeCommand(boolean deleteFile) {
        String fullFileName = this.applicationFile.getAbsolutePath();
        String cmd = this._application + " " + fullFileName;
        try {
            final Process proc = Runtime.getRuntime().exec(cmd);
            if (deleteFile) {
                BaseSecuritySupport.securitySupport.createThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            proc.waitFor();
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            ContentServer2.this.applicationFile.delete();
                            ContentServer2.this.applicationFile = null;
                        }
                    }
                }).start();
            }
        }
        catch (Exception e) {
            return 9;
        }
        return 0;
    }

    public int sendToBrowserApp() {
        int ret = this.openServer();
        if (ret != 0) {
            return ret;
        }
        Thread t = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
        t.start();
        String urlString = "http://localhost:" + this.getLocalPort() + "/" + this._fileName;
        String cmd = this._browser + " " + urlString;
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            return 9;
        }
        return 0;
    }

    public int sendToBrowser() {
        if (_useSockets) {
            return this.sendToBrowserServerSocket();
        }
        if (_useEcho) {
            return this.sendToBrowserEcho();
        }
        return 2;
    }

    protected String sendCreateCmd() throws Exception {
        OutputStream os = this.getOutputStreamForCreateCmd();
        os.write(this.getContent());
        os.flush();
        this.println(RB.getStringResource((String)RB_KEY, (String)"sentData.txt"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
        String resultsFile = reader.readLine();
        reader.close();
        os.close();
        resultsFile = resultsFile.trim();
        this.println(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"receivedFilename.txt"), (Object)resultsFile));
        return resultsFile;
    }

    protected void sendShowCmd(String resultsFile) throws Exception {
        StringBuffer sb = new StringBuffer(80);
        sb.append(_echoURL);
        sb.append("/tmp.");
        sb.append(this.getFileExtension());
        sb.append("?shownodel+");
        sb.append(resultsFile);
        sb.append("+");
        sb.append(this.getMIMEType());
        sb.append("+");
        sb.append("tmp.");
        sb.append(this.getFileExtension());
        URL url = new URL(sb.toString());
        this.println(url.toExternalForm());
        ((Applet)GlobalInfoTable.getObject()).getAppletContext().showDocument(url, "_blank");
    }

    protected void sendDeleteCmd(final String resultsFile) {
        BaseSecuritySupport.securitySupport.createThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(60000L);
                    StringBuffer sb = new StringBuffer(80);
                    sb.append(_echoURL);
                    sb.append("?delete+");
                    sb.append(resultsFile);
                    ContentServer2.this.println(Message.format((String)RB.getStringResource((String)ContentServer2.RB_KEY, (String)"deleteTheFile.txt"), (Object)sb.toString()));
                    URL url = new URL(sb.toString());
                    URLConnection conn = url.openConnection();
                    conn.connect();
                    ContentServer2.this.println(RB.getStringResource((String)ContentServer2.RB_KEY, (String)"fileDeleted.txt"));
                }
                catch (Exception e) {
                    ContentServer2.this.println(Message.format((String)RB.getStringResource((String)ContentServer2.RB_KEY, (String)"errorDeletingFile.ex.txt"), (Object)resultsFile));
                    ContentServer2.this.printStackTrace(e);
                }
            }
        }).start();
    }

    protected int sendToBrowserEcho() {
        try {
            String resultsFile = this.sendCreateCmd();
            this.sendShowCmd(resultsFile);
            this.sendDeleteCmd(resultsFile);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            return 6;
        }
        return 0;
    }

    protected int sendToBrowserServerSocket() {
        int ret = this.openServer();
        this.showStatus(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"openingServerReturned.txt"), (Object)errorMsgs[ret]));
        this.println(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"openingServerReturned.txt"), (Object)errorMsgs[ret]));
        if (ret != 0) {
            return ret;
        }
        this.showStatus(RB.getStringResource((String)RB_KEY, (String)"serverOpenedSuccessfully.txt"));
        this.println(RB.getStringResource((String)RB_KEY, (String)"serverOpenedSuccessfully.txt"));
        this.showStatus(RB.getStringResource((String)RB_KEY, (String)"startingServer.txt"));
        this.println(RB.getStringResource((String)RB_KEY, (String)"startingServer.txt"));
        Thread t = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
        t.start();
        Thread.yield();
        this.showStatus(RB.getStringResource((String)RB_KEY, (String)"constructingTheURL.txt"));
        this.println(RB.getStringResource((String)RB_KEY, (String)"constructingTheURL.txt"));
        String urlString = "http://localhost:" + this.getLocalPort() + "/" + this._fileName;
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (Exception e) {
            return 7;
        }
        this.showStatus("URL " + url.toString());
        this.println("URL " + url.toString());
        try {
            ((Applet)GlobalInfoTable.getObject()).getAppletContext().showDocument(url, "_blank" + _counter++);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            return 6;
        }
        this.println(RB.getStringResource((String)RB_KEY, (String)"showDocumentCalled.txt"));
        this.showStatus(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"nowShowingURL.txt"), (Object)url.toString()));
        return 0;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileExtension(String extension) {
        this._extension = extension != null && extension.charAt(0) == '.' ? extension.substring(1) : extension;
    }

    public String getFileExtension() {
        return this._extension;
    }

    public void setContentType(String contentType) {
        this.setMIMEType(contentType);
    }

    public void setMIMEType(String mimeType) {
        this._mimeType = mimeType;
    }

    public String getMIMEType() {
        return this._mimeType;
    }

    public void setContent(byte[] content) {
        this._content = content;
    }

    public void setContent(StringBuffer content) {
        this.setContent(content.toString());
    }

    public void setContent(String content) {
        this._content = content.getBytes();
    }

    public byte[] getContent() {
        return this._content;
    }

    public int getLocalPort() {
        return this._localPort;
    }

    public void setMinPort(int minPort) {
        this._minPort = minPort;
        this.validateMaxPortRange();
    }

    public int getMinPort() {
        return this._minPort;
    }

    public void setMaxPort(int maxPort) {
        this._maxPort = maxPort;
        this.validateMinPortRange();
    }

    public int getMaxPort() {
        return this._maxPort;
    }

    private void validateMinPortRange() {
        this._minPort = Math.min(this._minPort, this._maxPort);
        this._maxPort = Math.max(this._minPort, this._maxPort);
    }

    private void validateMaxPortRange() {
        this._maxPort = Math.max(this._minPort, this._maxPort);
        this._minPort = Math.min(this._minPort, this._maxPort);
    }

    public int openServer() {
        if (this._server != null) {
            this.println(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"serverSocketOpen.txt"), (Object)new Integer(this._localPort)));
            return 0;
        }
        this.println(RB.getStringResource((String)RB_KEY, (String)"openingServer.txt"));
        int openPort = this._minPort;
        int ret = 0;
        do {
            try {
                this._server = new ServerSocket(openPort);
                this._localPort = this._server.getLocalPort();
                ret = 0;
                this.println(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"finishedOpeningServer.txt"), (Object)new Integer(this._localPort)));
            }
            catch (Exception e) {
                try {
                    if (this._server != null) {
                        this._server.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._server = null;
                ret = 1;
            }
        } while (ret != 0 && ++openPort <= this.getMaxPort());
        return ret;
    }

    @Override
    public void run() {
        this.serveContent();
        try {
            if (this._server != null) {
                this._server.close();
            }
            this._server = null;
            this._localPort = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int serveContent() {
        int ret = this.serveContentImpl();
        this.println(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"serveContentReturned.txt"), (Object)errorMsgs[ret]));
        return ret;
    }

    /*
     * Exception decompiling
     */
    protected int serveContentImpl() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[TRYBLOCK]], but top level block is 30[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void sendHeader(OutputStream os) throws IOException {
        StringBuffer sBuf = new StringBuffer(512);
        sBuf.append("HTTP/1.1 200 OK\r\n");
        sBuf.append("Host: localhost\r\n");
        sBuf.append("Connection: close\r\n");
        sBuf.append("Server: SAS HTTP Content Server\r\n");
        sBuf.append("Content-Type: " + this._mimeType + "\r\n");
        sBuf.append("Content-Length: " + this.getContent().length + "\r\n\r\n");
        this.println("Sending header:\n" + sBuf);
        os.write(sBuf.toString().getBytes());
        this.showStatus(RB.getStringResource((String)RB_KEY, (String)"headerSent.txt"));
    }

    protected void sendContent(OutputStream os) throws IOException {
        this.println(RB.getStringResource((String)RB_KEY, (String)"sendingContent.txt"));
        try {
            os.write(this.getContent());
            os.flush();
        }
        catch (Exception e) {
            this.printStackTrace(e);
        }
        this.println("..." + RB.getStringResource((String)RB_KEY, (String)"contentSent.txt") + ".");
        this.showStatus(RB.getStringResource((String)RB_KEY, (String)"contentSent.txt"));
    }

    private static boolean waitForEndOfRequest(InputStream is) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(is);
        int count = 0;
        while (true) {
            int c;
            if ((c = pbis.read()) == 13) {
                c = pbis.read();
                if (c == 10) {
                    if (++count != 2) continue;
                    return true;
                }
                if (c == -1) {
                    return false;
                }
                pbis.unread(c);
                continue;
            }
            if (c == -1) {
                return false;
            }
            count = 0;
        }
    }

    protected boolean pathExists(String path) {
        try {
            if (_verbose) {
                System.err.println("Path: " + path);
            }
            if (path != null) {
                if (path.length() == 0) {
                    path = null;
                } else {
                    File f = new File(path);
                    if (!f.exists() || !f.isFile()) {
                        path = null;
                    }
                }
            }
        }
        catch (Exception e) {
            path = null;
        }
        if (_verbose) {
            System.err.println("Path exists? " + (path != null));
        }
        return path != null;
    }

    public void showStatus(String status) {
        if (_isInApplet) {
            ((Applet)GlobalInfoTable.getObject()).showStatus(status);
        }
        Thread.yield();
    }

    protected void readInputStream(Socket s) {
        try {
            int nread;
            BufferedInputStream is = new BufferedInputStream(s.getInputStream());
            byte[] buf = new byte[1024];
            int r = 0;
            for (nread = 0; nread < buf.length && ((InputStream)is).available() > 0; nread += r) {
                r = ((InputStream)is).read(buf, nread, buf.length - nread);
                int i = nread;
            }
            System.out.flush();
            this.println("***** server received *****");
            this.println(new String(buf, 0, nread));
            this.println("***** end *****");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void println(String s) {
        if (!_verbose) {
            return;
        }
        if (this._printBuf == null) {
            this._printBuf = new StringBuffer(1024);
            final Frame f = new Frame();
            this._printDialog = new Dialog(f, "ContentServer2 verbose output");
            this._printDialog.setLayout(new BorderLayout());
            this._printText = new TextArea(25, 80);
            this._printDialog.add((Component)this._printText, "Center");
            this._printDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ContentServer2.this._printDialog.dispose();
                    f.dispose();
                }
            });
            this._printDialog.pack();
            this._printDialog.setVisible(true);
        }
        this._printBuf.append(s);
        this._printBuf.append("\n");
        this._printText.setText(this._printBuf.toString());
    }

    protected void printStackTrace(Throwable t) {
        if (!_verbose) {
            return;
        }
        StringWriter buf = new StringWriter();
        t.printStackTrace(new PrintWriter(buf));
        this.println(buf.toString());
    }

    static {
        errorMsgs = new String[]{RB.getStringResource((String)RB_KEY, (String)"success.txt"), RB.getStringResource((String)RB_KEY, (String)"socketError.txt"), RB.getStringResource((String)RB_KEY, (String)"serverConnectionError.txt"), RB.getStringResource((String)RB_KEY, (String)"outputStreamError.txt"), RB.getStringResource((String)RB_KEY, (String)"timedOutError.txt"), RB.getStringResource((String)RB_KEY, (String)"sendingHeaderError.txt"), RB.getStringResource((String)RB_KEY, (String)"sendingContentError.txt"), RB.getStringResource((String)RB_KEY, (String)"creatingURLError.txt"), RB.getStringResource((String)RB_KEY, (String)"writingDataToFileError.txt"), RB.getStringResource((String)RB_KEY, (String)"invokingApplicationError.txt"), RB.getStringResource((String)RB_KEY, (String)"httpRequestError.txt"), RB.getStringResource((String)RB_KEY, (String)"exportNotAllowed.txt"), RB.getStringResource((String)RB_KEY, (String)"failedToExport.txt")};
    }
}

