/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.wizard2;

import com.sas.beans.Util;
import com.sas.swing.visuals.ImageView;
import com.sas.swing.visuals.wizard.WizardPageInterface;
import com.sas.swing.visuals.wizard2.BackAction;
import com.sas.swing.visuals.wizard2.ButtonNavigationPanel;
import com.sas.swing.visuals.wizard2.CancelAction;
import com.sas.swing.visuals.wizard2.FinishAction;
import com.sas.swing.visuals.wizard2.HelpAction;
import com.sas.swing.visuals.wizard2.Next_FinishAction;
import com.sas.swing.visuals.wizard2.RB;
import com.sas.swing.visuals.wizard2.WizardDialog;
import com.sas.swing.visuals.wizard2.WizardImageView;
import com.sas.swing.visuals.wizard2.WizardPageDeck;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.SASIcons;
import java.awt.Color;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class Wizard
extends JPanel
implements PropertyChangeListener {
    public static final String RB_KEY = "Wizard.";
    protected BackAction backAction = new BackAction(this);
    protected FinishAction finishAction = new FinishAction(this);
    protected Next_FinishAction next_finishAction = new Next_FinishAction(this);
    protected CancelAction cancelAction = new CancelAction(this);
    protected HelpAction helpAction = new HelpAction(this);
    protected boolean closeWindowOnCancel = true;
    protected boolean promptOnClose = true;
    public static final int CREATE_WHEN_SHOWN = 1;
    public static final int CREATE_IN_ADVANCE = 2;
    protected int whenToCreatePage;
    protected ImageView imageView;
    protected String currentImageSource;
    protected String defaultImage;
    protected String wizardName;
    protected WizardPageDeck deck;
    protected ButtonNavigationPanel buttonPanel;
    protected String titleFormatString;
    protected JPanel statusImagePanel;
    protected JPanel deckAndImagePanel;
    protected boolean wasCancelled;

    public Wizard() {
        this(null, 2);
    }

    public Wizard(String wizardName) {
        this(wizardName, 2);
    }

    public Wizard(String wizardName, int whenToCreate) {
        String escKey = this.getClass().getName() + "CLOSE_ON_ESC";
        this.getActionMap().put(escKey, this.getEscAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), escKey);
        this.whenToCreatePage = whenToCreate;
        this.setDefaultImage("res/WizardImage.gif");
        this.createVisuals();
        this.setImage(this.getDefaultImage());
        this.setWizardName(wizardName);
        this.setTitleFormatString(RB.getStringResource(RB_KEY, "titleFormatString.txt"));
        Util.addPropertyChangeListener((Object)this.deck, (PropertyChangeListener)this);
    }

    public Next_FinishAction getNext_FinishAction() {
        return this.next_finishAction;
    }

    public CancelAction getCancelAction() {
        return this.cancelAction;
    }

    public HelpAction getHelpAction() {
        return this.helpAction;
    }

    public FinishAction getFinishAction() {
        return this.finishAction;
    }

    public BackAction getBackAction() {
        return this.backAction;
    }

    public void createLayout() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(3, 1);
        layout.setVgap(5);
        layout.setFillCell(true);
        layout.setUseColumnRemainder(true);
        layout.setUseRowRemainder(true);
        layout.setRemainderRow(1);
        this.setLayout(layout);
    }

    public void createVisuals() {
        this.createLayout();
        this.statusImagePanel = this.createStatusImagePanel();
        this.imageView = this.createWizardImageView();
        this.statusImagePanel.add(this.imageView);
        this.deck = this.createWizardPageDeck();
        this.deckAndImagePanel = new JPanel();
        AutoSizingGridLayout deckAndImagePanelLayout = new AutoSizingGridLayout(1, 0);
        deckAndImagePanelLayout.setFillCell(true);
        deckAndImagePanelLayout.setUseColumnRemainder(true);
        deckAndImagePanelLayout.setUseRowRemainder(true);
        this.deckAndImagePanel.setLayout(deckAndImagePanelLayout);
        this.deckAndImagePanel.add(this.statusImagePanel);
        this.deckAndImagePanel.add(this.deck);
        this.add(this.deckAndImagePanel);
        this.add(this.createSeparator());
        this.buttonPanel = this.createButtonPanel();
        this.add(this.buttonPanel);
    }

    public void setTitleFormatString(String titleFormat) {
        String oldTitleFormatString = this.titleFormatString;
        if (oldTitleFormatString == null || !oldTitleFormatString.equals(titleFormat)) {
            this.titleFormatString = titleFormat;
            this.firePropertyChange("titleFormatString", oldTitleFormatString, this.titleFormatString);
            this.firePropertyChange("title", null, this.getTitle());
        }
    }

    public String getTitleFormatString() {
        return this.titleFormatString;
    }

    public void setWizardName(String name) {
        String oldName = this.wizardName;
        if (oldName == null || !oldName.equals(name)) {
            this.wizardName = name;
            this.firePropertyChange("wizardName", oldName, this.wizardName);
            this.firePropertyChange("title", null, this.getTitle());
        }
    }

    public String getWizardName() {
        return this.wizardName;
    }

    public void addPage(String pageName, WizardPageInterface page) {
        this.deck.addPage(pageName, page);
        this.deck.addToPath(new String[]{pageName});
        String[] path = this.getPath();
        if (path.length == 1) {
            this.showPage(pageName);
        } else {
            this.buttonPanel.enableButtons();
        }
    }

    public void addPage(String pageName) {
        if (this.whenToCreatePage == 2) {
            this.addPage(pageName, this.createNamedPage(pageName));
        } else {
            this.addPage(pageName, null);
        }
    }

    public void addPages(String[] pageNames) {
        for (int i = 0; i < pageNames.length; ++i) {
            this.addPage(pageNames[i]);
        }
    }

    public void removePage(String pageName) {
        this.deck.removePage(pageName);
    }

    public WizardPageInterface createNamedPage(String pageName) {
        throw new IllegalStateException(RB.getStringResource(RB_KEY, "createNamedPage.ex.txt"));
    }

    public void setPath(String[] pageNames) {
        this.deck.clearPath();
        this.deck.addToPath(pageNames);
        String firstPage = this.deck.getFirstPageName();
        if (firstPage != null) {
            this.showPage(firstPage);
            this.buttonPanel.enableButtons();
        }
        this.firePropertyChange("title", null, this.getTitle());
    }

    public void appendPath(String[] pageNames) {
        this.deck.appendPath(pageNames);
    }

    public String[] getPath() {
        return this.deck.getPath();
    }

    public void handleButtonCommand(String actionCommand) {
        if (actionCommand.equals("Help")) {
            this.help();
        } else if (actionCommand.equals("Cancel")) {
            if (this.closeWindowOnCancel) {
                this.closeWindow();
            }
            this.cancel();
        } else if (actionCommand.equals("Next/Finish")) {
            this.finish();
        }
    }

    public void enableButtons() {
        this.buttonPanel.enableButtons();
    }

    public void help() {
    }

    public void cancel() {
        this.wasCancelled = true;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public int displayCancelPrompt() {
        String message = RB.getStringResource(RB_KEY, "cancelQuestion.txt");
        String title = RB.getStringResource(RB_KEY, "cancelMessageTitle.txt");
        int result = JOptionPane.showConfirmDialog(this, message, title, 0, 2);
        return result;
    }

    public void closeWindow() {
        Container c;
        for (c = this.getParent(); !(c instanceof Window) && c != null; c = c.getParent()) {
        }
        if (c instanceof Window) {
            ((Window)c).dispose();
        }
    }

    public Action getEscAction() {
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Wizard.this.doWindowClosingAction();
            }
        };
        return escAction;
    }

    public void doWindowClosingAction() {
        int result;
        if (!this.getPromptOnClose() && !this.getCloseWindowOnCancel()) {
            this.cancel();
        } else if (this.getCloseWindowOnCancel() && !this.getPromptOnClose()) {
            this.closeWindow();
            this.cancel();
        } else if (this.getPromptOnClose() && (result = this.displayCancelPrompt()) == 0) {
            if (this.closeWindowOnCancel) {
                this.closeWindow();
            }
            this.cancel();
        }
    }

    public void finish() {
        this.wasCancelled = false;
    }

    protected void cleanup() {
        WizardPageInterface[] pages = this.deck.getPages();
        for (int i = 0; i < pages.length; ++i) {
            if (pages[i] == null) continue;
            pages[i].cleanup();
        }
    }

    public void showPage(String pageName) {
        this.deck.showPage(pageName, 8);
    }

    public String getPageName(WizardPageInterface page) {
        return this.deck.getPageName(page);
    }

    public WizardPageInterface getPage(String pageName) {
        return this.deck.getPage(pageName);
    }

    public String getCurrentPageName() {
        return this.deck.getCurrentPageName();
    }

    public String getTitle() {
        if (this.getCurrentPageName() != null) {
            WizardPageInterface currentPage = this.getPage(this.getCurrentPageName());
            String title = Message.format((String)this.getTitleFormatString(), (Object)this.getWizardName(), (Object)new Integer(this.deck.getCurrentPageNumber()), (Object)new Integer(this.deck.getPageCount()), (Object)currentPage.getPageInfo());
            return title;
        }
        return null;
    }

    public String getDefaultImage() {
        return this.defaultImage;
    }

    public void setDefaultImage(String imageSource) {
        this.defaultImage = imageSource;
    }

    public String getCurrentImageSource() {
        return this.currentImageSource;
    }

    public void setImage(String imageSource) {
        this.statusImagePanel.removeAll();
        if (imageSource != null) {
            if (this.currentImageSource != imageSource) {
                this.currentImageSource = imageSource;
                this.imageView.setSource(this.currentImageSource);
            }
            this.statusImagePanel.add(this.imageView);
        }
        this.statusImagePanel.revalidate();
        this.statusImagePanel.repaint();
    }

    public ButtonNavigationPanel createButtonPanel() {
        ButtonNavigationPanel buttonPanel = new ButtonNavigationPanel(this.deck);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        return buttonPanel;
    }

    public ButtonNavigationPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public JComponent createSeparator() {
        JSeparator separator = new JSeparator(0);
        return separator;
    }

    public WizardPageDeck createWizardPageDeck() {
        WizardPageDeck wizDeck = new WizardPageDeck(this);
        wizDeck.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return wizDeck;
    }

    public JPanel createStatusImagePanel() {
        JPanel panel = new JPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout();
        layout.setFillCell(true);
        layout.setUseRowRemainder(true);
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }

    public JPanel getStatusImagePanel() {
        return this.statusImagePanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if (pce.getSource() == this.deck && (propName.equals("currentPageNumber") || propName.equals("pageCount"))) {
            this.firePropertyChange("title", null, this.getTitle());
        }
    }

    protected ImageView createWizardImageView() {
        WizardImageView imageView = new WizardImageView();
        imageView.setRelativeSourceClass(SASIcons.class);
        imageView.setOpaque(false);
        imageView.setBackground(Color.black);
        return imageView;
    }

    public void setCloseWindowOnCancel(boolean closeAction) {
        this.closeWindowOnCancel = closeAction;
    }

    public boolean getCloseWindowOnCancel() {
        return this.closeWindowOnCancel;
    }

    public void setPromptOnClose(boolean promptAction) {
        this.promptOnClose = promptAction;
    }

    public boolean getPromptOnClose() {
        return this.promptOnClose;
    }

    public static WizardDialog getWizardDialog(JFrame frame, Wizard wizard) {
        if (frame == null) {
            frame = new JFrame();
        }
        return new WizardDialog(frame, wizard);
    }

    public static void showWizardDialog(JFrame frame, Wizard wizard) {
        WizardDialog dialog = Wizard.getWizardDialog(frame, wizard);
        dialog.pack();
        dialog.setLocationRelativeTo(frame);
        dialog.show();
    }
}

