/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.wizard2;

import com.sas.swing.visuals.util.Util;
import com.sas.swing.visuals.wizard.ButtonLayout;
import com.sas.swing.visuals.wizard.WizardPageInterface;
import com.sas.swing.visuals.wizard2.RB;
import com.sas.swing.visuals.wizard2.WizardPageDeck;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonNavigationPanel
extends JPanel
implements ActionListener {
    public static final String RB_KEY = "ButtonNavigationPanel.";
    protected WizardPageDeck deck;
    protected ButtonLayout layout;
    public static final String ACTION_COMMAND = "ActionCommand";
    public static final String NEXT_FINISH_COMMAND = "Next/Finish";
    public static final String BACK_COMMAND = "Back";
    public static final String CANCEL_COMMAND = "Cancel";
    public static final String HELP_COMMAND = "Help";
    public static final String FINISH_COMMAND = "Finish";

    public ButtonNavigationPanel(WizardPageDeck deck, String[] buttonText, String[] actionCommand, Object[] constraint) {
        this.deck = deck;
        this.createVisuals(buttonText, actionCommand, constraint);
    }

    public ButtonNavigationPanel(WizardPageDeck deck) {
        this(deck, new Action[]{deck.wizard.getBackAction(), deck.wizard.getNext_FinishAction(), deck.wizard.getCancelAction(), deck.wizard.getHelpAction()}, new Object[]{new Integer(0), new Integer(30), new Integer(10), new Integer(15)});
    }

    public ButtonNavigationPanel(WizardPageDeck deck, Action[] action, Object[] constraint) {
        this.deck = deck;
        this.createVisuals(action, constraint);
    }

    public void addButton(String buttonText, String actionCommand, Object constraint) {
        this.addButton(buttonText, actionCommand, constraint, -1);
    }

    public void addButton(String buttonText, String actionCommand, Object constraint, int index) {
        JButton button = this.createButton(buttonText, actionCommand);
        this.add(button, constraint, index);
        this.enableButtons();
    }

    public void addButton(Action a, Object constraint) {
        this.addButton(a, constraint, -1);
    }

    public void addButton(Action a, Object constraint, int index) {
        JButton button = this.createButton(a);
        this.add(button, constraint, index);
        this.enableButtons();
    }

    public void removeButton(String actionCommand) {
        JButton button = this.getButton(actionCommand);
        if (button != null) {
            button.removeActionListener(this);
            button.removeActionListener(button.getAction());
            this.remove(button);
            this.repaint();
        }
    }

    public JButton getButton(String actionCommand) {
        int ncomponents = this.getComponentCount();
        for (int i = 0; i < ncomponents; ++i) {
            JButton button = (JButton)this.getComponent(i);
            if (!button.getActionCommand().equals(actionCommand)) continue;
            return button;
        }
        return null;
    }

    protected JButton createButton(String buttonText, String actionCommand) {
        JButton button = new JButton();
        Util.configureMnemonicForButton(button, buttonText);
        button.setActionCommand(actionCommand);
        button.addActionListener(this);
        return button;
    }

    protected JButton createButton(Action action) {
        JButton button = new JButton(action);
        String actionCommand = (String)action.getValue(ACTION_COMMAND);
        if (actionCommand != null) {
            button.setActionCommand(actionCommand);
        } else {
            button.setActionCommand((String)action.getValue("Name"));
        }
        return button;
    }

    public void enableButtons() {
        String currentPageName = this.deck.getCurrentPageName();
        if (currentPageName != null) {
            WizardPageInterface currentPage = this.deck.getPage(currentPageName);
            int ncomponents = this.getComponentCount();
            for (int i = 0; i < ncomponents; ++i) {
                JButton button = (JButton)this.getComponent(i);
                Action action = button.getAction();
                if (action != null) {
                    button.setEnabled(currentPage.isButtonEnabled(button.getActionCommand()) && action.isEnabled());
                    continue;
                }
                button.setEnabled(currentPage.isButtonEnabled(button.getActionCommand()));
            }
            if (this.deck.getCurrentPageName() == this.deck.getFirstPageName()) {
                this.getButton(BACK_COMMAND).setEnabled(false);
            }
            JButton nextFinishButton = this.getButton(NEXT_FINISH_COMMAND);
            Action action = nextFinishButton.getAction();
            if (this.deck.getCurrentPageName() == this.deck.getLastPageName()) {
                boolean finish = false;
                for (int i = 0; i < this.getComponentCount(); ++i) {
                    JButton button = (JButton)this.getComponent(i);
                    if (button.getActionCommand() != FINISH_COMMAND) continue;
                    finish = true;
                    nextFinishButton.setEnabled(false);
                    break;
                }
                if (!finish) {
                    String label = RB.getStringResource(RB_KEY, "finish.txt");
                    if (action != null) {
                        Util.setLabelAndMnemonicOnAction(action, label);
                    } else {
                        Util.configureMnemonicForButton(nextFinishButton, label);
                    }
                }
            } else {
                String nextText = RB.getStringResource(RB_KEY, "next.txt");
                if (!nextFinishButton.getText().equals(nextText)) {
                    if (action != null) {
                        Util.setLabelAndMnemonicOnAction(action, nextText);
                    } else {
                        Util.configureMnemonicForButton(nextFinishButton, nextText);
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        WizardPageInterface currentPage = this.deck.getPage(this.deck.getCurrentPageName());
        if (event.getActionCommand().equals(BACK_COMMAND)) {
            boolean proceed = currentPage.hidePage(1);
            if (proceed) {
                this.deck.showPage(this.deck.getPreviousPageName(), 2);
            }
        } else if (event.getActionCommand().equals(NEXT_FINISH_COMMAND)) {
            boolean proceed = currentPage.hidePage(2);
            if (proceed) {
                if (this.deck.getCurrentPageNumber() == this.deck.getPageCount()) {
                    this.deck.wizard.handleButtonCommand(event.getActionCommand());
                } else {
                    this.deck.showPage(this.deck.getNextPageName(), 1);
                }
            }
        } else if (event.getActionCommand().equals(FINISH_COMMAND)) {
            boolean proceed = currentPage.hidePage(2);
            if (proceed) {
                this.deck.wizard.handleButtonCommand(event.getActionCommand());
            }
        } else {
            this.deck.wizard.handleButtonCommand(event.getActionCommand());
        }
    }

    public void createLayout() {
        this.layout = new ButtonLayout();
        this.layout.setJustification(2);
        this.setLayout(this.layout);
    }

    public void createVisuals(String[] buttonText, String[] actionCommand, Object[] constraint) {
        this.createLayout();
        for (int i = 0; i < buttonText.length; ++i) {
            this.addButton(buttonText[i], actionCommand[i], constraint[i]);
        }
    }

    public void createVisuals(Action[] action, Object[] constraint) {
        this.createLayout();
        for (int i = 0; i < action.length; ++i) {
            this.addButton(action[i], constraint[i]);
        }
    }
}

