/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.wizard2;

import com.sas.swing.visuals.wizard.WizardPageInterface;
import com.sas.swing.visuals.wizard2.Wizard;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public class BaseWizardPage
extends JPanel
implements WizardPageInterface {
    protected boolean isNextEnabled = true;
    protected boolean isBackEnabled = true;
    protected Wizard wizard;
    protected String pageInfo;
    protected String image;
    private Map buttonStateMap;

    public BaseWizardPage(Wizard wizard) {
        this(wizard, "");
    }

    public BaseWizardPage(Wizard wizard, String pageInfo) {
        this.wizard = wizard;
        this.setPageInfo(pageInfo);
        this.setStatusImage(wizard.getDefaultImage());
        this.buttonStateMap = new HashMap();
    }

    @Override
    public String getPageInfo() {
        return this.pageInfo;
    }

    public void setPageInfo(String description) {
        this.pageInfo = description;
    }

    @Override
    public boolean isButtonEnabled(String actionCommand) {
        if (actionCommand.equals("Next/Finish")) {
            return this.isNextEnabled;
        }
        if (actionCommand.equals("Back")) {
            return this.isBackEnabled;
        }
        if (this.buttonStateMap.containsKey(actionCommand)) {
            return (Boolean)this.buttonStateMap.get(actionCommand);
        }
        return true;
    }

    public void setButtonEnabled(String actionCommand, boolean isEnabled) {
        if (actionCommand.equals("Next/Finish")) {
            this.isNextEnabled = isEnabled;
        } else if (actionCommand.equals("Back")) {
            this.isBackEnabled = isEnabled;
        } else {
            Boolean value = isEnabled ? Boolean.TRUE : Boolean.FALSE;
            this.buttonStateMap.put(actionCommand, value);
        }
    }

    @Override
    public void showPage(int directionFlag) {
    }

    @Override
    public boolean hidePage(int directionFlag) {
        return true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getStatusImage() {
        return this.image;
    }

    public void setStatusImage(String imageSource) {
        this.image = imageSource;
    }
}

