/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.util;

import com.sas.ComponentException;
import com.sas.codepolicy.SASScope;
import com.sas.swing.Constants;
import com.sas.swing.visuals.BaseBorder;
import com.sas.swing.visuals.CompoundIcon;
import com.sas.swing.visuals.util.RB;
import com.sas.util.ApplyInterface;
import com.sas.util.Command;
import com.sas.util.CommandManager;
import com.sas.util.Strings;
import com.sas.visuals.Resources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.View;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

@SASScope(value="ALL")
public abstract class Util
implements Constants {
    public static final String RB_KEY = "Util.";
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static int LINE_SEPARATOR_LEN = LINE_SEPARATOR.length();
    public static final String VERTICAL_LINE_WIDTH_STRING = "W";
    private static String mnemonicCache = null;
    private static String stringWithoutMnemonic = null;
    private static int mnemonic = -1;
    private static int mnemonicPosition = -1;
    private static String displayLabel = null;
    static Font dialogFont = null;

    public static void setEnabledOnContainer(Container container, boolean enabled) {
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            children[i].setEnabled(enabled);
            if (!(children[i] instanceof Container)) continue;
            Util.setEnabledOnContainer((Container)children[i], enabled);
        }
    }

    @SASScope
    public static Rectangle getVirtualScreenExtent() {
        Rectangle rBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] aDevices = ge.getScreenDevices();
        for (int iDevice = 0; iDevice < aDevices.length; ++iDevice) {
            GraphicsConfiguration[] aConfigurations = aDevices[iDevice].getConfigurations();
            for (int iConfiguration = 0; iConfiguration < aConfigurations.length; ++iConfiguration) {
                rBounds = rBounds.union(aConfigurations[iConfiguration].getBounds());
            }
        }
        return rBounds;
    }

    public static void center(Window window) {
        Dimension size = window.getSize();
        Dimension screenSize = window.getToolkit().getScreenSize();
        window.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
    }

    public static void centerOver(Window window, Component component) {
        int amountOver;
        if (component == null || !component.isShowing()) {
            Util.center(window);
            return;
        }
        Point location = component.getLocationOnScreen();
        Dimension componentSize = component.getSize();
        location.x += componentSize.width / 2;
        location.y += componentSize.height / 2;
        Dimension size = window.getSize();
        int x = location.x - size.width / 2;
        int y = location.y - size.height / 2;
        Dimension screenSize = window.getToolkit().getScreenSize();
        if (x + size.width > screenSize.width && (amountOver = x + size.width - screenSize.width) > 0 && x - amountOver > 0) {
            x -= amountOver;
        }
        if (y + size.height > screenSize.height && (amountOver = y + size.height - screenSize.height) > 0 && y - amountOver > 0) {
            y -= amountOver;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    @SASScope
    public static void centerOverAndResize(Window window, Component component) {
        int amountOver;
        if (!component.isShowing()) {
            Util.center(window);
            return;
        }
        Point location = component.getLocationOnScreen();
        Dimension componentSize = component.getSize();
        location.x += componentSize.width / 2;
        location.y += componentSize.height / 2;
        Dimension size = window.getSize();
        Dimension screenSize = window.getToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(component.getGraphicsConfiguration());
        int finalWidth = screenSize.width - screenInsets.left - screenInsets.right;
        int finalHeight = screenSize.height - screenInsets.top - screenInsets.bottom;
        int x = location.x - finalWidth / 2;
        int y = location.y - finalHeight / 2;
        if (x + size.width > finalWidth && (amountOver = x + size.width - finalWidth) > 0 && x - amountOver > 0) {
            x -= amountOver;
        }
        if (y + size.height > finalHeight && (amountOver = y + size.height - finalHeight) > 0 && y - amountOver > 0) {
            y -= amountOver;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        boolean resize = false;
        int newWindowWidth = size.width;
        int newWindowHeight = size.height;
        int newX = x;
        int newY = y;
        if (size.width > finalWidth) {
            resize = true;
            newWindowWidth = finalWidth;
            newX = screenInsets.left;
        }
        if (size.height > finalHeight) {
            resize = true;
            newWindowHeight = finalHeight;
            newY = screenInsets.top;
        }
        if (resize) {
            window.setSize(new Dimension(newWindowWidth, newWindowHeight));
            window.setLocation(newX, newY);
        } else {
            window.setLocation(x, y);
        }
    }

    public static void centerOverWindow(Window window, Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        if (component == null) {
            throw new ComponentException(RB.getStringResource(RB_KEY, "illegalComponentForCenterOverWindow.txt"));
        }
        Util.centerOver(window, component);
    }

    @SASScope
    public static void alignWindow(Window window, Component component, int horizontalAlignment, int verticalAlignment) {
        int amountOver;
        if (window == null || component == null || !component.isShowing()) {
            return;
        }
        Point componentLocation = component.getLocationOnScreen();
        int x = componentLocation.x;
        int y = componentLocation.y;
        Dimension windowSize = window.getSize();
        Dimension componentSize = component.getSize();
        switch (horizontalAlignment) {
            case 4: {
                x += componentSize.width;
                break;
            }
            case 2: {
                x -= windowSize.width;
                break;
            }
            case 0: {
                x += (componentSize.width - windowSize.width) / 2;
            }
        }
        switch (verticalAlignment) {
            case 1: {
                y -= windowSize.height;
                break;
            }
            case 3: {
                y += componentSize.height;
                break;
            }
            case 0: {
                y += (componentSize.height - windowSize.height) / 2;
            }
        }
        Dimension screenSize = window.getToolkit().getScreenSize();
        if (x + windowSize.width > screenSize.width && (amountOver = x + windowSize.width - screenSize.width) > 0 && x - amountOver > 0) {
            x -= amountOver;
        }
        if (y + windowSize.height > screenSize.height && (amountOver = y + windowSize.height - screenSize.height) > 0 && y - amountOver > 0) {
            y -= amountOver;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static Font getDialogFont() {
        if (dialogFont == null) {
            dialogFont = new Font("Dialog", 0, 12);
        }
        return dialogFont;
    }

    public static void configureGroupBoxBorder(Border border, String borderTitle) {
        if (border == null) {
            return;
        }
        if (border instanceof BaseBorder) {
            ((BaseBorder)border).setStyle(3);
            ((BaseBorder)border).setLightSource(10);
            ((BaseBorder)border).setBorderWidth(2);
            ((BaseBorder)border).setTextMargin(5);
            if (borderTitle != null) {
                ((BaseBorder)border).setText(borderTitle);
            }
        } else if (border instanceof TitledBorder && borderTitle != null) {
            ((TitledBorder)border).setTitle(" " + borderTitle + " ");
        }
    }

    public static Border getGroupBoxBorder(String title, int top, int left, int bottom, int right) {
        return BorderFactory.createCompoundBorder(Util.getGroupBoxBorder(title), BorderFactory.createEmptyBorder(top, left, bottom, right));
    }

    public static Border getGroupBoxBorder(String title) {
        if (title != null) {
            return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), " " + title + " ");
        }
        return BorderFactory.createEtchedBorder(1);
    }

    public static JFrame getParentFrame(Component comp) {
        JFrame parentFrame = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof JFrame) {
                parentFrame = (JFrame)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentFrame;
    }

    public static Frame getParentAWTFrame(Component comp) {
        Frame parentFrame = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Frame) {
                parentFrame = (Frame)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentFrame;
    }

    public static Container getParent(Component comp, Class containerClass) {
        Container parentContainer = null;
        Component parent = comp;
        while (parent != null) {
            if (containerClass.isAssignableFrom(parent.getClass())) {
                parentContainer = (Container)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentContainer;
    }

    public static Object getDefaultModel(Object comp) {
        if (comp instanceof JList) {
            return new DefaultListModel();
        }
        if (comp instanceof JComboBox) {
            return new DefaultComboBoxModel();
        }
        if (comp instanceof JTree) {
            return new DefaultTreeModel(new DefaultMutableTreeNode("JTree"));
        }
        if (comp instanceof JTable) {
            return new DefaultTableModel(6, 5);
        }
        if (comp instanceof JButton) {
            return new DefaultButtonModel();
        }
        if (comp instanceof JCheckBox || comp instanceof JToggleButton || comp instanceof JRadioButton) {
            return new JToggleButton.ToggleButtonModel();
        }
        if (comp instanceof JSlider || comp instanceof JScrollBar || comp instanceof JProgressBar) {
            return new DefaultBoundedRangeModel();
        }
        if (comp instanceof JTabbedPane) {
            return new DefaultSingleSelectionModel();
        }
        return null;
    }

    public static void addCommand(JMenu menu, Command command, Object object) {
        CommandManager.addCommand(menu, command, object);
    }

    public static void addCommand(JMenu menu, Command command) {
        Util.addCommand(menu, command, null);
    }

    public static void addCommands(JMenu menu, Command[] commands) {
        Util.addCommands(menu, commands, null);
    }

    public static void addCommands(JMenu menu, Command[] commands, Object object) {
        CommandManager.addCommands(menu, commands, object);
    }

    public static void addCommand(JPopupMenu menu, Command command, Object object) {
        CommandManager.addCommand(menu, command, object);
    }

    public static void addCommand(JPopupMenu menu, Command command) {
        Util.addCommand(menu, command, null);
    }

    public static void addCommands(JPopupMenu menu, Command[] commands) {
        Util.addCommands(menu, commands, null);
    }

    public static void addCommands(JPopupMenu menu, Command[] commands, Object object) {
        CommandManager.addCommands(menu, commands, object);
    }

    public static String[] breakupLines(String text) {
        return Util.breakupLines(text, true);
    }

    @SASScope
    public static String[] breakupLines(String text, boolean replaceTab) {
        return Util.breakupLines(text, replaceTab, true);
    }

    @SASScope
    public static String[] breakupLines(String text, boolean replaceTab, boolean replaceNewline) {
        int len;
        if (replaceNewline) {
            text = Strings.replace((String)text, (int)0, (int)-1, (String)"\\n", (String)"\n");
            text = Strings.replace((String)text, (int)0, (int)-1, (String)"\\r", (String)"\r");
        }
        if (replaceTab) {
            text = Strings.replace((String)text, (int)0, (int)-1, (String)"\\t", (String)"\t");
        }
        if ((len = text.length()) == 0) {
            return new String[]{""};
        }
        Vector<String> data = new Vector<String>(10);
        int start = 0;
        int i = 0;
        while (i < len) {
            if (text.startsWith(LINE_SEPARATOR, i)) {
                data.addElement(text.substring(start, i));
                i = start = i + LINE_SEPARATOR_LEN;
                continue;
            }
            if (text.charAt(i) == '\n') {
                data.addElement(text.substring(start, i));
                i = start = i + 1;
                continue;
            }
            ++i;
        }
        if (start != len) {
            data.addElement(text.substring(start));
        }
        int numlines = data.size();
        Object[] lines = new String[numlines];
        data.copyInto(lines);
        return lines;
    }

    public static String getClippedText(String text, FontMetrics fm, int availTextWidth) {
        int nChars;
        String clipString = "...";
        int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
        for (nChars = 0; nChars < text.length() && (totalWidth += fm.charWidth(text.charAt(nChars))) <= availTextWidth; ++nChars) {
        }
        return text.substring(0, nChars) + clipString;
    }

    public static boolean drawString(Graphics g, String text, int underlinedChar, int x, int y) {
        int index = -1;
        if (underlinedChar != 0) {
            char uc = Character.toUpperCase((char)underlinedChar);
            char lc = Character.toLowerCase((char)underlinedChar);
            int uci = text.indexOf(uc);
            int lci = text.indexOf(lc);
            index = uci == -1 ? lci : (lci == -1 ? uci : (lci < uci ? lci : uci));
        }
        g.drawString(text, x, y);
        if (index != -1) {
            FontMetrics fm = g.getFontMetrics();
            int underlineRectX = x + fm.stringWidth(text.substring(0, index));
            int underlineRectY = y;
            int underlineRectWidth = fm.charWidth(text.charAt(index));
            int underlineRectHeight = 1;
            g.fillRect(underlineRectX, underlineRectY + fm.getDescent() - 1, underlineRectWidth, underlineRectHeight);
        }
        return index != -1;
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap, int orientation, boolean lineWrap, boolean wrapStyleWord, int gapBetweenLines, boolean clipIt, int tabSize, int leadingContentOffset, int topContentOffset) {
        return Util.layoutCompoundLabel(c, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap, orientation, lineWrap, wrapStyleWord, gapBetweenLines, clipIt, tabSize, leadingContentOffset, topContentOffset, true);
    }

    @SASScope
    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap, int orientation, boolean lineWrap, boolean wrapStyleWord, int gapBetweenLines, boolean clipIt, int tabSize, int leadingContentOffset, int topContentOffset, boolean replaceTab) {
        return Util.layoutCompoundLabel(c, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap, orientation, lineWrap, wrapStyleWord, gapBetweenLines, clipIt, tabSize, leadingContentOffset, topContentOffset, replaceTab, true);
    }

    @SASScope
    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap, int orientation, boolean lineWrap, boolean wrapStyleWord, int gapBetweenLines, boolean clipIt, int tabSize, int leadingContentOffset, int topContentOffset, boolean replaceTab, boolean replaceNewline) {
        int gap;
        int w;
        int i;
        int textHeight = fm.getHeight();
        boolean orientationIsLeftToRight = true;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                horizontalAlignment = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                horizontalAlignment = orientationIsLeftToRight ? 4 : 2;
                break;
            }
            case 12: {
                horizontalAlignment = orientationIsLeftToRight ? 7 : 8;
                break;
            }
            case 13: {
                horizontalAlignment = orientationIsLeftToRight ? 8 : 7;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                horizontalTextPosition = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                horizontalTextPosition = orientationIsLeftToRight ? 4 : 2;
                break;
            }
            case 12: {
                horizontalTextPosition = orientationIsLeftToRight ? 7 : 8;
                break;
            }
            case 13: {
                int n = horizontalTextPosition = orientationIsLeftToRight ? 8 : 7;
            }
        }
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        StringBuffer tabBuffer = new StringBuffer(tabSize);
        for (int i2 = 0; i2 < tabSize; ++i2) {
            tabBuffer.append(' ');
        }
        text = Strings.replace((String)text, (int)0, (int)-1, (String)"\t", (String)tabBuffer.toString());
        if (replaceTab) {
            text = Strings.replace((String)text, (int)0, (int)-1, (String)"\\t", (String)tabBuffer.toString());
        }
        String[] lines = Util.breakupLines(text, replaceTab, replaceNewline);
        int numLines = lines.length;
        String maxLine = "";
        int maxWidth = 0;
        int maxHeight = 0;
        if (orientation == 0) {
            for (i = 0; i < numLines; ++i) {
                w = fm.stringWidth(lines[i]);
                if (w <= maxWidth) continue;
                maxLine = lines[i];
                maxWidth = w;
            }
        } else {
            for (i = 0; i < numLines; ++i) {
                w = lines[i].length() * textHeight;
                if (w <= maxHeight) continue;
                maxLine = lines[i];
                maxHeight = w;
            }
        }
        boolean textIsEmpty = text == null || text.equals("");
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
        } else {
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.width = (int)v.getPreferredSpan(0);
                textR.height = (int)v.getPreferredSpan(1);
            } else if (orientation == 0) {
                textR.width = SwingUtilities.computeStringWidth(fm, maxLine);
                textR.height = numLines * textHeight + gapBetweenLines * (numLines - 1);
            } else {
                textR.height = maxHeight;
                textR.width = numLines * SwingUtilities.computeStringWidth(fm, VERTICAL_LINE_WIDTH_STRING) + gapBetweenLines * (numLines - 1);
            }
        }
        int n = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        if (!textIsEmpty) {
            int i3;
            int availTextWidth = horizontalTextPosition == 0 || horizontalTextPosition == 7 || horizontalTextPosition == 8 ? viewR.width - leadingContentOffset : viewR.width - (iconR.width + gap) - leadingContentOffset;
            int availTextHeight = verticalTextPosition == 0 || verticalTextPosition == 5 || verticalTextPosition == 6 || horizontalTextPosition == 2 || horizontalTextPosition == 4 ? viewR.height - topContentOffset : viewR.height - (iconR.height + gap) - topContentOffset;
            if (orientation == 0) {
                int w2;
                if (lineWrap && textR.width > availTextWidth) {
                    if (v != null) {
                        textR.width = availTextWidth;
                    } else {
                        lines = Util.getWrappedText(availTextWidth, lines, fm, wrapStyleWord, orientation);
                        numLines = lines.length;
                        maxWidth = 0;
                        for (i3 = 0; i3 < numLines; ++i3) {
                            w2 = fm.stringWidth(lines[i3]);
                            if (w2 <= maxWidth) continue;
                            maxLine = lines[i3];
                            maxWidth = w2;
                        }
                        textR.height = numLines * textHeight + gapBetweenLines * (numLines - 1);
                        textR.width = SwingUtilities.computeStringWidth(fm, maxLine);
                    }
                }
                if (clipIt && textR.width > availTextWidth) {
                    if (v != null) {
                        textR.width = availTextWidth;
                    } else {
                        maxLine = "";
                        maxWidth = 0;
                        for (i3 = 0; i3 < numLines; ++i3) {
                            w2 = fm.stringWidth(lines[i3]);
                            if (w2 <= availTextWidth) continue;
                            lines[i3] = Util.getClippedText(lines[i3], fm, availTextWidth);
                            int ww = fm.stringWidth(lines[i3]);
                            if (ww <= maxWidth) continue;
                            maxLine = lines[i3];
                            maxWidth = ww;
                        }
                        textR.width = SwingUtilities.computeStringWidth(fm, maxLine);
                    }
                }
                if (clipIt && textR.height > availTextHeight) {
                    if (v != null) {
                        textR.height = availTextHeight;
                    } else {
                        int numLinesAvailable = (availTextHeight + gapBetweenLines) / (textHeight + gapBetweenLines);
                        if (numLinesAvailable < 1) {
                            numLinesAvailable = 1;
                        }
                        if (numLinesAvailable < numLines) {
                            lines[numLinesAvailable - 1] = Util.getClippedText(lines[numLinesAvailable - 1], fm, availTextWidth);
                            String[] tempLines = new String[numLinesAvailable];
                            System.arraycopy(lines, 0, tempLines, 0, numLinesAvailable);
                            lines = tempLines;
                            numLines = numLinesAvailable;
                            textR.height = numLines * textHeight + gapBetweenLines * (numLines - 1);
                            maxLine = "";
                            maxWidth = 0;
                            for (int i4 = 0; i4 < numLines; ++i4) {
                                int w3 = fm.stringWidth(lines[i4]);
                                if (w3 <= maxWidth) continue;
                                maxLine = lines[i4];
                                maxWidth = w3;
                            }
                            textR.width = SwingUtilities.computeStringWidth(fm, maxLine);
                        }
                    }
                }
            } else if (lineWrap && textR.height > availTextHeight) {
                if (v != null) {
                    textR.height = availTextHeight;
                } else {
                    lines = Util.getWrappedText(availTextHeight, lines, fm, wrapStyleWord, orientation);
                    numLines = lines.length;
                    maxHeight = 0;
                    for (i3 = 0; i3 < numLines; ++i3) {
                        int w4 = lines[i3].length() * textHeight;
                        if (w4 <= maxHeight) continue;
                        maxLine = lines[i3];
                        maxHeight = w4;
                    }
                    textR.height = maxHeight;
                    textR.width = numLines * SwingUtilities.computeStringWidth(fm, VERTICAL_LINE_WIDTH_STRING) + gapBetweenLines * (numLines - 1);
                }
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 && horizontalTextPosition != 7 && horizontalTextPosition != 8 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (verticalTextPosition == 3 ? (horizontalTextPosition != 0 && horizontalTextPosition != 7 && horizontalTextPosition != 8 ? iconR.height - textR.height : iconR.height + gap) : (verticalTextPosition == 5 ? (horizontalTextPosition != 0 && horizontalTextPosition != 7 && horizontalTextPosition != 8 ? Math.max(0, iconR.height / 2 - textR.height / 2) : Math.min(-(textR.height + gap), iconR.height / 2 - textR.height / 2)) : (horizontalTextPosition != 0 && horizontalTextPosition != 7 && horizontalTextPosition != 8 ? Math.min(iconR.height - textR.height, iconR.height / 2 - textR.height / 2) : Math.max(iconR.height + gap, iconR.height / 2 - textR.height / 2)))));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 4 ? iconR.width + gap : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : (horizontalTextPosition == 7 ? Math.max(0, iconR.width / 2 - textR.width / 2) : Math.min(iconR.width - textR.width, iconR.width / 2 - textR.width / 2))));
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : (verticalAlignment == 3 ? viewR.y + viewR.height - (labelR_y + labelR_height) : (verticalAlignment == 5 ? Math.max(viewR.y - labelR_y, viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2)) : Math.min(viewR.y + viewR.height - (labelR_y + labelR_height), viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2)))));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : (horizontalAlignment == 0 ? viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2) : (horizontalAlignment == 7 ? Math.max(viewR.x - labelR_x, viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2)) : Math.min(viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2), viewR.x + viewR.width - (labelR_x + labelR_width)))));
        dx = orientationIsLeftToRight ? (dx += leadingContentOffset) : (dx -= leadingContentOffset);
        textR.x += dx;
        textR.y += (dy += topContentOffset);
        iconR.x += dx;
        iconR.y += dy;
        text = "";
        StringBuffer sb = new StringBuffer();
        for (int i5 = 0; i5 < lines.length; ++i5) {
            sb.append(lines[i5]);
            if (i5 + 1 == lines.length) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    protected static String[] getWrappedText(int availableSize, String[] lines, FontMetrics fm, boolean wordWrap, int orientation) {
        Vector<String> data = new Vector<String>(10);
        int len = 0;
        int fontHeight = fm.getHeight();
        int numLines = lines.length;
        for (int i = 0; i < numLines; ++i) {
            len = orientation == 0 ? SwingUtilities.computeStringWidth(fm, lines[i]) : fontHeight * lines[i].length();
            if (len > availableSize) {
                int nChars;
                int lineSize = 0;
                int whiteLoc = -1;
                int nonWhiteLoc = -1;
                boolean prevWhite = false;
                for (nChars = 0; nChars < lines[i].length(); ++nChars) {
                    char ch = lines[i].charAt(nChars);
                    lineSize = orientation == 0 ? (lineSize += fm.charWidth(ch)) : (lineSize += fontHeight);
                    if (Character.isWhitespace(ch)) {
                        whiteLoc = nChars;
                        if (!prevWhite) {
                            nonWhiteLoc = nChars - 1;
                            prevWhite = true;
                        }
                    } else {
                        prevWhite = false;
                    }
                    if (lineSize > availableSize) break;
                }
                if (!(nChars <= 0 || wordWrap && whiteLoc != -1 && nonWhiteLoc != -1)) {
                    data.addElement(lines[i].substring(0, nChars));
                    lines[i] = lines[i].substring(nChars);
                    --i;
                    continue;
                }
                if (nChars > 0) {
                    if (whiteLoc == -1 || nonWhiteLoc == -1) continue;
                    data.addElement(lines[i].substring(0, nonWhiteLoc + 1));
                    lines[i] = lines[i].substring(whiteLoc + 1);
                    --i;
                    continue;
                }
                data.addElement(lines[i]);
                continue;
            }
            data.addElement(lines[i]);
        }
        int numLines2 = data.size();
        Object[] wrappedLines = new String[numLines2];
        data.copyInto(wrappedLines);
        return wrappedLines;
    }

    public static Dimension computePopupMenuSize(JPopupMenu popMenu, Component comp) {
        Dimension menuSize = popMenu.getSize();
        if (menuSize.width == 0 || menuSize.height == 0) {
            FontMetrics fm;
            Font font = popMenu.getFont();
            if (font == null) {
                font = comp.getFont();
            }
            if ((fm = comp.getFontMetrics(font)) != null) {
                MenuElement[] subElements = popMenu.getSubElements();
                int elementCount = 0;
                if (subElements != null) {
                    elementCount = subElements.length;
                }
                menuSize.height = (fm.getHeight() + 5) * elementCount;
                int maxWidth = 0;
                for (int i = 0; i < elementCount; ++i) {
                    int tmpWidth;
                    String txt;
                    if (!(subElements[i] instanceof JMenuItem) || (txt = ((JMenuItem)subElements[i]).getText()) == null || (tmpWidth = fm.stringWidth(txt)) <= maxWidth) continue;
                    maxWidth = tmpWidth;
                }
                menuSize.width = maxWidth + 5;
            }
        }
        return menuSize;
    }

    public static Point computePopupMenuLocation(int x, int y, int width, int height, Component comp) {
        Point p = new Point(0, 0);
        SwingUtilities.convertPointFromScreen(p, comp);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(comp.getGraphicsConfiguration());
        Rectangle scrBounds = new Rectangle();
        scrBounds.x = p.x + screenInsets.left;
        scrBounds.y = p.y + screenInsets.top;
        scrBounds.width = scrSize.width - screenInsets.left - screenInsets.right;
        scrBounds.height = scrSize.height - screenInsets.top - screenInsets.bottom;
        int scrMaxX = (int)scrBounds.getMaxX();
        int scrMaxY = (int)scrBounds.getMaxY();
        Rectangle popRect = new Rectangle(x, y, width, height);
        int popMaxX = (int)popRect.getMaxX();
        int popMaxY = (int)popRect.getMaxY();
        int xDiff = popMaxX - scrMaxX;
        int yDiff = popMaxY - scrMaxY;
        if (xDiff > 0 && yDiff <= 0) {
            return new Point(x - width, y);
        }
        if (yDiff > 0 && xDiff <= 0) {
            return new Point(x, y - height);
        }
        if (xDiff > 0 && yDiff > 0) {
            return new Point(x - width, y - height);
        }
        return new Point(x, y);
    }

    public static String getStringMapping(int key) {
        switch (key) {
            case 48: {
                return "VK_0";
            }
            case 49: {
                return "VK_1";
            }
            case 50: {
                return "VK_2";
            }
            case 51: {
                return "VK_3";
            }
            case 52: {
                return "VK_4";
            }
            case 53: {
                return "VK_5";
            }
            case 54: {
                return "VK_6";
            }
            case 55: {
                return "VK_7";
            }
            case 56: {
                return "VK_8";
            }
            case 57: {
                return "VK_9";
            }
            case 59: {
                return "VK_SEMICOLON";
            }
            case 61: {
                return "VK_EQUALS";
            }
            case 65: {
                return "VK_A";
            }
            case 66: {
                return "VK_B";
            }
            case 67: {
                return "VK_C";
            }
            case 68: {
                return "VK_D";
            }
            case 69: {
                return "VK_E";
            }
            case 70: {
                return "VK_F";
            }
            case 71: {
                return "VK_G";
            }
            case 72: {
                return "VK_H";
            }
            case 73: {
                return "VK_I";
            }
            case 74: {
                return "VK_J";
            }
            case 75: {
                return "VK_K";
            }
            case 76: {
                return "VK_L";
            }
            case 77: {
                return "VK_M";
            }
            case 78: {
                return "VK_N";
            }
            case 79: {
                return "VK_O";
            }
            case 80: {
                return "VK_P";
            }
            case 81: {
                return "VK_Q";
            }
            case 82: {
                return "VK_R";
            }
            case 83: {
                return "VK_S";
            }
            case 84: {
                return "VK_T";
            }
            case 85: {
                return "VK_U";
            }
            case 86: {
                return "VK_V";
            }
            case 87: {
                return "VK_W";
            }
            case 88: {
                return "VK_X";
            }
            case 89: {
                return "VK_Y";
            }
            case 90: {
                return "VK_Z";
            }
            case 91: {
                return "VK_OPEN_BRACKET";
            }
            case 92: {
                return "VK_BACK_SLASH";
            }
            case 93: {
                return "VK_CLOSE_BRACKET";
            }
            case 96: {
                return "VK_NUMPAD0";
            }
            case 97: {
                return "VK_NUMPAD1";
            }
            case 98: {
                return "VK_NUMPAD2";
            }
            case 99: {
                return "VK_NUMPAD3";
            }
            case 100: {
                return "VK_NUMPAD4";
            }
            case 101: {
                return "VK_NUMPAD5";
            }
            case 102: {
                return "VK_NUMPAD6";
            }
            case 103: {
                return "VK_NUMPAD7";
            }
            case 104: {
                return "VK_NUMPAD8";
            }
            case 105: {
                return "VK_NUMPAD9";
            }
            case 44: {
                return "VK_COMMA";
            }
            case 46: {
                return "VK_PERIOD";
            }
            case 47: {
                return "VK_SLASH";
            }
            case 10: {
                return "VK_ENTER";
            }
            case 8: {
                return "VK_BACK_SPACE";
            }
            case 9: {
                return "VK_BACK_SPACE";
            }
            case 3: {
                return "VK_CANCEL";
            }
            case 12: {
                return "VK_CLEAR";
            }
            case 16: {
                return "VK_SHIFT";
            }
            case 17: {
                return "VK_CONTROL";
            }
            case 18: {
                return "VK_ALT";
            }
            case 19: {
                return "VK_PAUSE";
            }
            case 20: {
                return "VK_CAPS_LOCK";
            }
            case 27: {
                return "VK_ESCAPE";
            }
            case 32: {
                return "VK_SPACE";
            }
            case 33: {
                return "PAGE_UP";
            }
            case 34: {
                return "VK_DOWN";
            }
            case 35: {
                return "VK_END";
            }
            case 36: {
                return "VK_HOME";
            }
            case 37: {
                return "VK_LEFT";
            }
            case 38: {
                return "VK_UP";
            }
            case 39: {
                return "VK_RIGHT";
            }
            case 40: {
                return "VK_DOWN";
            }
            case 106: {
                return "VK_MULTIPLY";
            }
            case 107: {
                return "VK_ADD";
            }
            case 108: {
                return "VK_SEPARATER";
            }
            case 109: {
                return "VK_SUBTRACT";
            }
            case 110: {
                return "VK_DECIMAL";
            }
            case 111: {
                return "VK_DIVIDE";
            }
            case 127: {
                return "VK_DELETE";
            }
            case 144: {
                return "VK_NUM_LOCK";
            }
            case 145: {
                return "VK_SCROLL_LOCK";
            }
            case 112: {
                return "VK_F1";
            }
            case 113: {
                return "VK_F2";
            }
            case 114: {
                return "VK_F3";
            }
            case 115: {
                return "VK_F4";
            }
            case 116: {
                return "VK_F5";
            }
            case 117: {
                return "VK_F6";
            }
            case 118: {
                return "VK_F7";
            }
            case 119: {
                return "VK_F8";
            }
            case 120: {
                return "VK_F9";
            }
            case 121: {
                return "VK_F10";
            }
            case 122: {
                return "VK_F11";
            }
            case 123: {
                return "VK_F12";
            }
            case 61440: {
                return "VK_F13";
            }
            case 61441: {
                return "VK_F14";
            }
            case 61442: {
                return "VK_F15";
            }
            case 61443: {
                return "VK_F16";
            }
            case 61444: {
                return "VK_F17";
            }
            case 61445: {
                return "VK_F18";
            }
            case 61446: {
                return "VK_F19";
            }
            case 61447: {
                return "VK_F20";
            }
            case 61448: {
                return "VK_F21";
            }
            case 61449: {
                return "VK_F22";
            }
            case 61450: {
                return "VK_F23";
            }
            case 61451: {
                return "VK_F24";
            }
            case 154: {
                return "VK_PRINTSCREEN";
            }
            case 155: {
                return "VK_INSERT";
            }
            case 156: {
                return "VK_HELP";
            }
            case 157: {
                return "VK_META";
            }
            case 192: {
                return "VK_BACK_QUOTE";
            }
            case 222: {
                return "VK_QUOTE";
            }
            case 224: {
                return "VK_KP_UP";
            }
            case 225: {
                return "VK_KP_DOWN";
            }
            case 226: {
                return "VK_KP_LEFT";
            }
            case 227: {
                return "VK_KP_RIGHT";
            }
            case 128: {
                return "VK_DEAD_GRAVE";
            }
            case 129: {
                return "VK_DEAD_ACUTE";
            }
            case 130: {
                return "VK_DEAD_CIRCUMFLEX";
            }
            case 131: {
                return "VK_DEAD_TILDE";
            }
            case 132: {
                return "VK_DEAD_MACRON";
            }
            case 133: {
                return "VK_DEAD_BREVE";
            }
            case 134: {
                return "VK_DEAD_ABOVEDOT";
            }
            case 135: {
                return "VK_DEAD_DIAERESIS";
            }
            case 136: {
                return "VK_DEAD_ABOVERING";
            }
            case 137: {
                return "VK_DEAD_DOUBLEACUTE";
            }
            case 138: {
                return "VK_DEAD_CARON";
            }
            case 139: {
                return "VK_DEAD_CEDILLA";
            }
            case 140: {
                return "VK_DEAD_OGONEK";
            }
            case 141: {
                return "VK_DEAD_IOTA";
            }
            case 142: {
                return "VK_DEAD_VOICED_SOUND";
            }
            case 143: {
                return "VK_DEAD_SEMIVOICED_SOUND";
            }
            case 150: {
                return "VK_AMPERSAND";
            }
            case 151: {
                return "VK_ASTERISK";
            }
            case 152: {
                return "VK_QUOTEDBL";
            }
            case 153: {
                return "VK_LESS";
            }
            case 160: {
                return "VK_GREATER";
            }
            case 161: {
                return "VK_BRACELEFT";
            }
            case 162: {
                return "VK_BRACERIGHT";
            }
            case 512: {
                return "VK_AT";
            }
            case 513: {
                return "VK_COLON";
            }
            case 514: {
                return "VK_CIRCUMFLEX";
            }
            case 515: {
                return "VK_DOLLAR";
            }
            case 516: {
                return "VK_EURO_SIGN";
            }
            case 517: {
                return "VK_EXCLAMATION_MARK";
            }
            case 518: {
                return "VK_INVERTED_EXCLAMATION_MARK";
            }
            case 519: {
                return "VK_LEFT_PARENTHESIS";
            }
            case 520: {
                return "VK_NUMBER_SIGN";
            }
            case 45: {
                return "VK_MINUS";
            }
            case 521: {
                return "VK_PLUS";
            }
            case 522: {
                return "VK_RIGHT_PARENTHESIS";
            }
            case 523: {
                return "VK_UNDERSCORE";
            }
            case 24: {
                return "VK_FINAL";
            }
            case 28: {
                return "VK_CONVERT";
            }
            case 29: {
                return "VK_NONCONVERT";
            }
            case 30: {
                return "VK_ACCEPT";
            }
            case 31: {
                return "VK_MODECHANGE";
            }
            case 21: {
                return "VK_KANA";
            }
            case 25: {
                return "VK_KANJI";
            }
            case 240: {
                return "VK_ALPHANUMERIC";
            }
            case 241: {
                return "VK_KATAKANA";
            }
            case 242: {
                return "VK_HIRAGANA";
            }
            case 243: {
                return "VK_FULL_WIDTH";
            }
            case 244: {
                return "VK_HALF_WIDTH";
            }
            case 245: {
                return "VK_ROMAN_CHARACTERS";
            }
            case 256: {
                return "VK_ALL_CANDIDATES";
            }
            case 257: {
                return "VK_PREVIOUS_CANDIDATE";
            }
            case 258: {
                return "VK_CODE_INPUT";
            }
            case 259: {
                return "VK_JAPANESE_KATAKANA";
            }
            case 260: {
                return "VK_JAPANESE_HIRAGANA";
            }
            case 261: {
                return "VK_JAPANESE_ROMAN";
            }
            case 262: {
                return "VK_KANA_LOCK";
            }
            case 263: {
                return "VK_INPUT_METHOD_ON_OFF";
            }
            case 65481: {
                return "VK_AGAIN";
            }
            case 65483: {
                return "VK_UNDO";
            }
            case 65485: {
                return "VK_COPY";
            }
            case 65487: {
                return "VK_PASTE";
            }
            case 65489: {
                return "VK_CUT";
            }
            case 65488: {
                return "VK_FIND";
            }
            case 65482: {
                return "VK_PROPS";
            }
            case 65480: {
                return "VK_STOP";
            }
            case 65312: {
                return "VK_COMPOSE";
            }
            case 65406: {
                return "VK_ALT_GRAPH";
            }
        }
        return null;
    }

    public static int getKeyMapping(String key) {
        if (key.equals("VK_0")) {
            return 48;
        }
        if (key.equals("VK_1")) {
            return 49;
        }
        if (key.equals("VK_2")) {
            return 50;
        }
        if (key.equals("VK_3")) {
            return 51;
        }
        if (key.equals("VK_4")) {
            return 52;
        }
        if (key.equals("VK_5")) {
            return 53;
        }
        if (key.equals("VK_6")) {
            return 54;
        }
        if (key.equals("VK_7")) {
            return 55;
        }
        if (key.equals("VK_8")) {
            return 56;
        }
        if (key.equals("VK_9")) {
            return 57;
        }
        if (key.equals("VK_SEMICOLON")) {
            return 59;
        }
        if (key.equals("VK_EQUALS")) {
            return 61;
        }
        if (key.equals("VK_A")) {
            return 65;
        }
        if (key.equals("VK_B")) {
            return 66;
        }
        if (key.equals("VK_C")) {
            return 67;
        }
        if (key.equals("VK_D")) {
            return 68;
        }
        if (key.equals("VK_E")) {
            return 69;
        }
        if (key.equals("VK_F")) {
            return 70;
        }
        if (key.equals("VK_G")) {
            return 71;
        }
        if (key.equals("VK_H")) {
            return 72;
        }
        if (key.equals("VK_I")) {
            return 73;
        }
        if (key.equals("VK_J")) {
            return 74;
        }
        if (key.equals("VK_K")) {
            return 75;
        }
        if (key.equals("VK_L")) {
            return 76;
        }
        if (key.equals("VK_M")) {
            return 77;
        }
        if (key.equals("VK_N")) {
            return 78;
        }
        if (key.equals("VK_O")) {
            return 79;
        }
        if (key.equals("VK_P")) {
            return 80;
        }
        if (key.equals("VK_Q")) {
            return 81;
        }
        if (key.equals("VK_R")) {
            return 82;
        }
        if (key.equals("VK_S")) {
            return 83;
        }
        if (key.equals("VK_T")) {
            return 84;
        }
        if (key.equals("VK_U")) {
            return 85;
        }
        if (key.equals("VK_V")) {
            return 86;
        }
        if (key.equals("VK_W")) {
            return 87;
        }
        if (key.equals("VK_X")) {
            return 88;
        }
        if (key.equals("VK_Y")) {
            return 89;
        }
        if (key.equals("VK_Z")) {
            return 90;
        }
        if (key.equals("VK_OPEN_BRACKET")) {
            return 91;
        }
        if (key.equals("VK_BACK_SLASH")) {
            return 92;
        }
        if (key.equals("VK_CLOSE_BRACKET")) {
            return 93;
        }
        if (key.equals("VK_NUMPAD0")) {
            return 96;
        }
        if (key.equals("VK_NUMPAD1")) {
            return 97;
        }
        if (key.equals("VK_NUMPAD2")) {
            return 98;
        }
        if (key.equals("VK_NUMPAD3")) {
            return 99;
        }
        if (key.equals("VK_NUMPAD4")) {
            return 100;
        }
        if (key.equals("VK_NUMPAD5")) {
            return 101;
        }
        if (key.equals("VK_NUMPAD6")) {
            return 102;
        }
        if (key.equals("VK_NUMPAD7")) {
            return 103;
        }
        if (key.equals("VK_NUMPAD8")) {
            return 104;
        }
        if (key.equals("VK_NUMPAD9")) {
            return 105;
        }
        if (key.equals("VK_COMMA")) {
            return 44;
        }
        if (key.equals("VK_PERIOD")) {
            return 46;
        }
        if (key.equals("VK_SLASH")) {
            return 47;
        }
        if (key.equals("VK_ENTER")) {
            return 10;
        }
        if (key.equals("VK_BACK_SPACE")) {
            return 8;
        }
        if (key.equals("VK_BACK_SPACE")) {
            return 9;
        }
        if (key.equals("VK_CANCEL")) {
            return 3;
        }
        if (key.equals("VK_CLEAR")) {
            return 12;
        }
        if (key.equals("VK_SHIFT")) {
            return 16;
        }
        if (key.equals("VK_CONTROL")) {
            return 17;
        }
        if (key.equals("VK_ALT")) {
            return 18;
        }
        if (key.equals("VK_PAUSE")) {
            return 19;
        }
        if (key.equals("VK_CAPS_LOCK")) {
            return 20;
        }
        if (key.equals("VK_ESCAPE")) {
            return 27;
        }
        if (key.equals("VK_SPACE")) {
            return 32;
        }
        if (key.equals("VK_PAGE_UP")) {
            return 33;
        }
        if (key.equals("VK_DOWN")) {
            return 34;
        }
        if (key.equals("VK_END")) {
            return 35;
        }
        if (key.equals("VK_HOME")) {
            return 36;
        }
        if (key.equals("VK_LEFT")) {
            return 37;
        }
        if (key.equals("VK_UP")) {
            return 38;
        }
        if (key.equals("VK_RIGHT")) {
            return 39;
        }
        if (key.equals("VK_DOWN")) {
            return 40;
        }
        if (key.equals("VK_MULTIPLY")) {
            return 106;
        }
        if (key.equals("VK_ADD")) {
            return 107;
        }
        if (key.equals("VK_SEPARATER")) {
            return 108;
        }
        if (key.equals("VK_SUBTRACT")) {
            return 109;
        }
        if (key.equals("VK_DECIMAL")) {
            return 110;
        }
        if (key.equals("VK_DIVIDE")) {
            return 111;
        }
        if (key.equals("VK_DELETE")) {
            return 127;
        }
        if (key.equals("VK_NUM_LOCK")) {
            return 144;
        }
        if (key.equals("VK_SCROLL_LOCK")) {
            return 145;
        }
        if (key.equals("VK_F1")) {
            return 112;
        }
        if (key.equals("VK_F2")) {
            return 113;
        }
        if (key.equals("VK_F3")) {
            return 114;
        }
        if (key.equals("VK_F4")) {
            return 115;
        }
        if (key.equals("VK_F5")) {
            return 116;
        }
        if (key.equals("VK_F6")) {
            return 117;
        }
        if (key.equals("VK_F7")) {
            return 118;
        }
        if (key.equals("VK_F8")) {
            return 119;
        }
        if (key.equals("VK_F9")) {
            return 120;
        }
        if (key.equals("VK_F10")) {
            return 121;
        }
        if (key.equals("VK_F11")) {
            return 122;
        }
        if (key.equals("VK_F12")) {
            return 123;
        }
        if (key.equals("VK_F13")) {
            return 61440;
        }
        if (key.equals("VK_F14")) {
            return 61441;
        }
        if (key.equals("VK_F15")) {
            return 61442;
        }
        if (key.equals("VK_F16")) {
            return 61443;
        }
        if (key.equals("VK_F17")) {
            return 61444;
        }
        if (key.equals("VK_F18")) {
            return 61445;
        }
        if (key.equals("VK_F19")) {
            return 61446;
        }
        if (key.equals("VK_F20")) {
            return 61447;
        }
        if (key.equals("VK_F21")) {
            return 61448;
        }
        if (key.equals("VK_F22")) {
            return 61449;
        }
        if (key.equals("VK_F23")) {
            return 61450;
        }
        if (key.equals("VK_F24")) {
            return 61451;
        }
        if (key.equals("VK_PRINTSCREEN")) {
            return 154;
        }
        if (key.equals("VK_INSERT")) {
            return 155;
        }
        if (key.equals("VK_HELP")) {
            return 156;
        }
        if (key.equals("VK_META")) {
            return 157;
        }
        if (key.equals("VK_BACK_QUOTE")) {
            return 192;
        }
        if (key.equals("VK_QUOTE")) {
            return 222;
        }
        if (key.equals("VK_KP_UP")) {
            return 224;
        }
        if (key.equals("VK_KP_DOWN")) {
            return 225;
        }
        if (key.equals("VK_KP_LEFT")) {
            return 226;
        }
        if (key.equals("VK_KP_RIGHT")) {
            return 227;
        }
        if (key.equals("VK_DEAD_GRAVE")) {
            return 128;
        }
        if (key.equals("VK_DEAD_ACUTE")) {
            return 129;
        }
        if (key.equals("VK_DEAD_CIRCUMFLEX")) {
            return 130;
        }
        if (key.equals("VK_DEAD_TILDE")) {
            return 131;
        }
        if (key.equals("VK_DEAD_MACRON")) {
            return 132;
        }
        if (key.equals("VK_DEAD_BREVE")) {
            return 133;
        }
        if (key.equals("VK_DEAD_ABOVEDOT")) {
            return 134;
        }
        if (key.equals("VK_DEAD_DIAERESIS")) {
            return 135;
        }
        if (key.equals("VK_DEAD_ABOVERING")) {
            return 136;
        }
        if (key.equals("VK_DEAD_DOUBLEACUTE")) {
            return 137;
        }
        if (key.equals("VK_DEAD_CARON")) {
            return 138;
        }
        if (key.equals("VK_DEAD_CEDILLA")) {
            return 139;
        }
        if (key.equals("VK_DEAD_OGONEK")) {
            return 140;
        }
        if (key.equals("VK_DEAD_IOTA")) {
            return 141;
        }
        if (key.equals("VK_DEAD_VOICED_SOUND")) {
            return 142;
        }
        if (key.equals("VK_DEAD_SEMIVOICED_SOUND")) {
            return 143;
        }
        if (key.equals("VK_AMPERSAND")) {
            return 150;
        }
        if (key.equals("VK_ASTERISK")) {
            return 151;
        }
        if (key.equals("VK_QUOTEDBL")) {
            return 152;
        }
        if (key.equals("VK_LESS")) {
            return 153;
        }
        if (key.equals("VK_GREATER")) {
            return 160;
        }
        if (key.equals("VK_BRACELEFT")) {
            return 161;
        }
        if (key.equals("VK_BRACERIGHT")) {
            return 162;
        }
        if (key.equals("VK_AT")) {
            return 512;
        }
        if (key.equals("VK_COLON")) {
            return 513;
        }
        if (key.equals("VK_CIRCUMFLEX")) {
            return 514;
        }
        if (key.equals("VK_DOLLAR")) {
            return 515;
        }
        if (key.equals("VK_EURO_SIGN")) {
            return 516;
        }
        if (key.equals("VK_EXCLAMATION_MARK")) {
            return 517;
        }
        if (key.equals("VK_INVERTED_EXCLAMATION_MARK")) {
            return 518;
        }
        if (key.equals("VK_LEFT_PARENTHESIS")) {
            return 519;
        }
        if (key.equals("VK_NUMBER_SIGN")) {
            return 520;
        }
        if (key.equals("VK_MINUS")) {
            return 45;
        }
        if (key.equals("VK_PLUS")) {
            return 521;
        }
        if (key.equals("VK_RIGHT_PARENTHESIS")) {
            return 522;
        }
        if (key.equals("VK_UNDERSCORE")) {
            return 523;
        }
        if (key.equals("VK_FINAL")) {
            return 24;
        }
        if (key.equals("VK_CONVERT")) {
            return 28;
        }
        if (key.equals("VK_NONCONVERT")) {
            return 29;
        }
        if (key.equals("VK_ACCEPT")) {
            return 30;
        }
        if (key.equals("VK_MODECHANGE")) {
            return 31;
        }
        if (key.equals("VK_KANA")) {
            return 21;
        }
        if (key.equals("VK_KANJI")) {
            return 25;
        }
        if (key.equals("VK_ALPHANUMERIC")) {
            return 240;
        }
        if (key.equals("VK_KATAKANA")) {
            return 241;
        }
        if (key.equals("VK_HIRAGANA")) {
            return 242;
        }
        if (key.equals("VK_FULL_WIDTH")) {
            return 243;
        }
        if (key.equals("VK_HALF_WIDTH")) {
            return 244;
        }
        if (key.equals("VK_ROMAN_CHARACTERS")) {
            return 245;
        }
        if (key.equals("VK_ALL_CANDIDATES")) {
            return 256;
        }
        if (key.equals("VK_PREVIOUS_CANDIDATE")) {
            return 257;
        }
        if (key.equals("VK_CODE_INPUT")) {
            return 258;
        }
        if (key.equals("VK_JAPANESE_KATAKANA")) {
            return 259;
        }
        if (key.equals("VK_JAPANESE_HIRAGANA")) {
            return 260;
        }
        if (key.equals("VK_JAPANESE_ROMAN")) {
            return 261;
        }
        if (key.equals("VK_KANA_LOCK")) {
            return 262;
        }
        if (key.equals("VK_INPUT_METHOD_ON_OFF")) {
            return 263;
        }
        if (key.equals("VK_AGAIN")) {
            return 65481;
        }
        if (key.equals("VK_UNDO")) {
            return 65483;
        }
        if (key.equals("VK_COPY")) {
            return 65485;
        }
        if (key.equals("VK_PASTE")) {
            return 65487;
        }
        if (key.equals("VK_CUT")) {
            return 65489;
        }
        if (key.equals("VK_FIND")) {
            return 65488;
        }
        if (key.equals("VK_PROPS")) {
            return 65482;
        }
        if (key.equals("VK_STOP")) {
            return 65480;
        }
        if (key.equals("VK_COMPOSE")) {
            return 65312;
        }
        if (key.equals("VK_ALT_GRAPH")) {
            return 65406;
        }
        return -1;
    }

    public static synchronized int getDisplayedMnemonic(String label) {
        if (mnemonicCache == null || !mnemonicCache.equals(label)) {
            Util.parseForMnemonic(label);
            mnemonicCache = label;
        }
        return mnemonic;
    }

    public static synchronized int getDisplayedMnemonicIndex(String label) {
        if (mnemonicCache == null || !mnemonicCache.equals(label)) {
            Util.parseForMnemonic(label);
            mnemonicCache = label;
        }
        return mnemonicPosition;
    }

    public static synchronized String getLabelWithoutMnemonic(String label) {
        if (mnemonicCache == null || !mnemonicCache.equals(label)) {
            Util.parseForMnemonic(label);
            mnemonicCache = label;
        }
        return stringWithoutMnemonic;
    }

    @SASScope
    public static synchronized String getDisplayLabel(String label) {
        if (mnemonicCache == null || !mnemonicCache.equals(label)) {
            Util.parseForMnemonic(label);
            mnemonicCache = label;
        }
        return displayLabel;
    }

    private static synchronized void parseForMnemonic(String label) {
        StringBuffer parsedLabel = new StringBuffer();
        mnemonic = -1;
        mnemonicPosition = -1;
        stringWithoutMnemonic = null;
        displayLabel = null;
        if (label != null) {
            boolean foundAmpersand = false;
            int len = label.length();
            for (int i = 0; i < len; ++i) {
                if ('&' == label.charAt(i)) {
                    if (foundAmpersand || i + 3 < len && "&gt;".equals(label.substring(i, i + 4)) || i + 3 < len && "&lt;".equals(label.substring(i, i + 4)) || i + 4 < len && "&amp;".equals(label.substring(i, i + 5)) || i + 5 < len && "&copy;".equals(label.substring(i, i + 6)) || i + 2 < len && "&#".equals(label.substring(i, i + 2))) {
                        parsedLabel.append(label.substring(i, i + 1));
                        foundAmpersand = false;
                        continue;
                    }
                    foundAmpersand = true;
                    continue;
                }
                if (foundAmpersand) {
                    String mnemonicString = label.substring(i, i + 1);
                    parsedLabel.append(mnemonicString);
                    if (mnemonic == -1) {
                        mnemonic = Util.getKeyMapping("VK_" + mnemonicString.toUpperCase());
                    }
                    if (mnemonicPosition == -1) {
                        mnemonicPosition = parsedLabel.length() - 1;
                    }
                } else {
                    parsedLabel.append(label.substring(i, i + 1));
                }
                foundAmpersand = false;
            }
        }
        displayLabel = stringWithoutMnemonic = parsedLabel.toString();
        int leftIndex = mnemonicPosition - 1;
        int rightIndex = mnemonicPosition + 1;
        if (leftIndex >= 0 && '(' == parsedLabel.charAt(leftIndex) && ')' == parsedLabel.charAt(rightIndex)) {
            parsedLabel.delete(leftIndex, rightIndex + 1);
            displayLabel = parsedLabel.toString();
        }
    }

    public static void configureMnemonicForLabel(JLabel label, String text) {
        String s = Util.getLabelWithoutMnemonic(text);
        label.setText(s);
        int index = Util.getDisplayedMnemonicIndex(text);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic(text);
            label.setDisplayedMnemonic(mnemonic);
            label.setDisplayedMnemonicIndex(index);
        }
    }

    public static void configureMnemonicForButton(AbstractButton button, String text) {
        String s = Util.getLabelWithoutMnemonic(text);
        button.setText(s);
        int index = Util.getDisplayedMnemonicIndex(text);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic(text);
            button.setMnemonic(mnemonic);
            button.setDisplayedMnemonicIndex(index);
        }
    }

    public static void setLabelAndMnemonicOnAction(Action action, String text) {
        String label = Util.getLabelWithoutMnemonic(text);
        int index = Util.getDisplayedMnemonicIndex(text);
        action.putValue("Name", label);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic(text);
            action.putValue("MnemonicKey", new Integer(mnemonic));
            action.putValue("MnemonicIndex", new Integer(index));
        }
    }

    public static JLabel createLabelForComponent(Component component, String text) {
        JLabel label = new JLabel();
        Util.configureMnemonicForLabel(label, text);
        label.setLabelFor(component);
        return label;
    }

    public static Image convertIconToImage(Component component, Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        if (icon != null) {
            Image image = component.createImage(icon.getIconWidth(), icon.getIconHeight());
            Graphics g = image.getGraphics();
            icon.paintIcon(component, g, 0, 0);
            return image;
        }
        return null;
    }

    public static void apply(Component rootComponent, ApplyInterface operation) {
        Util.applyImpl(rootComponent, operation);
    }

    private static int applyImpl(Component rootComponent, ApplyInterface operation) {
        int rc = operation.apply((Object)rootComponent);
        if (rootComponent instanceof Container && rc == 0) {
            Container container = (Container)rootComponent;
            Component[] components = container.getComponents();
            int iCount = components.length;
            for (int i = 0; i < iCount && (rc = Util.applyImpl(components[i], operation)) == 0; ++i) {
            }
        }
        return rc;
    }

    public static void invertRect(Graphics g, int x, int y, int width, int height) {
        g.setColor(Color.white);
        g.setXORMode(Color.black);
        g.fillRect(x, y, width, height);
        g.setPaintMode();
    }

    public static void invertRect(Graphics g, Rectangle rect) {
        Util.invertRect(g, rect.x, rect.y, rect.width, rect.height);
    }

    public static final void drawFocusRect(Graphics g, int x, int y, int width, int height) {
        Util.drawFocusRect(g, x, y, width, height, true);
    }

    public static final void drawFocusRect(Graphics g, int x, int y, int width, int height, boolean useXOR) {
        int i;
        g.setColor(Color.black);
        if (useXOR) {
            g.setXORMode(Color.white);
        }
        for (i = 0; i < width; i += 2) {
            g.drawLine(x + i, y, x + i, y);
            g.drawLine(x + i, y + height - 1, x + i, y + height - 1);
        }
        for (i = 0; i < height; i += 2) {
            g.drawLine(x, y + i, x, y + i);
            g.drawLine(x + width - 1, y + i, x + width - 1, y + i);
        }
        if (useXOR) {
            g.setPaintMode();
        }
    }

    @SASScope
    public static Icon getNewIcon(Icon icon) {
        CompoundIcon newIcon = null;
        if (icon != null) {
            int width = icon.getIconWidth();
            CompoundIcon compoundIcon = new CompoundIcon(new Icon[]{icon, Resources.getImageIcon((String)"New_overlay.gif", (int)16)});
            compoundIcon.setIconGap(-width);
            newIcon = compoundIcon;
        }
        return newIcon;
    }

    @SASScope
    public static Icon getNewIcon(String name, int size) {
        CompoundIcon newIcon = null;
        if (name != null) {
            CompoundIcon compoundIcon = new CompoundIcon(new Icon[]{Resources.getImageIcon((String)name, (int)size), Resources.getImageIcon((String)"New_overlay.gif", (int)16)});
            compoundIcon.setIconGap(-size);
            newIcon = compoundIcon;
        }
        return newIcon;
    }

    @SASScope
    public static Icon getCompoundIcon(Icon icon, Icon icon2) {
        CompoundIcon newIcon = null;
        if (icon != null) {
            int width = icon.getIconWidth();
            CompoundIcon compoundIcon = new CompoundIcon(new Icon[]{icon, icon2});
            compoundIcon.setIconGap(-width);
            newIcon = compoundIcon;
        }
        return newIcon;
    }
}

