/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.util;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class FlatButtons
implements MouseListener,
ItemListener {
    private static final FlatButtons INSTANCE = new FlatButtons();
    AbstractButton _buttonToTrack;

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        Object source = event.getSource();
        if (source instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)source;
            if (button.isEnabled()) {
                button.setBorderPainted(true);
            }
            this._buttonToTrack = null;
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        Object source = event.getSource();
        if (source instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)source;
            if (!button.isSelected()) {
                button.setBorderPainted(false);
            } else {
                this._buttonToTrack = button;
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 2 && this._buttonToTrack != null && this._buttonToTrack == event.getSource()) {
            this._buttonToTrack.setBorderPainted(false);
            this._buttonToTrack = null;
        }
    }

    public static void listenToButtons(JComponent component) {
        int componentCount;
        if (component instanceof AbstractButton) {
            FlatButtons.listenToButton((AbstractButton)component);
        }
        if ((componentCount = component.getComponentCount()) > 0) {
            for (int i = 0; i < componentCount; ++i) {
                Component comp = component.getComponent(i);
                if (comp instanceof JComponent) {
                    FlatButtons.listenToButtons((JComponent)comp);
                    continue;
                }
                if (!(comp instanceof AbstractButton)) continue;
                FlatButtons.listenToButton((AbstractButton)comp);
            }
        }
    }

    public static void listenToButton(AbstractButton button) {
        if (button instanceof JCheckBox || button instanceof JRadioButton) {
            return;
        }
        button.addItemListener(INSTANCE);
        button.addMouseListener(INSTANCE);
        if (!button.isSelected()) {
            button.setBorderPainted(false);
        }
    }
}

