/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.util;

import com.sas.util.ApplyInterface;
import com.sas.util.Command;
import com.sas.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Stack;

public class ChangeCursorCommand
implements Command,
ApplyInterface {
    private Cursor _cursor;
    private Stack _stack;

    public ChangeCursorCommand(Cursor cursor) {
        this._cursor = cursor;
    }

    public Object clone() throws CloneNotSupportedException {
        ChangeCursorCommand clone = new ChangeCursorCommand(this.getCursor());
        if (this._stack != null) {
            clone._stack = (Stack)this._stack.clone();
        }
        return clone;
    }

    public Cursor getCursor() {
        return this._cursor;
    }

    public boolean isExecutable() {
        return true;
    }

    public void execute(Object obj) {
        Cursor cursor;
        Component component = (Component)obj;
        Cursor componentCursor = component.getCursor();
        if (Util.equal((Object)componentCursor, (Object)(cursor = this.getCursor()))) {
            return;
        }
        if (this._stack == null) {
            this._stack = new Stack();
        }
        this._stack.push(component);
        this._stack.push(componentCursor);
        component.setCursor(cursor);
    }

    public int apply(Object obj) {
        this.execute(obj);
        return 0;
    }

    public boolean isUndoable() {
        return true;
    }

    public void undo() {
        if (this._stack != null && !this._stack.empty()) {
            Cursor cursor = (Cursor)this._stack.pop();
            Component component = (Component)this._stack.pop();
            component.setCursor(cursor);
        }
    }

    public void undoAll() {
        if (this._stack != null) {
            while (!this._stack.empty()) {
                this.undo();
            }
        }
    }

    public String getText() {
        return "";
    }

    public void setText(String text) {
    }
}

