/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treetable;

import com.sas.swing.visuals.treetable.TreeTable;
import com.sas.swing.visuals.treetable.TreeTableModel;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class TreeTableRow
extends DefaultMutableTreeNode {
    Object[] tableRow;
    String[] linkCommands;
    TreeTableModel model;
    boolean expanded = false;
    boolean editable = true;
    int height;
    Icon openIcon;
    Icon closedIcon;
    Icon leafIcon;
    Icon genericIcon;
    private Color background;
    private Color foreground;

    public TreeTableRow(Object[] row) {
        super(row[0]);
        this.tableRow = row;
        this.model = null;
        this.height = 0;
    }

    public TreeTableRow(TreeTableRow parent, Object[] row) {
        this(row);
        if (parent != null) {
            parent.add(this);
        }
    }

    public Object[] getTableRow() {
        return this.tableRow;
    }

    public boolean setValueAt(Object value, int cx) {
        if (this.tableRow == null || cx < 0 || cx >= this.tableRow.length) {
            return false;
        }
        this.tableRow[cx] = value;
        if (cx == 0) {
            this.setUserObject(value);
            if (this.model != null) {
                this.model.nodeChanged(this);
            }
        }
        return true;
    }

    public void setTreeModel(TreeTableModel m) {
        this.model = m;
    }

    public TreeTableModel getTreeModel() {
        return this.model;
    }

    public boolean setLinkCommand(int cx, String cmd) {
        int i;
        if (this.tableRow == null || cx < 0 || cx >= this.tableRow.length) {
            return false;
        }
        if (cmd != null && (this.linkCommands == null || cx >= this.linkCommands.length)) {
            String[] newLinks = new String[cx + 1];
            if (this.linkCommands != null) {
                for (i = 0; i < this.linkCommands.length; ++i) {
                    newLinks[i] = this.linkCommands[i];
                }
            }
            while (i < newLinks.length) {
                newLinks[i] = null;
                ++i;
            }
            this.linkCommands = newLinks;
        }
        if (this.linkCommands != null && cx < this.linkCommands.length) {
            this.linkCommands[cx] = cmd;
            if (cmd == null) {
                boolean allNull = true;
                for (i = 0; i < this.linkCommands.length; ++i) {
                    if (this.linkCommands[i] == null) continue;
                    allNull = false;
                    break;
                }
                if (allNull) {
                    this.linkCommands = null;
                }
            }
        }
        return true;
    }

    public String getLinkCommand(int cx) {
        if (this.linkCommands == null || cx < 0 || cx >= this.linkCommands.length) {
            return null;
        }
        return this.linkCommands[cx];
    }

    public void setExpanded(boolean e) {
        this.expanded = e;
        if (this.model != null) {
            this.model.setRowExpansionState(this, e);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isCollapsed() {
        return !this.expanded;
    }

    public void setEditable(boolean ed) {
        this.editable = ed;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setHeight(int h) {
        if (this.height == h) {
            return;
        }
        this.height = h;
        if (this.model == null) {
            return;
        }
        TreeTable tt = this.model.getTreeTable();
        if (tt == null) {
            return;
        }
        int rx = this.model.indexOf(this, true);
        if (rx < 0) {
            return;
        }
        tt.setRowHeight(rx, h);
    }

    public int getHeight() {
        return this.height;
    }

    public void setIcon(Icon i) {
        this.genericIcon = i;
    }

    public void setOpenIcon(Icon i) {
        this.openIcon = i;
    }

    public void setClosedIcon(Icon i) {
        this.closedIcon = i;
    }

    public void setLeafIcon(Icon i) {
        this.leafIcon = i;
    }

    public Icon getIcon() {
        return this.genericIcon;
    }

    public Icon getOpenIcon() {
        return this.findIcon(this.openIcon);
    }

    public Icon getClosedIcon() {
        return this.findIcon(this.closedIcon);
    }

    public Icon getLeafIcon() {
        return this.findIcon(this.leafIcon);
    }

    protected Icon findIcon(Icon i) {
        return i != null ? i : this.genericIcon;
    }

    public void setBackground(Color bg) {
        this.background = bg;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setForeground(Color fg) {
        this.foreground = fg;
    }

    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public void add(MutableTreeNode n) throws IllegalArgumentException, IllegalStateException {
        if (n.getParent() != null) {
            n.removeFromParent();
        }
        super.add(n);
    }

    @Override
    public void insert(MutableTreeNode n, int i) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, IllegalStateException {
        if (n.getParent() != null) {
            n.removeFromParent();
        }
        super.insert(n, i);
        if (n instanceof TreeTableRow) {
            ((TreeTableRow)n).setTreeModel(this.getTreeModel());
        }
        if (this.model != null) {
            this.model.nodesWereInserted(this, new int[]{i});
        }
    }

    @Override
    public void remove(MutableTreeNode n) throws IllegalArgumentException {
        int childIndex = -1;
        if (this.model != null) {
            childIndex = this.getIndex(n);
        }
        super.remove(n);
        if (this.getChildCount() == 0) {
            this.setExpanded(false);
        }
        if (childIndex != -1) {
            this.model.nodesWereRemoved(this, new int[]{childIndex}, new TreeNode[]{n});
        }
    }

    @Override
    public void removeAllChildren() {
        int kidCount = this.getChildCount();
        int[] indices = new int[kidCount];
        Object[] kids = new TreeNode[kidCount];
        for (int i = 0; i < kidCount; ++i) {
            indices[i] = i;
            kids[i] = this.getChildAt(i);
        }
        super.removeAllChildren();
        this.setExpanded(false);
        if (this.model != null) {
            this.model.nodesWereRemoved(this, indices, kids);
        }
    }

    @Override
    public void removeFromParent() {
        if (this.isRoot()) {
            return;
        }
        TreeNode p = this.getParent();
        int i = p.getIndex(this);
        super.removeFromParent();
        if (this.model != null) {
            this.model.nodesWereRemoved(p, new int[]{i}, new TreeNode[]{this});
        }
    }

    public boolean equals(Object x) {
        if (!(x instanceof TreeTableRow)) {
            return false;
        }
        TreeTableRow that = (TreeTableRow)x;
        if (this.tableRow.length != that.tableRow.length) {
            return false;
        }
        for (int i = 0; i < this.tableRow.length; ++i) {
            if (!this.ne(this.tableRow[i], that.tableRow[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        for (int i = 0; i < this.tableRow.length; ++i) {
            if (this.tableRow[i] == null) continue;
            hc += this.tableRow[i].hashCode();
        }
        return hc;
    }

    private boolean ne(Object x0, Object x1) {
        return x0 != x1 && (x0 == null || x1 == null || !x0.equals(x1));
    }
}

