/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treetable;

import com.sas.MissingValues;
import com.sas.swing.visuals.treetable.TreeTable;
import com.sas.swing.visuals.treetable.TreeTableModel;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.swing.visuals.treetable.TreeTableRowRE;
import com.sas.text.SASFormat;
import com.sas.util.transforms.ObjectToStringTransform;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class SasCellRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer {
    public static final int UNDEFINED = -1;
    private static final String blank = " ";
    protected JTable table;
    protected TreeTable tt = null;
    protected TreeTableModel ttm = null;
    protected SASFormat formatter = null;
    protected Object innerRenderer = null;
    protected Color bg;
    protected Color fg;
    protected int alignment = -1;
    private Border focusBorder;
    private Border nonfocusBorder;

    public SasCellRenderer() {
    }

    public SasCellRenderer(SASFormat f) {
        this();
        this.setFormat(f);
    }

    public SasCellRenderer(TableCellRenderer r) {
        this();
        this.setInnerRenderer(r);
    }

    public void setInnerRenderer(TableCellRenderer r) {
        this.innerRenderer = r;
        this.alignment = -1;
        if (this.innerRenderer != null && this.innerRenderer instanceof JLabel) {
            this.alignment = ((JLabel)this.innerRenderer).getHorizontalAlignment();
            if (this.alignment != 0 && this.alignment != 2 && this.alignment != 4 && this.alignment != 10 && this.alignment != 11) {
                this.alignment = -1;
            }
        }
    }

    public Object getInnerRenderer() {
        return this.innerRenderer;
    }

    public void setFormat(SASFormat f) {
        this.formatter = f;
        if (this.formatter != null) {
            StringBuffer sb = new StringBuffer();
            this.formatter.format((Object)MissingValues.Dot, sb, null);
            char ch0 = sb.charAt(0);
            char ch1 = sb.charAt(sb.length() - 1);
            this.alignment = ch0 == ' ' && ch1 == ' ' ? 0 : (ch0 == ' ' ? 4 : (ch1 == ' ' ? 2 : (this.formatter.isCharacterFormat() ? 2 : 4)));
        }
    }

    public SASFormat getFormat() {
        return this.formatter;
    }

    @Override
    public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean isFocused, int rx, int cx) {
        Color c;
        boolean linkIsActive;
        Object x;
        Class dataType = String.class;
        int mcx = -1;
        if (this.table == null) {
            this.setTable(t);
        }
        TreeTableRow ttr = null;
        if (this.tt != null && (x = this.tt.getRow(rx)) instanceof TreeTableRow) {
            ttr = (TreeTableRow)x;
        }
        mcx = t.convertColumnIndexToModel(cx);
        dataType = t.getModel().getColumnClass(mcx);
        int align = this.alignment != -1 ? this.alignment : (dataType.equals(String.class) ? 2 : 4);
        Component comp = this;
        if (dataType.equals(String.class) && (value == null || value instanceof MissingValues)) {
            value = blank;
        }
        if (value == null || value instanceof Double && ((Double)value).isNaN() || value instanceof Float && ((Float)value).isNaN()) {
            value = MissingValues.Dot;
        }
        boolean renderingLink = this.tt != null && this.tt.isCellLink(rx, cx);
        boolean bl = linkIsActive = renderingLink && this.tt.isMouseOver(rx, cx);
        if (value instanceof MissingValues || value.equals(blank)) {
            this.setText(this._htmlLink(this._objectToString(value), renderingLink, linkIsActive));
        } else if (this.formatter == null && this.innerRenderer == null) {
            this.setText(this._htmlLink(value.toString(), renderingLink, linkIsActive));
        } else {
            if (this.formatter == null) {
                if (value instanceof String) {
                    value = this._htmlLink((String)value, renderingLink, linkIsActive);
                }
            } else {
                StringBuffer sb = new StringBuffer();
                try {
                    this.formatter.format(value, sb, null);
                }
                catch (IllegalArgumentException x2) {
                    String vs = "null";
                    if (value != null) {
                        vs = value.getClass().getName() + ":" + value.toString();
                    }
                    IllegalArgumentException x22 = new IllegalArgumentException("[" + rx + "][" + cx + "]=" + vs + "  ><  " + this.formatter.getName());
                    x22.initCause(x2);
                    throw x22;
                }
                if (align == 2) {
                    this._trimRight(sb);
                }
                if (align == 4) {
                    this._trimLeft(sb);
                }
                if (align == 0) {
                    this._trimBoth(sb);
                }
                value = this._htmlLink(sb.toString(), renderingLink, linkIsActive);
            }
            if (this.innerRenderer != null) {
                Object r;
                if (this.innerRenderer instanceof TableCellRenderer) {
                    r = (TableCellRenderer)this.innerRenderer;
                    try {
                        comp = r.getTableCellRendererComponent(t, value, isSelected, isFocused, rx, cx);
                    }
                    catch (Exception x3) {
                        x3.printStackTrace();
                    }
                } else if (this.innerRenderer instanceof TreeCellRenderer) {
                    r = (TreeCellRenderer)this.innerRenderer;
                    boolean exp = false;
                    boolean leaf = false;
                    if (ttr != null) {
                        exp = ttr.isExpanded();
                        leaf = ttr.isLeaf();
                    }
                    JTree tree = r instanceof TreeTableRowRE ? (JTree)r : (this.ttm != null ? this.ttm.getTree() : null);
                    comp = r.getTreeCellRendererComponent(tree, value, isSelected, exp, leaf, rx, isFocused);
                }
            } else {
                this.setText(value.toString());
            }
        }
        comp.setFont(t.getFont());
        if (comp instanceof JLabel) {
            ((JLabel)comp).setHorizontalAlignment(align);
        }
        Color bgcolor = t.getBackground();
        Color fgcolor = t.getForeground();
        if (this.tt != null) {
            Color c2;
            Color[] cc = this.tt.getBackgroundArray();
            if (cc != null && (c2 = cc[rx % cc.length]) != null) {
                bgcolor = c2;
            }
            if ((cc = this.tt.getForegroundArray()) != null && (c2 = cc[rx % cc.length]) != null) {
                fgcolor = c2;
            }
        }
        if (ttr != null) {
            Color c3 = ttr.getBackground();
            if (c3 != null) {
                bgcolor = c3;
            }
            if ((c3 = ttr.getForeground()) != null) {
                fgcolor = c3;
            }
        }
        if (renderingLink && this.tt != null && (c = this.tt.getLinkForeground()) != null) {
            fgcolor = c;
        }
        if (isSelected) {
            c = t.getSelectionBackground();
            if (c != null) {
                bgcolor = c;
            }
            if ((c = t.getSelectionForeground()) != null) {
                fgcolor = c;
            }
        }
        if (comp == this) {
            Border b = UIManager.getBorder("Table.focusCellHighlightBorder");
            if (b != null && !isFocused) {
                if (b != this.focusBorder) {
                    this.focusBorder = b;
                    this.nonfocusBorder = null;
                }
                if (this.nonfocusBorder == null) {
                    this.nonfocusBorder = new EmptyBorder(b.getBorderInsets(this));
                }
                b = this.nonfocusBorder;
            }
            this.setBorder(b);
        }
        comp.setBackground(bgcolor);
        comp.setForeground(fgcolor);
        return comp;
    }

    public void setTreeTable(TreeTable t) {
        this.tt = t;
    }

    private void setTable(JTable t) {
        this.table = t;
        this.tt = null;
        this.ttm = null;
        if (this.table instanceof TreeTable) {
            this.tt = (TreeTable)this.table;
            if (this.tt.getModel() instanceof TreeTableModel) {
                this.ttm = (TreeTableModel)this.tt.getModel();
            }
        }
    }

    @Override
    public int getHorizontalAlignment() {
        return this.alignment;
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        this.alignment = alignment;
        super.setHorizontalAlignment(alignment);
    }

    private String _objectToString(Object x) {
        return (String)ObjectToStringTransform.defaultInstance.transform(x);
    }

    private void _trimLeft(StringBuffer sb) {
        int numSpaces = 0;
        int len = sb.length();
        for (int i = 0; i < len && sb.charAt(i) == ' '; ++i) {
            ++numSpaces;
        }
        sb.delete(0, numSpaces);
    }

    private void _trimRight(StringBuffer sb) {
        int last;
        int numSpaces = 0;
        int len = sb.length();
        for (int i = last = sb.length() - 1; i >= 0 && sb.charAt(i) == ' '; --i) {
            ++numSpaces;
        }
        sb.delete(len - numSpaces, len);
    }

    private void _trimBoth(StringBuffer sb) {
        this._trimRight(sb);
        this._trimLeft(sb);
    }

    private String _htmlLink(String value, boolean link, boolean active) {
        if (!link || value == null) {
            return value;
        }
        String s = value;
        Color c = this.tt.getLinkForeground();
        if (c != null) {
            s = "<font color=" + SasCellRenderer.getHtmlColor(c) + ">" + s + "</font>";
        }
        if (active) {
            s = "<u>" + s + "</u>";
        }
        if (s != value) {
            s = s.replaceAll(blank, "&nbsp;");
            s = "<html>" + s + "</html>";
        }
        return s;
    }

    static String getHtmlColor(Color c) {
        StringBuffer sb = new StringBuffer();
        sb.append("#");
        sb.append(SasCellRenderer.get2HexDigits(c.getRed()));
        sb.append(SasCellRenderer.get2HexDigits(c.getGreen()));
        sb.append(SasCellRenderer.get2HexDigits(c.getBlue()));
        return sb.toString();
    }

    private static String get2HexDigits(int n) {
        int b = 256 + (n & 0xFF);
        return Integer.toHexString(b).substring(1);
    }
}

