/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treetable;

import com.sas.MissingValues;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import com.sas.util.transforms.ObjectToStringTransform;
import java.awt.Component;
import java.lang.constant.Constable;
import java.text.ParsePosition;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class SasCellEditor
extends JTextField
implements TableCellEditor {
    private static final String DOT = ".";
    private static final String TRUE = SasCellEditor.objectToString(Boolean.TRUE);
    private static final String FALSE = SasCellEditor.objectToString(Boolean.FALSE);
    int row;
    int col;
    SASFormat format;
    Object oldValue;
    Object newValue;
    Class columnType;
    Vector listeners = new Vector();

    public SasCellEditor() {
        this((SASFormat)null);
    }

    public SasCellEditor(SASFormat f) {
        this.setFormat(f);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SasCellEditor.this.requestFocus();
                        SasCellEditor.this.requestFocusInWindow();
                    }
                });
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    public void setFormat(SASFormat f) {
        this.format = f;
    }

    public SASFormat getFormat() {
        return this.format;
    }

    @Override
    public Component getTableCellEditorComponent(JTable t, Object value, boolean sel, int rx, int cx) {
        this.row = rx;
        this.col = cx;
        this.oldValue = this.newValue = value;
        this.columnType = t.getColumnClass(cx);
        String s = null;
        if (value == null || value instanceof Double && ((Double)value).isNaN() || value instanceof Float && ((Float)value).isNaN() || value instanceof MissingValues) {
            s = this.columnType.equals(String.class) ? "" : DOT;
        } else if (this.format != null) {
            StringBuffer sb = new StringBuffer();
            try {
                this.format.format(value, sb, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            s = sb.toString();
        } else {
            s = SasCellEditor.objectToString(value);
        }
        this.setText(s);
        this.setFont(t.getFont());
        return this;
    }

    @Override
    public Object getCellEditorValue() {
        return this.newValue;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return e == null;
    }

    @Override
    public boolean shouldSelectCell(EventObject e) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        String s = this.getText().trim();
        if (this.missingNumeric(s)) {
            this.newValue = MissingValues.Dot;
        } else if (this.format == null) {
            this.newValue = this.stringToObject(s);
        } else if (!(this.format instanceof SASDateTimeFormat)) {
            this.newValue = this.format.parseObject(s, new ParsePosition(0));
        } else {
            double sasDate;
            SASDateTimeFormat f = (SASDateTimeFormat)this.format;
            try {
                sasDate = f.informat(s);
            }
            catch (Exception x) {
                return false;
            }
            Object object = this.columnType.equals(String.class) ? s : (this.columnType.equals(Double.class) ? new Double(sasDate) : (this.columnType.equals(Float.class) ? new Float(sasDate) : (this.columnType.equals(Integer.class) ? new Integer((int)sasDate) : (this.newValue = this.columnType.equals(Long.class) ? new Long((long)sasDate) : null))));
        }
        if (this.newValue != null) {
            this.fireEditingStoppedEvent();
        }
        return this.newValue != null;
    }

    @Override
    public void cancelCellEditing() {
        this.newValue = this.oldValue;
        this.fireEditingCancelledEvent();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.addElement(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.removeElement(l);
    }

    protected void fireEditingStoppedEvent() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener li = (CellEditorListener)this.listeners.elementAt(i);
            li.editingStopped(new ChangeEvent(this));
        }
    }

    protected void fireEditingCancelledEvent() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener li = (CellEditorListener)this.listeners.elementAt(i);
            li.editingCanceled(new ChangeEvent(this));
        }
    }

    private Object stringToObject(String s) {
        return SasCellEditor.stringToObject(s, this.columnType);
    }

    private static Object stringToObject(String s, Class objectType) {
        if (objectType.equals(String.class)) {
            return s;
        }
        if (s.equals(DOT)) {
            return MissingValues.Dot;
        }
        Constable x = null;
        if (objectType.equals(Boolean.class)) {
            String lc = s.toLowerCase();
            if (lc.equals(TRUE)) {
                x = new Boolean(true);
            } else if (lc.equals(FALSE)) {
                x = new Boolean(false);
            }
        } else if (objectType.equals(Integer.class)) {
            try {
                x = new Integer(s);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (objectType.equals(Float.class)) {
            try {
                x = new Float(s);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (objectType.equals(Double.class)) {
            try {
                x = new Double(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return x;
    }

    private static String objectToString(Object x) {
        return (String)ObjectToStringTransform.defaultInstance.transform(x);
    }

    private boolean missingNumeric(String s) {
        return s.equals(DOT) && !this.columnType.equals(String.class);
    }
}

