/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treetable;

import com.sas.MissingValues;
import com.sas.swing.visuals.treetable.ObjectComparator;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.text.SASFormat;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Comparator;
import java.util.Vector;

public class ConcatenatedFieldComparator
implements Comparator {
    Vector fields;
    ObjectComparator defaultComparator = new ObjectComparator();
    Vector listeners;
    Object eventSource;
    boolean fireActionEvents;

    public ConcatenatedFieldComparator() {
        this.clearFields();
        this.eventSource = this;
        this.fireActionEvents = true;
        this.listeners = new Vector();
    }

    public void setCollator(Collator c) {
        this.defaultComparator.setCollator(c);
    }

    public Collator getCollator() {
        return this.defaultComparator.getCollator();
    }

    public void clearFields() {
        this.fields = new Vector();
    }

    public void addField(int field) {
        this.addField(-1, new FieldInfo(field));
    }

    public void addField(int field, boolean ascending) {
        this.addField(-1, new FieldInfo(field, ascending));
    }

    public void addField(int field, boolean ascending, Comparator comp) {
        this.addField(-1, new FieldInfo(field, ascending, comp));
    }

    public void addField(int field, boolean ascending, SASFormat format) {
        this.addField(-1, new FieldInfo(field, ascending, format));
    }

    public void prependField(int field) {
        this.addField(0, new FieldInfo(field));
    }

    public void prependField(int field, boolean ascending) {
        this.addField(0, new FieldInfo(field, ascending));
    }

    public void prependField(int field, boolean ascending, Comparator comp) {
        this.addField(0, new FieldInfo(field, ascending, comp));
    }

    public void prependField(int field, boolean ascending, SASFormat format) {
        this.addField(0, new FieldInfo(field, ascending, format));
    }

    private void addField(int pos, FieldInfo fi) {
        this.removeField(fi.sortField);
        if (pos == -1) {
            this.fields.add(fi);
        } else {
            this.fields.insertElementAt(fi, pos);
        }
        this.fireActionEvent();
    }

    private int removeField(int n) {
        int removed = 0;
        for (int i = this.fields.size() - 1; i >= 0; --i) {
            FieldInfo fi = (FieldInfo)this.fields.elementAt(i);
            if (fi.sortField != n) continue;
            this.fields.removeElementAt(i);
            ++removed;
        }
        return removed;
    }

    void setEventSource(Object x) {
        this.eventSource = x;
    }

    public void addActionListener(ActionListener m) {
        if (!this.listeners.contains(m)) {
            this.listeners.addElement(m);
        }
    }

    public void removeActionListener(ActionListener m) {
        if (this.listeners.contains(m)) {
            this.listeners.removeElement(m);
        }
    }

    public void setActionEventsEnabled(boolean b) {
        this.fireActionEvents = b;
    }

    private void fireActionEvent() {
        if (!this.fireActionEvents) {
            return;
        }
        ActionEvent e = new ActionEvent(this.eventSource, 1001, "sort");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ActionListener m = (ActionListener)this.listeners.elementAt(i);
            m.actionPerformed(e);
        }
    }

    public int compare(Object x1, Object x2) {
        Object[] data2;
        Object[] data1;
        if (x1 instanceof TreeTableRow && x2 instanceof TreeTableRow) {
            data1 = ((TreeTableRow)x1).getTableRow();
            data2 = ((TreeTableRow)x2).getTableRow();
        } else if (x1 instanceof Object[] && x2 instanceof Object[]) {
            data1 = (Object[])x1;
            data2 = (Object[])x2;
        } else {
            throw new IllegalArgumentException("need TreeTableRows or arrays");
        }
        int len = this.fields.size();
        for (int i = 0; i < len; ++i) {
            int d;
            FieldInfo f = this.getField(i);
            int s = f.sortField;
            Object v1 = null;
            Object v2 = null;
            if (data1 != null && s >= 0 && s < data1.length) {
                v1 = data1[s];
            }
            if (data2 != null && s >= 0 && s < data2.length) {
                v2 = data2[s];
            }
            if (this.objectIsMissingValue(v1) || this.objectIsMissingValue(v2)) {
                d = !this.objectIsMissingValue(v1) ? 1 : (!this.objectIsMissingValue(v2) ? -1 : 0);
            } else {
                if (f.formatter != null) {
                    StringBuffer sb = new StringBuffer();
                    f.formatter.format(v1, sb, null);
                    v1 = sb.toString();
                    sb = new StringBuffer();
                    f.formatter.format(v2, sb, null);
                    v2 = sb.toString();
                }
                d = f.comp.compare(v1, v2);
            }
            if (!f.ascending) {
                d = -d;
            }
            if (d < 0) {
                return -1;
            }
            if (d <= 0) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object x) {
        if (!x.getClass().equals(this.getClass())) {
            return false;
        }
        ConcatenatedFieldComparator that = (ConcatenatedFieldComparator)x;
        int len = this.getLength();
        if (len != that.getLength()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.getSortField(i) == that.getSortField(i) && this.getAscending(i) == that.getAscending(i) && this.getComparator(i).equals(that.getComparator(i)) && this.getFormatter(i).equals(that.getFormatter(i))) continue;
            return false;
        }
        return true;
    }

    public int getLength() {
        return this.fields.size();
    }

    public int getSortField(int i) {
        return this.getField((int)i).sortField;
    }

    public boolean getAscending(int i) {
        return this.getField((int)i).ascending;
    }

    public Comparator getComparator(int i) {
        return this.getField((int)i).comp;
    }

    public SASFormat getFormatter(int i) {
        return this.getField((int)i).formatter;
    }

    public void setSortField(int i, int f) {
        this.getField((int)i).sortField = f;
    }

    public void setAscending(int i, boolean a) {
        this.getField((int)i).ascending = a;
    }

    public void setComparator(int i, Comparator c) {
        this.getField((int)i).comp = c;
    }

    public void setFormatter(int i, SASFormat f) {
        this.getField((int)i).formatter = f;
    }

    protected FieldInfo getField(int i) {
        return (FieldInfo)this.fields.elementAt(i);
    }

    private boolean objectIsMissingValue(Object x) {
        return x == null || x instanceof MissingValues || x instanceof Float && ((Float)x).isNaN() || x instanceof Double && ((Double)x).isNaN();
    }

    private class FieldInfo {
        public int sortField;
        public boolean ascending;
        public Comparator comp;
        public SASFormat formatter;

        public FieldInfo(int s) {
            this(s, true, null, null);
        }

        public FieldInfo(int s, boolean a) {
            this(s, a, null, null);
        }

        public FieldInfo(int s, boolean a, Comparator c) {
            this(s, a, c, null);
        }

        public FieldInfo(int s, boolean a, SASFormat f) {
            this(s, a, null, f);
        }

        public FieldInfo(int s, boolean a, Comparator c, SASFormat f) {
            this.sortField = s;
            this.ascending = a;
            this.comp = c != null ? c : ConcatenatedFieldComparator.this.defaultComparator;
            this.formatter = f;
        }
    }
}

