/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treecombobox;

import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.treecombobox.IndentedItemsRenderer;
import com.sas.swing.visuals.treecombobox.TreeItemsListCellRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ListCellRenderer;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public class TreeComboBox
extends WideComboBox
implements TreeModelListener {
    private TreeModel treeModel;
    private boolean rootVisible;
    private List nodeIndentLevels;
    private Object root;
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private ListCellRenderer treeItemsListCellRenderer;

    public TreeComboBox() {
        this(null, null, true);
    }

    public TreeComboBox(TreeModel treeModel) {
        this(treeModel, null, true);
    }

    public TreeComboBox(TreeModel treeModel, ListCellRenderer itemsListCellRenderer, boolean rootVisibility) {
        this.setModel(this.model);
        this.setNodeIndentLevels(new ArrayList(20));
        this.setRenderer(new IndentedItemsRenderer(this));
        this.rootVisible = rootVisibility;
        if (itemsListCellRenderer != null) {
            this.setTreeItemsListCellRenderer(itemsListCellRenderer);
        } else {
            this.setTreeItemsListCellRenderer(new TreeItemsListCellRenderer());
        }
        if (treeModel != null) {
            this.treeModel = treeModel;
            this.refresh();
            this.treeModel.addTreeModelListener(this);
        }
    }

    protected void setNodeIndentLevels(List indentLevels) {
        this.nodeIndentLevels = indentLevels;
    }

    protected List getNodeIndentLevels() {
        return this.nodeIndentLevels;
    }

    public void setTreeItemsListCellRenderer(ListCellRenderer itemsListCellRenderer) {
        this.treeItemsListCellRenderer = itemsListCellRenderer;
    }

    public ListCellRenderer getTreeItemsListCellRenderer() {
        return this.treeItemsListCellRenderer;
    }

    private void updateDataModelAndIndentionLevels() {
        if (this.getTreeModel() != null) {
            this.root = this.getRoot();
            this.model.removeAllElements();
            if (this.isRootVisible()) {
                this.model.addElement(this.root);
                this.nodeIndentLevels.clear();
                this.nodeIndentLevels.add(0, new Integer(0));
                this.addNodes(this.root, 1);
            } else {
                this.nodeIndentLevels.clear();
                this.addNodes(this.root, 0);
            }
        }
    }

    private void addNodes(Object node, int indentLevel) {
        TreeModel treeModelToRefresh = this.getTreeModel();
        int numOfChildren = treeModelToRefresh.getChildCount(node);
        Object nodeToProcess = node;
        for (int i = 0; i < numOfChildren; ++i) {
            Object childNode = treeModelToRefresh.getChild(nodeToProcess, i);
            this.model.addElement(childNode);
            this.nodeIndentLevels.add(this.getItemCount() - 1, new Integer(indentLevel));
            if (treeModelToRefresh.isLeaf(childNode)) continue;
            this.addNodes(childNode, indentLevel + 1);
        }
    }

    public void setRootVisible(boolean rootVisibility) {
        if (rootVisibility != this.rootVisible) {
            this.rootVisible = rootVisibility;
            this.refresh();
        }
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    protected Object getRoot() {
        return this.getTreeModel().getRoot();
    }

    public void refresh() {
        this.updateDataModelAndIndentionLevels();
    }

    @Override
    public void addItem(Object anObject) {
        throw new UnsupportedOperationException("Items cannot be added using this method.  Add item to TreeModel.");
    }

    public void insertItemAt(Object anObject, int index) {
        throw new UnsupportedOperationException("Items cannot be inserted using this method.  Insert item on TreeModel.");
    }

    @Override
    public void removeAllItems() {
        throw new UnsupportedOperationException("Items cannot be removed using this method.  Update TreeModel to make any changes in the displayed items.");
    }

    @Override
    public void removeItem(Object anObject) {
        throw new UnsupportedOperationException("Items cannot be removed using this method.  Remove item from TreeModel.");
    }

    @Override
    public void removeItemAt(int anIndex) {
        throw new UnsupportedOperationException("Items cannot be removed using this method.  Remove item at TreeModel.");
    }

    public void setTreeModel(TreeModel treeModel) {
        if (treeModel != null) {
            this.treeModel = treeModel;
            this.refresh();
            this.treeModel.addTreeModelListener(this);
        }
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent arg0) {
        this.refresh();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent arg0) {
        this.refresh();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent arg0) {
        this.refresh();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent arg0) {
        this.refresh();
    }
}

