/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview.editors;

import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class DualComboBoxEditor
extends DefaultTableCellEditor {
    protected JPanel panel;
    protected JComboBox comboBox1;
    protected JComboBox comboBox2;
    protected HashMap comboBoxMap;
    protected boolean initialFocusSet;

    public DualComboBoxEditor() {
        this.init();
    }

    public DualComboBoxEditor(JComboBox comboBox1, JComboBox comboBox2) {
        this.comboBox1 = comboBox1;
        this.comboBox2 = comboBox2;
        this.init();
    }

    protected void init() {
        this.comboBoxMap = new HashMap();
        this.initialFocusSet = false;
        this.panel = new JPanel();
        BorderLayout layout = new BorderLayout();
        layout.setHgap(2);
        this.panel.setLayout(layout);
        if (this.comboBox1 == null) {
            this.comboBox1 = new ComboBox();
        }
        this.comboBox1.setName("DualComboBoxEditor_ComboBox1");
        this.comboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DualComboBoxEditor.this.comboBox2.removeAllItems();
                List items = (List)DualComboBoxEditor.this.comboBoxMap.get(DualComboBoxEditor.this.comboBox1.getSelectedItem());
                DualComboBoxEditor.this.comboBox2.setVisible(items != null);
                if (items != null) {
                    for (int i = 0; i < items.size(); ++i) {
                        DualComboBoxEditor.this.comboBox2.addItem(items.get(i));
                    }
                }
            }
        });
        this.panel.add((Component)this.comboBox1, "Center");
        if (this.comboBox2 == null) {
            this.comboBox2 = new ComboBox();
        }
        this.comboBox2.setName("DualComboBoxEditor_ComboBox2");
        this.panel.add((Component)this.comboBox2, "East");
        this.editorComponent = this.panel;
        this.comboBox1.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 39) {
                    if (DualComboBoxEditor.this.comboBox2.isVisible()) {
                        DualComboBoxEditor.this.comboBox2.requestFocus();
                    }
                } else if (event.getKeyCode() == 37) {
                    DualComboBoxEditor.this.panel.requestFocus();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DualComboBoxEditor.this.stopEditing();
                        }
                    });
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.comboBox2.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 37) {
                    DualComboBoxEditor.this.comboBox1.requestFocus();
                } else if (event.getKeyCode() == 39) {
                    DualComboBoxEditor.this.panel.requestFocus();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DualComboBoxEditor.this.stopEditing();
                        }
                    });
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.panel.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (!DualComboBoxEditor.this.initialFocusSet) {
                    DualComboBoxEditor.this.initialFocusSet = true;
                    DualComboBoxEditor.this.comboBox1.requestFocus();
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
    }

    public JComboBox getComboBox1() {
        return this.comboBox1;
    }

    public JComboBox getComboBox2() {
        return this.comboBox2;
    }

    public void addItem(Object leftItem, List rightItems) {
        this.comboBox1.addItem(leftItem);
        this.comboBoxMap.put(leftItem, rightItems);
    }

    public void insertItemAt(Object leftItem, List rightItems, int index) {
        this.comboBox1.insertItemAt(leftItem, index);
        this.comboBoxMap.put(leftItem, rightItems);
    }

    public void removeItem(Object leftItem) {
        this.comboBox1.removeItem(leftItem);
        this.comboBoxMap.remove(leftItem);
    }

    public void removeItemAt(int index) {
        Object item = this.comboBox1.getItemAt(index);
        this.comboBox1.removeItemAt(index);
        this.comboBoxMap.remove(item);
    }

    public void removeAllItems() {
        this.comboBox1.removeAllItems();
        this.comboBoxMap.clear();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        boolean found = false;
        for (Object key : this.comboBoxMap.keySet()) {
            List valuesList = (List)this.comboBoxMap.get(key);
            if (valuesList == null || !valuesList.contains(value)) continue;
            this.comboBox1.setSelectedItem(key);
            this.comboBox2.setSelectedItem(value);
            found = true;
            break;
        }
        if (!found) {
            this.comboBox1.setSelectedItem(value);
        }
        this.initialFocusSet = false;
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        Object item = this.comboBox2.getSelectedItem();
        if (item != null) {
            return item;
        }
        return this.comboBox1.getSelectedItem();
    }

    protected void stopEditing() {
        this.stopCellEditing();
    }
}

