/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class StartEditingAction
extends AbstractAction {
    @Override
    public void actionPerformed(ActionEvent e) {
        JTable table = null;
        if (e.getSource() instanceof JTable) {
            table = (JTable)e.getSource();
        }
        if (table != null) {
            if (!table.hasFocus()) {
                TableCellEditor cellEditor = table.getCellEditor();
                if (cellEditor != null && !cellEditor.stopCellEditing()) {
                    return;
                }
                table.requestFocus();
                return;
            }
            if (table instanceof TableView) {
                int[] cell = ((TableView)table).getCurrentCell();
                if (cell[0] > -1 && cell[1] > -1) {
                    table.editCellAt(cell[0], cell[1]);
                }
            } else {
                ListSelectionModel rsm = table.getSelectionModel();
                int anchorRow = rsm.getAnchorSelectionIndex();
                ListSelectionModel csm = table.getColumnModel().getSelectionModel();
                int anchorColumn = csm.getAnchorSelectionIndex();
                table.editCellAt(anchorRow, anchorColumn);
            }
            Component editorComp = table.getEditorComponent();
            if (editorComp != null) {
                editorComp.requestFocus();
                if (editorComp instanceof JTextComponent) {
                    JTextComponent text = (JTextComponent)editorComp;
                    text.setCaretPosition(0);
                    text.selectAll();
                }
            }
        }
    }
}

