/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.BasicRowHeaderUI;
import com.sas.swing.visuals.tableview.DefaultRowHeaderRenderer;
import com.sas.swing.visuals.tableview.DefaultTableRowModel;
import com.sas.swing.visuals.tableview.HoldInterface;
import com.sas.swing.visuals.tableview.RB;
import com.sas.swing.visuals.tableview.RowHeaderUI;
import com.sas.swing.visuals.tableview.TableRowModel;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.swing.visuals.tableview.TableRowModelListener;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.table.InsertRowInterface;
import com.sas.table.StaticRowLabelInterface;
import com.sas.table.TableException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;

public class RowHeader
extends JComponent
implements TableRowModelListener,
HoldInterface,
SwingConstants {
    public static final String RB_KEY = "RowHeader.";
    private static final String uiClassID = "RowHeaderUI";
    protected TableView table;
    protected TableRowModel rowModel;
    protected boolean reorderingAllowed;
    protected boolean resizingAllowed;
    protected transient int resizingRow;
    protected transient int draggedRow;
    protected transient int draggedDistance;
    protected boolean widthSet;
    protected int width;
    protected int cellsToSizeCount;
    protected boolean holdingEnabled;
    protected int numRowsSized;
    protected List heldRows;
    protected List heldRowsTop;
    protected List heldRowsBottom;
    protected BitSet rowsSized;
    private TableCellRenderer defaultRenderer;
    public boolean printing;

    public RowHeader() {
        this(null);
    }

    public RowHeader(TableRowModel model) {
        if (model == null) {
            model = this.createDefaultRowModel();
        }
        this.setRowModel(model);
        this.initializeLocalVars();
        UIManager.put(uiClassID, "com.sas.swing.visuals.tableview.BasicRowHeaderUI");
        this.updateUI();
    }

    public void setTable(TableView table) {
        if (this.table != table) {
            TableView old = this.table;
            this.table = table;
            this.refreshRowsSized();
            this.sizeRowsToFit(true, true);
            this.firePropertyChange("table", old, table);
        }
    }

    private void refreshRowsSized() {
        this.numRowsSized = 0;
        if (this.table != null) {
            this.rowsSized = new BitSet(this.table.getRowCount());
        }
    }

    public TableView getTable() {
        return this.table;
    }

    public void setReorderingAllowed(boolean reorderingAllowed) {
        if (this.reorderingAllowed != reorderingAllowed) {
            boolean old = this.reorderingAllowed;
            this.reorderingAllowed = reorderingAllowed;
            this.firePropertyChange("reorderingAllowed", old, reorderingAllowed);
        }
    }

    public boolean getReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public void setResizingAllowed(boolean resizingAllowed) {
        if (this.resizingAllowed != resizingAllowed) {
            boolean old = this.resizingAllowed;
            this.resizingAllowed = resizingAllowed;
            this.firePropertyChange("resizingAllowed", old, resizingAllowed);
        }
    }

    public boolean getResizingAllowed() {
        return this.resizingAllowed;
    }

    public int getDraggedRow() {
        return this.draggedRow;
    }

    public int getDraggedDistance() {
        return this.draggedDistance;
    }

    public int getResizingRow() {
        return this.resizingRow;
    }

    public void setDefaultRenderer(TableCellRenderer defaultRenderer) {
        if (this.defaultRenderer != defaultRenderer) {
            TableCellRenderer old = this.defaultRenderer;
            this.defaultRenderer = defaultRenderer;
            this.sizeRowsToFit(true, true);
            this.firePropertyChange("defaultRenderer", old, this.defaultRenderer);
        }
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row) {
        Object value = this.getValueAt(row);
        boolean isSelected = this.getTable().isRowSelected(row);
        boolean rowIsAnchor = this.getTable().getCurrentRow() == row;
        boolean hasFocus = rowIsAnchor && this.getTable().getCurrentColumn() < 0 && this.getTable().isFocusOwner();
        return renderer.getTableCellRendererComponent(this.getTable(), value, isSelected, hasFocus, row, -1);
    }

    public int rowAtPoint(Point point) {
        return this.rowAtPoint(point, true);
    }

    public int rowAtPoint(Point point, boolean accoundForHolds) {
        return this.getTable().rowAtPoint(point, accoundForHolds);
    }

    public Rectangle getHeaderRect(int row) {
        Rectangle r = new Rectangle();
        TableRowModel tm = this.getRowModel();
        int modelRow = this.getTable().convertRowIndexToModel(row);
        Rectangle cellRect = this.table.getCellRect(row, 0, true);
        r.height = cellRect.height;
        if (row >= 0) {
            if (row >= tm.getRowCount()) {
                r.y = this.getHeight();
            } else {
                r.y = cellRect.y;
                r.width = this.getWidth();
            }
        }
        return r;
    }

    public Object getValueAt(int rowIndex) {
        InsertRowInterface insertModel;
        if (this.getTable().getModel() instanceof InsertRowInterface && (insertModel = (InsertRowInterface)this.getTable().getModel()).isUncommittedRowPresent()) {
            int modelRow = this.getTable().convertRowIndexToModel(rowIndex);
            if (modelRow == insertModel.getUncommittedRowNumber()) {
                return "*";
            }
            if (modelRow >= insertModel.getUncommittedRowNumber()) {
                --rowIndex;
            }
        }
        Object value = null;
        if (this.getTable().getModel() instanceof StaticRowLabelInterface) {
            try {
                StaticRowLabelInterface labels = (StaticRowLabelInterface)this.getTable().getModel();
                if (labels.isRowLabelsSupported()) {
                    value = labels.getRowLabel(this.getTable().convertRowIndexToModel(rowIndex));
                }
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
        if (value == null) {
            value = new Integer(this.getTable().convertRowIndexToModel(rowIndex) + 1);
        }
        return value;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Component component;
        String tip = null;
        Point p = event.getPoint();
        int row = this.rowAtPoint(p);
        if (row != -1 && (component = this.getDefaultRenderer().getTableCellRendererComponent(this.getTable(), this.getValueAt(row), false, false, row, -1)) instanceof JComponent) {
            Rectangle cellRect = this.getHeaderRect(row);
            p.translate(-cellRect.x, -cellRect.y);
            MouseEvent newEvent = new MouseEvent(component, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
            tip = ((JComponent)component).getToolTipText(newEvent);
        }
        if (tip == null) {
            tip = this.getToolTipText();
        }
        return tip;
    }

    @Override
    public RowHeaderUI getUI() {
        return (BasicRowHeaderUI)this.ui;
    }

    public void setUI(RowHeaderUI ui) {
        if (this.ui != ui) {
            super.setUI(ui);
            this.repaint();
        }
    }

    @Override
    public void updateUI() {
        if (this.getDefaultRenderer() instanceof JComponent) {
            ((JComponent)((Object)this.getDefaultRenderer())).updateUI();
        }
        this.setUI((RowHeaderUI)UIManager.getUI(this));
        this.resizeAndRepaint();
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setRowModel(TableRowModel model) {
        TableRowModel old = this.rowModel;
        if (model != old) {
            if (old != null) {
                old.removeRowModelListener(this);
            }
            this.rowModel = model;
            if (this.rowModel != null) {
                this.rowModel.addRowModelListener(this);
            }
            this.firePropertyChange("rowModel", old, this.rowModel);
            this.refreshRowsSized();
            this.sizeRowsToFit(true, true);
            this.resizeAndRepaint();
        }
    }

    public TableRowModel getRowModel() {
        return this.rowModel;
    }

    protected TableRowModel createDefaultRowModel() {
        if (this.getTable() != null) {
            return new DefaultTableRowModel(this.getTable());
        }
        return null;
    }

    protected TableCellRenderer createDefaultRenderer() {
        return new DefaultRowHeaderRenderer();
    }

    public Point getViewPosition() {
        Container p = this.getParent();
        Point point = new Point(0, 0);
        if (p instanceof JViewport) {
            point = ((JViewport)p).getViewPosition();
        }
        return point;
    }

    protected void initializeLocalVars() {
        this.setOpaque(false);
        this.table = null;
        this.reorderingAllowed = true;
        this.resizingAllowed = true;
        this.draggedRow = -1;
        this.draggedDistance = 0;
        this.resizingRow = -1;
        this.widthSet = false;
        this.cellsToSizeCount = 1;
        this.holdingEnabled = true;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setDefaultRenderer(this.createDefaultRenderer());
        this.setAutoscrolls(true);
        this.rowsSized = new BitSet();
    }

    public void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void setDraggedRow(int aRow) {
        if (this.draggedRow != aRow) {
            int old = this.draggedRow;
            this.draggedRow = aRow;
            this.firePropertyChange("draggedRow", old, this.draggedRow);
        }
    }

    public void setDraggedDistance(int distance) {
        if (this.draggedDistance != distance) {
            int old = this.draggedDistance;
            this.draggedDistance = distance;
            this.firePropertyChange("draggedDistance", old, this.draggedDistance);
        }
    }

    public void setResizingRow(int aRow) {
        if (this.resizingRow != aRow) {
            int old = this.resizingRow;
            this.resizingRow = aRow;
            this.firePropertyChange("resizingRow", old, this.resizingRow);
        }
    }

    public boolean isWidthSet() {
        return this.widthSet;
    }

    public void setWidth(int newWidth) {
        int old = this.getWidth();
        if (old != newWidth) {
            this.width = newWidth;
            this.widthSet = true;
            this.firePropertyChange("width", old, this.width);
        }
    }

    @Override
    public int getWidth() {
        if (this.isWidthSet()) {
            return this.width;
        }
        return super.getWidth();
    }

    public void setCellsToSizeCount(int newCount) {
        if (this.getCellsToSizeCount() != newCount) {
            int old = this.getCellsToSizeCount();
            this.cellsToSizeCount = newCount;
            this.firePropertyChange("cellsToSizeCount", old, this.cellsToSizeCount);
        }
    }

    public int getCellsToSizeCount() {
        return this.cellsToSizeCount;
    }

    public void sizeRowToFit(int row) {
        this.sizeRowsToFit(row, row, true);
    }

    public int sizeRowsToFit(int firstRow, int lastRow, boolean force) {
        TableView table = this.getTable();
        if (table != null && this.getResizingAllowed()) {
            if (force) {
                for (int i = firstRow; i <= lastRow; ++i) {
                    int height = this.calculatePreferredHeightForRow(i);
                    if (height <= -1) continue;
                    table.setRowHeight(i, height);
                    if (!this.rowsSized.get(i)) {
                        ++this.numRowsSized;
                    }
                    this.rowsSized.set(i);
                }
                return lastRow;
            }
            int lastRowSized = -1;
            for (int i = firstRow; i <= lastRow; ++i) {
                int height;
                if (this.rowsSized.get(i) || (height = this.calculatePreferredHeightForRow(i)) <= -1) continue;
                table.setRowHeight(i, height);
                this.rowsSized.set(i);
                ++this.numRowsSized;
                lastRowSized = i;
            }
            return lastRowSized;
        }
        return -1;
    }

    public int sizeRowsToFit(boolean onlyVisible, boolean force) {
        TableView table = this.getTable();
        if (table != null && table.tableInitialized && this.getResizingAllowed() && table.getRowAutoResizeMode() != 0) {
            int start;
            int finish;
            if (table.getRowAutoResizeMode() == 5 && this.numRowsSized == 1) {
                return -1;
            }
            int rowCount = table.getRowCount();
            if (this.numRowsSized == rowCount || rowCount <= 0) {
                return -1;
            }
            if (onlyVisible) {
                finish = table.getRowAutoResizeMode() == 5 ? 0 : table.getLastVisibleRow();
                start = table.getFirstVisibleRow();
            } else {
                finish = table.getRowAutoResizeMode() == 5 ? 0 : rowCount - 1;
                start = 0;
            }
            if (start == -1) {
                start = 0;
            }
            if (start > finish) {
                return -1;
            }
            int lastRowSized = -1;
            for (int row = start; row <= finish; ++row) {
                int height;
                if (force) {
                    height = this.calculatePreferredHeightForRow(row);
                    if (height <= -1) continue;
                    if (row == 0 && table.getRowAutoResizeMode() == 5) {
                        table.setRowHeight(height);
                    } else {
                        table.setRowHeight(row, height);
                    }
                    lastRowSized = row;
                    if (!this.rowsSized.get(row)) {
                        ++this.numRowsSized;
                    }
                    this.rowsSized.set(row);
                    continue;
                }
                if (this.rowsSized.get(row) || (height = this.calculatePreferredHeightForRow(row)) <= -1) continue;
                if (row == 0 && table.getRowAutoResizeMode() == 5) {
                    table.setRowHeight(height);
                } else {
                    table.setRowHeight(row, height);
                }
                lastRowSized = row;
                this.rowsSized.set(row);
                ++this.numRowsSized;
            }
            return lastRowSized;
        }
        return -1;
    }

    public int calculatePreferredHeightForRow(int row) {
        TableView table = this.getTable();
        if (table != null) {
            int cellSpacing = ((JTable)table).getRowMargin();
            int maxCellHeight = 0;
            int colCount = this.cellsToSizeCount < 0 ? table.getColumnCount() : Math.min(table.getColumnCount(), this.cellsToSizeCount);
            for (int c = 0; c < colCount; ++c) {
                Component component = ((JTable)table).prepareRenderer(((JTable)table).getCellRenderer(row, c), row, c);
                int cellHeight = component.getPreferredSize().height;
                if (cellHeight <= maxCellHeight) continue;
                maxCellHeight = cellHeight;
            }
            TableCellRenderer headerRenderer = this.getDefaultRenderer();
            Component component = headerRenderer.getTableCellRendererComponent(table, this.getValueAt(row), false, false, row, -1);
            int headerHeight = component.getPreferredSize().height;
            return Math.max(headerHeight, maxCellHeight += cellSpacing);
        }
        return -1;
    }

    private boolean checkOrientation(int orientation) {
        return orientation == 1 || orientation == 3;
    }

    @Override
    public void hold(int rowModelIndex) {
        this.hold(rowModelIndex, 1);
    }

    @Override
    public void hold(int rowModelIndex, int orientation) {
        if (!this.checkOrientation(orientation)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegalHoldOrientation.txt"));
        }
        if (this.isHoldingAllowed(orientation)) {
            Integer heldRow = new Integer(rowModelIndex);
            if (!this.getHeldIndices().contains(heldRow)) {
                int insertIndex = 0;
                if (orientation == 1) {
                    insertIndex = this.heldRowsTop.size();
                    this.heldRowsTop.add(heldRow);
                    this.getTable().moveRow(this.getTable().convertRowIndexToView(heldRow), insertIndex);
                } else {
                    insertIndex = this.heldRowsBottom.size();
                    this.heldRowsBottom.add(heldRow);
                    int rowCount = this.getTable().getRowCount();
                    this.getTable().moveRow(this.getTable().convertRowIndexToView(heldRow), rowCount - 1 - insertIndex);
                }
            }
        }
    }

    @Override
    public void release(int rowModelIndex) {
        if (this.isHoldingEnabled()) {
            int heldRow2;
            int j;
            Integer heldRow = new Integer(rowModelIndex);
            if (this.getHeldIndices(1).contains(heldRow)) {
                this.heldRowsTop.remove(heldRow);
            } else if (this.getHeldIndices(3).contains(heldRow)) {
                this.heldRowsBottom.remove(heldRow);
            } else {
                return;
            }
            List topList = this.getHeldIndices(1);
            List bottomList = this.getHeldIndices(3);
            int count = 0;
            int size = topList.size();
            for (j = 0; j < size; ++j) {
                heldRow2 = (Integer)topList.get(j);
                if (heldRow2 <= rowModelIndex) continue;
                ++count;
            }
            size = bottomList.size();
            for (j = 0; j < size; ++j) {
                heldRow2 = (Integer)bottomList.get(j);
                if (heldRow2 >= rowModelIndex) continue;
                --count;
            }
            int startIndex = this.getTable().convertRowIndexToView(rowModelIndex);
            if (startIndex != -1) {
                this.getTable().moveRow(startIndex, rowModelIndex + count);
            }
        }
    }

    @Override
    public void releaseAll() {
        if (this.isHoldingEnabled()) {
            List list = this.getHeldIndices();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.release((Integer)list.get(i));
            }
        }
    }

    @Override
    public List getHeldIndices() {
        if (this.heldRowsTop == null) {
            this.heldRowsTop = new ArrayList();
        }
        if (this.heldRowsBottom == null) {
            this.heldRowsBottom = new ArrayList();
        }
        if (this.heldRows == null) {
            this.heldRows = new ArrayList();
        } else {
            this.heldRows.clear();
        }
        this.heldRows.addAll(this.heldRowsTop);
        this.heldRows.addAll(this.heldRowsBottom);
        return this.heldRows;
    }

    @Override
    public List getHeldIndices(int orientation) {
        if (!this.checkOrientation(orientation)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegalHoldOrientation.txt"));
        }
        if (orientation == 1) {
            if (this.heldRowsTop == null) {
                this.heldRowsTop = new ArrayList();
            }
            return this.heldRowsTop;
        }
        if (this.heldRowsBottom == null) {
            this.heldRowsBottom = new ArrayList();
        }
        return this.heldRowsBottom;
    }

    @Override
    public boolean isHeld(int rowModelIndex) {
        return this.getHeldIndices().contains(new Integer(rowModelIndex));
    }

    @Override
    public boolean isHeld(int rowModelIndex, int orientaion) {
        return this.getHeldIndices(orientaion).contains(new Integer(rowModelIndex));
    }

    @Override
    public boolean isHoldingEnabled() {
        return this.holdingEnabled;
    }

    @Override
    public void setHoldingEnabled(boolean enableHolding) {
        if (this.holdingEnabled != enableHolding) {
            this.holdingEnabled = enableHolding;
            this.firePropertyChange("holdingEnabled", this.holdingEnabled ? Boolean.FALSE : Boolean.TRUE, this.holdingEnabled ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public boolean isHoldingAllowed(int orientation) {
        return this.isHoldingEnabled() && (orientation == 1 || orientation == 3);
    }

    @Override
    public void rowMoved(TableRowModelEvent e) {
        int start = e.getFromIndex();
        int end = e.getToIndex();
        if (start != -1 && end != -1) {
            int size = this.rowsSized.size();
            if (start < size && end < size) {
                if (start < end) {
                    boolean startb = this.rowsSized.get(start);
                    for (int i = end - 1; i >= start; --i) {
                        this.rowsSized.set(i, this.rowsSized.get(i + 1));
                    }
                    this.rowsSized.set(end, startb);
                } else {
                    boolean endb = this.rowsSized.get(end);
                    for (int i = start; i >= end + 1; --i) {
                        this.rowsSized.set(i, this.rowsSized.get(i - 1));
                    }
                    this.rowsSized.set(end, endb);
                }
            }
        } else {
            this.refreshRowsSized();
        }
        this.repaint();
    }

    @Override
    public void rowMarginChanged(ChangeEvent e) {
        this.sizeRowsToFit(true, false);
        this.resizeAndRepaint();
    }

    @Override
    public void rowSelectionChanged(ListSelectionEvent e) {
    }

    protected void tableRowsInserted(TableModelEvent e) {
        int last;
        int i;
        int r;
        Integer held;
        int i2;
        int start = e.getFirstRow();
        int end = e.getLastRow();
        int length = end - start + 1;
        int rowCount = this.getTable().getRowCount();
        List topHeld = this.getHeldIndices(1);
        List bottomHeld = this.getHeldIndices(3);
        int topHeldSize = topHeld.size();
        int bottomHeldSize = bottomHeld.size();
        for (i2 = 0; i2 < topHeldSize; ++i2) {
            held = (Integer)topHeld.get(i2);
            if (held < end) continue;
            topHeld.set(i2, new Integer(held + length));
        }
        for (i2 = 0; i2 < bottomHeldSize; ++i2) {
            held = (Integer)bottomHeld.get(i2);
            if (held < end) continue;
            bottomHeld.set(i2, new Integer(held + length));
        }
        for (i2 = 0; i2 < topHeldSize; ++i2) {
            held = (Integer)topHeld.get(i2);
            r = this.getTable().convertRowIndexToView(held);
            if (r == i2) continue;
            this.getRowModel().moveRow(r, i2);
        }
        for (i2 = 0; i2 < bottomHeldSize; ++i2) {
            int to;
            held = (Integer)bottomHeld.get(i2);
            r = this.getTable().convertRowIndexToView(held);
            if (r == (to = rowCount - 1 - i2)) continue;
            this.getRowModel().moveRow(r, to);
        }
        for (i = last = rowCount - length; i >= start; --i) {
            this.rowsSized.set(i + length, this.rowsSized.get(i));
        }
        for (i = start; i <= end; ++i) {
            this.rowsSized.set(i, false);
        }
    }

    protected void tableRowsDeleted(TableModelEvent e) {
        int i;
        int held;
        int start = e.getFirstRow();
        int end = e.getLastRow();
        int deletedCount = end - start + 1;
        List topHeld = this.getHeldIndices(1);
        List bottomHeld = this.getHeldIndices(3);
        for (int i2 = 0; i2 < deletedCount; ++i2) {
            held = start + i2;
            Integer heldRow = new Integer(held);
            if (topHeld.contains(heldRow)) {
                topHeld.remove(heldRow);
                continue;
            }
            if (!bottomHeld.contains(heldRow)) continue;
            bottomHeld.remove(heldRow);
        }
        int topHeldSize = topHeld.size();
        int bottomHeldSize = bottomHeld.size();
        for (i = 0; i < topHeldSize; ++i) {
            held = (Integer)topHeld.get(i);
            if (held < end) continue;
            topHeld.set(i, new Integer(held - deletedCount));
        }
        for (i = 0; i < bottomHeldSize; ++i) {
            held = (Integer)bottomHeld.get(i);
            if (held < end) continue;
            bottomHeld.set(i, new Integer(held - deletedCount));
        }
        for (i = start; i <= end; ++i) {
            this.rowsSized.set(i, this.rowsSized.get(i + deletedCount));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.printing = false;
        int heldRowTopHeight = this.getTopHeldHeight();
        int heldRowBottomHeight = this.getBottomHeldHeight();
        this.verifyClipRect(g, heldRowTopHeight, heldRowBottomHeight);
        super.paintComponent(g);
    }

    @Override
    public void printComponent(Graphics g) {
        this.printing = true;
        super.paintComponent(g);
    }

    private void verifyClipRect(Graphics g, int heldRowTopHeight, int heldRowBottomHeight) {
        if (heldRowTopHeight > 0 || heldRowBottomHeight > 0) {
            Rectangle clipBounds = g.getClipBounds();
            if (heldRowTopHeight > 0 && heldRowBottomHeight > 0) {
                Rectangle viewRect = this.getVisibleRect();
                viewRect.width = Math.min(this.getWidth(), viewRect.width);
                viewRect.height = Math.min(this.getHeight(), viewRect.height);
                clipBounds = viewRect;
            } else if (heldRowTopHeight > 0) {
                Point point = this.getTable().getViewPosition();
                Rectangle heldColumnsRect = new Rectangle(point.x, point.y, clipBounds.width, heldRowTopHeight);
                int yMin = point.y;
                int yMax = Math.max(point.y + heldRowTopHeight + clipBounds.height, clipBounds.y + clipBounds.height);
                clipBounds.y = heldColumnsRect.y;
                clipBounds.height = yMax - yMin;
                clipBounds.width = heldColumnsRect.width;
            } else if (heldRowBottomHeight > 0) {
                Rectangle viewRect = this.getVisibleRect();
                viewRect.width = Math.min(this.getWidth() + 1, viewRect.width);
                clipBounds = viewRect;
            }
            g.setClip(clipBounds);
        } else {
            Rectangle viewRect = this.getVisibleRect();
            Rectangle clipBounds = g.getClipBounds();
            clipBounds = viewRect;
            g.setClip(clipBounds);
        }
    }

    public int getTopHeldHeight() {
        int heldRowTopHeight = 0;
        int heldRowSize = this.getHeldIndices(1).size();
        for (int i = 0; i < heldRowSize; ++i) {
            heldRowTopHeight += this.getTable().getRowHeight(i);
        }
        return heldRowTopHeight;
    }

    public int getBottomHeldHeight() {
        int heldRowBottomHeight = 0;
        int heldRowSize = this.getHeldIndices(3).size();
        if (heldRowSize == 0) {
            return 0;
        }
        int rowCount = this.getTable().getRowCount();
        for (int i = rowCount - heldRowSize; i < rowCount; ++i) {
            heldRowBottomHeight += this.getTable().getRowHeight(i);
        }
        return heldRowBottomHeight;
    }
}

