/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.TableView;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;

public class NavigationalAction
extends AbstractAction {
    protected int dx;
    protected int dy;
    protected boolean toggle;
    protected boolean extend;
    protected boolean inSelection;
    protected int anchorRow;
    protected int anchorColumn;
    protected int leadRow;
    protected int leadColumn;

    public NavigationalAction(int dx, int dy, boolean toggle, boolean extend, boolean inSelection) {
        this.dx = dx;
        this.dy = dy;
        this.toggle = toggle;
        this.extend = extend;
        this.inSelection = inSelection;
    }

    protected int clipToRange(int i, int a, int b) {
        return Math.min(Math.max(i, a), b - 1);
    }

    protected void moveWithinTableRange(TableView table, int dx, int dy, boolean changeLead) {
        int rowMin = -1;
        int colMin = -1;
        int rowCount = table.getRowCount();
        int colCount = table.getColumnCount();
        if (rowCount == 0) {
            colMin = 0;
        }
        if (colCount == 0) {
            rowMin = 0;
        }
        if (changeLead) {
            this.leadRow = this.clipToRange(this.leadRow + dy, rowMin, rowCount);
            this.leadColumn = this.clipToRange(this.leadColumn + dx, colMin, colCount);
        } else {
            this.anchorRow = this.clipToRange(this.anchorRow + dy, rowMin, rowCount);
            this.anchorColumn = this.clipToRange(this.anchorColumn + dx, colMin, colCount);
        }
    }

    protected int compare(int i, int a, int b) {
        return i < a ? -1 : (i >= b ? 1 : 0);
    }

    protected boolean moveWithinSelectedRange(TableView table, int dx, int dy, boolean ignoreCarry) {
        boolean canStayInSelection;
        ListSelectionModel rsm = table.getRowModel().getSelectionModel();
        ListSelectionModel csm = table.getColumnModel().getSelectionModel();
        ListSelectionModel cellsm = table.getSelectionModel();
        int newAnchorRow = this.anchorRow + dy;
        int newAnchorColumn = this.anchorColumn + dx;
        int totalColumnCount = Math.max(1, table.getColumnCount());
        int totalRowCount = Math.max(1, table.getRowCount());
        int rowSgn = 0;
        int colSgn = 0;
        int rowCount = 0;
        int columnCount = 0;
        if (table.getCellSelectionEnabled() && table.getSelectedCellCount() > 0) {
            rowCount = cellsm.getMaxSelectionIndex() / totalColumnCount - cellsm.getMinSelectionIndex() / totalColumnCount + 1;
            columnCount = cellsm.getMaxSelectionIndex() % totalColumnCount - cellsm.getMinSelectionIndex() % totalColumnCount + 1;
        } else if (table.getColumnSelectionAllowed() && table.getSelectedColumnCount() > 0) {
            rowCount = totalRowCount;
            columnCount = (csm.getMaxSelectionIndex() - csm.getMinSelectionIndex()) % totalColumnCount + 1;
        } else if (table.getRowSelectionAllowed() && table.getSelectedRowCount() > 0) {
            rowCount = (rsm.getMaxSelectionIndex() - rsm.getMinSelectionIndex()) % totalRowCount + 1;
            columnCount = totalColumnCount;
        }
        boolean bl = canStayInSelection = rowCount * columnCount > 1;
        if (canStayInSelection) {
            if (table.getCellSelectionEnabled() && table.getSelectedCellCount() > 0) {
                rowSgn = this.compare(newAnchorRow, cellsm.getMinSelectionIndex() / totalColumnCount, cellsm.getMaxSelectionIndex() / totalColumnCount + 1);
                colSgn = this.compare(newAnchorColumn, cellsm.getMinSelectionIndex() % totalColumnCount, cellsm.getMaxSelectionIndex() % totalColumnCount + 1);
            } else if (table.getColumnSelectionAllowed() && table.getSelectedColumnCount() > 0) {
                rowSgn = this.compare(newAnchorRow, 0, totalRowCount);
                colSgn = this.compare(newAnchorColumn, csm.getMinSelectionIndex() % totalColumnCount, csm.getMaxSelectionIndex() % totalColumnCount + 1);
            } else if (table.getRowSelectionAllowed() && table.getSelectedRowCount() > 0) {
                rowSgn = this.compare(newAnchorRow, rsm.getMinSelectionIndex() % totalRowCount, rsm.getMaxSelectionIndex() % totalRowCount + 1);
                colSgn = this.compare(newAnchorColumn, 0, totalColumnCount);
            }
        } else {
            rowCount = totalRowCount;
            columnCount = totalColumnCount;
            rowSgn = this.compare(newAnchorRow, 0, rowCount);
            colSgn = this.compare(newAnchorColumn, 0, columnCount);
        }
        this.anchorRow = newAnchorRow - rowCount * rowSgn;
        this.anchorColumn = newAnchorColumn - columnCount * colSgn;
        if (!ignoreCarry) {
            return this.moveWithinSelectedRange(table, rowSgn, colSgn, true);
        }
        return canStayInSelection;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TableView table = null;
        if (e.getSource() instanceof TableView) {
            table = (TableView)e.getSource();
        }
        if (table != null) {
            if (table.isEditing() && !table.getCellEditor().stopCellEditing()) {
                return;
            }
            int currentRow = table.getCurrentRow();
            int currentColumn = table.getCurrentColumn();
            ListSelectionModel sm = null;
            int columnCount = Math.max(1, table.getColumnCount());
            int rowCount = Math.max(1, table.getRowCount());
            this.anchorRow = currentRow;
            this.anchorColumn = currentColumn;
            this.leadRow = this.anchorRow;
            this.leadColumn = this.anchorColumn;
            if (currentRow < 0 && currentColumn >= 0) {
                if (this.extend && table.getColumnSelectionAllowed() && table.getSelectedColumnCount() > 0) {
                    sm = table.getColumnModel().getSelectionModel();
                    this.leadColumn = sm.getLeadSelectionIndex();
                    this.leadRow = -(this.leadColumn / columnCount) - 1;
                    this.leadColumn %= columnCount;
                }
            } else if (currentColumn < 0 && currentRow >= 0) {
                if (this.extend && table.getRowSelectionAllowed() && table.getSelectedRowCount() > 0) {
                    sm = table.getRowModel().getSelectionModel();
                    this.leadRow = sm.getLeadSelectionIndex();
                    this.leadColumn = -(this.leadRow / rowCount) - 1;
                    this.leadRow %= rowCount;
                }
            } else if (currentRow >= 0 && currentColumn >= 0) {
                if (table.getCellSelectionEnabled() && table.getSelectedCellCount() > 0) {
                    sm = table.getSelectionModel();
                    int leadCell = sm.getLeadSelectionIndex();
                    this.leadRow = leadCell / columnCount;
                    this.leadColumn = leadCell % columnCount;
                } else if (this.extend && table.getRowSelectionAllowed() && table.getSelectedRowCount() > 0) {
                    sm = table.getRowModel().getSelectionModel();
                    this.leadRow = sm.getLeadSelectionIndex();
                    this.leadColumn = -(this.leadRow / rowCount) - 1;
                    this.leadRow %= rowCount;
                } else if (this.extend && table.getColumnSelectionAllowed() && table.getSelectedColumnCount() > 0) {
                    sm = table.getColumnModel().getSelectionModel();
                    this.leadColumn = sm.getLeadSelectionIndex();
                    this.leadRow = -(this.leadColumn / columnCount) - 1;
                    this.leadColumn %= columnCount;
                }
            }
            int oldAnchorRow = this.anchorRow;
            int oldAnchorColumn = this.anchorColumn;
            if (!this.inSelection) {
                this.moveWithinTableRange(table, this.dx, this.dy, this.extend);
                if (!this.extend) {
                    table.changeSelection(this.anchorRow, this.anchorColumn, false, this.extend);
                } else {
                    table.changeSelection(this.leadRow, this.leadColumn, false, this.extend);
                }
            } else if (this.moveWithinSelectedRange(table, this.dx, this.dy, false)) {
                table.changeCurrentCell(this.anchorRow, this.anchorColumn);
                table.scrollRectToVisible(table.getCellRect(this.anchorRow, this.anchorColumn, false));
            } else {
                table.changeSelection(this.anchorRow, this.anchorColumn, false, false);
            }
        }
    }
}

