/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.TableRowModel;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.swing.visuals.tableview.TableRowModelListener;
import com.sas.swing.visuals.tableview.TableView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class DefaultTableRowModel
implements TableRowModel,
PropertyChangeListener,
TableModelListener,
ListSelectionListener,
Serializable,
SwingConstants {
    private TableView table;
    protected List tableRows;
    protected ListSelectionModel selectionModel;
    protected int rowMargin;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent;
    protected boolean rowSelectionAllowed;
    private boolean rowMoved;

    public DefaultTableRowModel(TableView table) {
        this.table = table;
        this.createRowMappings();
        this.setSelectionModel(this.createSelectionModel());
        this.getSelectionModel().setAnchorSelectionIndex(0);
        this.setRowMargin(1);
        this.setRowSelectionAllowed(true);
        table.addPropertyChangeListener(this);
        table.getModel().addTableModelListener(this);
        this.rowMoved = false;
    }

    public TableView getTable() {
        return this.table;
    }

    public void setTable(TableView newTable) {
        if (newTable != this.table) {
            if (this.table != null) {
                this.table.removePropertyChangeListener(this);
                this.table.getModel().removeTableModelListener(this);
            }
            this.table = newTable;
            if (this.table != null) {
                this.table.addPropertyChangeListener(this);
                this.table.getModel().addTableModelListener(this);
            }
        }
    }

    private void createRowMappings() {
        int rowCount = this.getTable().getModel().getRowCount();
        if (this.tableRows == null) {
            this.tableRows = new Vector(rowCount);
        } else {
            this.tableRows.clear();
        }
        for (int i = 0; i < rowCount; ++i) {
            this.tableRows.add(new Integer(i));
        }
    }

    @Override
    public void moveRow(int rowIndex, int newIndex) {
        int rowCount = this.getRowCount();
        if (rowIndex < 0 || rowIndex >= rowCount || newIndex < 0 || newIndex >= rowCount) {
            throw new IllegalArgumentException("moveRow() - Index out of range");
        }
        this.rowMoved = true;
        Integer aRow = (Integer)this.tableRows.get(rowIndex);
        this.tableRows.remove(rowIndex);
        boolean selected = this.selectionModel.isSelectedIndex(rowIndex);
        this.selectionModel.removeIndexInterval(rowIndex, rowIndex);
        this.tableRows.add(newIndex, aRow);
        this.selectionModel.insertIndexInterval(newIndex, 1, true);
        if (selected) {
            this.selectionModel.addSelectionInterval(newIndex, newIndex);
        } else {
            this.selectionModel.removeSelectionInterval(newIndex, newIndex);
        }
        this.fireRowMoved(new TableRowModelEvent(this, rowIndex, newIndex));
    }

    @Override
    public void clearRowMoves() {
        if (this.rowMoved) {
            List topHeldIndices = this.table.getRowHeader().getHeldIndices(1);
            List bottomHeldIndices = this.table.getRowHeader().getHeldIndices(3);
            int rowCount = this.getRowCount();
            int topSize = topHeldIndices.size();
            int bottomSize = bottomHeldIndices.size();
            int offset = 0;
            for (int i = topSize; i < rowCount - topSize - bottomSize; ++i) {
                Integer in = new Integer(i + offset - topSize);
                if (!topHeldIndices.contains(in) && !bottomHeldIndices.contains(in)) {
                    this.tableRows.set(i, in);
                    continue;
                }
                ++offset;
                --i;
            }
            this.rowMoved = false;
            this.fireRowMoved(new TableRowModelEvent(this, -1, -1));
        }
    }

    @Override
    public int convertRowIndexToModel(int viewRowIndex) {
        if (viewRowIndex < 0) {
            return viewRowIndex;
        }
        if (this.tableRows.size() <= viewRowIndex) {
            return viewRowIndex;
        }
        return (Integer)this.tableRows.get(viewRowIndex);
    }

    @Override
    public int convertRowIndexToView(int modelRowIndex) {
        if (modelRowIndex < 0) {
            return modelRowIndex;
        }
        Integer rowIndex = new Integer(modelRowIndex);
        return this.tableRows.indexOf(rowIndex);
    }

    @Override
    public void setRowMargin(int newMargin) {
        if (newMargin != this.rowMargin) {
            this.rowMargin = newMargin;
            this.fireRowMarginChanged();
        }
    }

    @Override
    public int getRowCount() {
        if (this.table != null) {
            return this.table.getRowCount();
        }
        return 0;
    }

    @Override
    public int getRowMargin() {
        return this.rowMargin;
    }

    @Override
    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel oldModel = this.selectionModel;
        if (newModel != oldModel) {
            if (oldModel != null) {
                oldModel.removeListSelectionListener(this);
            }
            this.selectionModel = newModel;
            if (newModel != null) {
                newModel.addListSelectionListener(this);
            }
        }
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void setRowSelectionAllowed(boolean flag) {
        this.rowSelectionAllowed = flag;
    }

    @Override
    public boolean getRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    @Override
    public int[] getSelectedRows() {
        if (this.selectionModel != null) {
            int iMin = this.selectionModel.getMinSelectionIndex();
            int iMax = this.selectionModel.getMaxSelectionIndex();
            if (iMin == -1 || iMax == -1) {
                return new int[0];
            }
            int[] rvTmp = new int[1 + (iMax - iMin)];
            int n = 0;
            for (int i = iMin; i <= iMax; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                rvTmp[n++] = i;
            }
            int[] rv = new int[n];
            System.arraycopy(rvTmp, 0, rv, 0, n);
            return rv;
        }
        return new int[0];
    }

    @Override
    public int getSelectedRowCount() {
        if (this.selectionModel != null) {
            int iMin = this.selectionModel.getMinSelectionIndex();
            int iMax = this.selectionModel.getMaxSelectionIndex();
            int count = 0;
            for (int i = iMin; i <= iMax; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    @Override
    public void addRowModelListener(TableRowModelListener x) {
        this.listenerList.add(TableRowModelListener.class, x);
    }

    @Override
    public void removeRowModelListener(TableRowModelListener x) {
        this.listenerList.remove(TableRowModelListener.class, x);
    }

    public TableRowModelListener[] getRowModelListeners() {
        return (TableRowModelListener[])this.listenerList.getListeners(TableRowModelListener.class);
    }

    protected void fireRowMoved(TableRowModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableRowModelListener.class) continue;
            ((TableRowModelListener)listeners[i + 1]).rowMoved(e);
        }
    }

    protected void fireRowSelectionChanged(ListSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableRowModelListener.class) continue;
            ((TableRowModelListener)listeners[i + 1]).rowSelectionChanged(e);
        }
    }

    protected void fireRowMarginChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableRowModelListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((TableRowModelListener)listeners[i + 1]).rowMarginChanged(this.changeEvent);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("model")) {
            ((TableModel)evt.getOldValue()).removeTableModelListener(this);
            this.createRowMappings();
            this.table.getModel().addTableModelListener(this);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e == null || e.getFirstRow() == -1) {
            this.createRowMappings();
            return;
        }
        if (e.getType() == 1) {
            this.tableRowsInserted(e);
            return;
        }
        if (e.getType() == -1) {
            this.tableRowsDeleted(e);
            return;
        }
    }

    protected void tableRowsInserted(TableModelEvent e) {
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (start < 0) {
            start = 0;
        }
        int rowsInserted = end - start + 1;
        if (this.tableRows == null) {
            this.createRowMappings();
        } else {
            int i;
            int rowCount = this.tableRows.size();
            for (i = 0; i < rowCount; ++i) {
                int rowValue = (Integer)this.tableRows.get(i);
                if (rowValue < start) continue;
                this.tableRows.set(i, new Integer(rowValue + rowsInserted));
            }
            for (i = Math.min(start, this.tableRows.size()); i <= end; ++i) {
                this.tableRows.add(i, new Integer(i));
            }
        }
    }

    protected void tableRowsDeleted(TableModelEvent e) {
        int i;
        int start = e.getFirstRow();
        int end = e.getLastRow();
        int viewStart = this.convertRowIndexToView(start);
        int viewEnd = this.convertRowIndexToView(end);
        if (viewStart < 0) {
            viewStart = 0;
        }
        if (viewEnd < 0) {
            viewEnd = 0;
        }
        int deletedCount = viewEnd - viewStart + 1;
        if (this.table.rowHeightModel != null) {
            this.table.rowHeightModel.removeEntries(viewStart, deletedCount);
        }
        int index = 0;
        for (i = start; i <= end; ++i) {
            index = this.tableRows.indexOf(new Integer(i));
            if (index == -1) continue;
            this.tableRows.remove(index);
        }
        int size = this.tableRows.size();
        for (i = 0; i < size; ++i) {
            int rowValue = (Integer)this.tableRows.get(i);
            if (rowValue <= end) continue;
            this.tableRows.set(i, new Integer(rowValue - deletedCount));
        }
        if (this.getSelectionModel() != null) {
            this.getSelectionModel().removeIndexInterval(viewStart, viewEnd);
        }
        if (this.table.getSelectionModel() != null) {
            int columnCount = this.table.getColumnCount();
            if (columnCount > 0) {
                this.table.getSelectionModel().removeIndexInterval(viewStart * columnCount, columnCount - 1 + viewEnd * columnCount);
            } else {
                this.table.getSelectionModel().clearSelection();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.fireRowSelectionChanged(e);
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }
}

