/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.MissingValues;
import com.sas.swing.visuals.tableview.RB;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.text.Message;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.util.transforms.BaseTransforms;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.StringToDateTransform;
import com.sas.util.transforms.StringToDoubleTransform;
import com.sas.util.transforms.StringToFloatTransform;
import com.sas.util.transforms.StringToSQLDateTransform;
import com.sas.util.transforms.StringToSQLTimeTransform;
import com.sas.util.transforms.StringToSQLTimestampTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.validators.ValidationInterface;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class DefaultTableCellEditor
extends DefaultCellEditor
implements SupportsGenericErrorHandlerInterface {
    public static final String RB_KEY = "DefaultTableCellEditor.";
    private Class[] argTypes;
    private Constructor constructor;
    private Class type;
    private Object value;
    private TransformInterface transform;
    private TransformInterface outputTransform;
    private GenericErrorHandlerInterface genericErrorHandler;
    private GenericErrorHandlerInterface viewerErrorHandler;
    private ValidationInterface validator;
    private Locale locale;
    private Object lastValue;
    private boolean valid;
    private boolean defaultTransform;

    public DefaultTableCellEditor() {
        this(new JTextField());
    }

    public DefaultTableCellEditor(JCheckBox checkBox) {
        super(checkBox);
        this.initLocalVars();
        this.argTypes = new Class[]{Boolean.TYPE};
    }

    public DefaultTableCellEditor(JComboBox comboBox) {
        super(comboBox);
        this.initLocalVars();
        this.argTypes = new Class[]{String.class};
    }

    public DefaultTableCellEditor(JTextField textField) {
        super(textField);
        this.initLocalVars();
        this.argTypes = new Class[]{String.class};
    }

    private void initLocalVars() {
        this.locale = null;
        this.defaultTransform = true;
        this.transform = new ObjectToStringTransform();
        ((ObjectToStringTransform)this.transform).setNullString("");
        this.valid = true;
    }

    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
        if (this.defaultTransform && this.locale != null) {
            this.transform = new ObjectToStringTransform(this.locale);
            ((ObjectToStringTransform)this.transform).setNullString("");
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setTransform(TransformInterface newTransform) {
        this.transform = newTransform;
        this.defaultTransform = false;
    }

    public TransformInterface getTransform() {
        return this.transform;
    }

    public void setOutputTransform(TransformInterface newTransform) {
        this.outputTransform = newTransform;
    }

    public TransformInterface getOutputTransform() {
        return this.outputTransform;
    }

    @Override
    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.genericErrorHandler;
    }

    @Override
    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        this.genericErrorHandler = errorHandler;
    }

    public ValidationInterface getValidator() {
        return this.validator;
    }

    public void setValidator(ValidationInterface newValidator) {
        this.validator = newValidator;
    }

    @Override
    public boolean stopCellEditing() {
        Object s;
        block32: {
            s = super.getCellEditorValue();
            if (this.transform instanceof ObjectToStringTransform && s != null && s.equals(((ObjectToStringTransform)this.transform).getDotString())) {
                this.value = MissingValues.Dot;
                return super.stopCellEditing();
            }
            if (this.getValidator() != null) {
                if (s == null || !s.equals(this.lastValue)) {
                    if (!this.getValidator().validateValue(this.getComponent(), s)) {
                        this.valid = false;
                        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError(this.getComponent(), this.getValidator().getValidationMessage(), this.getValidator().getValidationMessageCode());
                        }
                        this.lastValue = s;
                        return false;
                    }
                } else if (!this.valid) {
                    ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                    return false;
                }
            }
            if ("".equals(s)) {
                try {
                    Constructor constructor = this.type.getConstructor(this.argTypes);
                    if (constructor != null && constructor.getDeclaringClass() == String.class) {
                        this.value = s;
                    }
                }
                catch (Exception constructor) {
                    // empty catch block
                }
                return super.stopCellEditing();
            }
            this.valid = true;
            try {
                TransformInterface editTransform = null;
                if (this.getOutputTransform() != null) {
                    editTransform = this.getOutputTransform();
                } else {
                    editTransform = s != null ? BaseTransforms.defaultInstance.lookupTransform(s.getClass(), this.type) : BaseTransforms.defaultInstance.lookupTransform(String.class, this.type);
                    if (this.locale != null) {
                        if (editTransform instanceof StringToDoubleTransform) {
                            editTransform = new StringToDoubleTransform(this.locale);
                        } else if (editTransform instanceof StringToFloatTransform) {
                            editTransform = new StringToFloatTransform(this.locale);
                        } else if (editTransform instanceof StringToSQLDateTransform) {
                            editTransform = new StringToSQLDateTransform(this.locale);
                        } else if (editTransform instanceof StringToSQLTimestampTransform) {
                            editTransform = new StringToSQLTimestampTransform(this.locale);
                        } else if (editTransform instanceof StringToSQLTimeTransform) {
                            editTransform = new StringToSQLTimeTransform(this.locale);
                        } else if (editTransform instanceof StringToDateTransform) {
                            editTransform = new StringToDateTransform(this.locale);
                        }
                    }
                }
                if (editTransform != null) {
                    this.value = editTransform.transform(s);
                    break block32;
                }
                try {
                    this.constructor = this.type.getConstructor(this.argTypes);
                    this.value = this.constructor.newInstance(s);
                }
                catch (Exception e) {
                    return false;
                }
            }
            catch (Exception e) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                if (this.getGenericErrorHandler() != null) {
                    this.viewerErrorHandler = this.getGenericErrorHandler();
                }
                if (!(this.viewerErrorHandler == null || s != null && s.equals(this.lastValue))) {
                    this.lastValue = s;
                    this.viewerErrorHandler.handleError(this.getComponent(), new Message(RB.getStringResource(RB_KEY, "errorSettingValue.txt"), s), null);
                }
                this.lastValue = s;
                return false;
            }
        }
        this.lastValue = s;
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = null;
        this.lastValue = value;
        this.type = null;
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
        this.type = table instanceof TableView ? ((TableView)table).getUnformattedColumnClass(column) : table.getColumnClass(column);
        if (this.type == Object.class) {
            this.type = String.class;
        }
        if (this.transform != null) {
            try {
                value = this.transform.transform(value);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        if (this.getGenericErrorHandler() == null && table instanceof SupportsGenericErrorHandlerInterface) {
            SupportsGenericErrorHandlerInterface viewer = (SupportsGenericErrorHandlerInterface)((Object)table);
            this.viewerErrorHandler = viewer.getGenericErrorHandler();
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }
}

