/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.OriginComponent;
import com.sas.swing.visuals.tableview.OriginComponentUI;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class BasicOriginComponentUI
extends OriginComponentUI {
    protected OriginComponent originComponent;
    protected CellRendererPane rendererPane;
    protected boolean resizingColumnHeader;
    protected boolean resizingRowHeader;
    protected MouseInputListener mouseInputListener;

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicOriginComponentUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.originComponent = (OriginComponent)c;
        this.rendererPane = new CellRendererPane();
        this.originComponent.add(this.rendererPane);
        this.installListeners();
    }

    protected void installDefaults() {
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.originComponent.addMouseListener(this.mouseInputListener);
        this.originComponent.addMouseMotionListener(this.mouseInputListener);
    }

    protected void installKeyboardActions() {
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.originComponent.remove(this.rendererPane);
        this.rendererPane = null;
        this.originComponent = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.originComponent.removeMouseListener(this.mouseInputListener);
        this.originComponent.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    protected void uninstallKeyboardActions() {
    }

    public void setResizingColumnHeader(boolean newValue) {
        this.resizingColumnHeader = newValue;
    }

    public boolean isResizingColumnHeader() {
        return this.resizingColumnHeader;
    }

    public void setResizingRowHeader(boolean newValue) {
        this.resizingRowHeader = newValue;
    }

    public boolean isResizingRowHeader() {
        return this.resizingRowHeader;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int currentRow = this.originComponent.getTable().getCurrentRow();
        int currentColumn = this.originComponent.getTable().getCurrentColumn();
        boolean hasFocus = this.originComponent.getTable().isFocusOwner() && currentRow < 0 && currentColumn < 0;
        Component component = this.originComponent.getRenderer().getTableCellRendererComponent(this.originComponent.getTable(), this.originComponent.getHeaderValue(), false, hasFocus, -1, -1);
        this.rendererPane.paintComponent(g, component, this.originComponent, 0, 0, this.originComponent.getWidth(), this.originComponent.getHeight(), true);
        this.rendererPane.removeAll();
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected int lastEffectiveMouseY;
        protected int lastEffectiveMouseX;

        protected boolean shouldIgnore(MouseEvent e) {
            return !BasicOriginComponentUI.this.originComponent.getTable().isEnabled() || !BasicOriginComponentUI.this.originComponent.isEnabled();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                if (!BasicOriginComponentUI.this.originComponent.getTable().hasFocus() && BasicOriginComponentUI.this.originComponent.getTable().isRequestFocusEnabled()) {
                    BasicOriginComponentUI.this.originComponent.getTable().requestFocus();
                }
                Point p = e.getPoint();
                this.lastEffectiveMouseY = p.y;
                this.lastEffectiveMouseX = p.x;
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    if (!e.isConsumed() && BasicOriginComponentUI.this.originComponent.getTable().isPopupMenuEnabled()) {
                        Point point = BasicOriginComponentUI.this.originComponent.getComponentOrientation().isLeftToRight() ? new Point(p.x - BasicOriginComponentUI.this.originComponent.getWidth(), p.y - BasicOriginComponentUI.this.originComponent.getHeight()) : new Point(p.x + BasicOriginComponentUI.this.originComponent.getTable().getWidth(), p.y - BasicOriginComponentUI.this.originComponent.getHeight());
                        BasicOriginComponentUI.this.originComponent.getTable().showPopup(point);
                    }
                } else {
                    if (BasicOriginComponentUI.this.isResizingColumnHeader() || BasicOriginComponentUI.this.isResizingRowHeader()) {
                        return;
                    }
                    Action act = BasicOriginComponentUI.this.originComponent.getAction();
                    if (act != null) {
                        act.actionPerformed(new ActionEvent(BasicOriginComponentUI.this.originComponent, 1001, null));
                    }
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                this.validateCursor(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                int mouseY = e.getY();
                int mouseX = e.getX();
                boolean headerLeftToRight = BasicOriginComponentUI.this.originComponent.getComponentOrientation().isLeftToRight();
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int deltaY = mouseY - this.lastEffectiveMouseY;
                    int deltaX = mouseX - this.lastEffectiveMouseX;
                    if (BasicOriginComponentUI.this.isResizingColumnHeader()) {
                        if (deltaY == 0) {
                            return;
                        }
                        int oldHeight = BasicOriginComponentUI.this.originComponent.getTable().getColumnHeader().getHeight();
                        int newHeight = oldHeight + deltaY;
                        JScrollPane pane = BasicOriginComponentUI.this.originComponent.getTable().getScrollPane();
                        int maxHeight = pane.getSize().height - pane.getInsets().top - pane.getInsets().bottom;
                        if (newHeight < 1) {
                            newHeight = 1;
                        }
                        if (newHeight > maxHeight) {
                            newHeight = maxHeight;
                        }
                        BasicOriginComponentUI.this.originComponent.getTable().getColumnHeader().setHeight(newHeight);
                        int acheivedDeltaY = BasicOriginComponentUI.this.originComponent.getTable().getColumnHeader().getHeight() - oldHeight;
                        this.lastEffectiveMouseY += acheivedDeltaY;
                        this.lastEffectiveMouseX = mouseX;
                        BasicOriginComponentUI.this.originComponent.getTable().getColumnHeader().resizeAndRepaint();
                    } else if (BasicOriginComponentUI.this.isResizingRowHeader()) {
                        if (deltaX == 0) {
                            return;
                        }
                        int oldWidth = BasicOriginComponentUI.this.originComponent.getTable().getRowHeader().getWidth();
                        int newWidth = 0;
                        newWidth = headerLeftToRight ? oldWidth + deltaX : oldWidth - deltaX;
                        JScrollPane pane = BasicOriginComponentUI.this.originComponent.getTable().getScrollPane();
                        int maxWidth = pane.getSize().width - pane.getInsets().left - pane.getInsets().right;
                        if (newWidth < 1) {
                            newWidth = 1;
                        }
                        if (newWidth > maxWidth) {
                            newWidth = maxWidth;
                        }
                        BasicOriginComponentUI.this.originComponent.getTable().getRowHeader().setWidth(newWidth);
                        int acheivedDeltaX = BasicOriginComponentUI.this.originComponent.getTable().getRowHeader().getWidth() - oldWidth;
                        if (headerLeftToRight) {
                            this.lastEffectiveMouseX += acheivedDeltaX;
                        }
                        this.lastEffectiveMouseY = mouseY;
                        BasicOriginComponentUI.this.originComponent.getTable().getRowHeader().resizeAndRepaint();
                    }
                } else {
                    this.lastEffectiveMouseY = mouseY;
                    this.lastEffectiveMouseX = mouseX;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                this.validateCursor(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void validateCursor(MouseEvent e) {
            if (this.canResizeColumnHeader(e.getPoint())) {
                BasicOriginComponentUI.this.setResizingRowHeader(false);
                BasicOriginComponentUI.this.setResizingColumnHeader(true);
                Cursor resizeCursor = Cursor.getPredefinedCursor(8);
                if (BasicOriginComponentUI.this.originComponent.getCursor() != resizeCursor) {
                    BasicOriginComponentUI.this.originComponent.setCursor(resizeCursor);
                }
            } else if (this.canResizeRowHeader(e.getPoint())) {
                BasicOriginComponentUI.this.setResizingRowHeader(true);
                BasicOriginComponentUI.this.setResizingColumnHeader(false);
                Cursor resizeCursor = Cursor.getPredefinedCursor(10);
                if (BasicOriginComponentUI.this.originComponent.getCursor() != resizeCursor) {
                    BasicOriginComponentUI.this.originComponent.setCursor(resizeCursor);
                }
            } else {
                BasicOriginComponentUI.this.setResizingRowHeader(false);
                BasicOriginComponentUI.this.setResizingColumnHeader(false);
                Cursor defaultCursor = Cursor.getPredefinedCursor(0);
                if (BasicOriginComponentUI.this.originComponent.getCursor() != defaultCursor) {
                    BasicOriginComponentUI.this.originComponent.setCursor(defaultCursor);
                }
            }
        }

        protected boolean canResizeColumnHeader(Point p) {
            Rectangle r = new Rectangle(0, 0, BasicOriginComponentUI.this.originComponent.getWidth(), BasicOriginComponentUI.this.originComponent.getHeight());
            r.grow(0, -3);
            r.y = 0;
            r.height += 3;
            return !r.contains(p);
        }

        protected boolean canResizeRowHeader(Point p) {
            Rectangle r = new Rectangle(0, 0, BasicOriginComponentUI.this.originComponent.getWidth(), BasicOriginComponentUI.this.originComponent.getHeight());
            r.grow(-3, 0);
            r.x = 0;
            r.width += 3;
            return !r.contains(p);
        }

        protected void setValueIsAdjusting(boolean flag) {
            TableView table = BasicOriginComponentUI.this.originComponent.getTable();
            table.getSelectionModel().setValueIsAdjusting(flag);
            table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }
    }
}

