/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.filters;

import com.sas.models.itemlistmanager.ItemListManagerViewerInterface;
import com.sas.models.itemlistmanager.tree.ILMTreeInterface;
import com.sas.swing.visuals.itemlistmanager.RB;
import com.sas.swing.visuals.itemlistmanager.TreeItemListManagerPanel;
import com.sas.swing.visuals.tableview.editors.ComboBoxEditor;
import com.sas.swing.visuals.util.Util;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class FilterItemListManagerPanel
extends TreeItemListManagerPanel {
    public static final String RB_KEY = "FilterItemListManagerPanel.";
    protected JButton andButton;
    protected JButton orButton;
    protected JButton notButton;
    protected JButton andNotButton;
    protected JButton orNotButton;

    public FilterItemListManagerPanel() {
        this((ILMTreeInterface)null);
    }

    public FilterItemListManagerPanel(ILMTreeInterface model) {
        super(model);
    }

    @Override
    protected void setupRenderersAndEditors() {
        super.setupRenderersAndEditors();
        List logicalConditions = this.treeModel.getLogicalConditionList();
        String notText = RB.getStringResource(RB_KEY, "not.txt");
        JComboBox<String> boolean1ComboBox = new JComboBox<String>();
        boolean1ComboBox.addItem(RB.getStringResource(RB_KEY, "noCondition.txt"));
        for (Object condition : logicalConditions) {
            if (!condition.toString().equals(notText)) continue;
            boolean1ComboBox.addItem((String)condition);
        }
        this.setCellEditor("FirstCondition", new ComboBoxEditor((JComboBox)boolean1ComboBox));
        JComboBox boolean2ComboBox = new JComboBox();
        for (Object condition : logicalConditions) {
            if (condition.toString().equals(notText)) continue;
            boolean2ComboBox.addItem(condition);
        }
        this.setCellEditor("Condition", new ComboBoxEditor(boolean2ComboBox));
    }

    @Override
    protected void addButtons() {
        super.addButtons();
        this.andButton = new JButton();
        this.andButton.setAction(new AndAction());
        this.andButton.setName("And");
        this.addButton(this.andButton, 1, 0);
        this.orButton = new JButton();
        this.orButton.setAction(new OrAction());
        this.orButton.setName("Or");
        this.addButton(this.orButton, 1, 1);
        this.notButton = new JButton();
        this.notButton.setAction(new NotAction());
        this.notButton.setName("Not");
        this.addButton(this.notButton, 1, 2);
        this.andNotButton = new JButton();
        this.andNotButton.setAction(new AndNotAction());
        this.andNotButton.setName("AndNot");
        this.addButton(this.andNotButton, 1, 3);
        this.orNotButton = new JButton();
        this.orNotButton.setAction(new OrNotAction());
        this.orNotButton.setName("OrNot");
        this.addButton(this.orNotButton, 1, 4);
        this.addButton(ItemListManagerViewerInterface.BUTTON_DIVIDER, 1, 5);
    }

    @Override
    protected void setSensitivities() {
        super.setSensitivities();
        int selectedRowCount = this.tableView.getSelectedRowCount();
        this.andButton.setEnabled(selectedRowCount > 0);
        this.orButton.setEnabled(selectedRowCount > 0);
        this.notButton.setEnabled(selectedRowCount > 0);
        this.andNotButton.setEnabled(selectedRowCount > 0);
        this.orNotButton.setEnabled(selectedRowCount > 0);
    }

    protected class AndAction
    extends AbstractAction {
        public AndAction() {
            super(Util.getLabelWithoutMnemonic(RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "and.txt")));
            this.putValue("ShortDescription", RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "andToolTip.txt"));
            this.putValue("MnemonicKey", new Integer(Util.getDisplayedMnemonic(RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "and.txt"))));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class OrAction
    extends AbstractAction {
        public OrAction() {
            super(Util.getLabelWithoutMnemonic(RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "or.txt")));
            this.putValue("ShortDescription", RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "orToolTip.txt"));
            this.putValue("MnemonicKey", new Integer(Util.getDisplayedMnemonic(RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "or.txt"))));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class NotAction
    extends AbstractAction {
        public NotAction() {
            super(Util.getLabelWithoutMnemonic(RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "not.txt")));
            this.putValue("ShortDescription", RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "notToolTip.txt"));
            this.putValue("MnemonicKey", new Integer(Util.getDisplayedMnemonic(RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "not.txt"))));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class AndNotAction
    extends AbstractAction {
        public AndNotAction() {
            super(Util.getLabelWithoutMnemonic(RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "andNot.txt")));
            this.putValue("ShortDescription", RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "andNotToolTip.txt"));
            this.putValue("MnemonicKey", new Integer(Util.getDisplayedMnemonic(RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "andNot.txt"))));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class OrNotAction
    extends AbstractAction {
        public OrNotAction() {
            super(Util.getLabelWithoutMnemonic(RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "orNot.txt")));
            this.putValue("ShortDescription", RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "orNotToolTip.txt"));
            this.putValue("MnemonicKey", new Integer(Util.getDisplayedMnemonic(RB.getStringResource(FilterItemListManagerPanel.RB_KEY, "orNot.txt"))));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

