/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dualselector;

import com.sas.codepolicy.SASScope;
import com.sas.security.BaseSecuritySupport;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.TupleElement;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualSelectorTreeInterface;
import com.sas.swing.visuals.dualselector.DualSelectorV2Interface;
import com.sas.swing.visuals.dualselector.TreeListSelector;
import com.sas.swing.visuals.util.DNDObject;
import com.sas.swing.visuals.util.TreeUtil;
import com.sas.util.PreorderTreeModelIterator;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

@SASScope(value="ALL")
public class JTreeDualSelectorAdapter
implements DualSelectorV2Interface,
DualSelectorTreeInterface,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    private boolean moveParentNodesOnly;
    private boolean moveChildNodesOnly;
    private boolean parentNodesMoveable;
    private boolean moveChildNodes;
    private TreeModel treeModel;
    private boolean removeEmptyParentNodes;
    private List childlessParents;
    protected JTree component;
    protected JScrollPane containerComponent;
    protected JComponent parentSelector;
    protected Object sourceTargetNode;
    public DropTarget dropTarget = null;
    public DragSource dragSource = null;

    public JTreeDualSelectorAdapter(JComponent parent) {
        this(new JTree(), parent);
    }

    public JTreeDualSelectorAdapter(JTree tree, JComponent parent) {
        this.component = tree;
        this.parentSelector = parent;
        this.containerComponent = new JScrollPane(tree);
        if (this.parentSelector != null) {
            if (!((BaseDualSelector)this.parentSelector).isDesignTime()) {
                this.dropTarget = new DropTarget(this.component, this);
                this.dragSource = DragSource.getDefaultDragSource();
                this.dragSource.createDefaultDragGestureRecognizer(this.component, 3, this);
            } else {
                ((BaseDualSelector)this.parentSelector).setDragAndDropEnabled(false);
            }
        }
        this.parentNodesMoveable = true;
        this.moveChildNodes = true;
        this.removeEmptyParentNodes = false;
        this.childlessParents = new ArrayList();
    }

    @Override
    public int getCount() {
        this.treeModel = this.component.getModel();
        Object fromRootNode = this.treeModel.getRoot();
        return this.treeModel.getChildCount(fromRootNode);
    }

    @Override
    public int getSelectedCount() {
        return this.component.getSelectionCount();
    }

    @Override
    public int getLastSelectedIndex() {
        return this.component.getMaxSelectionRow();
    }

    @Override
    public void setSelectedIndex(int index) {
        this.component.setSelectionRow(index);
    }

    @SASScope
    public void setSelectedIndices(int[] indices) {
        this.component.setSelectionRows(indices);
    }

    @Override
    @SASScope
    public void setSelectedValues(List values) {
        this.treeModel = this.component.getModel();
        if (this.treeModel == null || values == null) {
            return;
        }
        int valuesSize = values.size();
        Vector<Integer> selectedIndicesList = new Vector<Integer>();
        TreePath[] paths = new TreePath[valuesSize];
        Object userObject = null;
        int rowCount = this.component.getRowCount();
        TreePath pathForLoc = null;
        block0: for (int i = 0; i < valuesSize; ++i) {
            if (values.get(i) == null) continue;
            paths[i] = (TreePath)values.get(i);
            Object treeNode = paths[i].getLastPathComponent();
            if (!(treeNode instanceof DefaultMutableTreeNode)) continue;
            userObject = ((DefaultMutableTreeNode)treeNode).getUserObject();
            for (int ii = 0; ii < rowCount; ++ii) {
                pathForLoc = this.component.getPathForRow(ii);
                Object o = ((DefaultMutableTreeNode)pathForLoc.getLastPathComponent()).getUserObject();
                if (o != userObject) continue;
                selectedIndicesList.add(new Integer(ii));
                continue block0;
            }
        }
        int listSize = selectedIndicesList.size();
        int[] selectedIndices = new int[listSize];
        for (int index = 0; index < listSize; ++index) {
            selectedIndices[index] = (Integer)selectedIndicesList.get(index);
        }
        this.setSelectedIndices(selectedIndices);
    }

    @Override
    public List getSelectedItems() {
        this.treeModel = this.component.getModel();
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        TreePath[] selectedItems = this.component.getSelectionPaths();
        if (selectedItems != null) {
            for (int i = 0; i < selectedItems.length; ++i) {
                int j;
                List childPaths;
                TreePath tempPath = selectedItems[i];
                int childCount = this.treeModel.getChildCount(tempPath.getLastPathComponent());
                if (list.contains(tempPath)) continue;
                if (!this.parentNodesMoveable || this.moveChildNodesOnly) {
                    if (childCount == 0 && !this.childlessParents.contains(selectedItems[i].getLastPathComponent())) {
                        list.add(selectedItems[i]);
                        continue;
                    }
                    if (childCount <= 0 || !this.moveChildNodes) continue;
                    childPaths = this.getChildPaths(this.treeModel, tempPath.getLastPathComponent(), tempPath);
                    for (j = 0; j < childPaths.size(); ++j) {
                        Object obj = ((TreePath)childPaths.get(j)).getLastPathComponent();
                        if (obj instanceof TupleElement) {
                            try {
                                if (!list.contains(childPaths.get(j)) && !this.childlessParents.contains(((TreePath)childPaths.get(j)).getLastPathComponent()) && ((TupleElement)((TreePath)childPaths.get(j)).getLastPathComponent()).getChildCount() == 0) {
                                    list.add((TreePath)childPaths.get(j));
                                }
                            }
                            catch (OLAPException e) {
                                e.printStackTrace();
                            }
                        }
                        if (!(obj instanceof TreeNode) || list.contains(childPaths.get(j)) || this.childlessParents.contains(((TreePath)childPaths.get(j)).getLastPathComponent()) || ((TreeNode)((TreePath)childPaths.get(j)).getLastPathComponent()).getChildCount() != 0) continue;
                        list.add((TreePath)childPaths.get(j));
                    }
                    continue;
                }
                if (this.moveParentNodesOnly) {
                    if (childCount <= 0 || list.contains(selectedItems[i])) continue;
                    list.add(selectedItems[i]);
                    continue;
                }
                if (!list.contains(selectedItems[i])) {
                    list.add(selectedItems[i]);
                }
                if (childCount <= 0 || !this.moveChildNodes) continue;
                childPaths = this.getChildPaths(this.treeModel, tempPath.getLastPathComponent(), tempPath);
                for (j = 0; j < childPaths.size(); ++j) {
                    if (list.contains(childPaths.get(j))) continue;
                    list.add((TreePath)childPaths.get(j));
                }
            }
        }
        return list;
    }

    private List getChildPaths(TreeModel treeModel, Object lastComponent, TreePath childPath) {
        ArrayList returnList = new ArrayList();
        int childCount = treeModel.getChildCount(lastComponent);
        for (int i = 0; i < childCount; ++i) {
            Object childNode = treeModel.getChild(lastComponent, i);
            TreePath tempPath = childPath.pathByAddingChild(childNode);
            List childPathList = new ArrayList<TreePath>();
            if (treeModel.getChildCount(childNode) > 0) {
                childPathList = this.getChildPaths(treeModel, childNode, tempPath);
            }
            childPathList.add(tempPath);
            for (int j = 0; j < childPathList.size(); ++j) {
                returnList.add(childPathList.get(j));
            }
        }
        return returnList;
    }

    @Override
    public List getAllItems() {
        this.treeModel = this.component.getModel();
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        Object fromRootNode = this.treeModel.getRoot();
        TreePath childPath = null;
        TreePath previousPath = null;
        PreorderTreeModelIterator e = new PreorderTreeModelIterator(this.treeModel);
        while (e.hasNext()) {
            Object node = e.next();
            Object[] tempArray = e.getParentStack();
            if (tempArray.length > 0) {
                previousPath = new TreePath(tempArray);
            }
            childPath = childPath != null ? childPath.pathByAddingChild(node) : new TreePath(node);
            list.add(childPath);
            childPath = previousPath;
        }
        return list;
    }

    @Override
    public List getAllMoveableItems() {
        this.treeModel = this.component.getModel();
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        Object fromRootNode = this.treeModel.getRoot();
        TreePath childPath = null;
        TreePath previousPath = null;
        PreorderTreeModelIterator e = new PreorderTreeModelIterator(this.treeModel);
        while (e.hasNext()) {
            Object node = e.next();
            Object[] tempArray = e.getParentStack();
            if (tempArray.length > 0) {
                previousPath = new TreePath(tempArray);
            }
            childPath = childPath != null ? childPath.pathByAddingChild(node) : new TreePath(node);
            int childCount = this.treeModel.getChildCount(node);
            if (!this.parentNodesMoveable || this.moveChildNodesOnly) {
                if (childCount == 0 && !this.childlessParents.contains(childPath.getLastPathComponent())) {
                    list.add(childPath);
                }
            } else if (this.moveParentNodesOnly) {
                if (childCount > 0) {
                    list.add(childPath);
                }
            } else {
                list.add(childPath);
            }
            childPath = previousPath;
        }
        return list;
    }

    @Override
    public JComponent getContainerComponent() {
        return this.containerComponent;
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void addItems(List newItems) {
        this.treeModel = this.component.getModel();
        for (int i = newItems.size() - 1; i >= 0; --i) {
            TreePath tempPath = (TreePath)newItems.get(i);
            if (this.sourceTargetNode != null) {
                Object lastTempComponent = tempPath.getLastPathComponent();
                TreePath sourcePath = this.component.getNextMatch(this.sourceTargetNode.toString(), 0, Position.Bias.Forward);
                tempPath = sourcePath.pathByAddingChild(lastTempComponent);
            }
            TreePath addedPath = this.addNodeToTree(this.treeModel, tempPath);
            this.component.makeVisible(addedPath);
        }
    }

    @Override
    public void setSourceTargetNode(Object sourceTargetNode) {
        this.sourceTargetNode = sourceTargetNode;
    }

    @Override
    public void removeItems(List removeItems) {
        this.treeModel = this.component.getModel();
        TreeNode parent = null;
        for (int i = 0; i < removeItems.size(); ++i) {
            Object rootNode;
            TreePath tempPath = (TreePath)removeItems.get(i);
            Object pathComponent = tempPath.getLastPathComponent();
            if (pathComponent.equals(rootNode = this.treeModel.getRoot()) || pathComponent.equals(this.sourceTargetNode)) continue;
            if (this.isRemoveEmptyParentNodes()) {
                parent = ((MutableTreeNode)pathComponent).getParent();
                while (parent != null) {
                    if (!this.childlessParents.contains(pathComponent) && parent.getChildCount() == 1) {
                        this.childlessParents.add(parent);
                    }
                    ((DefaultTreeModel)this.treeModel).removeNodeFromParent((MutableTreeNode)pathComponent);
                    if (parent.getChildCount() == 0) {
                        pathComponent = parent;
                        parent = ((MutableTreeNode)pathComponent).getParent();
                        continue;
                    }
                    parent = null;
                }
                continue;
            }
            parent = ((MutableTreeNode)pathComponent).getParent();
            if (!this.childlessParents.contains(parent) && parent.getChildCount() == 1) {
                this.childlessParents.add(parent);
            }
            ((DefaultTreeModel)this.treeModel).removeNodeFromParent((MutableTreeNode)pathComponent);
        }
    }

    @Override
    public void clearSelections() {
        this.component.getSelectionModel().clearSelection();
    }

    public void setParentNodesOnlyMoveable(boolean parentNodesMoveable) {
        this.moveParentNodesOnly = parentNodesMoveable;
    }

    public boolean isParentNodeOnlyMoveable() {
        return this.moveParentNodesOnly;
    }

    public void setParentNodesMoveable(boolean moveableParentNodes) {
        this.parentNodesMoveable = moveableParentNodes;
    }

    public boolean isParentNodeMoveable() {
        return this.parentNodesMoveable;
    }

    public void setChildNodesOnlyMoveable(boolean nodes) {
        this.moveChildNodesOnly = nodes;
    }

    public boolean isChildNodesOnlyMoveable() {
        return this.moveChildNodesOnly;
    }

    @SASScope
    public boolean isRemoveEmptyParentNodes() {
        return this.removeEmptyParentNodes;
    }

    @SASScope
    public void setRemoveEmptyParentNodes(boolean remove) {
        this.removeEmptyParentNodes = remove;
    }

    private TreePath addNodeToTree(TreeModel toTree, TreePath treePath) {
        int index = 0;
        boolean notInTree = true;
        Object previousParentNode = null;
        Object newComponent = null;
        Object parentNode = null;
        Object pathComponent = null;
        Object rootNode = toTree.getRoot();
        TreePath addedPath = new TreePath(rootNode);
        int startIndex = this.isParentNodeMoveable() || this.parentSelector instanceof TreeListSelector ? 1 : treePath.getPathCount() - 1;
        for (int j = startIndex; j < treePath.getPathCount(); ++j) {
            pathComponent = treePath.getPathComponent(j);
            boolean OKToCheck = this.sourceTargetNode != null && ((TreeNode)pathComponent).getParent() != null ? true : this.sourceTargetNode == null && !pathComponent.equals(rootNode);
            if (OKToCheck) {
                if (parentNode == null || parentNode.equals(rootNode)) {
                    parentNode = toTree.getRoot();
                }
                if (this.sourceTargetNode != null && !this.isParentNodeMoveable()) {
                    parentNode = this.sourceTargetNode;
                }
                try {
                    Method method = BaseSecuritySupport.securitySupport.getMethod(pathComponent.getClass(), "clone", new Class[0]);
                    newComponent = BaseSecuritySupport.securitySupport.invokeMethod(method, pathComponent, new Object[0]);
                }
                catch (NoSuchMethodException nsme) {
                    nsme.printStackTrace();
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                }
                catch (InvocationTargetException ite) {
                    ite.printStackTrace();
                }
                notInTree = true;
                PreorderTreeModelIterator e = new PreorderTreeModelIterator(toTree);
                while (e.hasNext()) {
                    Object next = e.next();
                    if (next.equals(newComponent)) {
                        notInTree = false;
                        newComponent = next;
                        continue;
                    }
                    if (newComponent instanceof DefaultMutableTreeNode) {
                        Object userObject = ((DefaultMutableTreeNode)next).getUserObject();
                        TreeNode parent = ((DefaultMutableTreeNode)next).getParent();
                        if (userObject == null || !userObject.equals(((DefaultMutableTreeNode)newComponent).getUserObject()) || parent == null || !parent.equals(parentNode)) continue;
                        notInTree = false;
                        newComponent = next;
                        continue;
                    }
                    notInTree = true;
                }
                if (notInTree) {
                    ((DefaultTreeModel)toTree).insertNodeInto((MutableTreeNode)newComponent, (MutableTreeNode)parentNode, index);
                }
                addedPath = addedPath.pathByAddingChild(newComponent);
                if (parentNode == previousParentNode) {
                    ++index;
                } else {
                    index = 0;
                    previousParentNode = parentNode;
                }
            }
            parentNode = newComponent;
        }
        return addedPath;
    }

    @Override
    public boolean isInAdapter(Object item) {
        this.treeModel = this.component.getModel();
        boolean value = false;
        Object node = ((TreePath)item).getLastPathComponent();
        if (TreeUtil.getPathToRoot(this.treeModel, node) != null) {
            value = true;
        }
        return value;
    }

    public boolean canMove(int[] indices, int offset) {
        return true;
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
            event.acceptDrag(2);
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
            if (((BaseDualSelector)this.parentSelector).dragGestureInitiator == event.getDropTargetContext().getComponent()) {
                event.rejectDrop();
            } else {
                Transferable transferable = event.getTransferable();
                if (transferable.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    event.acceptDrop(2);
                    if (((BaseDualSelector)this.parentSelector).sourceAdapter == this) {
                        ((BaseDualSelector)this.parentSelector).transferTargetItems();
                    } else {
                        ((BaseDualSelector)this.parentSelector).transferSourceItems();
                    }
                    event.getDropTargetContext().dropComplete(true);
                } else {
                    event.rejectDrop();
                }
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        if (this.parentSelector != null) {
            List selected;
            ((BaseDualSelector)this.parentSelector).dragGestureInitiator = event.getComponent();
            if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled() && (selected = this.getSelectedItems()) != null) {
                DNDObject items = new DNDObject();
                for (int i = 0; i < selected.size(); ++i) {
                    items.add(selected.get(i));
                }
                this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, items, this);
            }
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    @SASScope
    public boolean isMoveChildNodesWithParent() {
        return this.moveChildNodes;
    }

    @SASScope
    public void setMoveChildNodesWithParent(boolean moveChildNodes) {
        if (this.moveChildNodes != moveChildNodes) {
            this.moveChildNodes = moveChildNodes;
        }
    }

    @SASScope
    public void setParentSelector(JComponent parentSelector) {
        this.parentSelector = parentSelector;
    }
}

