/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dualselector;

import com.sas.beans.Util;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.JListDualSelectorAdapter;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DualListSelector
extends BaseDualSelector
implements ListSelectionListener,
ViewDefaultModel {
    private transient ListModel sourceListModel;
    private transient ListModel targetListModel;
    private boolean clearSelection;
    private static final String RB_KEY = "DualListSelector.";
    protected JList sourceJList;
    protected JList targetJList;

    public DualListSelector() {
        this.setDesignTime(Util.isDesignTime());
        this.targetMaximumCount = -1;
        this.dragAndDropEnabled = true;
        this.sourceAdapter = new JListDualSelectorAdapter(this);
        this.targetAdapter = new JListDualSelectorAdapter(this);
        this.sourceJList = (JList)this.sourceAdapter.getComponent();
        this.targetJList = (JList)this.targetAdapter.getComponent();
        this.initializeBaseDualSelector();
        this.sourceJList.addMouseListener(this.sourceMouseListener);
        this.targetJList.addMouseListener(this.targetMouseListener);
        if (this.getModel() == null) {
            this.sourceListModel = new DefaultListModel();
            this.setModel(this.sourceListModel);
        }
        if (this.getTargetModel() == null) {
            this.setDefaultTargetModel(new DefaultListModel());
        }
        this.sourceAdapter.setSelectedIndex(0);
        this.initialized = true;
        this.ensureButtonsEnabled();
        this.addListeners();
        this.updateUI();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.sourceJList.removeListSelectionListener(this);
        this.sourceJList.addListSelectionListener(this);
        this.targetJList.removeListSelectionListener(this);
        this.targetJList.addListSelectionListener(this);
    }

    public ListCellRenderer getSourceCellRenderer() {
        return this.sourceJList.getCellRenderer();
    }

    public void setSourceCellRenderer(ListCellRenderer newValue) {
        ListCellRenderer oldValue = this.sourceJList.getCellRenderer();
        if (newValue == oldValue) {
            return;
        }
        this.sourceJList.setCellRenderer(newValue);
        this.firePropertyChange("sourceListCellRenderer", oldValue, newValue);
    }

    public ListCellRenderer getTargetCellRenderer() {
        return this.targetJList.getCellRenderer();
    }

    public void setTargetCellRenderer(ListCellRenderer newValue) {
        ListCellRenderer oldValue = this.targetJList.getCellRenderer();
        if (newValue == oldValue) {
            return;
        }
        this.targetJList.setCellRenderer(newValue);
        this.firePropertyChange("targetListCellRenderer", oldValue, newValue);
    }

    public ListModel getModel() {
        return this.sourceListModel;
    }

    public void setModel(ListModel listModel) {
        ListModel oldModel = this.sourceListModel;
        if (listModel != null) {
            this.sourceListModel = listModel;
        }
        if (this.sourceJList != null) {
            this.sourceJList.setModel(this.sourceListModel);
        } else {
            this.sourceListModel = new DefaultListModel();
            if (this.sourceJList != null) {
                this.sourceJList.setModel(this.sourceListModel);
            }
        }
        if (!(this.sourceListModel instanceof DefaultListModel) && !(this.sourceListModel instanceof CollectionToListModelAdapter)) {
            this.setCopyModeEnabled(true);
        }
        this.firePropertyChange("sourceListModel", oldModel, this.sourceListModel);
        if (this.sourceAdapter.getCount() > 0 && this.isEnabled()) {
            this.sourceAdapter.setSelectedIndex(0);
        }
        this.ensureButtonsEnabled();
    }

    public ListModel getTargetModel() {
        return this.targetListModel;
    }

    public void setDefaultTargetModel(DefaultListModel listModel) {
        if (listModel != null) {
            this.targetListModel = listModel;
            this.targetJList.setModel(this.targetListModel);
            this.firePropertyChange("targetListModel", null, this.targetListModel);
        }
    }

    public void setTargetModel(ListModel listModel) throws IllegalArgumentException {
        if (listModel instanceof DefaultListModel || listModel instanceof CollectionToListModelAdapter) {
            ListModel oldModel = this.targetListModel;
            if (listModel != null) {
                this.targetListModel = listModel;
            }
            if (this.targetJList != null) {
                this.targetJList.setModel(this.targetListModel);
            } else {
                this.targetListModel = new DefaultListModel();
                if (this.targetJList != null) {
                    this.targetJList.setModel(this.targetListModel);
                }
            }
            this.firePropertyChange("targetListModel", oldModel, this.targetListModel);
        } else if (listModel != null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isDefaultModelAttached() {
        return this.getModel() instanceof DefaultListModel && this.getModel().getSize() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent ie) {
        Object source = ie.getSource();
        this.direction = source != this.sourceJList || this.sourceListModel.getSize() <= 0;
        if (!this.clearSelection) {
            if (source == this.sourceJList && this.sourceListModel.getSize() > 0) {
                if (this.alternatingMultipleButtonStyle) {
                    this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", false));
                }
                if (this.alternatingSingleButtonStyle) {
                    this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", false));
                }
                this.ensureButtonsEnabled();
                this.clearSelection = true;
                try {
                    this.targetJList.getSelectionModel().clearSelection();
                    this.direction = false;
                }
                finally {
                    this.clearSelection = false;
                }
            }
            if (source == this.targetJList) {
                if (this.alternatingMultipleButtonStyle) {
                    this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", true));
                }
                if (this.alternatingSingleButtonStyle) {
                    this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", true));
                }
                this.ensureButtonsEnabled();
                this.clearSelection = true;
                try {
                    this.sourceJList.getSelectionModel().clearSelection();
                    this.direction = true;
                }
                finally {
                    this.clearSelection = false;
                }
            }
        }
    }
}

